/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OscarDB
extends DBType {
    public static final DataType CHAR = new DataType("CHAR", 1, -4000);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -4000);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, -38);
    public static final DataType NUMBER = new DataType("NUMBER", 2, -38);
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 38);
    public static final DataType DOUBLE = new DataType("DOUBLE", 8);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType DATE = new DataType("DATE", 91, 4);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType CLOB = new DataType("CLOB", 2005);
    public static final DataType BLOB = new DataType("BLOB", 2004);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    private static final DataType[] m_allDataTypes = new DataType[]{CHAR, VARCHAR, NUMBER, DATE, NUMERIC, INT, FLOAT, TIMESTAMP, SMALLINT, DATETIME, BIGINT, TINYINT, DECIMAL, CLOB, BLOB, VARCHAR2, DOUBLE, NVARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{NUMBER, VARCHAR2, CLOB, DATE};

    public OscarDB() {
        super("Oscar", "com.oscar.Driver", true);
    }

    public OscarDB(String _sName, String _sDriverClass) {
        super("Oscar", "com.oscar.Driver", true);
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
    }

    @Override
    public String encodeStrToWrite(String _strSrc) {
        return _strSrc;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return false;
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2) {
        return "CONCAT(" + _strSQL1 + "," + _strSQL2 + ")";
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2, String _strSQL3) {
        return "CONCAT(CONCAT(" + _strSQL1 + "," + _strSQL2 + ")," + _strSQL3 + ")";
    }

    @Override
    public String sqlConcatStr(String[] _strSQLs) {
        String sRet = "CONCAT(" + _strSQLs[0] + "," + _strSQLs[1] + ")";
        for (int i = 2; i < _strSQLs.length; ++i) {
            sRet = "CONCAT(" + sRet + "," + _strSQLs[i] + ")";
        }
        return sRet;
    }

    @Override
    public String sqlFilterForClob(String _sFieldName, String _sValue) {
        String sValue = _sValue.equals("?") ? "?" : "'" + CMyString.filterForSQL(_sValue) + "'";
        return " dbms_lob.instr(" + _sFieldName + "," + sValue + ", 1, 1)>0 ";
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable, String _sDefaultValue, int _nScale) {
        DataType dataType = this.getDataType(_sFieldType);
        if (dataType == null) {
            return null;
        }
        String sFieldType = _sFieldType;
        int nMaxLength = _nMaxLength;
        boolean zVarChar2 = false;
        switch (dataType.getType()) {
            case 2: {
                sFieldType = "NUMERIC";
                break;
            }
            case 5: {
                sFieldType = "SMALLINT";
                break;
            }
            case 4: {
                sFieldType = "INTEGER";
                break;
            }
            case 6: {
                sFieldType = "FLOAT";
                break;
            }
            case 93: {
                sFieldType = "TIMESTAMP";
                break;
            }
            case 91: {
                sFieldType = "DATE";
                break;
            }
            case 12: {
                sFieldType = "VARCHAR";
                zVarChar2 = true;
                break;
            }
        }
        String strSQL = "ALTER TABLE " + _sTableName + " ADD( " + _sFieldName + " " + sFieldType;
        if (dataType.isLengthDefinedByUser()) {
            if (zVarChar2 && nMaxLength > 8000) {
                nMaxLength = 8000;
            }
            strSQL = _nScale > 0 ? strSQL + "(" + nMaxLength + ", " + _nScale + ")" : strSQL + "(" + nMaxLength + ")";
        }
        if (_bNullable) {
            strSQL = strSQL + " NULL";
        } else {
            if (_sDefaultValue != null) {
                strSQL = strSQL + " DEFAULT ";
                strSQL = dataType.isCharData() ? strSQL + "'" + CMyString.filterForSQL(_sDefaultValue) + "'" : strSQL + _sDefaultValue;
            }
            strSQL = strSQL + " NOT NULL ";
        }
        return strSQL + ")";
    }

    @Override
    public String sqlRenameTable(String _sOldTableName, String _sNewTableName) {
        return "ALTER TABLE " + CMyString.filterForSQL(_sOldTableName) + " rename to " + CMyString.filterForSQL(_sNewTableName);
    }

    @Override
    public String sqlRenameField(String _sTableName, String _sOldFieldName, String _sNewFieldName) {
        return "ALTER TABLE " + CMyString.filterForSQL(_sTableName) + " rename column " + _sOldFieldName + " to " + _sNewFieldName;
    }

    @Override
    protected String keywordsModifyField() {
        return "modify";
    }

    @Override
    public String sqlGetSysDate() {
        return "SYSDATE";
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        return _sFieldName + " like to_date('" + _sDateTime + "','" + _sFormat + "')";
    }

    @Override
    public String sqlDateTime(String _sDateTime, String _sFormat) {
        return "to_date('" + _sDateTime + "','" + _sFormat + "')";
    }

    @Override
    public String sqlDate(String _sDateTime) {
        return this.sqlDateTime(_sDateTime, "yyyy-MM-dd HH24:MI:SS");
    }

    @Override
    public String sqlDateField(String _sDateField) {
        return _sDateField;
    }

    @Override
    public String initQuerySQL(String _strSql, int _nStartIndex, int _nSize) {
        StringBuffer querySQL = new StringBuffer();
        if (_nSize != 9999) {
            querySQL.append("select * from (select my_table.*,rownum as my_rownum from(").append(_strSql).append(") my_table where rownum<").append(_nStartIndex + _nSize).append(") where my_rownum>=").append(_nStartIndex);
        } else {
            querySQL.append("select * from (select my_table.*,rownum as my_rownum from(").append(_strSql).append(") my_table ").append(") where my_rownum>=").append(_nStartIndex);
        }
        return querySQL.toString();
    }

    @Override
    public String sqlQueryTableInfos(String _sUserOwner) {
        String strSQL = "SELECT * 22 COLUMN_ID AS  FROM ALL_TAB_COLUMNS WHERE OWNER='" + _sUserOwner.toUpperCase() + "' ORDER BY TABLE_NAME,COLUMN_NAME";
        return strSQL;
    }

    @Override
    public String sqlQueryTableInfo(String _sUserOwner, String _sTableName) {
        String strSQL = "SELECT *,22  AS COLUMN_ID  FROM ALL_TAB_COLUMNS WHERE OWNER='" + _sUserOwner.toUpperCase() + "' AND TABLE_NAME='" + _sTableName.toUpperCase() + "' ORDER BY TABLE_NAME,COLUMN_NAME";
        return strSQL;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        try {
            return p_rsData.getString(p_nFieldIndex);
        }
        catch (SQLException e) {
            throw new CMyException(40, "\u8bfb\u53d6\u5927\u5b57\u6bb5\u5185\u5bb9\u5931\u8d25.");
        }
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        try {
            return p_rsData.getString(p_sFieldName);
        }
        catch (SQLException e) {
            throw new CMyException(40, "\u8bfb\u53d6\u5927\u5b57\u6bb5\u5185\u5bb9\u5931\u8d25.");
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, "\u53c2\u6570\u65e0\u6548");
        }
        if (p_sValue == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ").append(p_sClobFieldName);
        sql.append(" from ").append(p_sTableName);
        sql.append(" where ").append(p_sWhere);
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            pstmt = p_oConn.prepareStatement(sql.toString());
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                Clob clob = rsData.getClob(1);
                clob.setString(1L, p_sValue);
            }
            boolean clob = true;
            return clob;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548");
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(p_asFieldsAndValues[0]);
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
        }
        sql.append(" from ");
        sql.append(p_sTableName);
        sql.append(" where ").append(p_sWhere);
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            int colIndex;
            pstmt = p_oConn.prepareStatement(sql.toString());
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                colIndex = 1;
                for (int i = 1; i < length; i += 2) {
                    String value = p_asFieldsAndValues[i];
                    if (value == null) {
                        value = "";
                    }
                    Clob clob = rsData.getClob(colIndex++);
                    clob.setString(1L, value);
                }
            }
            colIndex = 1;
            return colIndex != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String sqlGetNextId() {
        return null;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void setStringFieldValue(PreparedStatement _preStat, int _nIndex, String _sValue) throws Exception {
        _preStat.setString(_nIndex, _sValue);
    }

    @Override
    public boolean canDropField() {
        return true;
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String sIdFieldName, int nObjId, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sValue == null) {
            return true;
        }
        return this.setClob(p_oConn, p_sTableName, sIdFieldName, nObjId, new String[]{p_sClobFieldName, p_sValue});
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sIdFieldName, int nObjId, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548");
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(p_asFieldsAndValues[0]);
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
        }
        sql.append(" from ");
        sql.append(p_sTableName);
        sql.append(" where ").append(p_sIdFieldName);
        sql.append("=?");
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            int colIndex;
            pstmt = p_oConn.prepareStatement(sql.toString());
            pstmt.setInt(1, nObjId);
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                colIndex = 1;
                for (int i = 1; i < length; i += 2) {
                    String value = p_asFieldsAndValues[i];
                    if (value == null) {
                        value = "";
                    }
                    Clob clob = rsData.getClob(colIndex++);
                    clob.setString(1L, value);
                }
            }
            colIndex = 1;
            return colIndex != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String sqlModifyField(String _sTableName, String _sFieldName, int _nFieldType, int _nLengthOrPrecision, boolean _bNullable, int _nScale) throws WCMException {
        String strSQL = "ALTER TABLE " + _sTableName + " " + this.keywordsModifyField() + " (" + _sFieldName + " " + this.getTypeName(_nFieldType, _nLengthOrPrecision, _nLengthOrPrecision, _nScale) + " )";
        return strSQL;
    }
}

