/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class CImage {
    private static final int MIN_WIDTH = 108;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image loadImage(String p_PicFile) throws IOException {
        InputStream fins = null;
        try {
            fins = new FileService(p_PicFile).getInputStream();
            BufferedImage bufferedImage = ImageIO.read(fins);
            return bufferedImage;
        }
        finally {
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getWidth(Image p_Image) {
        return p_Image.getWidth(null);
    }

    public int getHeight(Image p_Image) {
        return p_Image.getHeight(null);
    }

    public void drawWatermark(Image p_Image, Color p_Color, String p_sWatermark, String p_sDestFileName) throws IOException {
        this.drawWatermark(p_Image, p_Color, p_sWatermark, p_sDestFileName, I18NMessage.get(CImage.class, "CImage.label1", "\u5b8b\u4f53"), 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawWatermark(Image p_Image, Color p_Color, String p_sWatermark, String p_sDestFileName, String _sFont, int _nFontSize) throws IOException {
        int nPicWidth = this.getWidth(p_Image);
        int nPicHeight = this.getHeight(p_Image);
        BufferedImage buffImg = new BufferedImage(nPicWidth, nPicHeight, 1);
        Graphics graphics = buffImg.getGraphics();
        graphics.drawImage(p_Image, 0, 0, null);
        graphics.setColor(p_Color);
        Font tmpFont = new Font(_sFont, 1, _nFontSize);
        graphics.setFont(tmpFont);
        graphics.drawString(p_sWatermark, nPicWidth / 2, nPicHeight / 2);
        OutputStream fileOut = null;
        try {
            String ext = CMyFile.extractFileExt(p_sDestFileName);
            fileOut = new FileService(p_sDestFileName).getOutputStream();
            ImageIO.write((RenderedImage)buffImg, ext, fileOut);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSmallImage(String p_sSrcPicName, String p_sDestPicName, int p_nSmallPicWidth) throws IOException {
        Image img = this.loadImage(p_sSrcPicName);
        int nPicWidth = img.getWidth(null);
        int nPicHeight = img.getHeight(null);
        if (p_nSmallPicWidth < 108) {
            p_nSmallPicWidth = 108;
        }
        int nPicMax = Math.max(nPicWidth, nPicHeight);
        double lnPicRate = (double)p_nSmallPicWidth / (double)nPicMax;
        int nNewWidth = 0;
        int nNewHeight = 0;
        if (nPicHeight < nPicMax) {
            nNewWidth = p_nSmallPicWidth;
            nNewHeight = (int)(lnPicRate * (double)nPicHeight);
        } else {
            nNewHeight = p_nSmallPicWidth;
            nNewWidth = (int)(lnPicRate * (double)nPicWidth);
        }
        BufferedImage smallImg = new BufferedImage(nNewWidth, nNewHeight, 1);
        smallImg.getGraphics().drawImage(img, 0, 0, nNewWidth, nNewHeight, null);
        if (nPicMax >= p_nSmallPicWidth) {
            smallImg = smallImg.getSubimage(0, 0, nNewWidth, nNewHeight);
        }
        OutputStream fos = null;
        try {
            fos = new FileService(p_sDestPicName).getOutputStream();
            ImageIO.write((RenderedImage)smallImg, CMyFile.extractFileExt(p_sDestPicName), fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void moveFile(String p_srcFileName, String p_destFileName) {
        try {
            int c;
            InputStream in = new FileService(p_srcFileName).getInputStream();
            OutputStream out = new FileService(p_destFileName).getOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            FileService inputFile = new FileService(p_srcFileName);
            inputFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
    }
}

