/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DBType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ExchangeHelper {
    public static final void readFromRs(BaseObj _oBaseObj, ResultSet _rsData, ResultSetMetaData _rsmdData, DBType _oDBType) throws WCMException {
        ExchangeHelper.readFromRs(_oBaseObj, _rsData, _rsmdData, _oDBType, false);
    }

    public static final void readFromRs(BaseObj _oBaseObj, ResultSet _rsData, ResultSetMetaData _rsmdData, DBType _oDBType, boolean _bDataTypeIsString) throws WCMException {
        try {
            if (_rsData == null) {
                return;
            }
            Object objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case 2: 
                    case 3: {
                        if (rsmdData.getScale(i) <= 0) {
                            long lValue = _rsData.getLong(i);
                            if (_rsData.wasNull()) break;
                            objValue = new Long(lValue);
                            break;
                        }
                        Double dValue = new Double(_rsData.getDouble(i));
                        if (_rsData.wasNull()) break;
                        objValue = dValue;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long lValue = _rsData.getLong(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Long(lValue);
                        break;
                    }
                    case 1: 
                    case 12: {
                        objValue = _rsData.getString(i);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = new CMyDateTime();
                        ((CMyDateTime)objValue).setDateTimeWithRs(_rsData, i);
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = new CDBText(_oDBType);
                        ((CDBText)objValue).readFromRs(_rsData, i);
                        break;
                    }
                    case 8: {
                        double dValue = _rsData.getDouble(i);
                        if (_rsData.wasNull()) break;
                        objValue = new Double(dValue);
                        break;
                    }
                    default: {
                        objValue = _rsData.getObject(i);
                    }
                }
                if (objValue == null) continue;
                if (_bDataTypeIsString) {
                    _oBaseObj.setProperty(sFieldName, objValue.toString(), false);
                    continue;
                }
                _oBaseObj.setProperty(sFieldName, objValue, false);
            }
            _oBaseObj.removeProperty(_oBaseObj.getIdFieldName());
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519", ex);
        }
        catch (CMyException ex) {
            throw new WCMException(1, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519", ex);
        }
    }

    public static boolean isForbidFileExt(String _sFileExt) {
        String strSuffixConfig = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG");
        if (CMyString.isEmpty(strSuffixConfig)) {
            return true;
        }
        String sUpperCaseExt = _sFileExt.toUpperCase();
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(strSuffixConfig)) {
            String strAllowExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strAllowExt)) {
                return true;
            }
            strAllowExt = strAllowExt.toUpperCase().trim();
            return ("," + strAllowExt + ",").indexOf("," + sUpperCaseExt + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(strSuffixConfig)) {
            String strForbidExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strForbidExt)) {
                return false;
            }
            strForbidExt = strForbidExt.toUpperCase().trim();
            return ("," + strForbidExt + ",").indexOf("," + sUpperCaseExt + ",") > 0;
        }
        return true;
    }

    public static String parserInnerText(String _sHTMLContent) {
        String sReg = "(?is)<script.*?>.*?</script>";
        String sResult = _sHTMLContent.replaceAll(sReg, "");
        sReg = "(?is)<[^>].*?>";
        sResult = sResult.replaceAll(sReg, "");
        String[] pEntityRegs = new String[]{"&(quot|#34);", "&(amp|#38);", "&(lt|#60);", "&(gt|#62);", "&(nbsp|#160);"};
        String[] pEntitys = new String[]{"\"", "&", "<", ">", " "};
        for (int i = 0; i < pEntityRegs.length; ++i) {
            sResult = sResult.replaceAll(pEntityRegs[i], pEntitys[i]);
        }
        return sResult;
    }

    public static String extractFileExt(String _sFileName) {
        String sFileExt = _sFileName;
        int nPos = _sFileName.lastIndexOf(63);
        if (nPos >= 0) {
            sFileExt = sFileExt.substring(0, nPos);
        }
        if ((nPos = sFileExt.lastIndexOf(46)) <= 0) {
            return null;
        }
        return sFileExt.substring(nPos + 1).toLowerCase();
    }
}

