/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.util;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.util.Category;
import com.trs.components.wcm.util.Categorys;
import com.trs.components.wcm.util.ICategoryMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class CategoryMgr
implements ICategoryMgr {
    @Override
    public void deleteCategory(User user, Category category) throws WCMException {
        if (category == null) {
            return;
        }
        Categorys childrens = this.queryChildren(user, category, null);
        int nSize = childrens.size();
        for (int i = 0; i < nSize; ++i) {
            Category child = (Category)childrens.getAt(i);
            this.deleteCategory(user, child);
        }
        category.delete(user);
    }

    @Override
    public Categorys queryChildren(User user, Category category, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=?", "COrder desc");
        filter.addSearchValues(category == null ? 0 : category.getId());
        filter.mergeWith(_extraFilter);
        return Categorys.openWCMObjs(user, filter);
    }

    @Override
    public String getPath(Categorys categorys) throws WCMException {
        if (categorys == null) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(50);
        int nSize = categorys.size();
        for (int i = 0; i < nSize; ++i) {
            Category category = (Category)categorys.getAt(i);
            if (category == null) continue;
            sbResult.append(this.getPath(category)).append(",");
        }
        if (sbResult.length() > 0) {
            sbResult.setLength(sbResult.length() - 1);
        }
        return sbResult.toString();
    }

    @Override
    public String getPath(Category category) throws WCMException {
        if (category == null) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(50);
        sbResult.insert(0, category.getId());
        while (!category.isRoot()) {
            int parentId = category.getParentId();
            sbResult.insert(0, parentId + ",");
            category = Category.findById(parentId);
        }
        return sbResult.toString();
    }
}

