/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.PinyinHelper;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Source
extends CMSObj {
    public static final int OBJ_TYPE = 608;
    public static final String DB_TABLE_NAME = "WCMSOURCE";
    public static final String DB_ID_NAME = "SOURCEID";
    private boolean m_bCheckedSiteId = false;
    static Hashtable hCharName = null;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 608;
    }

    public String getName() {
        return (String)this.getProperty("SRCNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("SRCNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("SRCDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("SRCDESC", _desc);
    }

    public String getLink() {
        return (String)this.getProperty("SRCLINK");
    }

    public boolean setLink(String _link) throws WCMException {
        return this.setProperty("SRCLINK", _link);
    }

    public int getSecurityId() {
        return this.getPropertyAsInt("SECURITY", 0);
    }

    public Security getSecurity() throws WCMException {
        return Security.findById(this.getSecurityId());
    }

    public boolean setSecurity(int _nSecurityId) throws WCMException {
        return this.setProperty("SECURITY", _nSecurityId);
    }

    public boolean setSecurity(Security _security) throws WCMException {
        if (_security == null || !_security.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Source.class, "Source.label1", "\u65e0\u6548\u7684\u5b89\u5168\u5bf9\u8c61\uff08Source.setSecurity\uff09"));
        }
        return this.setSecurity(_security.getId());
    }

    public int getPrice() {
        return this.getPropertyAsInt("PRICE", 0);
    }

    public boolean setPrice(int _nPrice) throws WCMException {
        return this.setProperty("PRICE", _nPrice);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    public String getType() {
        return (String)this.getProperty("SRCTYPE");
    }

    public boolean setType(String _type) throws WCMException {
        return this.setProperty("SRCTYPE", _type);
    }

    public void setCheckedSiteId(boolean _bCheckedSiteId) {
        this.m_bCheckedSiteId = _bCheckedSiteId;
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        int nSiteId = 0;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("SRCNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(Source.class, "Source.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Source.isValid)"));
            }
            nSiteId = this.getPropertyAsInt("SiteId", 0);
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Source.class, "Source.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Source.isValid)"));
            }
            sName = (String)this.getNewProperty("SRCNAME");
            nSiteId = this.getNewPropertyAsInt("SiteId", 0);
        }
        this.autoSetDesc();
        if (sName != null) {
            String strCondition = " SrcName='" + CMyString.filterForSQL(sName) + "'";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.m_bCheckedSiteId && nSiteId > 0) {
                strCondition = strCondition + " AND (SiteId=" + nSiteId + " or SiteId='0') ";
            }
            if (this.checkExists(strCondition)) {
                return false;
            }
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public static void loadFirstLetter(String _sFileName) throws WCMException {
        if (hCharName == null) {
            hCharName = new Hashtable(300);
        } else {
            hCharName.clear();
        }
        InputStreamReader fileReader = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, CMyString.FILE_WRITING_ENCODING));
            while ((sLine = buffReader.readLine()) != null) {
                String sKey;
                char chrName;
                if ((sLine = sLine.trim()).length() < 2 || (chrName = sLine.charAt(1)) > '\u007f' || hCharName.containsKey(sKey = sLine.substring(0, 1))) continue;
                hCharName.put(sKey, sLine.substring(1, 2).toUpperCase());
            }
        }
        catch (FileNotFoundException ex) {
            throw new WCMException(55, I18NMessage.get(Source.class, "Source.label5", "\u8981\u8bfb\u53d6\u7684\u62fc\u97f3\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyString.getFirstLetter)"), ex);
        }
        catch (IOException ex) {
            throw new WCMException(53, I18NMessage.get(Source.class, "Source.label6", "\u8bfb\u62fc\u97f3\u914d\u7f6e\u6587\u4ef6\u4ef6\u65f6\u9519\u8bef(CMyString.getFirstLetter)"), ex);
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getFirstLetter(String _sFileName, String _str) throws WCMException {
        if (_str == null || _str.length() == 0) {
            return _str;
        }
        String sFirstLetter = _str.substring(0, 1);
        if (sFirstLetter.charAt(0) <= '\u007f') {
            return sFirstLetter;
        }
        if (hCharName == null) {
            Source.loadFirstLetter(_sFileName);
        }
        return (String)hCharName.get(sFirstLetter.toUpperCase());
    }

    public static final Source findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Source)BaseObj.findById(Source.class, _nId);
    }

    public static final Source createNewInstance() throws WCMException {
        return (Source)BaseObj.createNewInstance(Source.class);
    }

    public static final Source findByKey(Object _oKey) throws WCMException {
        return (Source)BaseObj.findByKey(Source.class, _oKey);
    }

    private void autoSetDesc() throws WCMException {
        char firstChar;
        String sDesc = this.getDesc();
        if (this.isChangeProperty("SRCDESC")) {
            sDesc = this.getNewPropertyAsString("SRCDESC");
        }
        if (CMyString.isEmpty(sDesc)) {
            sDesc = this.getName();
            if (this.isChangeProperty("SRCNAME")) {
                sDesc = this.getNewPropertyAsString("SRCNAME");
            }
            this.setDesc(sDesc);
        }
        if ((firstChar = sDesc.charAt(0)) > '\u007f') {
            String pinyinLetter = PinyinHelper.getFirstLetter(sDesc, false);
            this.setDesc(pinyinLetter + "--" + sDesc);
        }
    }

    public int getOrder() {
        return this.getPropertyAsInt("SOURCEORDER", -1);
    }

    public boolean setOrder(int _nOrder) throws WCMException {
        return this.setProperty("SOURCEORDER", _nOrder);
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = nMaxOrder;
                nMoveBeginAt = nNewOrder;
            }
        } else {
            if (!this.isChangeProperty("SOURCEORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("SOURCEORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "SOURCEORDER>=" + nMoveBeginAt + " AND SOURCEORDER <= " + nMoveEndAt;
        String sMoveSql = "UPDATE WCMSOURCE SET SOURCEORDER = SOURCEORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        WCMFilter aFilter = new WCMFilter("", sRegionWhere, "SOURCEORDER desc");
        Sources sources = Sources.openWCMObjs(null, aFilter);
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        for (int i = 0; i < sources.size(); ++i) {
            Source source = (Source)sources.getAt(i);
            if (source == null) continue;
            source.refreshProperty("SOURCEORDER", source.getOrder() + nMoveDirection);
        }
        this.setOrder(nNewOrder);
    }

    private synchronized int getMaxOrder() throws WCMException {
        StringBuffer buff = new StringBuffer("SELECT max(SOURCEORDER) FROM ");
        buff.append(DB_TABLE_NAME);
        return DBManager.getDBManager().sqlExecuteIntQuery(buff.toString());
    }

    public static void main(String[] args) {
        String sFileName = "d:\\winpy2000.txt";
        try {
            long lStartTime = System.currentTimeMillis();
            Source.loadFirstLetter(sFileName);
            long lEndTime = System.currentTimeMillis();
            System.out.println(I18NMessage.get(Source.class, "Source.label8", "\u521d\u59cb\u5316\u6240\u7528\u65f6\u95f4\u4e3a:[") + (lEndTime - lStartTime) + I18NMessage.get(Source.class, "Source.label9", "]\u6beb\u79d2"));
            lStartTime = System.currentTimeMillis();
            System.out.println(Source.getFirstLetter(sFileName, I18NMessage.get(Source.class, "Source.label10", "\u94c1")));
            System.out.println(Source.getFirstLetter(sFileName, I18NMessage.get(Source.class, "Source.label11", "\u56fd")));
            System.out.println(Source.getFirstLetter(sFileName, I18NMessage.get(Source.class, "Source.label12", "\u4eba")));
            lEndTime = System.currentTimeMillis();
            System.out.println(I18NMessage.get(Source.class, "Source.label13", "\u67e5\u8be2\u6240\u7528\u65f6\u95f4\u4e3a:[") + (lEndTime - lStartTime) + I18NMessage.get(Source.class, "Source.label9", "]\u6beb\u79d2"));
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(Source.class, "Source.label14", "\uff1d\uff1d\uff1d\uff1d\uff1d\u88c5\u8f7d\u6c49\u8bed\u62fc\u97f3\u5931\u8d25\uff01\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d\uff1d"));
            ex.printStackTrace();
        }
    }
}

