/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.resource.Status;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.sql.Connection;
import java.util.StringTokenizer;

public class WebSite
extends BaseChannel {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 103;
    public static final String DB_TABLE_NAME = "WCMWEBSITE";
    public static final String DB_ID_NAME = "SITEID";
    public static final String SAVE_STATUS_KEY = "SITE_SAVE_STATUS";
    public static final String AUTO_SAVE_KEY = "SITE_AUTO_SAVE";
    public static final int AUTO_SAVE_EDIT = 0;
    public static final int AUTO_SAVE_CHG_STATUS = 1;
    public static final int AUTO_SAVE_PUBLISH = 2;
    public static final int COMMON_SITE = 0;
    public static final int PHOTO_SITE = 1;
    public static final int VIDEO_SITE = 2;
    public static final int METADATA_SITE = 4;
    public static final int PROP_INDEX_UPLOAD = 0;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 103;
    }

    @Override
    public String getName() {
        return (String)this.getProperty("SITENAME");
    }

    @Override
    public boolean setName(String _name) throws WCMException {
        return this.setProperty("SITENAME", _name);
    }

    @Override
    public String getDesc() {
        String strTemp = (String)this.getProperty("SITEDESC");
        if (CMyString.isEmpty(strTemp)) {
            strTemp = this.getName();
        }
        return strTemp;
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("SITEDESC", _desc);
    }

    public String getFtpServer() {
        return (String)this.getProperty("FTPSERVER");
    }

    public boolean setFtpServer(String _ftpServer) throws WCMException {
        return this.setProperty("FTPSERVER", _ftpServer);
    }

    public String getFtpUser() {
        return (String)this.getProperty("FTPUSER");
    }

    public boolean setFtpUser(String _ftpUser) throws WCMException {
        return this.setProperty("FTPUSER", _ftpUser);
    }

    public String getFtpPassword() {
        return (String)this.getProperty("FTPPASSWORD");
    }

    public boolean setFtpPassword(String _password) throws WCMException {
        return this.setProperty("FTPPASSWORD", _password);
    }

    public String getFtpFolder() {
        return (String)this.getProperty("FTPFOLDER");
    }

    public boolean setFtpFolder(String _ftpFolder) throws WCMException {
        return this.setProperty("FTPFOLDER", _ftpFolder);
    }

    public String getDataPath() {
        return (String)this.getProperty("DATAPATH");
    }

    public boolean setDataPath(String _dataPath) throws WCMException {
        return this.setProperty("DATAPATH", _dataPath);
    }

    public String getWebHttp() {
        return (String)this.getProperty("WEBHTTP");
    }

    public boolean setWebHttp(String _webHttp) throws WCMException {
        return this.setProperty("WEBHTTP", _webHttp);
    }

    @Override
    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public WebSite getParent() throws WCMException {
        return WebSite.findById(this.getParentId());
    }

    @Override
    public boolean setParent(int _parentId) throws WCMException {
        return this.setProperty("PARENTID", _parentId);
    }

    public boolean setParent(WebSite _parent) throws WCMException {
        if (_parent == null) {
            return this.setParent(0);
        }
        if (!_parent.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(WebSite.class, "WebSite.label1", "\u65e0\u6548\u7684\u7236\u7ad9\u70b9\u5bf9\u8c61(WebSite.setParent)"));
        }
        return this.setParent(_parent.getId());
    }

    @Override
    public int getOrder() {
        return this.getPropertyAsInt("SITEORDER", -1);
    }

    public boolean setOrder(int _nOrder) throws WCMException {
        return this.setProperty("SITEORDER", _nOrder);
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = nMaxOrder;
                nMoveBeginAt = nNewOrder;
            }
        } else {
            if (!this.isChangeProperty("SITEORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("SITEORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "SITEORDER>=" + nMoveBeginAt + " AND SITEORDER <= " + nMoveEndAt;
        String sMoveSql = "UPDATE WCMWebSite SET SITEORDER = SITEORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        WCMFilter aFilter = new WCMFilter("", sRegionWhere, "SiteOrder desc");
        WebSites sites = WebSites.openWCMObjs(null, aFilter);
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        for (int i = 0; i < sites.size(); ++i) {
            WebSite child = (WebSite)sites.getAt(i);
            if (child == null) continue;
            child.refreshProperty("SiteOrder", child.getOrder() + nMoveDirection);
        }
        this.setOrder(nNewOrder);
    }

    private synchronized int getMaxOrder() throws WCMException {
        StringBuffer buff = new StringBuffer("SELECT max(SiteOrder) FROM ");
        buff.append(DB_TABLE_NAME);
        return DBManager.getDBManager().sqlExecuteIntQuery(buff.toString());
    }

    public String getOrderBy() {
        return (String)this.getProperty("SITEORDERBY");
    }

    public boolean setOrderBy(String _sOrderBy) throws WCMException {
        return this.setProperty("SITEORDERBY", _sOrderBy);
    }

    public boolean setMainFileName(String _sName) throws WCMException {
        return this.setAttribute("MainFileName", _sName);
    }

    public String getMainFileName() {
        return this.getAttributeValue("MainFileName");
    }

    public boolean setMainFileExt(String _sExt) throws WCMException {
        return this.setAttribute("MainFileExt", _sExt);
    }

    public String getMainFileExt() {
        return this.getAttributeValue("MainFileExt");
    }

    public boolean setOutlineName(String _sName) throws WCMException {
        return this.setAttribute("OutlineName", _sName);
    }

    public String getOutlineName() {
        return this.getAttributeValue("OutlineName");
    }

    public boolean setOutlineExt(String _sExt) throws WCMException {
        return this.setAttribute("OutlineExt", _sExt);
    }

    public String getOutlineExt() {
        return this.getAttributeValue("OutlineExt");
    }

    public boolean setDetailExt(String _sExt) throws WCMException {
        return this.setAttribute("DetailExt", _sExt);
    }

    public String getDetailExt() {
        return this.getAttributeValue("DetailExt");
    }

    public String getPubStatusIds() {
        String sIds = this.getPropertyAsString("PUBSTATUSES");
        return sIds == null ? "" : sIds;
    }

    public Statuses getPubStatuses(User _currUser) throws WCMException {
        Statuses pubStatuses = null;
        try {
            String sIds = this.getPubStatusIds();
            pubStatuses = Statuses.createNewInstance(_currUser);
            if (sIds == null || sIds.length() == 0) {
                return pubStatuses;
            }
            StringTokenizer stIds = new StringTokenizer(sIds, ",");
            Status status = null;
            while (stIds.hasMoreElements()) {
                int nId = Integer.parseInt((String)stIds.nextElement());
                status = Status.findById(nId);
                if (status == null) continue;
                pubStatuses.addElement(status);
            }
            return pubStatuses;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label2", "\u53d6\u7ad9\u70b9\u5141\u8bb8\u53d1\u5e03\u7684\u6587\u6863\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff08WebSite.getPubStatuses\uff09"), ex);
        }
    }

    public boolean setPubStatus(String _statusIds) throws WCMException {
        if (_statusIds == null) {
            _statusIds = "";
        } else if ((_statusIds = _statusIds.trim()).length() > 0) {
            StringTokenizer stIds = new StringTokenizer(_statusIds, ",");
            while (stIds.hasMoreElements()) {
                String sId = (String)stIds.nextElement();
                try {
                    Integer.parseInt(sId);
                }
                catch (Exception ex) {
                    throw new WCMException(10, I18NMessage.get(WebSite.class, "WebSite.label3", "\u65e0\u6548\u7684\u6587\u6863\u72b6\u6001\uff1a") + sId + "\uff08WebSite.setPubStatus\uff09");
                }
            }
        }
        return this.setProperty("PUBSTATUSES", _statusIds);
    }

    public boolean addPubStatus(int _nStatusId) throws WCMException {
        Status status = Status.findById(_nStatusId);
        return this.addPubStatus(status);
    }

    public boolean addPubStatus(Status _status) throws WCMException {
        if (_status == null) {
            throw new WCMException(10, I18NMessage.get(WebSite.class, "WebSite.label4", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u5bf9\u8c61\u4e3a\u7a7a\uff08WebSite.addPubStatus\uff09"));
        }
        try {
            String sIdNew = String.valueOf(_status.getId());
            String sIds = (String)this.getNewProperty("PUBSTATUSES");
            if (sIds == null) {
                sIds = this.getPubStatusIds();
            }
            if (("," + sIds + ",").indexOf("," + sIdNew + ",") >= 0) {
                return false;
            }
            return this.setProperty("PUBSTATUSES", (sIds.length() == 0 ? "" : sIds + ",") + sIdNew);
        }
        catch (WCMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label5", "\u6dfb\u52a0\u5141\u8bb8\u53d1\u5e03\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff08WebSite.addPubStatus\uff09"), ex);
        }
    }

    public boolean setFtpUpload(boolean _isUpload) throws WCMException {
        return this.setSiteProp(0, _isUpload);
    }

    public boolean canFtpUpload() {
        return this.getSiteProp(0);
    }

    public boolean setSiteProp(int _index, boolean _value) throws WCMException {
        int nSitePro = this.getPropertyAsInt("SITEPROP", 0);
        if (this.isAddMode()) {
            nSitePro = this.getPropertyAsInt("SITEPROP", 0);
        } else if (this.isModified() && this.getNewProperty("SITEPROP") != null) {
            nSitePro = ((Number)this.getNewProperty("SITEPROP")).intValue();
        }
        CMyBitsValue aBits = new CMyBitsValue(nSitePro);
        aBits.setBit(_index, _value);
        return this.setProperty("SITEPROP", new Integer(aBits.getValueAsInt()));
    }

    public boolean getSiteProp(int _index) {
        CMyBitsValue aBits = new CMyBitsValue(this.getPropertyAsInt("SITEPROP", 0));
        return aBits.getBit(_index);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("SITENAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(WebSite.class, "WebSite.label6", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("PARENTID") == null) {
                throw new WCMException(1106, I18NMessage.get(WebSite.class, "WebSite.label7", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(WebSite.class, "WebSite.label11", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
            }
            sName = (String)this.getNewProperty("SITENAME");
        }
        if (sName != null) {
            WCMFilter filter = new WCMFilter();
            filter.setFrom(DB_TABLE_NAME);
            StringBuilder where = new StringBuilder("ParentId = ? and SiteName = ?");
            filter.addSearchValues(this.getParentId());
            filter.addSearchValues(sName);
            if (!this.isAddMode()) {
                where.append(" and " + this.getIdFieldName() + " <> ?");
                filter.addSearchValues(this.getId());
            }
            filter.setWhere(where.toString());
            if (DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0) {
                throw new BizError(I18NMessage.get(WebSite.class, "WebSite.label12", "\u7ad9\u70b9\u552f\u4e00\u6807\u8bc6[") + sName + I18NMessage.get(WebSite.class, "WebSite.label13", "]\u5df2\u7ecf\u5b58\u5728"));
            }
        }
        this.changeOrder();
        return true;
    }

    @Override
    protected synchronized int getNextId(Connection _oConn) throws WCMException {
        int nNextId = super.getNextId(_oConn);
        if (this.getAllProperty().get("SITEORDER") == null) {
            this.setOrder(-1);
        }
        return nNextId;
    }

    private String getLocalPubPath(int _nType) throws WCMException {
        try {
            String sPath = FilesMan.getFilesMan().getPathConfigValue("LP", _nType);
            if (sPath == null) {
                return null;
            }
            String sRelatePath = this.getDataPath();
            if (sRelatePath == null) {
                return null;
            }
            sRelatePath = CMyString.setStrEndWith(sRelatePath, File.separatorChar);
            if (_nType != 0 && File.separatorChar != '/') {
                sRelatePath = CMyString.replaceStr(sRelatePath, File.separator, "/");
            }
            return sPath + sRelatePath;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label14", "\u83b7\u53d6\u7ad9\u70b9\u6587\u6863\u5b58\u653e\u7684\u672c\u5730\u8def\u5f84\u65f6\u5931\u8d25\uff08WebSite.getLocalPubPath\uff09"), ex);
        }
    }

    public String getLocalPath() throws WCMException {
        return this.getLocalPubPath(0);
    }

    public String getLocalHttpPath() throws WCMException {
        return this.getLocalPubPath(1);
    }

    public String getLocalFtpPath() throws WCMException {
        return this.getLocalPubPath(2);
    }

    public String getSaveStatusIds() {
        return "";
    }

    public Statuses getSaveStatuses(User _currUser) throws WCMException {
        Statuses saveStatuses = null;
        try {
            String sIds = this.getSaveStatusIds();
            saveStatuses = new Statuses(_currUser);
            if (sIds == null || sIds.length() == 0) {
                return saveStatuses;
            }
            StringTokenizer stIds = new StringTokenizer(sIds, ",");
            Status status = null;
            while (stIds.hasMoreElements()) {
                int nId = Integer.parseInt((String)stIds.nextElement());
                status = Status.findById(nId);
                if (status == null) continue;
                saveStatuses.addElement(status);
            }
            return saveStatuses;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WebSite.class, "WebSite.label15", "\u53d6\u7ad9\u70b9\u5141\u8bb8\u4fdd\u5b58\u7684\u6587\u6863\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff08WebSite.getSaveStatuses\uff09"), ex);
        }
    }

    @Override
    public WebSite getSite() {
        return this;
    }

    @Override
    public int getSiteId() {
        return this.id;
    }

    @Override
    public boolean isSite() {
        return true;
    }

    public static final WebSite findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (WebSite)BaseObj.findById(WebSite.class, _nId);
    }

    public static final WebSite createNewInstance() throws WCMException {
        return (WebSite)BaseObj.createNewInstance(WebSite.class);
    }

    public static final WebSite findByKey(Object _oKey) throws WCMException {
        return (WebSite)BaseObj.findByKey(WebSite.class, _oKey);
    }

    @Override
    public BaseChannel getHost() {
        return null;
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getDesc();
        }
        return this.getDesc() + I18NMessage.get(WebSite.class, "WebSite.label16", "[\u7ad9\u70b9-") + this.getId() + "]";
    }

    @Override
    public String getInfo() {
        return this.toString();
    }

    public int getType() {
        return this.getPropertyAsInt("SiteType", 0);
    }

    public boolean setType(int siteType) throws WCMException {
        return this.setProperty("SiteType", siteType);
    }

    public boolean isMobile() {
        return this.getPropertyAsBoolean("ISMOBILE", false);
    }

    public boolean setMobile(boolean _bMobile) throws WCMException {
        return this.setProperty("ISMOBILE", _bMobile);
    }

    public int getMediaType() {
        return this.getPropertyAsInt("MediaType", 0);
    }

    public boolean setMediaType(int mediaType) throws WCMException {
        return this.setProperty("MediaType", mediaType);
    }

    public int getChnlOutlineTemp() {
        return this.getPropertyAsInt("CHNLOUTLINETEMP", 0);
    }

    public boolean setChnlOutlineTemp(int chnlOutlineTemp) throws WCMException {
        return this.setProperty("CHNLOUTLINETEMP", chnlOutlineTemp);
    }
}

