/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.intelligence;

import com.trs.components.wcm.content.domain.intelligence.FilePathFilter;
import com.trs.components.wcm.content.domain.intelligence.IIntellResLocator;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.HashMap;

public class IntellResLocatorImpl
implements IIntellResLocator {
    @Override
    public String[] findSiteKinds(String _sSrcPath) throws WCMException {
        HashMap[] configs = this.loadConfig(_sSrcPath);
        String[] fileNames = this.getFilePathNames(_sSrcPath);
        String[] retVal = new String[fileNames.length];
        for (int i = 0; i < retVal.length; ++i) {
            String sKey = fileNames[i];
            String sValue = (String)configs[0].get(sKey);
            retVal[i] = sValue == null ? fileNames[i] : sValue;
        }
        return retVal;
    }

    private String[] getFilePathNames(String _sSrcPath) throws WCMException {
        FileService srcPath = new FileService(_sSrcPath);
        if (!srcPath.exists()) {
            throw new WCMException(I18NMessage.get(IntellResLocatorImpl.class, "IntellResLocatorImpl.label1", "\u6307\u5b9a\u7684\u76ee\u5f55[") + _sSrcPath + I18NMessage.get(IntellResLocatorImpl.class, "IntellResLocatorImpl.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        FileStore[] pFilePaths = srcPath.listFiles(new FilePathFilter());
        String[] pSiteKinds = new String[pFilePaths.length];
        int targetIndex = 0;
        for (int i = 0; i < pSiteKinds.length; ++i) {
            if ("web-inf".equalsIgnoreCase(pFilePaths[i].getName()) || "config.txt".equalsIgnoreCase(pFilePaths[i].getName()) || "echo.jsp".equalsIgnoreCase(pFilePaths[i].getName())) continue;
            pSiteKinds[targetIndex] = pFilePaths[i].getName();
            ++targetIndex;
        }
        return pSiteKinds;
    }

    private HashMap[] loadConfig(String _sSrcPath) throws WCMException {
        String sContentFile = _sSrcPath + "config.txt";
        if (!CMyFile.fileExists(sContentFile)) {
            return null;
        }
        try {
            String sContent = CMyFile.readFile(sContentFile);
            HashMap[] retVal = new HashMap[]{new HashMap(), new HashMap()};
            String[] lines = sContent.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                int nIndex;
                String sTemp = lines[i].trim();
                if (sTemp.equals("") || sTemp.startsWith("#") || (nIndex = sTemp.indexOf("=")) == -1) continue;
                String sTrueName = sTemp.substring(0, nIndex).trim();
                String sDisplayName = sTemp.substring(nIndex + 1).trim();
                retVal[0].put(sTrueName, sDisplayName);
                retVal[1].put(sDisplayName, sTrueName);
            }
            return retVal;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(IntellResLocatorImpl.class, "IntellResLocatorImpl.label3", "\u8bfb\u53d6\u6587\u4ef6[") + sContentFile + I18NMessage.get(IntellResLocatorImpl.class, "IntellResLocatorImpl.label4", "]\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    public String[] findSiteStylesOfKind(String _sSrcPath, String _sKindName) throws WCMException {
        HashMap[] configs = this.loadConfig(_sSrcPath);
        String sKindPath = (String)configs[1].get(_sKindName);
        if (sKindPath == null) {
            sKindPath = _sKindName;
        }
        String[] fileNames = null;
        fileNames = _sSrcPath.endsWith(File.separator) ? this.getFilePathNames(_sSrcPath + sKindPath) : this.getFilePathNames(_sSrcPath + File.separatorChar + sKindPath);
        String[] retVal = new String[fileNames.length];
        for (int i = 0; i < retVal.length; ++i) {
            String sKey = sKindPath + '.' + fileNames[i];
            String sValue = (String)configs[0].get(sKey);
            retVal[i] = sValue == null ? fileNames[i] : sValue.split("\\.")[1];
        }
        return retVal;
    }

    @Override
    public String getSiteKindPath(String _sSrcPath, String _sKindName) throws WCMException {
        HashMap[] configs = this.loadConfig(_sSrcPath);
        String sKindPath = (String)configs[1].get(_sKindName);
        if (sKindPath == null) {
            sKindPath = _sKindName;
        }
        return _sSrcPath + File.separatorChar + sKindPath;
    }

    @Override
    public String getSiteKindStylePath(String _sSrcPath, String _sKindName, String _sStyle) throws WCMException {
        String sStylePath;
        HashMap[] configs = this.loadConfig(_sSrcPath);
        String sKindPath = (String)configs[1].get(_sKindName);
        if (sKindPath == null) {
            sKindPath = _sKindName;
        }
        sStylePath = (sStylePath = (String)configs[1].get(sKindPath + '.' + _sStyle)) == null ? _sStyle : sStylePath.split("\\.")[1];
        String stylePath = "";
        stylePath = _sSrcPath.endsWith(File.separator) ? _sSrcPath + sKindPath + File.separatorChar + sStylePath : _sSrcPath + File.separatorChar + sKindPath + File.separatorChar + sStylePath;
        return stylePath;
    }
}

