/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.content.ExtendedField;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;

public class ContentExtFieldLCListenerForDocFields
implements IObjectLCListenerOnDel {
    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        ContentExtField contentExtField = (ContentExtField)_oObjDeleted;
        int nHostId = contentExtField.getObjId();
        int nHostType = contentExtField.getObjType();
        if (nHostType != 101) {
            return;
        }
        int nExtId = contentExtField.getExtFieldId();
        ExtendedField extfield = ExtendedField.findById(nExtId);
        if (extfield == null) {
            return;
        }
        String sFieldName = "WCMDocument." + extfield.getName();
        Channel channel = Channel.findById(nHostId);
        if (channel == null) {
            return;
        }
        String showFields = channel.getPropertyAsString("SHOWFIELDS", "");
        String sFieldWidth = channel.getPropertyAsString("FIELDSWIDTH", "");
        String sNewshowFields = "";
        String sNewFieldWidth = "";
        int index = showFields.indexOf(sFieldName);
        if (index > -1) {
            String[] aShowFields = showFields.split(",");
            String[] aFieldWidth = sFieldWidth.split(",");
            for (int i = 0; i < aShowFields.length; ++i) {
                if (sFieldName.equalsIgnoreCase(aShowFields[i])) continue;
                if (sNewshowFields == "") {
                    sNewshowFields = sNewshowFields + aShowFields[i];
                    sNewFieldWidth = sNewFieldWidth + aFieldWidth[i];
                    continue;
                }
                sNewshowFields = sNewshowFields + "," + aShowFields[i];
                sNewFieldWidth = sNewFieldWidth + "," + aFieldWidth[i];
            }
            channel.setPropertyWithString("SHOWFIELDS", sNewshowFields);
            channel.setPropertyWithString("FIELDSWIDTH", sNewFieldWidth);
            channel.save();
        }
    }
}

