/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.filter.IQueryFilter;
import com.trs.components.filter.IQueryFilterFactory;
import com.trs.components.filter.QueryFilterFactory;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaDataCenterHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.center.xml.MetaViewDataExporter;
import com.trs.components.metadata.center.xml.MetaViewDataImporter;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.service.MetaDataDefServiceProvider;
import com.trs.components.metadata.service.MetaViewDataExporter4MuchData;
import com.trs.components.metadata.service.ViewRangeConstants;
import com.trs.components.metadata.service.WCMFilterMakerForContainsChildren;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.domain.transmit.IDocumentTransmitor;
import com.trs.components.wcm.content.domain.transmit.IDocumentTransmitorFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.DocLevelMgr;
import com.trs.components.wcm.resource.DocLevels;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.FieldInfo;
import com.trs.wcm.publish.PreviewURLSign;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataCenterServiceProvider
implements ISelfDefinedServiceProvider {
    public static final String KEY_PRIVATE_PREVIEW_ACCESS = ConfigConstants.DIR_APPROOT + "private_platform_log.key";
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private IClassInfoViewMgr m_oClassInfoViewMgr = null;
    private Logger logger = Logger.getLogger(MetaDataCenterServiceProvider.class);
    private AppendixMgr m_oAppendixMgr = null;
    private IMetaDataDefCacheMgr m_oMetaDataDefCacheMgr = null;
    private static final String SQL_QUERY_CHANNELS = "exists(select 1 from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ViewId=? and XWCMMetaViewEmployer.ChannelId=WCMChnlDoc.ChnlId)";

    public MetaDataCenterServiceProvider() {
        this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        this.m_oClassInfoViewMgr = (IClassInfoViewMgr)DreamFactory.createObjectById("IClassInfoViewMgr");
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    }

    public MetaViewData saveMetaViewData(MethodContext _methodContext) throws Throwable {
        Document document;
        User loginUser = this.getLoginUser();
        Channel channel = null;
        MetaView view = null;
        MetaViewData oMetaViewData = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label2", "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01"));
            }
            view = this.findViewByChannel(channel);
            oMetaViewData = new MetaViewData(view);
        } else {
            oMetaViewData = MetaViewData.findById(nObjectId);
            if (oMetaViewData == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5728\u6307\u5b9a\u89c6\u56fe\u4e0b\u63d0\u4ea4\u7684\u6570\u636e\uff01[Id=") + nObjectId + "]");
            }
            channel = oMetaViewData.getChannel();
            _methodContext.setValue("channelId", channel.getId());
            document = oMetaViewData.getDocument();
            int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
            if (nFlowDocId > 0 && nObjectId > 0) {
                WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 0, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label4", "\u4fee\u6539"));
            } else if (!DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, document, 32)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label5", "]\u4e0b\u4fee\u6539\u8bb0\u5f55\uff01"));
            }
            view = oMetaViewData.getMetaView();
            oMetaViewData.validCanEditAndLock(loginUser);
        }
        oMetaViewData = MetaDataCenterServiceProvider.setViewDataProperties(_methodContext, oMetaViewData);
        MetaDataCenterHelper.renderFields(oMetaViewData);
        MetaDataCenterClassInfoHelper.renderClassInfoFields(oMetaViewData);
        if (_methodContext.getValue("DocStatus", 0) == 1028) {
            oMetaViewData.setSkipValid(true);
        }
        oMetaViewData.save(loginUser);
        if (nObjectId > 0) {
            int nDocStatus = _methodContext.getValue("DocStatus", 0);
            Document document2 = oMetaViewData.getDocument();
            if (nDocStatus == 1 && document2.getStatusId() == 1028) {
                DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                documentMgr.changeStatus(document2, document2.getChannel(), Status.findById(1));
            }
        }
        document = Document.findById(oMetaViewData.getId());
        try {
            WCMProcessServiceHelper.startDocumentInFlow(loginUser, document, _methodContext);
        }
        catch (Throwable ex) {
            ServiceInvocationException exp = new ServiceInvocationException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label6", "\u867d\u7136\u5df2\u6210\u529f\u65b0\u589e\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label7", "]\uff0c\u4f46\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01"), ex);
            exp.setErrorCode("17080");
            throw exp;
        }
        return oMetaViewData;
    }

    public Reports importMetaViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = null;
        MetaView view = null;
        channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
            throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label8", "]\u4e0b\u65b0\u5efa\u6587\u6863\uff01"));
        }
        view = this.findViewById(_methodContext.getValue("ViewId", 0));
        String sXSLFile = null;
        sXSLFile = _methodContext.getValue("XMLSource", 3) == 3 ? MetaDataDefHelper.getViewApplicationPath(view.getId()) + "data.xsl" : _methodContext.getValue("XSLFile");
        MetaViewDataImporter importer = new MetaViewDataImporter(loginUser, view, channel);
        importer.setImportToCurrChannel(_methodContext.getValue("ImportToCurrChannel", true));
        importer.setImportByChnlName(_methodContext.getValue("ImportByChnlName", true));
        return importer.importFromFile(1, _methodContext.getValue("ImportFile"), sXSLFile);
    }

    public MetaViewDatas queryViewDatas(MethodContext _methodContext) throws Throwable {
        int nFilterType;
        User loginUser = this.getLoginUser();
        Channel channel = null;
        MetaView view = null;
        int nViewId = _methodContext.getValue("ViewId", 0);
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        } else {
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            view = this.findViewByChannel(channel);
        }
        Channels channels = new Channels(null, 1, 1);
        if (channel != null) {
            int queryType = _methodContext.getValue("_queryType_", 0);
            if (queryType == ViewRangeConstants.SAME_VIEW_CONTAIN_CHILDREN || channel.isContainsChildren()) {
                WCMFilterMakerForContainsChildren maker = new WCMFilterMakerForContainsChildren(channel);
                maker.execute(loginUser);
                channels = maker.getCurrChannels();
            } else if (queryType == ViewRangeConstants.SAME_VIEW_CONTAIN_ALL) {
                channels = this.m_oMetaViewEmployerMgr.getEmployers(view, null);
            } else {
                channels.addElement(channel);
            }
        } else {
            channels = this.m_oMetaViewEmployerMgr.getEmployers(view, null);
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel oChannel = (Channel)channels.getAt(i);
            if (oChannel == null || AuthServer.hasRight(loginUser, (CMSObj)oChannel, 30)) continue;
            channels.remove(oChannel, false);
        }
        MetaViewDatas viewDatas = new MetaViewDatas(view);
        viewDatas.setCurrUser(loginUser);
        if (channels.isEmpty()) {
            return viewDatas;
        }
        WCMFilter filter = this.getQueryFilter(_methodContext, loginUser, view);
        viewDatas.setSelectFields(_methodContext.getValue("ChnlDocSelectFields"), filter.getSelect());
        filter.setSelect(null);
        String sqlWhere = _methodContext.getValue("_sqlWhere_");
        if (!CMyString.isEmpty(sqlWhere)) {
            if (filter.getWhere().length() > 0) {
                boolean isOr = _methodContext.getValue("IsOr", true);
                filter.setWhere(filter.getWhere() + (isOr ? " or " : " and ") + "(" + sqlWhere + ")");
            } else {
                filter.setWhere("(" + sqlWhere + ")");
            }
        }
        if ((nFilterType = _methodContext.getValue("FilterType", -1)) != -1) {
            IQueryFilterFactory oQueryFilterFactory = QueryFilterFactory.getInstance();
            IQueryFilter oQueryFilter = oQueryFilterFactory.createQueryFilter(nFilterType);
            WCMFilter filterQuery = oQueryFilter.getFilter(_methodContext);
            filter.mergeWith(filterQuery);
        }
        WCMFilter filterWihtClassInfos = MetaDataCenterHelper.makeFilterWithClassInfos(_methodContext.getValue("ClassInfoIds"), _methodContext.getValue("ContainsChildClassInfoIds", true));
        filter.mergeWith(filterWihtClassInfos);
        this.logger.debug((Object)filter);
        viewDatas.setPageSize(_methodContext.getPageSize());
        viewDatas.setCurrPage(_methodContext.getPageIndex());
        viewDatas.setRightIndex(64);
        viewDatas.setNeedWithAuthFilter(loginUser, true);
        if (channels.size() > 900) {
            StringBuffer sbWhere = new StringBuffer(1024);
            WCMFilter channelFilter = new WCMFilter("", "", "");
            this.makeDocLevelWhere(channelFilter, sbWhere);
            String sWhere = "exists(select 1 from XWCMMetaViewEmployer where XWCMMetaViewEmployer.ViewId=" + view.getId() + " and XWCMMetaViewEmployer.ChannelId=WCMChnlDoc.ChnlId and exists(select 1 from WCMChannel where XWCMMetaViewEmployer.ChannelId=WCMChannel.ChannelId and (WCMChannel.USEDOCLEVEL =0 or WCMChannel.USEDOCLEVEL is null or (WCMChannel.USEDOCLEVEL =1 " + sbWhere + "))))";
            channelFilter.setWhere(sWhere);
            filter.mergeWith(channelFilter);
            viewDatas.loadViewDatas(filter);
        } else {
            viewDatas.open(channels, filter);
        }
        return viewDatas;
    }

    public MetaViewDatas queryViewDatasNoView(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sMainTableName = _methodContext.getValue("TABLENAME");
        MetaViewDatas viewDatas = new MetaViewDatas(sMainTableName);
        viewDatas.setCurrUser(loginUser);
        String sSelectFields = _methodContext.getValue("SELECTFIELDS");
        String sSelectDBFields = this.tranFieldName(_methodContext, sSelectFields);
        WCMFilter filter = this.getQueryFilter(_methodContext, loginUser);
        WCMFilter selectFilter = new WCMFilter("", "", "", sSelectDBFields);
        filter.mergeWith(selectFilter);
        this.logger.debug((Object)filter);
        String where = filter.getWhere();
        String relWhere = sMainTableName + ".metadataid = WCMChnlDoc.docid";
        where = CMyString.isEmpty(where) ? relWhere : relWhere + " and (" + where + ")";
        filter.setWhere(where);
        filter.setFrom(sMainTableName + ",WCMChnlDoc");
        viewDatas.setSelectFields(_methodContext.getValue("ChnlDocSelectFields"), sSelectDBFields);
        viewDatas.setPageSize(_methodContext.getPageSize());
        viewDatas.setCurrPage(_methodContext.getPageIndex());
        viewDatas.setRightIndex(64);
        viewDatas.setNeedWithAuthFilter(loginUser, true);
        this.logger.debug((Object)filter);
        viewDatas.loadViewDatas(filter);
        return viewDatas;
    }

    private WCMFilter getQueryFilter(MethodContext _methodContext, User _loginUser, MetaView _view) throws WCMException, CMyException {
        MetaViewFields viewFields = this.m_oMetaDataDefMgr.getViewFields(_loginUser, _view, new WCMFilter("", "InOutline=1 or SearchField=1", ""));
        boolean bMultiTable = _view.isMultiTable();
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer sbSelectFields = new StringBuffer((viewFields.size() + 1) * 10);
        StringBuffer sbWhereFields = new StringBuffer(viewFields.size() * 10);
        sbSelectFields.append("MetaDataId");
        String sTrueTableName = _view.getTrueTableName();
        int nSize = viewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField field = (MetaViewField)viewFields.getAt(i);
            if (field == null) continue;
            if (field.isInOutline()) {
                sbSelectFields.append(",");
                if (bMultiTable || field.getDBName().equalsIgnoreCase(field.getName())) {
                    sbSelectFields.append(field.getName());
                } else {
                    sbSelectFields.append(field.getDBName() + " " + field.getName());
                }
            }
            if (!field.isSearchField()) continue;
            boolean isMultiValue = false;
            String sFieldName = null;
            String sParamName = field.getTableName() + "." + field.getDBName();
            sFieldName = bMultiTable ? sTrueTableName + "." + field.getName() : sTrueTableName + "." + field.getDBName();
            String sSearchValue = _methodContext.getValue(sParamName);
            if (sSearchValue == null) {
                sSearchValue = _methodContext.getValue(field.getName());
            }
            if (!_methodContext.getValue("_isAdvanceSearch_", false) && !CMyString.isEmpty(sSearchValue)) {
                String orignSearchValue = sSearchValue;
                if (CMyString.isEmpty(sSearchValue = this.getIdsFromDescs(field, sSearchValue))) {
                    sSearchValue = orignSearchValue;
                }
                if (CMyString.isEmpty(sSearchValue) && !_methodContext.getValue("IsOr", true)) {
                    sbWhereFields = new StringBuffer("1 != 1");
                }
            }
            if (field.getType() == 9 || field.getType() == 10) {
                isMultiValue = true;
            }
            this.makeFilter(filter, sbWhereFields, sFieldName, field.getDBType(), sSearchValue, _methodContext.getValue("IsOr", true), _methodContext, isMultiValue);
        }
        String sViewDataSelectFields = _methodContext.getValue("ViewDataSelectFields");
        if (!CMyString.isEmpty(sViewDataSelectFields)) {
            if (("," + sViewDataSelectFields + ",").indexOf(",MetaDataId,") < 0) {
                sViewDataSelectFields = sViewDataSelectFields + ",MetaDataId";
            }
            filter.setSelect(sViewDataSelectFields);
        } else {
            filter.setSelect(sbSelectFields.toString());
        }
        if (sbWhereFields.length() > 0) {
            filter.setWhere(sbWhereFields.toString());
        }
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        return filter;
    }

    private WCMFilter getQueryFilter(MethodContext _methodContext, User _loginUser) throws Throwable {
        String sCurrField;
        WCMFilter filter = new WCMFilter("", "", "", "");
        String sSelectFields = _methodContext.getValue("SELECTFIELDS");
        if (sSelectFields.indexOf(sCurrField = CMyString.showNull(_methodContext.getValue("CURRFIELD"))) == -1) {
            sSelectFields = sSelectFields + "," + sCurrField;
        }
        String[] aSelectFields = sSelectFields.split(",");
        String sAndOr = " or ";
        if (!"true".equals(_methodContext.getValue("ISOR"))) {
            sAndOr = " and ";
        }
        int nViewId = _methodContext.getValue("VIEWID", 0);
        MetaView _view = MetaView.findById(nViewId);
        MetaViewFields viewFields = this.m_oMetaDataDefMgr.getViewFields(_loginUser, _view, new WCMFilter("", "InOutline=1 or SearchField=1", ""));
        StringBuffer sbWhereFields = new StringBuffer(viewFields.size() * 10);
        String sTrueTableName = _methodContext.getValue("TABLENAME");
        String sFieldName2 = null;
        for (String sFieldName2 : aSelectFields) {
            MetaViewField field = this.m_oMetaDataDefCacheMgr.getMetaViewField(nViewId, sFieldName2);
            if (field == null || field.isFromMainTable() || !field.isSearchField() && !field.getName().equalsIgnoreCase(sCurrField)) continue;
            boolean isMultiValue = false;
            sFieldName2 = sTrueTableName + "." + field.getDBName();
            String sSearchValue = _methodContext.getValue(field.getName());
            if (!_methodContext.getValue("_isAdvanceSearch_", false) && !CMyString.isEmpty(sSearchValue)) {
                String orignSearchValue = sSearchValue;
                if (CMyString.isEmpty(sSearchValue = this.getIdsFromDescs(field, sSearchValue))) {
                    sSearchValue = orignSearchValue;
                }
                if (CMyString.isEmpty(sSearchValue) && !_methodContext.getValue("IsOr", true)) {
                    sbWhereFields = new StringBuffer("1 != 1");
                }
            }
            if (field.getType() == 9 || field.getType() == 10) {
                isMultiValue = true;
            }
            this.makeFilter(filter, sbWhereFields, sFieldName2, field.getDBType(), sSearchValue, _methodContext.getValue("IsOr", true), _methodContext, isMultiValue);
        }
        String sMetaDataId = _methodContext.getValue("METADATAID");
        if (!CMyString.isEmpty(sMetaDataId)) {
            if (sbWhereFields.length() > 0) {
                sbWhereFields.append(sAndOr).append(' ');
            }
            sbWhereFields.append("MetaDataId = ? ");
            filter.addSearchValues(Integer.parseInt(sMetaDataId));
        }
        if (sbWhereFields.length() > 0) {
            filter.setWhere(sbWhereFields.toString());
        }
        this.logger.debug((Object)filter);
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        this.logger.debug((Object)filter);
        return filter;
    }

    private String tranFieldName(MethodContext _methodContext, String sSelectFields) throws WCMException {
        String sCurrField = CMyString.showNull(_methodContext.getValue("CURRFIELD"));
        if (sSelectFields.indexOf(sCurrField) == -1) {
            sSelectFields = sSelectFields + "," + sCurrField;
        }
        String[] aSelectFields = sSelectFields.split(",");
        int nViewId = _methodContext.getValue("VIEWID", 0);
        String[] aSelectDBFields = new String[aSelectFields.length];
        String sFieldName2 = null;
        for (String sFieldName2 : aSelectFields) {
            MetaViewField field = this.m_oMetaDataDefCacheMgr.getMetaViewField(nViewId, sFieldName2);
            if (field == null || field.isFromMainTable()) continue;
            aSelectDBFields[i] = field.getDBName();
        }
        String sSelectDBFields = "";
        boolean flag = false;
        for (int i = 0; i < aSelectDBFields.length; ++i) {
            if (CMyString.isEmpty(aSelectDBFields[i])) continue;
            if (!flag) {
                sSelectDBFields = aSelectDBFields[i];
                flag = true;
            }
            sSelectDBFields = sSelectDBFields + "," + aSelectDBFields[i];
        }
        return sSelectDBFields;
    }

    private String getIdsFromDescs(MetaViewField _field, String _sSearchValue) throws WCMException {
        if (CMyString.isEmpty(_sSearchValue)) {
            return _sSearchValue;
        }
        switch (MetaDataConstants.formatOfEnumValue(_field.getType())) {
            case -1: {
                StringBuffer sbSearchValue = new StringBuffer(100);
                String[] aKeys = _field.getValuesFromLabel(_sSearchValue);
                for (int i = 0; i < aKeys.length; ++i) {
                    sbSearchValue.append(aKeys[i]).append("|");
                }
                if (sbSearchValue.length() > 0) {
                    sbSearchValue.setLength(sbSearchValue.length() - 1);
                }
                _sSearchValue = sbSearchValue.toString();
                break;
            }
            case 10: {
                WCMFilter filter = new WCMFilter();
                StringBuffer sbWhere = new StringBuffer(100);
                sbWhere.append("(ClassInfoId=").append(_field.getClassId());
                sbWhere.append(" or RootId=").append(_field.getClassId());
                sbWhere.append(") and  (CName like ?) ");
                filter.addSearchValues("%" + _sSearchValue + "%");
                filter.setWhere(sbWhere.toString());
                ClassInfos classInfos = ClassInfos.openWCMObjs(null, filter);
                _sSearchValue = classInfos.getIdListAsString('|');
                break;
            }
        }
        return _sSearchValue;
    }

    private void makeFilter(WCMFilter _filter, StringBuffer _sbWhereFields, String _sSearchName, int _nSearchType, String _sSearchValue, boolean _bIsOr, MethodContext _methodContext, boolean _bIsMultiValue) throws CMyException {
        if (_nSearchType != 93) {
            this.makeFilterForNormalField(_filter, _sbWhereFields, _sSearchName, _nSearchType, _sSearchValue, _bIsOr, _bIsMultiValue);
        } else {
            this.makeFilterForDateField(_filter, _sbWhereFields, _sSearchName, _sSearchValue, _methodContext);
        }
    }

    private void makeFilterForNormalField(WCMFilter _filter, StringBuffer _sbWhereFields, String _sSearchName, int _nSearchType, String _sSearchValue, boolean _bIsOr, boolean _bIsMultiValue) {
        if (CMyString.isEmpty(_sSearchValue)) {
            return;
        }
        if (_sbWhereFields.length() > 0) {
            _sbWhereFields.append(_bIsOr ? " or " : " and ");
        }
        String[] aSearchValue = null;
        boolean isOr = false;
        if (_sSearchValue.indexOf(124) >= 0) {
            aSearchValue = _sSearchValue.split("\\|");
            isOr = true;
        } else {
            aSearchValue = _sSearchValue.split("\\s");
            isOr = false;
        }
        _sbWhereFields.append("(");
        if (_bIsMultiValue) {
            _sSearchName = DBManager.getDBManager().getDBType().sqlConcatStr("','", _sSearchName, "','");
        }
        for (int j = 0; j < aSearchValue.length; ++j) {
            aSearchValue[j] = aSearchValue[j].trim();
            if (CMyString.isEmpty(aSearchValue[j])) continue;
            if (_bIsMultiValue) {
                aSearchValue[j] = "," + aSearchValue[j] + ",";
            }
            this.setFilterOfNormalField(_filter, _sbWhereFields, _sSearchName, _nSearchType, aSearchValue[j]);
            if (j >= aSearchValue.length - 1) continue;
            _sbWhereFields.append(isOr ? " or " : " and ");
        }
        _sbWhereFields.append(")");
    }

    private void setFilterOfNormalField(WCMFilter _filter, StringBuffer _sbWhereFields, String _sSearchName, int _nSearchType, String _sSearchValue) {
        if (_sSearchValue == null || CMyString.isEmpty(_sSearchValue)) {
            return;
        }
        switch (_nSearchType) {
            case 12: 
            case 2005: {
                _sbWhereFields.append(_sSearchName);
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" not");
                    _sSearchValue = _sSearchValue.substring(1);
                }
                _sbWhereFields.append(" like ?");
                _filter.addSearchValues("%" + _sSearchValue + "%");
                break;
            }
            case 4: {
                int intSearchValue;
                try {
                    intSearchValue = Integer.parseInt(_sSearchValue);
                }
                catch (Throwable e) {
                    intSearchValue = 0;
                }
                _sbWhereFields.append(_sSearchName);
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" !");
                    intSearchValue = -intSearchValue;
                }
                _sbWhereFields.append("=?");
                _filter.addSearchValues(intSearchValue);
                break;
            }
            case 6: {
                float floatSearchValue;
                try {
                    floatSearchValue = Float.parseFloat(_sSearchValue);
                }
                catch (Throwable e) {
                    floatSearchValue = 0.0f;
                }
                _sbWhereFields.append(_sSearchName);
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" !");
                }
                _sbWhereFields.append("=?");
                _filter.addSearchValues(floatSearchValue);
                break;
            }
            case 8: {
                double doubleSearchValue;
                try {
                    doubleSearchValue = Double.parseDouble(_sSearchValue);
                }
                catch (Throwable e) {
                    doubleSearchValue = 0.0;
                }
                _sbWhereFields.append(_sSearchName);
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" !");
                }
                _sbWhereFields.append("=?");
                _filter.addSearchValues(doubleSearchValue);
                break;
            }
        }
    }

    private void makeFilterForDateField(WCMFilter _filter, StringBuffer _sbWhereFields, String _sSearchName, String _sSearchValue, MethodContext _methodContext) throws CMyException {
        boolean _bIsOr = _methodContext.getValue("IsOr", true);
        boolean isAdvanceSearch = _methodContext.getValue("_isAdvanceSearch_", false);
        CMyDateTime dtTemp = new CMyDateTime();
        if (isAdvanceSearch) {
            int ix = _sSearchName.indexOf("WCMMetaTable");
            String sParamName = null;
            if (ix == 0) {
                sParamName = _sSearchName.substring("WCMMetaTable".length());
            }
            String sDateStartSuffix = _methodContext.getValue("_dateStartSuffix_");
            String sStartTimeValue = _methodContext.getValue(_sSearchName + sDateStartSuffix);
            if (sStartTimeValue == null && ix == 0) {
                sStartTimeValue = _methodContext.getValue(sParamName + sDateStartSuffix);
            }
            if (!dtTemp.testDateFormat(sStartTimeValue)) {
                sStartTimeValue = null;
            }
            String sDateEndSuffix = _methodContext.getValue("_dateEndSuffix_");
            String sEndTimeValue = _methodContext.getValue(_sSearchName + sDateEndSuffix);
            if (sEndTimeValue == null && ix == 0) {
                sEndTimeValue = _methodContext.getValue(sParamName + sDateEndSuffix);
            }
            if (!dtTemp.testDateFormat(sEndTimeValue)) {
                sEndTimeValue = null;
            }
            if (CMyString.isEmpty(sStartTimeValue) && CMyString.isEmpty(sEndTimeValue)) {
                return;
            }
            if (_sbWhereFields.length() > 0) {
                _sbWhereFields.append(_bIsOr ? " or " : " and ");
            }
            _sbWhereFields.append("(");
            this.setFilterOfDate(_filter, _sbWhereFields, _sSearchName, sStartTimeValue, ">=?");
            if (!CMyString.isEmpty(sStartTimeValue) && !CMyString.isEmpty(sEndTimeValue)) {
                _sbWhereFields.append(" and ");
            }
            this.setFilterOfDate(_filter, _sbWhereFields, _sSearchName, sEndTimeValue, "<=?");
            _sbWhereFields.append(")");
        } else {
            if (CMyString.isEmpty(_sSearchValue) || !dtTemp.testDateFormat(_sSearchValue)) {
                return;
            }
            if (_sbWhereFields.length() > 0) {
                _sbWhereFields.append(_bIsOr ? " or " : " and ");
            }
            this.setFilterOfDate(_filter, _sbWhereFields, _sSearchName, _sSearchValue, "=?");
        }
    }

    private void setFilterOfDate(WCMFilter _filter, StringBuffer _sbWhereFields, String _sFieldName, String _sFieldValue, String _sOperator) throws CMyException {
        if (!CMyString.isEmpty(_sFieldValue)) {
            _sbWhereFields.append(_sFieldName);
            _sbWhereFields.append(_sOperator);
            CMyDateTime dtTemp = new CMyDateTime();
            dtTemp.setDateTimeWithString(_sFieldValue);
            _filter.addSearchValues(dtTemp);
        }
    }

    public MetaViewData findViewDataById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methodContext.getObjectId();
        int nViewId = _methodContext.getValue("ViewId", 0);
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        MetaViewData oMetaViewData = null;
        if (nObjectId == 0) {
            MetaView view = null;
            if (nViewId > 0) {
                view = this.findViewById(nViewId);
            } else {
                Channel channel = null;
                channel = this.findChannelById(nChannelId);
                view = this.findViewByChannel(channel);
            }
            oMetaViewData = new MetaViewData(view);
        } else {
            oMetaViewData = MetaViewData.findById(nObjectId);
            if (oMetaViewData == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label9", "\u6307\u5b9a\u7684\u89c6\u56fe\u6570\u636e\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + nObjectId + "]");
            }
            int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
            if (nFlowDocId > 0 && nObjectId > 0) {
                Document document = oMetaViewData.getDocument();
                WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, -1, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label10", "\u67e5\u770b"));
            } else if (nChannelId > 0) {
                Channel channel = null;
                channel = this.findChannelById(nChannelId);
                this.validateRight(loginUser, oMetaViewData, channel, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label10", "\u67e5\u770b"));
            } else {
                this.validateRight(loginUser, oMetaViewData, oMetaViewData.getChannel(), I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label10", "\u67e5\u770b"));
            }
        }
        return oMetaViewData;
    }

    private void validateRight(User _currUser, MetaViewData _metaViewData, Channel _channel, String _sDesc) throws WCMException {
        if (_currUser.getName().equalsIgnoreCase(_metaViewData.getCrUserName())) {
            return;
        }
        if (!AuthServer.hasRight(_currUser, (CMSObj)_channel, 34)) {
            throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + _channel.getName() + "][ID=" + _channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label11", "]\u4e0b") + _sDesc + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label12", "\u6570\u636e\uff01"));
        }
    }

    public Reports deleteViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Reports reports = new Reports(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label13", "\u5220\u9664\u89c6\u56fe\u6570\u636e"));
        String sChnlDocIds = _methodContext.getObjectIds();
        int[] aChnlDocs = CMyString.splitToInt(sChnlDocIds, ",");
        for (int i = 0; i < aChnlDocs.length; ++i) {
            ChnlDoc oChnlDoc = ChnlDoc.findById(aChnlDocs[i]);
            if (oChnlDoc == null) continue;
            if (oChnlDoc.isEntity()) {
                this.deleteViewDatasOfEntity(loginUser, oChnlDoc.getDocId(), reports);
                continue;
            }
            this.deleteViewDatasOfQuote(oChnlDoc, reports);
        }
        return reports;
    }

    private void deleteViewDatasOfEntity(User _currUser, int _nObjectId, Reports _reports) throws Throwable {
        MetaViewData oMetaViewData = MetaViewData.findById(_nObjectId);
        if (oMetaViewData == null) {
            return;
        }
        try {
            this.validateRight(_currUser, oMetaViewData, 33, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label13", "\u5220\u9664\u89c6\u56fe\u6570\u636e"));
            oMetaViewData.deleteViewDataAndDoc(_currUser);
            _reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + _nObjectId + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label15", "]\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            _reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + _nObjectId + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label16", "]\u5931\u8d25\uff01"), e);
        }
    }

    private void deleteViewDatasOfQuote(ChnlDoc _chnlDoc, Reports _reports) throws Throwable {
        if (_chnlDoc == null) {
            return;
        }
        Channel channel = _chnlDoc.getChannel();
        if (channel == null) {
            return;
        }
        Document document = _chnlDoc.getDocument();
        if (document == null) {
            return;
        }
        DocumentMgr oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        try {
            oDocumentMgr.delete(document, channel, true);
            _reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + _chnlDoc.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label15", "]\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            _reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label14", "\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=") + _chnlDoc.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label16", "]\u5931\u8d25\uff01"), e);
        }
    }

    public Reports copy(MethodContext _methodContext) throws Throwable {
        int i;
        Reports reports = new Reports(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label17", "\u590d\u5236\u6587\u6863"));
        User loginUser = this.getLoginUser();
        Channels toChannels = Channels.findByIds(loginUser, _methodContext.getValue("ToChannelIds"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        if (!loginUser.isAdministrator()) {
            for (i = chnlDocs.size() - 1; i >= 0; --i) {
                Channel srcChannel;
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc == null || AuthServer.hasRight(loginUser, (CMSObj)(srcChannel = chnlDoc.getChannel()), 34)) continue;
                reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label18", "\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[ID=") + srcChannel.getId() + ",Name=" + srcChannel.getDispDesc() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label19", "]\u4e0b\u7684\u6587\u6863"), null);
                chnlDocs.remove(i);
            }
        }
        int nSize = toChannels.size();
        for (i = 0; i < nSize; ++i) {
            Channel channel = (Channel)toChannels.getAt(i);
            if (channel == null) continue;
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
                reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label20", "\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[ID=") + channel.getId() + ",Name=" + channel.getDispDesc() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label21", "]\u4e0b\u521b\u5efa\u6587\u6863"), null);
                continue;
            }
            for (int j = chnlDocs.size() - 1; j >= 0; --j) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(j);
                int srcViewId = chnlDoc.getPropertyAsInt("docKind", 0);
                if (chnlDoc == null || srcViewId == 0) continue;
                if (chnlDoc.getStatusId() == 1028) {
                    reports.addFailedReport(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label100", "\u8bb0\u5f55[{0}]\u72b6\u6001\u4e3a\u8349\u7a3f\uff0c\u65e0\u6cd5\u590d\u5236\uff01"), new String[]{chnlDoc.getDocument().getTitle()}), null);
                    continue;
                }
                IDocumentTransmitorFactory m_oDocumentTransmitorFactory = (IDocumentTransmitorFactory)DreamFactory.createObjectById("IDocumentTransmitorFactory");
                IDocumentTransmitor transmitor = m_oDocumentTransmitorFactory.getTransmitor(chnlDoc.getDocument());
                reports.addReport(transmitor.copy(chnlDoc.getChannel(), chnlDoc.getDocument(), channel));
            }
        }
        return reports;
    }

    public String exportViewDatas(MethodContext _methodContext) throws Throwable {
        String sViewDataIds = _methodContext.getObjectIds();
        Channel channel = null;
        MetaView view = null;
        int nViewId = _methodContext.getValue("ViewId", 0);
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        } else {
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            view = this.findViewByChannel(channel);
        }
        MetaViewDatas viewDatas = new MetaViewDatas(view);
        int[] pObjecteds = CMyString.splitToInt(sViewDataIds, ",");
        viewDatas.setMaxBufferSize(pObjecteds.length);
        for (int i = 0; i < pObjecteds.length; ++i) {
            MetaViewData viewData = new MetaViewData(view);
            if (!viewData.loadById(pObjecteds[i], "*")) continue;
            viewData.setMetaDataId(pObjecteds[i]);
            Document document = Document.findById(pObjecteds[i], "DocTitle,DocContent");
            viewData.getProperties().put("DOCTITLE", document.getTitle());
            viewData.getProperties().put("DOCCONTENT", document.getContent());
            viewDatas.addElement(viewData);
        }
        String sSelectFields = _methodContext.getValue("EXPORTFIELDS");
        boolean bEptAppendix = _methodContext.getValue("EXPORTAPPENDIX", true);
        MetaViewDataExporter exporter = new MetaViewDataExporter(view);
        if (_methodContext.getValue("fileType", 1) == 1) {
            return exporter.exportToZip(viewDatas, sSelectFields, bEptAppendix);
        }
        return exporter.exportToExcelZip(viewDatas, sSelectFields, bEptAppendix);
    }

    public String exportAllViewDatas(MethodContext _methodContext) throws Throwable {
        boolean bExportAsXml;
        int nFilterType;
        User loginUser = ContextHelper.getLoginUser();
        Channels oChannels = null;
        Channel oChannel = null;
        MetaView oView = null;
        int nViewId = _methodContext.getValue("ViewId", 0);
        if (nViewId > 0) {
            oView = this.findViewById(nViewId);
            IMetaViewEmployerMgr employerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
            oChannels = employerMgr.getEmployers(oView, null);
        } else {
            oChannel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            oChannels = Channels.createNewInstance(loginUser);
            oChannels.addElement(oChannel);
            oView = this.findViewByChannel(oChannel);
        }
        for (int i = oChannels.size() - 1; i >= 0; --i) {
            Channel element = (Channel)oChannels.getAt(i);
            if (element == null || AuthServer.hasRight(loginUser, (CMSObj)element, 34)) continue;
            oChannels.remove(oChannel, false);
        }
        WCMFilter filter = this.getQueryFilter(_methodContext, loginUser, oView);
        String sqlWhere = _methodContext.getValue("_sqlWhere_");
        if (!CMyString.isEmpty(sqlWhere)) {
            if (filter.getWhere().length() > 0) {
                boolean isOr = _methodContext.getValue("IsOr", true);
                filter.setWhere(filter.getWhere() + (isOr ? " or " : " and ") + "(" + sqlWhere + ")");
            } else {
                filter.setWhere("(" + sqlWhere + ")");
            }
        }
        if ((nFilterType = _methodContext.getValue("FilterType", -1)) != -1) {
            IQueryFilterFactory oQueryFilterFactory = QueryFilterFactory.getInstance();
            IQueryFilter oQueryFilter = oQueryFilterFactory.createQueryFilter(nFilterType);
            WCMFilter filterQuery = oQueryFilter.getFilter(_methodContext);
            filter.mergeWith(filterQuery);
        }
        WCMFilter filterWihtClassInfos = MetaDataCenterHelper.makeFilterWithClassInfos(_methodContext.getValue("ClassInfoIds"), _methodContext.getValue("ContainsChildClassInfoIds", true));
        filter.mergeWith(filterWihtClassInfos);
        MetaViewDatas oViewDatas = new MetaViewDatas(oView);
        oViewDatas.setPageSize(1);
        oViewDatas.open(oChannels, filter);
        int nDataCount = oViewDatas.size();
        String sSelectFields = _methodContext.getValue("EXPORTFIELDS");
        boolean bEptAppendix = _methodContext.getValue("EXPORTAPPENDIX", true);
        boolean bl = bExportAsXml = _methodContext.getValue("fileType", 1) == 1;
        if (nDataCount > 500) {
            MetaViewDataExporter4MuchData exporter = new MetaViewDataExporter4MuchData(nDataCount, bEptAppendix, bExportAsXml);
            String sPath = exporter.exportData(oChannels, oView, sSelectFields, filter);
            return sPath;
        }
        oViewDatas.clear();
        oViewDatas = new MetaViewDatas(oView);
        oViewDatas.setPageSize(nDataCount);
        oViewDatas.setLoadAllDatas(true);
        oViewDatas.open(oChannels, filter);
        for (int i = oViewDatas.size() - 1; i >= 0; --i) {
            MetaViewData oViewData = (MetaViewData)oViewDatas.getAt(i);
            if (oViewData == null) {
                oViewDatas.remove(oViewData, false);
                continue;
            }
            Document document = Document.findById(oViewData.getDocumentId(), "DocTitle,DocContent");
            if (document == null) {
                oViewDatas.remove(oViewData, false);
                continue;
            }
            oViewData.getProperties().put("DOCTITLE", CMyString.showNull(document.getTitle()));
            oViewData.getProperties().put("DOCCONTENT", CMyString.showNull(document.getContent()));
        }
        MetaViewDataExporter exporter = new MetaViewDataExporter(oView);
        if (bExportAsXml) {
            return exporter.exportToZip(oViewDatas, sSelectFields, bEptAppendix);
        }
        return exporter.exportToExcelZip(oViewDatas, sSelectFields, bEptAppendix);
    }

    private void copy(ChnlDoc _fromChnlDoc, Channel _toChannel, Reports _reports, User _currUser) throws Throwable {
        if (_fromChnlDoc == null) {
            return;
        }
        int nSrcDocId = _fromChnlDoc.getDocId();
        MetaViewData metaViewData = MetaViewData.findById(nSrcDocId);
        MetaViewData newMetaViewData = (MetaViewData)metaViewData.cloneToNewObj();
        MetaView view = metaViewData.getMetaView();
        newMetaViewData.setMetaView(view);
        newMetaViewData.setProperty("channelId", _toChannel.getId());
        if (view.isMultiTable()) {
            String sTableName = "WCMMetaRelation" + view.getId();
            CMSObjDefaultImpl oRelationTablePO = new CMSObjDefaultImpl(sTableName, "MetaDataId");
            boolean bFind = oRelationTablePO.loadById(nSrcDocId, null);
            if (bFind) {
                Enumeration<String> enPropNames = oRelationTablePO.getProperties().keys();
                while (enPropNames.hasMoreElements()) {
                    String sPropName = enPropNames.nextElement();
                    if (!sPropName.startsWith("WCMMetaTable".toUpperCase())) continue;
                    newMetaViewData.setProperty(sPropName, oRelationTablePO.getProperty(sPropName));
                }
            }
            IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(view.getId());
            for (MetaViewField field : hFields.values()) {
                if (field == null || field.isFromMainTable()) continue;
                newMetaViewData.removeProperty(field.getName());
            }
        }
        newMetaViewData.save(_currUser);
        Document newDoc = Document.findById(newMetaViewData.getId());
        if (newDoc != null) {
            newDoc.setDocLevel(_fromChnlDoc.getDocLevleId());
            newDoc.save();
            boolean bDocumentInFlowOnCopy = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false"));
            User loginUser = this.getLoginUser();
            if (bDocumentInFlowOnCopy) {
                WCMProcessServiceHelper.startDocumentInFlow(loginUser, newDoc, true);
            }
        }
        if (metaViewData.getId() != newMetaViewData.getId()) {
            this.m_oAppendixMgr.copyAppendixes(Document.findById(metaViewData.getId()), Document.findById(newMetaViewData.getId()));
        }
        _reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label26", "\u6210\u529f\u590d\u5236\u8bb0\u5f55[") + metaViewData.getTitle() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label27", "]\u5230\u680f\u76ee[") + _toChannel.getDispDesc() + "]\uff01");
    }

    private void copyQuote(ChnlDoc _fromChnlDoc, Channel _toChannel, Reports _reports) throws Throwable {
        Channel fromChannel = _fromChnlDoc.getChannel();
        if (fromChannel == null) {
            _reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label28", "\u590d\u5236\u5931\u8d25:\u6587\u6863\u7684\u680f\u76ee[Id=") + _fromChnlDoc.getChannelId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
            return;
        }
        Document fromDocument = _fromChnlDoc.getDocument();
        if (fromDocument == null) {
            _reports.addFailedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label30", "\u590d\u5236\u5931\u8d25:\u6587\u6863[Id=") + _fromChnlDoc.getDocId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
            return;
        }
        DocumentMgr oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Document newDoc = oDocumentMgr.copyDocument(fromDocument, fromChannel, _toChannel);
        if (newDoc == null) {
            _reports.addFailedReport(fromDocument + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label31", "\u5728") + _toChannel + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label32", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), null);
            return;
        }
        if (newDoc.getId() != fromDocument.getId()) {
            this.m_oAppendixMgr.copyAppendixes(fromDocument, newDoc);
        }
        _reports.addSucessedReport(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label26", "\u6210\u529f\u590d\u5236\u8bb0\u5f55[") + newDoc.getTitle() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label27", "]\u5230\u680f\u76ee[") + _toChannel.getDispDesc() + "]\uff01");
    }

    private void validateRight(User _loginUser, MetaViewData _oMetaViewData, int _nRightIndex, String sDesc) throws WCMException {
        Channel channel;
        if (_loginUser.isAdministrator() || _loginUser.getName().equalsIgnoreCase(_oMetaViewData.getCrUserName())) {
            return;
        }
        int nChannelId = _oMetaViewData.getChannelId();
        if (nChannelId <= 0) {
            nChannelId = _oMetaViewData.getPropertyAsInt("ChannelId", 0);
        }
        if (!AuthServer.hasRight(_loginUser, (CMSObj)(channel = this.findChannelById(nChannelId)), _nRightIndex)) {
            throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label33", "\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c") + sDesc + "[ID=" + _oMetaViewData.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label34", "]\u7684\u64cd\u4f5c\uff01"));
        }
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label35", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private MetaView findViewById(int _nViewId) throws WCMException {
        MetaView view = MetaView.findById(_nViewId);
        if (view == null) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label36", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + _nViewId + "]");
        }
        return view;
    }

    private MetaView findViewByChannel(Channel _channel) throws WCMException {
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(_channel);
        if (view == null) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label37", "\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe\uff01[\u680f\u76ee\u4fe1\u606f=") + _channel + "]");
        }
        return view;
    }

    private static MetaViewData setViewDataProperties(MethodContext _methodContext, MetaViewData _oViewData) throws WCMException {
        Map mapParams = _methodContext.getParams();
        for (String sParamName : mapParams.keySet()) {
            Object value = mapParams.get(sParamName);
            if (value instanceof String) {
                _oViewData.setProperty(sParamName, value.toString().trim());
                continue;
            }
            if (value instanceof String[]) {
                String[] pValues = (String[])value;
                _oViewData.setProperty(sParamName, pValues == null || pValues.length == 0 ? null : pValues[0].trim());
                continue;
            }
            _oViewData.setProperty(sParamName, value);
        }
        return _oViewData;
    }

    public void moveViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sObjectIds = _methodContext.getValue("objectIds");
        MetaViewDatas oViewDatas = MetaViewDatas.findByIds(sObjectIds);
        for (int i = oViewDatas.size() - 1; i >= 0; --i) {
            MetaViewData oViewData = (MetaViewData)oViewDatas.getAt(i);
            if (oViewData == null) continue;
            try {
                this.validateRight(loginUser, oViewData, 32, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label38", "\u79fb\u52a8\u8bb0\u5f55"));
                continue;
            }
            catch (WCMException e) {
                oViewDatas.remove(oViewData, false);
            }
        }
        if (oViewDatas.size() <= 0) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label39", "\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u8f6c\u6362\u8bb0\u5f55\u7684\u5206\u7c7b\u6cd5\u64cd\u4f5c"));
        }
        String sSrcClassInfoIds = _methodContext.getValue("srcClassInfoIds");
        ClassInfos oSrcClassInfos = ClassInfos.findByIds(loginUser, sSrcClassInfoIds);
        ClassInfo oDestClassInfo = null;
        int nDestClassInfoId = _methodContext.getValue("destClassInfoId", 0);
        if (nDestClassInfoId != 0) {
            oDestClassInfo = ClassInfo.findById(nDestClassInfoId);
        }
        this.m_oClassInfoViewMgr.moveViewDatasByClassInfos(oViewDatas, oSrcClassInfos, oDestClassInfo, loginUser);
    }

    public void copyViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label40", "\u975e\u7ba1\u7406\u5458\u6ca1\u6709\u6743\u9650\u6267\u884c\u8f6c\u6362\u8bb0\u5f55\u7684\u5206\u7c7b\u6cd5\u64cd\u4f5c"));
        }
        String sObjectIds = _methodContext.getValue("objectIds");
        MetaViewDatas oViewDatas = MetaViewDatas.findByIds(sObjectIds);
        String sDestClassInfoIds = _methodContext.getValue("destClassInfoIds");
        ClassInfos oDestClassInfos = ClassInfos.findByIds(loginUser, sDestClassInfoIds);
        this.m_oClassInfoViewMgr.copyViewDatasByClassInfos(oViewDatas, oDestClassInfos, loginUser);
    }

    public void modifyViewDatas(MethodContext _methodContext) throws WCMException {
        String sFieldName = _methodContext.getValue("FieldName");
        String sFieldValue = _methodContext.getValue("FieldValue");
        int nViewId = _methodContext.getValue("VIEWID", 0);
        if (CMyString.isEmpty(sFieldName)) {
            throw new WCMException(10, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label41", "\u53c2\u6570FieldName\u6ca1\u6709\u6307\u5b9a\u3002"));
        }
        if (CMyString.isEmpty(sFieldValue)) {
            throw new WCMException(10, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label42", "\u53c2\u6570FieldValue\u6ca1\u6709\u6307\u5b9a\u3002"));
        }
        if (nViewId <= 0) {
            throw new WCMException(10, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label43", "\u53c2\u6570VIEWID\u6ca1\u6709\u6307\u5b9a\u6216\u6307\u5b9a\u65e0\u6548\u3002"));
        }
        MetaView oMetaView = MetaView.findById(nViewId);
        if (oMetaView == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label44", "\u6ca1\u6709\u627e\u5230 Id=") + nViewId + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label45", " \u7684\u8d44\u6e90\u7ed3\u6784\u5bf9\u8c61"));
        }
        DBManager dbmanager = DBManager.getDBManager();
        String sMetaTable = oMetaView.getTrueTableName();
        WCMFilter oFilter = _methodContext.getExtraWCMFilter();
        String sExtraWhere = oFilter.getWhere();
        String strSQL = "update " + sMetaTable + " set " + sFieldName + "=? where " + sExtraWhere;
        Object[] parameters = new Object[]{sFieldValue};
        dbmanager.sqlExecuteUpdate(new String[]{strSQL}, parameters);
    }

    public MetaViewDatas queryViewDatasByClassinfos(MethodContext _methodContext) throws WCMException {
        return null;
    }

    public Map queryRelatingViewDatas(MethodContext _methodContext) throws WCMException {
        int nRelatingViewId = _methodContext.getValue("RelatingViewId", 0);
        int nRelatedViewId = _methodContext.getValue("RelatedViewId", 0);
        int nRelatedDocId = _methodContext.getValue("RelatedDocId", 0);
        MetaView oRelationView = MetaView.findById(nRelatingViewId);
        if (oRelationView == null) {
            throw new WCMException(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label50", "\u6ca1\u6709\u627e\u5230ID\u4e3a\u3010{0}\u3011\u7684\u89c6\u56fe\uff01"), new int[]{nRelatingViewId}));
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        WCMFilter fieldFilter = new WCMFilter("", "VIEWID=? AND FIELDTYPE=? AND RELATIONVIEWID=?", "");
        fieldFilter.addSearchValues(nRelatingViewId);
        fieldFilter.addSearchValues(14);
        fieldFilter.addSearchValues(nRelatedViewId);
        MetaViewFields fields = MetaViewFields.openWCMObjs(null, fieldFilter);
        if (fields.size() == 0) {
            return result;
        }
        MetaViewField relationField = (MetaViewField)fields.getAt(0);
        String sDBFieldName = relationField.getName();
        WCMFilter datasFilter = new WCMFilter("", "", "");
        String sDataWhere = DBManager.getDBManager().getDBType().sqlConcatStr("','", sDBFieldName, "','") + " like '%," + nRelatedDocId + ",%'";
        datasFilter.setWhere(sDataWhere);
        String sTrueTableName = oRelationView.getTrueTableName();
        MetaViewDatas metaviewDatas = MetaViewDatas.openWCMObjs(sTrueTableName, datasFilter);
        result.put("RelationField", relationField);
        result.put("MetaViewDatas", metaviewDatas);
        return result;
    }

    public void saveRelatingViewDatas(MethodContext _methodContext) throws WCMException {
        int i;
        User loginUser = this.getLoginUser();
        int nRelatedDocId = _methodContext.getValue("RelatedDocId", 0);
        String sRelatingDocIds = _methodContext.getValue("RelatingDocIds");
        int nRelatingViewId = _methodContext.getValue("RelatingViewId", 0);
        String sRelatingFieldName = _methodContext.getValue("RelatingFieldName");
        MetaView oRelatingView = MetaView.findById(nRelatingViewId);
        if (oRelatingView == null) {
            throw new WCMException(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label50", "\u6ca1\u6709\u627e\u5230ID\u4e3a\u3010{0}\u3011\u7684\u89c6\u56fe\uff01"), new int[]{nRelatingViewId}));
        }
        if (CMyString.isEmpty(sRelatingFieldName)) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label51", "\u5173\u8054\u7684\u89c6\u56fe\u5b57\u6bb5\u53c2\u6570RelatingFieldName\u6ca1\u6709\u4f20\u5165\uff01"));
        }
        String sTrueTableName = oRelatingView.getTrueTableName();
        FieldInfo fieldInfo = DBManager.getDBManager().getFieldInfo(sTrueTableName, sRelatingFieldName);
        if (fieldInfo == null) {
            throw new WCMException(CMyString.format(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label52", "\u5b57\u6bb5\u540d\u3010{0}\u3011\u4e0d\u662f\u89c6\u56fe\u3010{1}\u3011\u4e2d\u7684\u6709\u6548\u5b57\u6bb5\uff01"), new String[]{sRelatingFieldName, oRelatingView.getName()}));
        }
        WCMFilter datasFilter = new WCMFilter("", "", "");
        String sDataWhere = DBManager.getDBManager().getDBType().sqlConcatStr("','", sRelatingFieldName, "','") + " like '%," + nRelatedDocId + ",%'";
        datasFilter.setWhere(sDataWhere);
        MetaViewDatas metaviewDatas = MetaViewDatas.openWCMObjs(sTrueTableName, datasFilter);
        int[] nRelationDocIds = CMyString.splitToInt(sRelatingDocIds, ",");
        for (i = 0; i < nRelationDocIds.length; ++i) {
            MetaViewData targetViewData;
            int nRelationDocId = nRelationDocIds[i];
            boolean bExist = false;
            int nSize = metaviewDatas.size();
            for (int j = nSize - 1; j >= 0; --j) {
                MetaViewData metaviewData = (MetaViewData)metaviewDatas.getAt(j);
                if (metaviewData == null) continue;
                try {
                    this.validateRight(loginUser, metaviewData, 32, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label53", "\u4fee\u6539\u8bb0\u5f55"));
                }
                catch (WCMException e) {
                    continue;
                }
                int nDocId = metaviewData.getId();
                if (nRelationDocId != nDocId) continue;
                bExist = true;
                metaviewDatas.remove(metaviewData, false);
                metaviewDatas.setRecCount(metaviewDatas.size() - 1);
                break;
            }
            if (bExist || (targetViewData = MetaViewData.findById(nRelationDocId)) == null) continue;
            targetViewData.setMetaView(oRelatingView);
            this.saveMetaViewDataRelation(nRelatedDocId, targetViewData, sRelatingFieldName);
        }
        int nSize = metaviewDatas.size();
        for (i = 0; i < nSize; ++i) {
            MetaViewData viewData = (MetaViewData)metaviewDatas.getAt(i);
            if (viewData == null) continue;
            try {
                this.validateRight(loginUser, viewData, 32, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label53", "\u4fee\u6539\u8bb0\u5f55"));
            }
            catch (WCMException e) {
                continue;
            }
            viewData.setMetaView(oRelatingView);
            this.removeMetaViewDataRelation(nRelatedDocId, viewData, sRelatingFieldName);
        }
    }

    private void removeMetaViewDataRelation(int _nRelatedDocId, MetaViewData _metaViewData, String _sRelatingFieldName) throws WCMException {
        int i;
        String sCurrValue = _metaViewData.getPropertyAsString(_sRelatingFieldName);
        if (CMyString.isEmpty(sCurrValue)) {
            return;
        }
        int[] currRelatedIds = CMyString.splitToInt(sCurrValue, ",");
        int nRemoveTagetIndex = 0;
        boolean bFind = false;
        StringBuffer sTargetValue = new StringBuffer();
        for (i = 0; i < currRelatedIds.length; ++i) {
            if (_nRelatedDocId == currRelatedIds[i]) {
                bFind = true;
                nRemoveTagetIndex = i;
                break;
            }
            sTargetValue.append(currRelatedIds[i] + ",");
        }
        if (!bFind) {
            return;
        }
        for (i = nRemoveTagetIndex + 1; i < currRelatedIds.length; ++i) {
            if (i < currRelatedIds.length - 1) {
                sTargetValue.append(currRelatedIds[i] + ",");
                continue;
            }
            sTargetValue.append(currRelatedIds[i]);
        }
        _metaViewData.setProperty(_sRelatingFieldName, sTargetValue.toString());
        _metaViewData.update(this.getLoginUser());
    }

    private void saveMetaViewDataRelation(int _nRelatedDocId, MetaViewData _metaViewData, String _sRelatingFieldName) throws WCMException {
        String sCurrValue = _metaViewData.getPropertyAsString(_sRelatingFieldName);
        String sNewValue = "";
        if (CMyString.isEmpty(sCurrValue)) {
            sNewValue = _nRelatedDocId + "";
        } else {
            boolean bHasExist = false;
            int[] relatedIds = CMyString.splitToInt(sCurrValue, ",");
            for (int i = 0; i < relatedIds.length; ++i) {
                int docId = relatedIds[i];
                if (_nRelatedDocId != docId) continue;
                bHasExist = true;
                break;
            }
            if (bHasExist) {
                return;
            }
            sNewValue = sCurrValue + "," + _nRelatedDocId;
        }
        _metaViewData.setPropertyWithString(_sRelatingFieldName, sNewValue);
        _metaViewData.update(this.getLoginUser());
    }

    private void makeDocLevelWhere(WCMFilter _filter, StringBuffer _sbWhere) throws WCMException {
        User currUser = this.getLoginUser();
        DocLevel docLevel = currUser.getDocLevel();
        int nDocLevelId = docLevel.getId();
        DocLevelMgr docLevelMgr = new DocLevelMgr();
        DocLevels docLevels = docLevelMgr.queryLowerDocLevels(currUser, docLevel);
        _sbWhere.append(" and (");
        if (docLevels.isEmpty()) {
            _sbWhere.append("WCMChnlDoc.DOCLEVEL=?");
            _filter.addSearchValues(nDocLevelId);
        } else {
            _sbWhere.append("WCMChnlDoc.DOCLEVEL in(");
            int nSize = docLevels.size();
            for (int i = 0; i < nSize; ++i) {
                DocLevel currLevel = (DocLevel)docLevels.getAt(i);
                if (currLevel == null) continue;
                _sbWhere.append(" ?,");
                _filter.addSearchValues(currLevel.getId());
            }
            _sbWhere.append(" ?)");
            _filter.addSearchValues(nDocLevelId);
        }
        _sbWhere.append(" or WCMChnlDoc.DOCLEVEL is null");
        _sbWhere.append(" or WCMChnlDoc.DOCLEVEL=0");
        _sbWhere.append(" or WCMChnlDoc.CrUser=?");
        _filter.addSearchValues(currUser.getName());
        _sbWhere.append(")");
    }

    public String preview(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = null;
        MetaView view = null;
        MetaViewData oMetaViewData = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label2", "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01"));
            }
            view = this.findViewByChannel(channel);
            oMetaViewData = new MetaViewData(view);
            oMetaViewData.setId(-loginUser.getId());
            oMetaViewData.setCrUser(loginUser);
            oMetaViewData.setProperty("CRTIME", CMyDateTime.now());
        } else {
            oMetaViewData = MetaViewData.findById(nObjectId);
            if (oMetaViewData == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5728\u6307\u5b9a\u89c6\u56fe\u4e0b\u63d0\u4ea4\u7684\u6570\u636e\uff01[Id=") + nObjectId + "]");
            }
            channel = oMetaViewData.getChannel();
            _methodContext.setValue("channelId", channel.getId());
            Document document = oMetaViewData.getDocument();
            if (!DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, document, 32)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label5", "]\u4e0b\u4fee\u6539\u8bb0\u5f55\uff01"));
            }
            view = oMetaViewData.getMetaView();
            oMetaViewData.validCanEditAndLock(loginUser);
        }
        oMetaViewData = MetaDataCenterServiceProvider.setViewDataProperties(_methodContext, oMetaViewData);
        String[] warningHolder = new String[1];
        String sPreviewUrl = null;
        IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(oMetaViewData);
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        content.setFolder(folder);
        HashMap<String, MetaViewData> paramMap = new HashMap<String, MetaViewData>();
        paramMap.put("o_MetaViewData", oMetaViewData);
        sPreviewUrl = PublishServer.getInstance().previewContent(content, warningHolder, null, paramMap);
        String[] urls = new String[]{sPreviewUrl};
        PreviewURLSign.getUniqueSignedStrs(urls, KEY_PRIVATE_PREVIEW_ACCESS);
        return "<result><![CDATA[" + urls[0] + "]]></result>";
    }

    public boolean isValidOnlyField(MethodContext _methodContext) throws Throwable {
        String sFieldName = _methodContext.getValue("FieldName");
        String sFieldValue = _methodContext.getValue("FieldValue");
        int nViewId = _methodContext.getValue("ViewId", 0);
        int nObjectId = _methodContext.getValue("ObjectId", 0);
        if ("".equalsIgnoreCase(sFieldValue)) {
            return true;
        }
        MetaView view = MetaView.findById(nViewId);
        if (view == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + nViewId + "]");
        }
        MetaViewData oMetaViewData = new MetaViewData(view);
        String sWhere = sFieldName + "=? and MetaDataId <>?";
        String sSelect = oMetaViewData.getDbTableName() + ".MetaDataId";
        WCMFilter filter = new WCMFilter(oMetaViewData.getDbTableName(), sWhere, "", sSelect);
        filter.addSearchValues(0, sFieldValue);
        filter.addSearchValues(1, nObjectId);
        this.logger.debug((Object)("[\u6821\u9a8c\u5b57\u6bb5\u552f\u4e00\u6027\u7684\u6267\u884cSQL: ]" + filter));
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null) {
            throw new WCMException(10, I18NMessage.get(MetaViewData.class, "MetaViewData.label21", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(MetaViewData.class, "MetaViewData.label22", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        int nCount = currDBManager.sqlExecuteIntQuery(filter);
        return nCount <= 0;
    }
}

