/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.infra.util.PinyinHelper;
import java.io.UnsupportedEncodingException;

public class LetterConvertor {
    static final int GB_SP_DIFF = 160;
    static final int[] secPosValueList = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600};
    static final char[] firstLetter = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z'};

    public static String convertToFirstLetter(String _sOldValue) {
        return LetterConvertor.convertToFirstLetter(_sOldValue, true, 30);
    }

    public static String convertToFirstLetter(String _sOldValue, boolean _bConvertorFull, int _nLimitAutoToFirstLetter) {
        if (_bConvertorFull) {
            String sValue = PinyinHelper.convert(_sOldValue, "_");
            if (sValue.length() < 30) {
                return sValue;
            }
            return PinyinHelper.getFirstLetter(_sOldValue, false);
        }
        String str = _sOldValue.toLowerCase();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            char[] temp = new char[]{ch};
            byte[] uniCode = null;
            try {
                uniCode = new String(temp).getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                uniCode = new String(temp).getBytes();
            }
            if (uniCode[0] < 128 && uniCode[0] > 0) {
                buffer.append(temp);
                continue;
            }
            buffer.append(LetterConvertor.convert(uniCode));
        }
        return buffer.toString();
    }

    private static char convert(byte[] bytes) {
        char result = '-';
        int secPosValue = 0;
        int i = 0;
        while (i < bytes.length) {
            int n = i++;
            bytes[n] = (byte)(bytes[n] - 160);
        }
        secPosValue = bytes[0] * 100 + bytes[1];
        for (i = 0; i < 23; ++i) {
            if (secPosValue < secPosValueList[i] || secPosValue >= secPosValueList[i + 1]) continue;
            result = firstLetter[i];
            break;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(LetterConvertor.convertToFirstLetter("I love u"));
        System.out.println(LetterConvertor.convertToFirstLetter("\u6211\u7231\u5317\u4eac\u5929\u5b89\u95e8"));
        System.out.println(LetterConvertor.convertToFirstLetter("\u6807\u9898"));
        System.out.println(LetterConvertor.convertToFirstLetter("\u7533\u8bf7\u8d44\u6599"));
        System.out.println(LetterConvertor.convertToFirstLetter("I love \u4e2d\u56fd"));
        System.out.println(LetterConvertor.convertToFirstLetter("\u539f\u578b\u8bbe\u8ba1\u5b8c\u6210\u7684\u65e5\u671f"));
    }
}

