/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.RightSet;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeField;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.IInitValueCreator;
import com.trs.components.infoview.CABFileExtractor;
import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.PatternAnalyzer;
import com.trs.components.infoview.RightHostInfoViewField;
import com.trs.components.infoview.RightHostInfoViewGroup;
import com.trs.components.infoview.RightHostInfoViewView;
import com.trs.components.infoview.config.GatewayConfig;
import com.trs.components.infoview.db.IInfoViewDBMgr;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.extract.DataGroup;
import com.trs.components.infoview.extract.DataType;
import com.trs.components.infoview.extract.InfoPathFileData;
import com.trs.components.infoview.extract.XSLTViewBuilder;
import com.trs.components.infoview.extract.XSLTViewConstrainter;
import com.trs.components.infoview.extract.manifest.View;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewGroups;
import com.trs.components.infoview.persistent.InfoViewSerialGenerator;
import com.trs.components.infoview.persistent.InfoViewView;
import com.trs.components.infoview.persistent.InfoViewViews;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.infoview.publish.tagparser.FormProperty;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;

public class InfoViewMgr {
    private static final Logger s_logger = Logger.getLogger(InfoViewMgr.class);
    public static final String PUBLISH_SCRIPT_PATH = "infoview/";
    public static final String NS_XSL_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final float INCREASE_FIELD_LENGTH_FACTOR = 1.5f;
    private InfoViewEmployMgr m_oIVEmployMgr = null;
    private IInfoViewDBMgr m_oIVDBMgr = null;
    private InfoViewConfig m_oInfoViewCfg = this.loadInfoViewConfig();
    private CABFileExtractor m_CABExtractor = (CABFileExtractor)DreamFactory.createObjectById("CABFileExtractor");
    private FilesMan m_oFilesManMgr;
    private Random m_oRandomMaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileContent(String file) throws IOException {
        InputStream fis = null;
        BufferedReader reader = null;
        try {
            int length;
            char[] buff = new char[2048];
            fis = new FileService(file).getInputStream();
            InputStreamReader isr = new InputStreamReader(fis, "utf-8");
            reader = new BufferedReader(isr);
            StringBuffer sbContent = new StringBuffer(4096);
            while ((length = reader.read(buff)) != -1) {
                sbContent.append(buff, 0, length);
            }
            String string = sbContent.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public InfoViewMgr() {
        if (this.m_CABExtractor != null) {
            this.m_CABExtractor.init(this.m_oInfoViewCfg);
        }
        this.m_oIVEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
        this.m_oIVDBMgr = (IInfoViewDBMgr)DreamFactory.createObjectById("IInfoViewDBMgr");
        this.m_oFilesManMgr = FilesMan.getFilesMan();
        this.m_oRandomMaker = new Random(System.currentTimeMillis());
    }

    public InfoViewConfig getInfoViewConfig() {
        if (this.m_oInfoViewCfg == null) {
            this.m_oInfoViewCfg = this.loadInfoViewConfig();
        }
        return this.m_oInfoViewCfg;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private InfoViewConfig loadInfoViewConfig() {
        List configs = XMLConfigServer.getInstance().getConfigObjects("InfoViewConfig");
        if (configs == null || configs.size() == 0) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label1", "\u6ca1\u6709\u627e\u5230InfoView\u7684\u914d\u7f6e\u6587\u4ef6"));
            return null;
        }
        return (InfoViewConfig)configs.get(0);
    }

    public void delete(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label2", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        String sInfoPathFile = _oInfoView.getInfoPathFile();
        String sInfoViewPath = _oInfoView.getInfoViewPath();
        this.m_oIVEmployMgr.clearByInfoView(_oInfoView);
        this.clearFields(_oInfoView);
        this.clearGroups(_oInfoView);
        this.clearViews(_oInfoView);
        _oInfoView.delete(this.getLoginUser());
        String sBasePath = this.m_oFilesManMgr.mapFilePath(sInfoPathFile, 0);
        CMyFile.deleteFile(sBasePath + File.separatorChar + sInfoPathFile);
        CMyFile.deleteDir(sBasePath + File.separatorChar + sInfoViewPath);
    }

    private int clearFields(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            return 0;
        }
        List list = _oInfoView.allFields();
        if (list == null) {
            return 0;
        }
        int iCount = 0;
        for (InfoViewField field : list) {
            if (field == null) continue;
            this.delete(field);
            ++iCount;
        }
        return iCount;
    }

    private int clearGroups(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            return 0;
        }
        InfoViewGroups groups = InfoViewGroups.findBy(_oInfoView);
        if (groups == null) {
            return 0;
        }
        int iCount = groups.size();
        groups.removeAll(true);
        return iCount;
    }

    private int clearViews(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            return 0;
        }
        InfoViewViews views = InfoViewViews.findBy(_oInfoView);
        if (views == null) {
            return 0;
        }
        int iCount = views.size();
        views.removeAll(true);
        return iCount;
    }

    public void delete(InfoViewView _oView) throws WCMException {
        if (_oView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label3", "\u65e0\u6548\u7684\u8868\u5355\u89c6\u56fe[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        if (_oView.isSpecialRight()) {
            RightHostInfoViewView oRightHost = new RightHostInfoViewView(_oView);
            RightSet rightSet = new RightSet();
            rightSet.setRights(ContextHelper.getLoginUser(), oRightHost, null, false);
        }
        _oView.delete();
    }

    public void delete(InfoViewGroup _oGroup) throws WCMException {
        if (_oGroup == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label4", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u8282[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        if (_oGroup.isSpecialRight()) {
            RightHostInfoViewGroup oRightHost = new RightHostInfoViewGroup(_oGroup);
            RightSet rightSet = new RightSet();
            rightSet.setRights(ContextHelper.getLoginUser(), oRightHost, null, false);
        }
        _oGroup.delete();
    }

    public void delete(InfoViewField _oField) throws WCMException {
        if (_oField == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label5", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u9879[null],\u65e0\u6cd5\u5220\u9664!"));
        }
        if (_oField.isSpecialRight()) {
            RightHostInfoViewField oRightHost = new RightHostInfoViewField(_oField);
            RightSet rightSet = new RightSet();
            rightSet.setRights(ContextHelper.getLoginUser(), oRightHost, null, false);
        }
        _oField.delete(ContextHelper.getLoginUser());
    }

    public InfoViews getInfoViews(WCMFilter _filter) throws WCMException {
        InfoViews aInfoViews = new InfoViews(ContextHelper.getLoginUser());
        aInfoViews.open(_filter);
        return aInfoViews;
    }

    public InfoViewViews filterByFlow(InfoViewViews _oInfoViewViews, int nFlowDocId) throws Throwable {
        FlowNode oFlowNode = this.getCurrFlowNode(nFlowDocId);
        if (oFlowNode.isStartNode()) {
            return _oInfoViewViews;
        }
        HashMap hsReadUnableViews = new HashMap();
        this.renderViewsInFlow(nFlowDocId, hsReadUnableViews);
        for (int i = _oInfoViewViews.size() - 1; i >= 0; --i) {
            InfoViewView oView = (InfoViewView)_oInfoViewViews.getAt(i);
            String sViewName = "InfoViewView_" + oView.getId();
            if (hsReadUnableViews.get(sViewName) == null) continue;
            _oInfoViewViews.removeAt(i, false);
        }
        return _oInfoViewViews;
    }

    public String getAbsolutePath(InfoView _oInfoView, String sFileName) throws WCMException {
        if (sFileName.indexOf("/") >= 0 || sFileName.indexOf("\\") >= 0) {
            throw new WCMException("\u4e0d\u80fd\u4f20\u5165\u6587\u4ef6\u8def\u5f84\uff01");
        }
        String sInfoViewPath = _oInfoView.getInfoViewPath();
        String sBasePath = this.m_oFilesManMgr.mapFilePath(sInfoViewPath, 0);
        return sBasePath + File.separatorChar + sInfoViewPath + File.separatorChar + sFileName;
    }

    public String forFillOut(InfoView _oInfoView, InfoViewView _oView) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label7", "\u65e0\u6548\u7684\u89c6\u56fe\u5bf9\u8c61[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oView.getInfoViewID() != _oInfoView.getId()) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label8", "\u8868\u5355\u5bf9\u8c61\u548c\u89c6\u56fe\u5bf9\u8c61\u4e0d\u5339\u914d,\u65e0\u6cd5\u9884\u89c8!"));
        }
        Reader xslReader = null;
        Reader xmlReader = null;
        String sResult = null;
        String sFile = null;
        try {
            sFile = this.getAbsolutePath(_oInfoView, _oView.getNewFile());
            InputStream fisXSL = new FileService(sFile).getInputStream();
            xslReader = new InputStreamReader(fisXSL, "utf-8");
            StreamSource xslSource = new StreamSource(xslReader);
            sFile = this.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
            InputStream fisXML = new FileService(sFile).getInputStream();
            xmlReader = new InputStreamReader(fisXML, "utf-8");
            StreamSource xmlSource = new StreamSource(xmlReader);
            CharArrayWriter xmlWriter = new CharArrayWriter();
            StreamResult xmlResult = new StreamResult(xmlWriter);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer oTransformer = tf.newTransformer(xslSource);
            oTransformer.transform(xmlSource, xmlResult);
            sResult = xmlWriter.toString();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label9", "\u9884\u89c8\u81ea\u5b9a\u4e49\u8868\u5355\u65f6\u53d1\u751f\u9519\u8bef!"), e);
        }
        finally {
            if (xslReader != null) {
                try {
                    xslReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return sResult;
    }

    public String forFillOutInner(InfoView _oInfoView, InfoViewView _oView) throws WCMException {
        return this.forFillOutInner(_oInfoView, _oView, false);
    }

    public String forFillOutInner(InfoView _oInfoView, InfoViewView _oView, boolean _bNewDocInFlow) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label7", "\u65e0\u6548\u7684\u89c6\u56fe\u5bf9\u8c61[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oView.getInfoViewID() != _oInfoView.getId()) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label8", "\u8868\u5355\u5bf9\u8c61\u548c\u89c6\u56fe\u5bf9\u8c61\u4e0d\u5339\u914d,\u65e0\u6cd5\u9884\u89c8!"));
        }
        String sFile = this.getAbsolutePath(_oInfoView, _oView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        if (_bNewDocInFlow) {
            this.removeCanotPublish(xslDocument);
        }
        this.removeUnWriteableForGateWay(xslDocument);
        return this.filteredFillOut(_oInfoView, xslDocument);
    }

    public String forFillOutInFlow(InfoView _oInfoView, InfoViewView _oView, int _nFlowDocId) throws WCMException, Throwable {
        FlowNode oFlowNode = this.getCurrFlowNode(_nFlowDocId);
        if (oFlowNode.isStartNode()) {
            return this.forFillOut(_oInfoView, _oView);
        }
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label7", "\u65e0\u6548\u7684\u89c6\u56fe\u5bf9\u8c61[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oView.getInfoViewID() != _oInfoView.getId()) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label8", "\u8868\u5355\u5bf9\u8c61\u548c\u89c6\u56fe\u5bf9\u8c61\u4e0d\u5339\u914d,\u65e0\u6cd5\u9884\u89c8!"));
        }
        String sFile = this.getAbsolutePath(_oInfoView, _oView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        ArrayList lstReadUnableGroups = new ArrayList();
        this.renderGroupsInFlow(_nFlowDocId, lstReadUnableGroups);
        this.removeUnReadable(xslDocument, lstReadUnableGroups, true);
        ArrayList lstReadUnableFields = new ArrayList();
        ArrayList lstWriteUnableFields = new ArrayList();
        HashMap hmInitValues = new HashMap();
        this.renderFieldsInFlow(_nFlowDocId, lstReadUnableFields, lstWriteUnableFields, hmInitValues);
        this.reformUnWriteable(xslDocument, lstWriteUnableFields);
        this.removeUnReadable(xslDocument, lstReadUnableFields, false);
        return this.filteredFillOut(_oInfoView, xslDocument);
    }

    public String filterContentInFlow(InfoView _oInfoView, String _sXmlContent, int _nFlowDocId) throws WCMException, Throwable {
        FlowNode oFlowNode = this.getCurrFlowNode(_nFlowDocId);
        if (oFlowNode.isStartNode()) {
            return _sXmlContent;
        }
        Document xmlDocument = InfoViewHelper.parseToDocument(_sXmlContent);
        if (xmlDocument != null) {
            try {
                ArrayList lstReadUnableFields = new ArrayList();
                ArrayList lstWriteUnableFields = new ArrayList();
                HashMap hmInitValues = new HashMap();
                this.renderFieldsInFlow(_nFlowDocId, lstReadUnableFields, lstWriteUnableFields, hmInitValues);
                for (String sXPath : lstReadUnableFields) {
                    for (Element element : xmlDocument.selectNodes("//" + sXPath)) {
                        element.detach();
                    }
                }
                for (String sXPath : hmInitValues.keySet()) {
                    for (Element element : xmlDocument.selectNodes("//" + sXPath)) {
                        if (!element.isTextOnly() || !CMyString.isEmpty(element.getText())) continue;
                        element.setText((String)hmInitValues.get(sXPath));
                    }
                }
                return xmlDocument.asXML();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return _sXmlContent;
    }

    public String initTemplateInFlow(InfoView _oInfoView, int _nFlowDocId) throws WCMException, Throwable {
        FlowNode oFlowNode = this.getCurrFlowNode(_nFlowDocId);
        if (oFlowNode.isStartNode()) {
            return _oInfoView.getTemplateFileContent();
        }
        String file = this.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
        Document xmlDocument = InfoViewHelper.buildDOM4JDocument(file);
        ArrayList lstReadUnableFields = new ArrayList();
        ArrayList lstWriteUnableFields = new ArrayList();
        HashMap hmInitValues = new HashMap();
        this.renderFieldsInFlow(_nFlowDocId, lstReadUnableFields, lstWriteUnableFields, hmInitValues);
        for (String sXPath : hmInitValues.keySet()) {
            for (Element element : xmlDocument.selectNodes("//" + sXPath)) {
                short nNodeType = element.getNodeType();
                if (nNodeType != 3 && nNodeType != 4) continue;
                element.addText((String)hmInitValues.get(sXPath));
            }
        }
        return xmlDocument.asXML();
    }

    private String filteredFillOut(InfoView _oInfoView, Document xslDocument) throws TransformerFactoryConfigurationError, WCMException {
        StringReader xslReader = null;
        Reader xmlReader = null;
        String sResult = null;
        try {
            xslReader = new StringReader(xslDocument.asXML());
            StreamSource xslSource = new StreamSource(xslReader);
            String sFile = this.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
            InputStream fisXML = new FileService(sFile).getInputStream();
            xmlReader = new InputStreamReader(fisXML, "utf-8");
            StreamSource xmlSource = new StreamSource(xmlReader);
            CharArrayWriter xmlWriter = new CharArrayWriter();
            StreamResult xmlResult = new StreamResult(xmlWriter);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer oTransformer = tf.newTransformer(xslSource);
            oTransformer.transform(xmlSource, xmlResult);
            sResult = xmlWriter.toString();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label10", "\u81ea\u5b9a\u4e49\u8868\u5355\u5728\u5de5\u4f5c\u6d41\u6d41\u8f6c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef!"), e);
        }
        finally {
            if (xslReader != null) {
                try {
                    ((Reader)xslReader).close();
                }
                catch (Exception exception) {}
            }
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return sResult;
    }

    private void renderViewsInFlow(int _nFlowDocId, HashMap _hsReadUnableViews) throws Throwable {
        FlowNodeFields oFlowNodeFields = this.getFieldsInfoInFlow(_nFlowDocId, 2);
        for (int i = 0; i < oFlowNodeFields.size(); ++i) {
            FlowNodeField oFlowNodeField = (FlowNodeField)oFlowNodeFields.getAt(i);
            if (oFlowNodeField.getFieldType() != 2) continue;
            String sFieldName = oFlowNodeField.getFieldName();
            if (oFlowNodeField.isReadField()) continue;
            _hsReadUnableViews.put(sFieldName, "");
        }
    }

    private void renderGroupsInFlow(int _nFlowDocId, ArrayList lstReadUnable) throws Throwable {
        FlowNodeFields oFlowNodeFields = this.getFieldsInfoInFlow(_nFlowDocId, 1);
        for (int i = 0; i < oFlowNodeFields.size(); ++i) {
            FlowNodeField oFlowNodeField = (FlowNodeField)oFlowNodeFields.getAt(i);
            if (oFlowNodeField.getFieldType() != 1) continue;
            String sFieldName = oFlowNodeField.getFieldName();
            if (oFlowNodeField.isReadField()) continue;
            lstReadUnable.add(sFieldName);
        }
    }

    private void renderFieldsInFlow(int _nFlowDocId, ArrayList lstReadUnable, ArrayList lstWriteUnable, HashMap hmInitValues) throws Throwable {
        FlowNodeFields oFlowNodeFields = this.getFieldsInfoInFlow(_nFlowDocId, 0);
        for (int i = 0; i < oFlowNodeFields.size(); ++i) {
            String sInitValue;
            FlowNodeField oFlowNodeField = (FlowNodeField)oFlowNodeFields.getAt(i);
            if (oFlowNodeField.getFieldType() != 0) continue;
            String sFieldName = oFlowNodeField.getFieldName();
            if (!oFlowNodeField.isReadField()) {
                lstReadUnable.add(sFieldName);
            }
            if (!oFlowNodeField.isWriteField()) {
                lstWriteUnable.add(sFieldName);
            }
            if (CMyString.isEmpty(sInitValue = (String)oFlowNodeField.getProperties().get("INITVALUE"))) continue;
            hmInitValues.put(sFieldName, sInitValue);
        }
    }

    private void removeUnReadable(Document _oXslDocument, List _oLstReadUnable, boolean _bGroup) {
        for (String sXPath : _oLstReadUnable) {
            for (Element element : _oXslDocument.selectNodes("//*[@trs_temp_id=\"" + sXPath + "\"]")) {
                if (element.getParent() == null) continue;
                if (!_bGroup) {
                    element.clearContent();
                    if (element.attribute("trs_temp_id") != null) {
                        element.remove(element.attribute("trs_temp_id"));
                    }
                    if (element.attribute("xctname") != null) {
                        element.remove(element.attribute("xctname"));
                    }
                    if (element.attribute("binding") != null) {
                        element.remove(element.attribute("binding"));
                    }
                    if (element.attribute("contentEditable") == null) continue;
                    element.remove(element.attribute("contentEditable"));
                    continue;
                }
                element.detach();
            }
        }
    }

    private void reformUnWriteable(Document _oXslDocument, List _oLstWriteUnable) {
        Element element;
        Iterator iterElements = _oXslDocument.selectNodes("//*[@trs_readonly_field=\"1\"]").iterator();
        Iterator iterElementsForBackReadOnly = _oXslDocument.selectNodes("//*[@trs_backreadonly_field=\"1\"]").iterator();
        while (iterElements.hasNext()) {
            element = (Element)iterElements.next();
            if (element.attribute("trs_readonly_field") == null) continue;
            element.remove(element.attribute("trs_readonly_field"));
        }
        while (iterElementsForBackReadOnly.hasNext()) {
            element = (Element)iterElementsForBackReadOnly.next();
            if (element.attribute("trs_backreadonly_field") == null) continue;
            element.remove(element.attribute("trs_backreadonly_field"));
        }
        for (String sXPath : _oLstWriteUnable) {
            for (Element element2 : _oXslDocument.selectNodes("//*[@trs_temp_id=\"" + sXPath + "\"]")) {
                element2.addAttribute("trs_readonly_field", "1");
                if (element2.attribute("contentEditable") == null) continue;
                element2.remove(element2.attribute("contentEditable"));
            }
        }
    }

    private void removeUnWriteableForGateWay(Document _oXslDocument) {
        for (Element element : _oXslDocument.selectNodes("//*[@trs_readonly_field=\"1\"]")) {
            if (element.attribute("trs_readonly_field") == null) continue;
            element.remove(element.attribute("trs_readonly_field"));
        }
    }

    private FlowNodeFields getFieldsInfoInFlow(int _nFlowDocId, int _nFlowNodeFieldType) throws Throwable {
        User loginUser = this.getLoginUser();
        FlowDoc flowDoc = FlowDoc.findById(_nFlowDocId);
        FlowNode oFlowNode = this.getCurrFlowNode(_nFlowDocId);
        WCMFilter filter = new WCMFilter("", "NodeId=? and FieldType=?", "");
        filter.addSearchValues(oFlowNode.getId());
        filter.addSearchValues(_nFlowNodeFieldType);
        FlowNodeFields fields = FlowNodeFields.openWCMObjs(loginUser, filter);
        fields.setMaxBufferSize(fields.size());
        int nSize = fields.size();
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(loginUser);
        flowContext.setPostUser(loginUser);
        flowContext.setCurrFlowDoc(flowDoc);
        for (int i = 0; i < nSize; ++i) {
            String sInitValueCreator;
            FlowNodeField field = (FlowNodeField)fields.getAt(i);
            if (field == null || CMyString.isEmpty(sInitValueCreator = field.getPropertyAsString("InitValueCreator"))) continue;
            IInitValueCreator creator = (IInitValueCreator)Class.forName(sInitValueCreator).newInstance();
            field.getProperties().put("INITVALUE", creator.createInitValue(flowContext));
        }
        return fields;
    }

    private FlowNode getCurrFlowNode(int _nFlowDocId) throws WCMException {
        User loginUser = this.getLoginUser();
        FlowDoc flowDoc = FlowDoc.findById(_nFlowDocId);
        if (flowDoc == null) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label11", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u8f68\u8ff9\uff01[ID=") + _nFlowDocId + "]");
        }
        if (!loginUser.isAdministrator() && !flowDoc.getPostUserName().equalsIgnoreCase(loginUser.getName()) && flowDoc.getToUserId() != loginUser.getId()) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label12", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u6b64\u8f68\u8ff9\uff01[FlowDocId=") + _nFlowDocId + "]");
        }
        FlowNode oFlowNode = null;
        oFlowNode = flowDoc.isWorked() && flowDoc.getPostUserName().equalsIgnoreCase(loginUser.getName()) ? flowDoc.getPreNode() : flowDoc.getNode();
        return oFlowNode;
    }

    private InfoPathFileData prepareSave(InfoView _oInfoView) throws WCMException {
        String sDesc = _oInfoView.getDesc();
        if (sDesc == null || sDesc.length() == 0) {
            _oInfoView.setDesc(_oInfoView.getName());
        }
        String sFileName = "";
        if (_oInfoView.isAddMode()) {
            sFileName = _oInfoView.getInfoPathFile();
            if (sFileName == null) {
                throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label13", "\u5fc5\u987b\u5148\u8bbe\u7f6eInfoPath\u6587\u4ef6\u624d\u80fd\u7ee7\u7eed\u4fdd\u5b58\uff01"));
            }
        } else {
            sFileName = _oInfoView.getNewInfoPathFile();
            if (!_oInfoView.isChangeProperty("INFOPATHFILE") || sFileName == null) {
                InfoPathFileData ifpd = this.analyzeFile(_oInfoView, _oInfoView.getInfoPathFile());
                return ifpd;
            }
        }
        if (sFileName == null) {
            return null;
        }
        if (!"XSN".equalsIgnoreCase(CMyFile.extractFileExt(sFileName))) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label14", "\u76ee\u524d\u53ea\u63a5\u53d7InfoPath\u7684XSN\u6587\u4ef6\uff0c\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\uff08") + sFileName + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label15", "\uff09\u683c\u5f0f\u65e0\u6548\uff01"));
        }
        if (CMyFile.fileExists(sFileName)) {
            String sNewFileName = this.m_oFilesManMgr.getNextFileName("IV", "xsn", null, true);
            try {
                CMyFile.copyFile(sFileName, sNewFileName);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label16", "\u62f7\u8d1dXSN\u6587\u4ef6[") + sFileName + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label17", "]\u5230[") + sNewFileName + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label18", "]\u5931\u8d25\uff01"), e);
            }
            sFileName = CMyFile.extractFileName(sNewFileName);
        } else {
            FilesMan filesman = this.m_oFilesManMgr;
            if (!filesman.fileExists(sFileName)) {
                throw new WCMException(50, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label19", "InfoPath\u6587\u4ef6\uff08") + sFileName + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label20", "\uff09\u5728\u670d\u52a1\u5668\u4e0a\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u5148\u4e0a\u4f20\u5230\u670d\u52a1\u5668\u4e0a\u518d\u4fdd\u5b58\uff01"));
            }
            if (filesman.getFileFlag(sFileName) != "U0") {
                return null;
            }
            sFileName = filesman.copyWCMFile(sFileName, "IV");
        }
        InfoPathFileData ifpd = this.analyzeFile(_oInfoView, sFileName);
        return ifpd;
    }

    private InfoPathFileData analyzeFile(InfoView oInfoView, String sFileName) throws WCMException {
        FilesMan filesman = this.m_oFilesManMgr;
        String sMainPath = filesman.mapFilePath(sFileName, 0);
        String sMainName = CMyFile.extractMainFileName(sFileName);
        String sFilePath = sMainName + ".DIR";
        String sSrcFile = sMainPath + sFileName;
        String sDstPath = sMainPath + sFilePath;
        oInfoView.setInfoPathFile(sFileName);
        oInfoView.setInfoViewPath(sFilePath);
        HashMap files = null;
        try {
            files = this.m_CABExtractor.extract(sSrcFile, sDstPath);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label21", "\u5206\u89e3InfoPath\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + e.getMessage(), e);
        }
        InfoPathFileData ipfd = new InfoPathFileData();
        try {
            ipfd.build(sDstPath, files, this.m_oInfoViewCfg);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label22", "\u5206\u6790InfoPath\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + e.getMessage(), e);
        }
        if (oInfoView.isAddMode() || oInfoView.getId() >= InfoViewMgr.getNewRuleFromInfoViewId()) {
            this.validateRepeatField(ipfd);
        }
        oInfoView.setSchemaFile(ipfd.getSchemaFile());
        oInfoView.setAllFileList(ipfd.getAllFileList());
        oInfoView.setTemplateFile(ipfd.getTemplateFile());
        return ipfd;
    }

    private void validateRepeatField(InfoPathFileData _ipfd) throws WCMException {
        StringBuffer sbLengthError = new StringBuffer();
        Hashtable<String, String> hErrorResult = new Hashtable<String, String>();
        Hashtable<String, String> hTemp = new Hashtable<String, String>();
        ArrayList arFields = _ipfd.getFieldList();
        int nSize = arFields.size();
        for (int i = 0; i < nSize; ++i) {
            boolean isKeyWords;
            DataType dataType = (DataType)arFields.get(i);
            String sFieldName = dataType.getName().trim();
            if ((sFieldName = LetterConvertor.convertToFirstLetter(sFieldName).toUpperCase()).length() >= 30) {
                sbLengthError.append(dataType.getName());
                sbLengthError.append("\u7684\u957f\u5ea6\u8d85\u8fc730\uff0c\u6570\u636e\u5e93\u521b\u5efa\u5b57\u6bb5\u65f6\u5019\u53ef\u80fd\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u5728InfoPath\u4e2d\u4fee\u6539\u5b57\u6bb5\u540d\u79f0\uff01[\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + sFieldName + "]\n");
            }
            if (isKeyWords = DBManager.getDBManager().getDBKeywords().contains(sFieldName)) {
                sbLengthError.append(dataType.getName());
                sbLengthError.append("\u662f\u6570\u636e\u5e93\u4fdd\u7559\u5173\u952e\u5b57\u8bf7\u91cd\u65b0\u5728InfoPath\u4e2d\u4fee\u6539\u5b57\u6bb5\u540d\u79f0\uff01[\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + sFieldName + "]\n");
            }
            if (sFieldName.indexOf(".") > 0) {
                sbLengthError.append(dataType.getName());
                sbLengthError.append("\u4e2d\u5305\u542b\u4e0d\u5408\u6cd5\u7684\u5b57\u7b26[.]\u8bf7\u91cd\u65b0\u5728InfoPath\u4e2d\u4fee\u6539\u5b57\u6bb5\u540d\u79f0\uff01[\u6570\u636e\u5e93\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + sFieldName + "]\n");
            }
            if (hTemp.containsKey(sFieldName)) {
                String sRepeatFieldNames = null;
                sRepeatFieldNames = !hErrorResult.containsKey(sFieldName) ? (String)hTemp.get(sFieldName) : (String)hErrorResult.get(sFieldName);
                hErrorResult.put(sFieldName, sRepeatFieldNames + "," + dataType.getName());
                continue;
            }
            hTemp.put(sFieldName, dataType.getName());
        }
        if (hErrorResult.size() > 0) {
            StringBuffer sbRepeatInfo = new StringBuffer();
            sbRepeatInfo.append(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label23", "\u5728\u60a8\u5f53\u524d\u5bfc\u5165\u7684\u8868\u5355\u4e2d\uff0c\u547d\u540d\u7684\u4e2d\u6587\u5b57\u6bb5\u8f6c\u6362\u6210\u4ee5\u9996\u5b57\u6bcd\u7ec4\u5408\u7684\u82f1\u6587\u5b57\u6bb5\u65f6\u53ef\u80fd\u5b58\u5728\u91cd\u590d\uff0c") + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label24", "\u8fd9\u6837\u4f1a\u5bfc\u81f4\u7cfb\u7edf\u4e0d\u80fd\u521b\u5efa\u8868\uff01") + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label25", "\u6211\u4eec\u5efa\u8bae\u60a8\u4fee\u6539\u4e00\u4e0b\u8868\u5355\u518d\u5bfc\u5165\uff0c\u5728\u540d\u79f0\u540e\u52a0\u4e00\u4e9b\u6570\u5b57\u6216\u8005\u6587\u5b57\u533a\u5206\uff0c\u91cd\u590d\u7684\u5b57\u6bb5\u5982\u4e0b\u6240\u793a\uff1a\n"));
            Enumeration emKeys = hErrorResult.keys();
            while (emKeys.hasMoreElements()) {
                String sEngName = (String)emKeys.nextElement();
                sbRepeatInfo.append("\n===========================\n");
                sbRepeatInfo.append(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label26", "\u8f6c\u6362\u540e\u7684\u82f1\u6587\u540d\u79f0\uff1a"));
                sbRepeatInfo.append(sEngName);
                sbRepeatInfo.append("\n");
                sbRepeatInfo.append(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label27", "\u76f8\u5173\u7684\u4e2d\u6587\u540d\u79f0\uff1a"));
                sbRepeatInfo.append(hErrorResult.get(sEngName));
            }
            if (sbLengthError.length() > 0) {
                sbRepeatInfo.append("\n");
                sbRepeatInfo.append(sbLengthError);
            }
            throw new WCMException(sbRepeatInfo.toString());
        }
        if (sbLengthError.length() > 0) {
            throw new WCMException(sbLengthError.toString());
        }
    }

    public void save(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label28", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        boolean isAddMode = _oInfoView.isAddMode();
        User loginUser = this.getLoginUser();
        if (!isAddMode && !_oInfoView.canEdit(loginUser)) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + loginUser.getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + _oInfoView.getLockerUserName() + "]");
        }
        InfoPathFileData ipfd = this.prepareSave(_oInfoView);
        if (ipfd == null) {
            _oInfoView.save(loginUser);
            return;
        }
        boolean bUploadNew = _oInfoView.isAddMode() || _oInfoView.isChangeProperty("INFOPATHFILE");
        String sOldInfoPathFile = null;
        String sOldInfoViewPath = null;
        if (bUploadNew && !_oInfoView.isAddMode()) {
            sOldInfoPathFile = _oInfoView.getInfoPathFile();
            sOldInfoViewPath = _oInfoView.getInfoViewPath();
        }
        _oInfoView.save(loginUser);
        this.m_oIVDBMgr.createDBTable(loginUser, _oInfoView.getId());
        this.saveViews(_oInfoView, ipfd.getViewList());
        this.saveGroups(_oInfoView, ipfd.getGroupList());
        this.saveFields(_oInfoView, ipfd.getFieldList());
        if (sOldInfoPathFile != null) {
            String sBasePath = this.m_oFilesManMgr.mapFilePath(sOldInfoPathFile, 0);
            CMyFile.deleteFile(sBasePath + File.separator + sOldInfoPathFile);
            CMyFile.deleteDir(sBasePath + File.separator + sOldInfoViewPath);
        }
        try {
            ipfd.reform(_oInfoView.getId());
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label31", "\u683c\u5f0f\u5316XSLT\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + e.getMessage(), e);
        }
        try {
            ipfd.reformTemplateXml();
            this.rebuildXSLT(_oInfoView);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label32", "\u683c\u5f0f\u5316Template.xml\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef:") + e.getMessage(), e);
        }
    }

    private void saveViews(InfoView _oInfoView, List newViews) throws WCMException {
        int i;
        HashMap<String, InfoViewView> oldViews = new HashMap<String, InfoViewView>();
        InfoViewViews oldList = null;
        if (!_oInfoView.isAddMode()) {
            oldList = InfoViewViews.findBy(_oInfoView);
        }
        if (oldList != null && oldList.size() > 0) {
            for (i = oldList.size() - 1; i >= 0; --i) {
                InfoViewView view = (InfoViewView)oldList.getAt(i);
                if (view == null) continue;
                oldViews.put(view.getName(), view);
            }
        }
        for (i = 0; i < newViews.size(); ++i) {
            View dataView = (View)newViews.get(i);
            String sViewName = dataView.getName();
            InfoViewView view = (InfoViewView)oldViews.get(sViewName);
            if (view == null) {
                view = new InfoViewView();
                view.setInfoViewID(_oInfoView.getId());
                view.setName(sViewName);
                view.setDesc(dataView.getCaption());
            } else {
                oldViews.remove(sViewName);
            }
            view.setNewFile(dataView.getNewTransform());
            view.setOldFile(dataView.getTransform());
            view.setViewWidth(dataView.getViewWidth());
            view.setDefaultView(dataView.isDefaultView());
            view.setXSLPrefix(dataView.getXSLPrefix());
            this.save(view);
            dataView.setTRSObjectID(view.getId());
        }
        if (oldViews.size() > 0) {
            for (InfoViewView view : oldViews.values()) {
                if (view == null) continue;
                this.delete(view);
            }
            oldViews.clear();
        }
    }

    private void saveGroups(InfoView _oInfoView, List newGroups) throws WCMException {
        int i;
        HashMap<String, InfoViewGroup> oldGroups = new HashMap<String, InfoViewGroup>();
        InfoViewGroups oldList = null;
        if (!_oInfoView.isAddMode()) {
            oldList = InfoViewGroups.findBy(_oInfoView);
        }
        if (oldList != null && oldList.size() > 0) {
            for (i = oldList.size() - 1; i >= 0; --i) {
                InfoViewGroup group = (InfoViewGroup)oldList.getAt(i);
                if (group == null) continue;
                oldGroups.put(group.getName(), group);
            }
        }
        for (i = 0; i < newGroups.size(); ++i) {
            DataGroup dataGroup = (DataGroup)newGroups.get(i);
            String sGroupName = dataGroup.getName();
            InfoViewGroup group = (InfoViewGroup)oldGroups.get(sGroupName);
            if (group == null) {
                group = new InfoViewGroup();
                group.setInfoViewID(_oInfoView.getId());
                group.setName(sGroupName);
                group.setDesc(dataGroup.getBindname());
                dataGroup.enablePublish(true);
            } else {
                dataGroup.enablePublish(group.isPublicFill());
                oldGroups.remove(sGroupName);
            }
            group.setViewID(dataGroup.getViewID());
            this.save(group);
            dataGroup.setTRSObjectID(group.getId());
        }
        if (oldGroups.size() > 0) {
            for (InfoViewGroup group : oldGroups.values()) {
                if (group == null) continue;
                this.delete(group);
            }
            oldGroups.clear();
        }
    }

    private void saveFields(InfoView _oInfoView, List newFields) throws WCMException {
        HashMap<String, InfoViewField> oldFields = new HashMap<String, InfoViewField>();
        List oldList = _oInfoView.allFields();
        if (oldList != null && oldList.size() > 0) {
            for (int i = oldList.size() - 1; i >= 0; --i) {
                InfoViewField field = (InfoViewField)oldList.get(i);
                if (field == null) continue;
                oldFields.put(field.getName(), field);
            }
        }
        User currUser = this.getLoginUser();
        for (int i = 0; i < newFields.size(); ++i) {
            DataType dataType = (DataType)newFields.get(i);
            String sTypeName = dataType.getNewBindName();
            InfoViewField field = (InfoViewField)oldFields.get(sTypeName);
            if (field == null) {
                field = new InfoViewField();
                _oInfoView.addField(field);
            } else {
                oldFields.remove(sTypeName);
            }
            field.setXPath(dataType.getBindName());
            field.setName(sTypeName);
            field.setDesc(dataType.getDisplayName());
            field.setDataType(dataType.getDataTypeAsInt());
            field.setFieldType(dataType.getDisplayFieldType());
            field.setNillable(dataType.isNillable());
            field.setMaxLength(dataType.getMaxLength());
            field.setMinLength(dataType.getMinLength());
            this.save(field);
            this.m_oIVDBMgr.createDBField(currUser, _oInfoView, field);
            dataType.setTRSObjectID(field.getId());
        }
        if (oldFields.size() > 0) {
            for (InfoViewField field : oldFields.values()) {
                if (field == null) continue;
                _oInfoView.removeField(field);
                this.delete(field);
            }
            oldFields.clear();
        }
    }

    public void save(InfoViewView _oView) throws WCMException {
        if (_oView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label33", "\u65e0\u6548\u7684\u8868\u5355\u89c6\u56fe[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        if (!_oView.isAddMode() && !_oView.canEdit(this.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + this.getLoginUser().getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + _oView.getLockerUserName() + "]");
        }
        _oView.save(this.getLoginUser());
    }

    public void save(InfoViewGroup _oGroup) throws WCMException {
        if (_oGroup == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label34", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u8282[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        if (!_oGroup.isAddMode() && !_oGroup.canEdit(this.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + this.getLoginUser().getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + _oGroup.getLockerUserName() + "]");
        }
        boolean zCanPublishChanged = _oGroup.isChangeProperty("PUBLICFILL");
        _oGroup.save(this.getLoginUser());
        if (zCanPublishChanged) {
            this.changeDataGroupPublishFlag(_oGroup);
        }
    }

    private void changeDataGroupPublishFlag(InfoViewGroup _oGroup) throws WCMException {
        String sAttrXPath;
        InfoView infoview = _oGroup.getInfoView();
        if (infoview == null) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label35", "\u6570\u636e\u8282\u6240\u5c5e\u8868\u5355\u5bf9\u8c61\u4e0d\u5b58\u5728"));
            return;
        }
        InfoViewView view = _oGroup.getView();
        if (view == null) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label36", "\u6570\u636e\u8282\u6240\u5c5e\u8868\u5355\u89c6\u56fe\u4e0d\u5b58\u5728"));
            return;
        }
        String file = this.getAbsolutePath(infoview, view.getNewFile());
        Document xslDoc = InfoViewHelper.buildDOM4JDocument(file);
        List list = xslDoc.selectNodes(sAttrXPath = "//*/@trs_obj_type");
        if (list == null) {
            return;
        }
        String sObjId = String.valueOf(_oGroup.getId());
        boolean zFound = false;
        for (Attribute attr : list) {
            Element elDiv;
            String id;
            if (!XSLTViewBuilder.TYPE_DATA_SECTION.equals(attr.getValue()) || !sObjId.equals(id = (elDiv = attr.getParent()).attributeValue("trs_obj_id"))) continue;
            String sFlag = _oGroup.isPublicFill() ? "1" : "0";
            elDiv.addAttribute("trs_obj_publish", sFlag);
            zFound = true;
            break;
        }
        if (zFound) {
            InfoViewHelper.writeDOM4JDocument(xslDoc, file);
        }
    }

    public void save(InfoViewField _oField) throws WCMException {
        if (_oField == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label37", "\u65e0\u6548\u7684\u8868\u5355\u6570\u636e\u9879[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        if (!_oField.isAddMode() && !_oField.canEdit(this.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label29", "\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539!\u5f53\u524d\u7528\u6237:[") + this.getLoginUser().getName() + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label30", "] \u9501\u5b9a\u7528\u6237:[") + _oField.getLockerUserName() + "]");
        }
        _oField.save(this.getLoginUser());
    }

    public void setFieldsReadOnly(InfoView _oInfoView, InfoViewFields _oInfoViewFields, boolean _bReadOnly) throws WCMException {
        ArrayList<InfoViewField> lstFields = new ArrayList<InfoViewField>();
        for (int i = 0; i < _oInfoViewFields.size(); ++i) {
            InfoViewField oInfoViewField = (InfoViewField)_oInfoViewFields.getAt(i);
            oInfoViewField.setReadOnly(_bReadOnly);
            oInfoViewField.setBackReadOnly(_bReadOnly);
            this.save(oInfoViewField);
            lstFields.add(oInfoViewField);
        }
        this.rebuildXSLTByFields(_oInfoView, lstFields);
    }

    public void saveViewByFields(InfoView _oInfoView, List _lstFields) throws WCMException {
        ArrayList lstSearchFields = this.split2List(_oInfoView.getSearchFields());
        ArrayList lstOutlineFields = this.split2List(_oInfoView.getOutlineFields());
        boolean bChanged = false;
        for (InfoViewField oField : _lstFields) {
            String sFieldName = oField.getXPath();
            if (oField.isSearchField()) {
                if (!lstSearchFields.contains(sFieldName)) {
                    lstSearchFields.add(sFieldName);
                    bChanged = true;
                }
            } else if (lstSearchFields.contains(sFieldName)) {
                lstSearchFields.remove(sFieldName);
                bChanged = true;
            }
            if (oField.isOutlineField()) {
                if (lstOutlineFields.contains(sFieldName)) continue;
                lstOutlineFields.add(sFieldName);
                bChanged = true;
                continue;
            }
            if (!lstOutlineFields.contains(sFieldName)) continue;
            lstOutlineFields.remove(sFieldName);
            bChanged = true;
        }
        if (!bChanged) {
            return;
        }
        _oInfoView.setSearchFields(this.join2String(lstSearchFields));
        _oInfoView.setOutlineFields(this.join2String(lstOutlineFields));
        _oInfoView.save(this.getLoginUser());
    }

    private String join2String(ArrayList lstFields) {
        String sCurrOutlineFields = "";
        Iterator iterKeys = lstFields.iterator();
        boolean bFirst = true;
        while (iterKeys.hasNext()) {
            String sField;
            if (!bFirst) {
                sCurrOutlineFields = sCurrOutlineFields + ",";
            }
            if ((sField = (String)iterKeys.next()).trim().length() <= 0) continue;
            sCurrOutlineFields = sCurrOutlineFields + sField.trim();
            bFirst = false;
        }
        return sCurrOutlineFields;
    }

    private ArrayList split2List(String _sFields) {
        ArrayList<String> lstFields = new ArrayList<String>();
        if (_sFields == null) {
            return lstFields;
        }
        String[] arrSearchFields = _sFields.split(",");
        for (int i = 0; i < arrSearchFields.length; ++i) {
            if (arrSearchFields[i].trim().length() <= 0) continue;
            lstFields.add(arrSearchFields[i].trim());
        }
        return lstFields;
    }

    public void rebuildXSLT(InfoView _oInfoView) throws WCMException {
        InfoViewViews allViews = InfoViewViews.findBy(_oInfoView);
        for (int i = 0; i < allViews.size(); ++i) {
            InfoViewView aView = (InfoViewView)allViews.getAt(i);
            String sFile = this.getAbsolutePath(_oInfoView, aView.getNewFile());
            Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
            XSLTViewConstrainter oXSLTViewConstrainter = new XSLTViewConstrainter();
            oXSLTViewConstrainter.init(_oInfoView, aView, null, null);
            boolean bNeedSave = oXSLTViewConstrainter.rebuild(xslDocument);
            if (!bNeedSave) continue;
            InfoViewHelper.writeDOM4JDocument(xslDocument, sFile);
        }
    }

    public void rebuildXSLTByGroups(InfoView _oInfoView, List _lstGroups) throws WCMException {
        InfoViewViews allViews = InfoViewViews.findBy(_oInfoView);
        for (int i = 0; i < allViews.size(); ++i) {
            InfoViewView aView = (InfoViewView)allViews.getAt(i);
            String sFile = this.getAbsolutePath(_oInfoView, aView.getNewFile());
            Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
            boolean bNeedSave = this.reformGroupsConstraint(xslDocument, _oInfoView, aView, _lstGroups);
            if (!bNeedSave) continue;
            InfoViewHelper.writeDOM4JDocument(xslDocument, sFile);
        }
    }

    private boolean reformGroupsConstraint(Document _oXslDocument, InfoView _oInfoView, InfoViewView _oInfoViewView, List _lstGroups) throws WCMException {
        XSLTViewConstrainter oXSLTViewConstrainter = new XSLTViewConstrainter();
        oXSLTViewConstrainter.init(_oInfoView, _oInfoViewView, _lstGroups, null);
        return oXSLTViewConstrainter.rebuild(_oXslDocument);
    }

    public void rebuildXSLTByFields(InfoView _oInfoView, List _lstFields) throws WCMException {
        InfoViewViews allViews = InfoViewViews.findBy(_oInfoView);
        for (int i = 0; i < allViews.size(); ++i) {
            InfoViewView aView = (InfoViewView)allViews.getAt(i);
            String sFile = this.getAbsolutePath(_oInfoView, aView.getNewFile());
            Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
            boolean bNeedSave = this.reformFieldsConstraint(xslDocument, _oInfoView, aView, _lstFields);
            if (!bNeedSave) continue;
            InfoViewHelper.writeDOM4JDocument(xslDocument, sFile);
        }
    }

    private boolean reformFieldsConstraint(Document _oXslDocument, InfoView _oInfoView, InfoViewView _oInfoViewView, List _lstFields) throws WCMException {
        XSLTViewConstrainter oXSLTViewConstrainter = new XSLTViewConstrainter();
        oXSLTViewConstrainter.init(_oInfoView, _oInfoViewView, null, _lstFields);
        return oXSLTViewConstrainter.rebuild(_oXslDocument);
    }

    public String forPreviewMultiView(InfoView _oInfoView, InfoViewView _oPubView, FormProperty _oProperty, List fileList) throws WCMException {
        if (_oPubView == null) {
            return this.forPreview(_oInfoView, _oProperty, fileList);
        }
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        String sFile = this.getAbsolutePath(_oInfoView, _oPubView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        String sTempContent = this.getTemplateFileContent(_oInfoView);
        this.addDataFormAndSubmit(xslDocument, _oProperty, _oPubView, sTempContent);
        this.reformCharEncoding(xslDocument, _oProperty.getFormEncoding());
        this.reformScriptAndCSS(xslDocument);
        this.reformForm4Publish(xslDocument, _oProperty);
        this.removeCanotPublish(xslDocument);
        this.getAllHTMImageFile(_oInfoView, xslDocument, fileList);
        StringReader xslReader = new StringReader(xslDocument.asXML());
        StreamSource xslSource = new StreamSource(xslReader);
        return this.transformTemplate(_oInfoView, xslSource);
    }

    public String forPreview(InfoView _oInfoView, FormProperty _oProperty, List fileList) throws WCMException {
        InfoViewViews allViews;
        InfoViewView aView;
        int i;
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        this.buildPropertyForGateway(_oProperty);
        _oProperty.normalize();
        boolean bPublishAll = _oProperty.isPublishAllViews();
        if (bPublishAll) {
            return null;
        }
        InfoViewView oPubView = null;
        String sPubViewName = _oProperty.getInfoViewViewName();
        if (sPubViewName == null || CMyString.isEmpty(sPubViewName)) {
            InfoViewViews allDefaultViews = InfoViewViews.findDefaultBy(_oInfoView);
            for (i = 0; i < allDefaultViews.size(); ++i) {
                aView = (InfoViewView)allDefaultViews.getAt(i);
                if (!aView.isPublicFill()) continue;
                oPubView = aView;
                break;
            }
        } else {
            allViews = InfoViewViews.findBy(_oInfoView);
            for (i = 0; i < allViews.size(); ++i) {
                aView = (InfoViewView)allViews.getAt(i);
                if (!aView.isPublicFill() || !sPubViewName.equals(aView.getName())) continue;
                oPubView = aView;
                break;
            }
        }
        if (oPubView == null) {
            allViews = InfoViewViews.findBy(_oInfoView);
            for (i = 0; i < allViews.size(); ++i) {
                aView = (InfoViewView)allViews.getAt(i);
                if (!aView.isPublicFill()) continue;
                oPubView = aView;
                break;
            }
        }
        if (oPubView == null) {
            return null;
        }
        String sFile = this.getAbsolutePath(_oInfoView, oPubView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        String sTempContent = this.getTemplateFileContent(_oInfoView);
        this.addDataFormAndSubmit(xslDocument, _oProperty, oPubView, sTempContent);
        this.reformCharEncoding(xslDocument, _oProperty.getFormEncoding());
        this.reformScriptAndCSS(xslDocument);
        this.reformForm4Publish(xslDocument, _oProperty);
        this.removeCanotPublish(xslDocument);
        this.getAllHTMImageFile(_oInfoView, xslDocument, fileList);
        StringReader xslReader = new StringReader(xslDocument.asXML());
        StreamSource xslSource = new StreamSource(xslReader);
        return this.transformTemplate(_oInfoView, xslSource);
    }

    public static Map split2AttrMap(String _sAttrStr) {
        Pattern pattern = Pattern.compile("([^\\s=]*)\\s*=(([^\\s'\"]+\\s)|(\\s*(['\"]?)(.*?)\\5))");
        Matcher matcher = pattern.matcher(_sAttrStr);
        HashMap<String, String> mpResult = new HashMap<String, String>();
        while (matcher.find()) {
            String sValue = CMyString.showNull(CMyString.showNull(matcher.group(6), matcher.group(3))).trim();
            mpResult.put(matcher.group(1), sValue);
        }
        return mpResult;
    }

    private void addDataFormAndSubmit(Document xslDocument, FormProperty _oProperty, InfoViewView _oPubView, String sTemplateContent) {
        Element body = (Element)xslDocument.selectSingleNode(".//body");
        Element elDataForm = body.addElement("form");
        elDataForm.addAttribute("id", "frmData");
        elDataForm.addAttribute("name", "frmData");
        List lstChilds = body.elements();
        for (int i = 0; i < lstChilds.size(); ++i) {
            Node oNode = (Node)lstChilds.get(i);
            if (oNode == elDataForm) continue;
            elDataForm.add(oNode.detach());
        }
        Element elForm = body.addElement("form");
        body.add(elDataForm.detach());
        elForm.addAttribute("id", "frmAction");
        elForm.addAttribute("name", "frmAction");
        if (!CMyString.isEmpty(_oProperty.getFormExtra())) {
            String sFormExtra = _oProperty.getFormExtra();
            Map mapExtraAttrs = InfoViewMgr.split2AttrMap(sFormExtra);
            for (String sKey : mapExtraAttrs.keySet()) {
                elForm.addAttribute(sKey, (String)mapExtraAttrs.get(sKey));
            }
        }
        Element inputSite = elForm.addElement("input");
        inputSite.addAttribute("type", "hidden");
        inputSite.addAttribute("name", "SiteId");
        String s = String.valueOf(_oProperty.getSiteID());
        inputSite.addAttribute("value", s);
        Element inputChannel = elForm.addElement("input");
        inputChannel.addAttribute("type", "hidden");
        inputChannel.addAttribute("name", "ChannelId");
        s = String.valueOf(_oProperty.getChannelID());
        inputChannel.addAttribute("value", s);
        Element inputInfoView = elForm.addElement("input");
        inputInfoView.addAttribute("type", "hidden");
        inputInfoView.addAttribute("name", "InfoViewId");
        s = String.valueOf(_oPubView.getInfoViewID());
        inputInfoView.addAttribute("value", s);
        Element inputDocument = elForm.addElement("input");
        inputDocument.addAttribute("type", "hidden");
        inputDocument.addAttribute("name", "DocumentId");
        s = String.valueOf(_oProperty.getSelectFields());
        if (!CMyString.isEmpty(s) && !s.equals("null")) {
            Element selectFields = elForm.addElement("input");
            selectFields.addAttribute("type", "hidden");
            selectFields.addAttribute("name", "SelectFields");
            selectFields.addAttribute("value", s);
        }
        Element inputNeedInit = elForm.addElement("input");
        inputNeedInit.addAttribute("type", "hidden");
        inputNeedInit.addAttribute("name", "NeedInit");
        s = String.valueOf(_oProperty.getNeedInit());
        inputNeedInit.addAttribute("value", s);
        Element inputOnlyCached = elForm.addElement("input");
        inputOnlyCached.addAttribute("type", "hidden");
        inputOnlyCached.addAttribute("name", "OnlyCached");
        s = String.valueOf(_oProperty.isOnlyCached());
        inputOnlyCached.addAttribute("value", s);
        Element textarea = elForm.addElement("textarea");
        textarea.addAttribute("name", "ObjectXML");
        textarea.addAttribute("style", "display:none");
        textarea.setText(sTemplateContent);
        String sViewWidth = _oPubView.getViewWidth();
        Element divElement = body.addElement("div");
        divElement.addAttribute("align", "center");
        if (sViewWidth != null) {
            divElement.addAttribute("style", "width:" + sViewWidth);
        }
        if (_oProperty.getSubmitButtonHTML() != null) {
            Element txtElement = divElement.addElement("xsl:text", NS_XSL_URI);
            txtElement.addAttribute("disable-output-escaping", "yes");
            txtElement.addText(_oProperty.getSubmitButtonHTML());
        } else {
            Element submitButton = divElement.addElement("input");
            submitButton.addAttribute("id", "SubmitButton");
            submitButton.addAttribute("name", "SubmitButton");
            submitButton.addAttribute("type", "button");
            submitButton.addAttribute("value", I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label38", "\u63d0\u4ea4"));
            if (_oProperty.isResetButton()) {
                Element resetButton = divElement.addElement("input");
                resetButton.addAttribute("id", "ResetButton");
                resetButton.addAttribute("name", "ResetButton");
                resetButton.addAttribute("type", "reset");
                resetButton.addAttribute("value", I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label39", "\u91cd\u7f6e"));
            }
        }
    }

    public String appendJsAndCsses(String html) {
        int nHeadEnd = html.indexOf("</head>");
        int nBodyEnd = html.indexOf("</body>");
        String sPrefix = "${ROOT_PATH}images/infoview/";
        StringBuffer sbLinks = new StringBuffer();
        StringBuffer sbJses = new StringBuffer();
        String[] saStyle = CMyString.split(this.getInfoViewConfig().getPubStyleURI(), ",");
        for (int i = 0; i < saStyle.length; ++i) {
            sbLinks.append("<link href=\"" + sPrefix + saStyle[i] + "\" rel=\"stylesheet\" type=\"text/css\" />");
        }
        String[] saScript = CMyString.split(this.getInfoViewConfig().getPubScriptURI(), ",");
        for (int i = 0; i < saScript.length; ++i) {
            sbJses.append("<script src=\"" + sPrefix + saScript[i] + "\"></script>");
        }
        StringBuffer rst = new StringBuffer();
        if (nHeadEnd == -1 || nBodyEnd == -1) {
            rst.append(html);
            rst.append(sbLinks);
            rst.append(sbJses);
            return rst.toString();
        }
        rst.append(html.substring(0, nHeadEnd));
        rst.append(sbLinks);
        rst.append(html.substring(nHeadEnd, nBodyEnd));
        rst.append(sbJses);
        rst.append(html.substring(nBodyEnd));
        return rst.toString();
    }

    private void reformScriptAndCSS(Document xslDocument) {
        Attribute attr;
        int i;
        String sPrefix = "${ROOT_PATH}images/infoview/";
        sPrefix = CMyString.replaceStr(sPrefix, "{", "{{");
        sPrefix = CMyString.replaceStr(sPrefix, "}", "}}");
        sPrefix = CMyString.setStrEndWith(sPrefix, '/');
        List list = xslDocument.selectNodes("//script/@src");
        for (i = list.size() - 1; i >= 0; --i) {
            attr = (Attribute)list.get(i);
            attr.setValue(sPrefix + attr.getValue());
        }
        list = xslDocument.selectNodes("//link/@href");
        for (i = list.size() - 1; i >= 0; --i) {
            attr = (Attribute)list.get(i);
            attr.setValue(sPrefix + attr.getValue());
        }
        list = xslDocument.selectNodes("//img/@src");
        for (i = list.size() - 1; i >= 0; --i) {
            attr = (Attribute)list.get(i);
            if (!attr.getValue().equals("TRSCalendar.gif")) continue;
            attr.setValue(sPrefix + attr.getValue());
        }
    }

    private void reformFormProperty(Document xslDocument, String sActionURI) {
        Element elForm = (Element)xslDocument.selectSingleNode("//form");
        if (sActionURI != null) {
            elForm.addAttribute("action", sActionURI);
        }
        if (CMyString.isEmpty(elForm.attributeValue("target"))) {
            elForm.addAttribute("target", "_top");
        }
    }

    private void reformForm4Publish(Document xslDocument, FormProperty _oProperty) {
        Element elForm = (Element)xslDocument.selectSingleNode("//form");
        if (elForm == null) {
            s_logger.error((Object)I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label40", "\u8868\u5355\u4e2d\u6ca1\u6709\u627e\u5230:form"));
            return;
        }
        this.appendHiddenField(elForm, "encoding", _oProperty.getFormEncoding());
        String sDefaultValueOfVerifyCode = "0";
        if (_oProperty.isVerifyCodeEnable()) {
            sDefaultValueOfVerifyCode = "1";
        }
        this.appendHiddenField(elForm, "verifycode", sDefaultValueOfVerifyCode);
        this.appendHiddenField(elForm, "verifycodeurl", _oProperty.getVerifyCodeURL());
        this.appendHiddenField(elForm, "ValidVerifycodeUrl", _oProperty.getValidVerifycodeUrl());
        String sGateWayInitPage = _oProperty.getGateWayInitPage();
        if (sGateWayInitPage != null) {
            this.appendHiddenField(elForm, "GateWayInit", sGateWayInitPage);
        }
        this.appendHiddenField(elForm, "fileuploadurl", _oProperty.getFileAction());
        this.appendHiddenField(elForm, "readfileurl", _oProperty.getReadFileURL());
        Map nonReservedProps = _oProperty.getNonReservedGatewayPageProps();
        if (nonReservedProps != null && nonReservedProps.size() > 0) {
            for (Map.Entry entry : nonReservedProps.entrySet()) {
                this.appendHiddenField(elForm, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        String sPrefix = "${ROOT_PATH}images/infoview/";
        sPrefix = CMyString.replaceStr(sPrefix, "{", "{{");
        sPrefix = CMyString.replaceStr(sPrefix, "}", "}}");
        sPrefix = CMyString.setStrEndWith(sPrefix, '/');
        this.appendHiddenField(elForm, "resourcebase", sPrefix);
        this.appendHiddenField(elForm, "InfoviewTitle", CMyString.filterForXsltValue(_oProperty.getInfoviewTitle()));
        this.appendHiddenField(elForm, "CachedInfoviewId", "");
        this.appendHiddenField(elForm, "JustCached", "");
    }

    private void appendHiddenField(Element _elForm, String _sFieldName, String _sFieldValue) {
        if (_elForm == null || _sFieldName == null) {
            return;
        }
        Element elInput = _elForm.addElement("input");
        elInput.addAttribute("type", "hidden");
        elInput.addAttribute("name", _sFieldName);
        elInput.addAttribute("value", _sFieldValue);
    }

    private void reformCharEncoding(Document xslDocument, String enc) {
        Element elOutput = (Element)xslDocument.selectSingleNode("//xsl:output");
        if (elOutput != null) {
            elOutput.addAttribute("encoding", enc);
        }
    }

    private void removeCanotPublish(Document xslDocument) {
        String sAttrXPath = "//div/@trs_obj_publish";
        List list = xslDocument.selectNodes(sAttrXPath);
        if (list == null) {
            return;
        }
        for (Attribute attr : list) {
            if ("1".equals(attr.getValue())) continue;
            Element elDiv = attr.getParent();
            elDiv.detach();
        }
    }

    private void getAllHTMImageFile(InfoView _oInfoView, Document xslDocument, List fileList) throws WCMException {
        List list;
        Attribute attr2 = null;
        attr2 = (Attribute)xslDocument.selectSingleNode("//body/@old_src");
        if (attr2 != null) {
            String filename = attr2.getValue();
            String fullname = this.getAbsolutePath(_oInfoView, filename);
            if ((attr2 = attr2.getParent().attribute("background")) != null) {
                attr2.setValue(filename);
                fileList.add(fullname);
            }
        }
        if ((list = xslDocument.selectNodes("//img/@old_src")) != null) {
            for (Attribute attr2 : list) {
                Element elImage = attr2.getParent();
                if (elImage.attribute("CtrlId") != null) continue;
                String filename = attr2.getValue();
                String fullname = this.getAbsolutePath(_oInfoView, filename);
                if ((attr2 = attr2.getParent().attribute("src")) == null) continue;
                attr2.setValue(filename);
                fileList.add(fullname);
            }
        }
    }

    public String forInfoGate(InfoView _oInfoView, FormProperty _oProperty) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label41", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        if (_oProperty.getChannelID() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label42", "\u65e0\u6548\u7684\u9891\u9053ID[<=0],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        this.buildPropertyForGateway(_oProperty);
        _oProperty.normalize();
        InfoViewView oPubView = null;
        InfoViewViews allViews = InfoViewViews.findBy(_oInfoView);
        for (int i = 0; i < allViews.size(); ++i) {
            InfoViewView aView = (InfoViewView)allViews.getAt(i);
            if (!aView.isPublicFill()) continue;
            oPubView = aView;
            break;
        }
        if (oPubView == null) {
            return null;
        }
        String sFile = this.getAbsolutePath(_oInfoView, oPubView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        String sTempContent = this.getTemplateFileContent(_oInfoView);
        this.addDataFormAndSubmit(xslDocument, _oProperty, oPubView, sTempContent);
        this.reformFormProperty(xslDocument, _oProperty.getFormAction());
        this.reformCharEncoding(xslDocument, "utf-8");
        this.reformForm4Publish(xslDocument, _oProperty);
        DocumentSource xslSource = new DocumentSource(xslDocument);
        return this.transformTemplate(_oInfoView, (Source)xslSource);
    }

    private void buildPropertyForGateway(FormProperty _oProperty) {
        GatewayConfig oGatewayConfig = this.m_oInfoViewCfg.getGatewayConfig();
        _oProperty.setGatewayPageProperties(oGatewayConfig.getGatewayPageProperties());
    }

    public String forPublishMultiView(InfoView _oInfoView, InfoViewView _oPubView, FormProperty _oProperty, List fileList) throws WCMException {
        if (_oPubView == null) {
            return this.forPublish(_oInfoView, _oProperty, fileList);
        }
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label41", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        if (_oProperty.getChannelID() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label42", "\u65e0\u6548\u7684\u9891\u9053ID[<=0],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        this.buildPropertyForGateway(_oProperty);
        _oProperty.normalize();
        String sFile = this.getAbsolutePath(_oInfoView, _oPubView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        String sTempContent = this.getTemplateFileContent(_oInfoView);
        this.addDataFormAndSubmit(xslDocument, _oProperty, _oPubView, sTempContent);
        this.reformCharEncoding(xslDocument, _oProperty.getFormEncoding());
        this.reformScriptAndCSS(xslDocument);
        this.reformFormProperty(xslDocument, _oProperty.getFormAction());
        this.reformForm4Publish(xslDocument, _oProperty);
        this.removeCanotPublish(xslDocument);
        this.getAllHTMImageFile(_oInfoView, xslDocument, fileList);
        DocumentSource xslSource = new DocumentSource(xslDocument);
        return this.transformTemplate(_oInfoView, (Source)xslSource);
    }

    public String forMultiView(InfoView _oInfoView, InfoViewView _oPubView, List fileList) throws WCMException {
        if (_oPubView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label43", "\u65e0\u6548\u7684\u8868\u5355\u89c6\u56fe[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label6", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u9884\u89c8!"));
        }
        String sFile = this.getAbsolutePath(_oInfoView, _oPubView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        this.reformScriptAndCSS(xslDocument);
        this.removeCanotPublish(xslDocument);
        this.getAllHTMImageFile(_oInfoView, xslDocument, fileList);
        StringReader xslReader = new StringReader(xslDocument.asXML());
        StreamSource xslSource = new StreamSource(xslReader);
        return this.transformTemplate(_oInfoView, xslSource);
    }

    public String forPublish(InfoView _oInfoView, FormProperty _oProperty, List fileList) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label41", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        if (_oProperty.getChannelID() <= 0) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label42", "\u65e0\u6548\u7684\u9891\u9053ID[<=0],\u65e0\u6cd5\u53d1\u5e03!"));
        }
        this.buildPropertyForGateway(_oProperty);
        _oProperty.normalize();
        InfoViewView oPubView = null;
        InfoViewViews allViews = InfoViewViews.findBy(_oInfoView);
        for (int i = 0; i < allViews.size(); ++i) {
            InfoViewView aView = (InfoViewView)allViews.getAt(i);
            if (!aView.isPublicFill()) continue;
            oPubView = aView;
            break;
        }
        if (oPubView == null) {
            return null;
        }
        String sFile = this.getAbsolutePath(_oInfoView, oPubView.getNewFile());
        Document xslDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        String sTempContent = this.getTemplateFileContent(_oInfoView);
        this.addDataFormAndSubmit(xslDocument, _oProperty, oPubView, sTempContent);
        this.reformCharEncoding(xslDocument, _oProperty.getFormEncoding());
        this.reformScriptAndCSS(xslDocument);
        this.reformFormProperty(xslDocument, _oProperty.getFormAction());
        this.reformForm4Publish(xslDocument, _oProperty);
        this.removeCanotPublish(xslDocument);
        this.getAllHTMImageFile(_oInfoView, xslDocument, fileList);
        DocumentSource xslSource = new DocumentSource(xslDocument);
        return this.transformTemplate(_oInfoView, (Source)xslSource);
    }

    private String transformTemplate(InfoView _oInfoView, Source xslSource) throws WCMException {
        Reader xmlReader = null;
        String sResult = null;
        String sFile = null;
        try {
            CharArrayWriter xmlWriter = new CharArrayWriter();
            StreamResult xmlResult = new StreamResult(xmlWriter);
            sFile = this.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
            InputStream fisXML = new FileService(sFile).getInputStream();
            xmlReader = new InputStreamReader(fisXML, "utf-8");
            StreamSource xmlSource = new StreamSource(xmlReader);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer oTransformer = tf.newTransformer(xslSource);
            oTransformer.transform(xmlSource, xmlResult);
            sResult = xmlWriter.toString();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label9", "\u9884\u89c8\u81ea\u5b9a\u4e49\u8868\u5355\u65f6\u53d1\u751f\u9519\u8bef!"), e);
        }
        finally {
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return sResult;
    }

    public String getInfoViewSerial(int _iInfoViewId) throws WCMException {
        InfoView infoView = InfoView.findById(_iInfoViewId);
        if (infoView == null) {
            throw new WCMException(200006, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label44", "\u6ca1\u6709\u627e\u5230[Id=") + _iInfoViewId + I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label45", "]\u7684\u8868\u5355!"));
        }
        return this.getInfoViewSerial(infoView);
    }

    public String getInfoViewSerial(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label46", "\u65e0\u6548\u7684\u8868\u5355\u5bf9\u8c61[null],\u65e0\u6cd5\u83b7\u5f97\u5176\u7f16\u53f7!"));
        }
        if (!_oInfoView.hasDocSerial()) {
            return "";
        }
        int iInfoViewId = _oInfoView.getId();
        int iSerialPeriod = _oInfoView.getSerialPeriod();
        InfoViewSerialGenerator serialGen = InfoViewSerialGenerator.getInstance();
        Object[] serial = serialGen.getNextSerial(iInfoViewId, iSerialPeriod, 1);
        String serialPattern = _oInfoView.getSerialPattern();
        MessageFormat form = new MessageFormat(serialPattern);
        return form.format(serial);
    }

    public String getTemplateFileContent(InfoView _oInfoView) throws WCMException {
        String file = this.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
        try {
            return InfoViewMgr.getFileContent(file);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label47", "\u83b7\u53d6\u6570\u636e\u6a21\u677f\u6587\u4ef6\u5185\u5bb9\u65f6\u53d1\u751fIO\u9519\u8bef"), e);
        }
    }

    public String getDocumentTitle(InfoView _oInfoView, Document _dom4jDocument) throws WCMException {
        String sDocTitle = "";
        try {
            sDocTitle = this.getDocumentTitleForUserName(_oInfoView, _dom4jDocument, null);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label52", "\u83b7\u53d6\u6587\u6863\u6807\u9898\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u8bbe\u7f6e\u7684\u8868\u5355\u6587\u6863\u6807\u9898\u662f\u5426\u6709\u4e0d\u5408\u6cd5\u7684\u683c\u5f0f\uff01"), ex);
        }
        DBManager currDBManager = DBManager.getDBManager();
        FieldInfo fi = currDBManager.getFieldInfo("WCMDOCUMENT", "docTitle");
        int length = this.getCompressLength(fi.getDataLength());
        if (CMyString.getBytesLength(sDocTitle) > length) {
            sDocTitle = CMyString.truncateStr(sDocTitle, length);
        }
        return sDocTitle;
    }

    public String getDocumentTitle(InfoView _oInfoView, Document _dom4jDocument, String _sPostUserName) throws WCMException {
        String sDocTitle = this.getDocumentTitleForUserName(_oInfoView, _dom4jDocument, _sPostUserName);
        DBManager currDBManager = DBManager.getDBManager();
        FieldInfo fi = currDBManager.getFieldInfo("WCMDOCUMENT", "docTitle");
        int length = this.getCompressLength(fi.getDataLength());
        if (CMyString.getBytesLength(sDocTitle) > length) {
            sDocTitle = CMyString.truncateStr(sDocTitle, length);
        }
        return sDocTitle;
    }

    public String getDocumentTitleForUserName(InfoView _oInfoView, Document _dom4jDocument, String _sPostUserName) throws WCMException {
        String title;
        if (_oInfoView == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label48", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u62bd\u53d6\u6587\u6863\u6807\u9898!"));
        }
        if (_dom4jDocument == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label49", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61[null],\u65e0\u6cd5\u62bd\u53d6\u6587\u6863\u6807\u9898!"));
        }
        String pattern = _oInfoView.getTitlePattern();
        PatternAnalyzer analyzer = new PatternAnalyzer(pattern);
        analyzer.setDocument(_dom4jDocument);
        analyzer.setCurrentUser(this.getLoginUser());
        if (_sPostUserName != null) {
            analyzer.setInfogateUserName(_sPostUserName);
        }
        if (CMyString.isEmpty(title = analyzer.getAnalyzedResult())) {
            title = I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label50", "\u81ea\u5b9a\u4e49\u8868\u5355\u6570\u636e");
        }
        return title;
    }

    public String getRandomSerial() {
        String pattern;
        String randomSerial = "";
        if (this.m_oInfoViewCfg.getPublicRandomSerialRequired() && !CMyString.isEmpty(pattern = this.m_oInfoViewCfg.getPublicRandomSerialPattern())) {
            MessageFormat form = new MessageFormat(pattern);
            Format[] formats = form.getFormatsByArgumentIndex();
            NumberFormat numberPart = (NumberFormat)formats[1];
            int randLength = numberPart.getMinimumIntegerDigits();
            Integer randNumber = this.makeRandNumber(randLength);
            Object[] args = new Object[]{Calendar.getInstance().getTime(), randNumber};
            randomSerial = form.format(args);
        }
        return randomSerial;
    }

    public String[] getPublicPassword() {
        String pattern;
        if (this.m_oInfoViewCfg.isPublicPasswordRequired() && !CMyString.isEmpty(pattern = this.m_oInfoViewCfg.getPublicPasswordPattern())) {
            String publicPassword = "";
            String field = this.m_oInfoViewCfg.getPublicPasswordField();
            MessageFormat form = new MessageFormat(pattern);
            Format[] formats = form.getFormatsByArgumentIndex();
            NumberFormat numberPart = (NumberFormat)formats[0];
            int randLength = numberPart.getMinimumIntegerDigits();
            Integer randNumber = this.makeRandNumber(randLength);
            Object[] args = new Object[]{randNumber};
            publicPassword = form.format(args);
            return new String[]{field, publicPassword};
        }
        return new String[0];
    }

    private Integer makeRandNumber(int _iDigits) {
        int iLimit = (int)Math.pow(10.0, _iDigits);
        int randInt = this.m_oRandomMaker.nextInt(iLimit) & Integer.MAX_VALUE;
        return new Integer(randInt);
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int nFromInfoViewId = -1;
        String sConfigValue = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            nFromInfoViewId = Integer.parseInt(sConfigValue);
        }
        catch (NumberFormatException e) {
            s_logger.error((Object)(I18NMessage.get(InfoViewMgr.class, "InfoViewMgr.label51", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + sConfigValue + "]"), (Throwable)e);
            nFromInfoViewId = -1;
        }
        return nFromInfoViewId;
    }

    private int getCompressLength(int _nOldLength) {
        return (int)Math.floor((float)_nOldLength / 1.5f);
    }
}

