/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class InfoViewDataHelper {
    public static final String KEY_DOM4J = "KEY_DOM4JDOCUMENT";
    private static final Logger s_logger = Logger.getLogger(InfoViewDataHelper.class);
    private static HashMap WCM_SYSTEM_FIELD_DESCS = null;
    private static HashMap WCM_SYSTEM_FIELDS = null;

    private InfoViewDataHelper() {
    }

    public static final String getProperty(com.trs.components.wcm.content.persistent.Document wcmDocument, String field) throws WCMException {
        if (wcmDocument.getChannel().getType() != 13) {
            return null;
        }
        Document dom4jDocument = null;
        dom4jDocument = (Document)wcmDocument.getProperty(KEY_DOM4J);
        if (dom4jDocument == null) {
            String xmlContent = wcmDocument.getContent();
            if (xmlContent == null) {
                return null;
            }
            StringReader reader = new StringReader(xmlContent);
            SAXReader xmlReader = new SAXReader();
            try {
                dom4jDocument = xmlReader.read((Reader)reader);
            }
            catch (Exception e) {
                s_logger.error((Object)I18NMessage.get(InfoViewDataHelper.class, "InfoViewDataHelper.label1", "\u5c06\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u683c\u5f0f\u5316\u4e3aDOM4J\u5bf9\u8c61\u51fa\u9519"), (Throwable)e);
            }
            if (dom4jDocument == null) {
                return null;
            }
            wcmDocument.setProperty(KEY_DOM4J, dom4jDocument, false);
        }
        return InfoViewDataHelper.getFieldValue(field, dom4jDocument);
    }

    public static final String getFieldValue(com.trs.components.wcm.content.persistent.Document wcmDocument, String field) throws WCMException {
        if (wcmDocument.getChannel().getType() != 13) {
            return null;
        }
        Object sResult = wcmDocument.getProperty(field);
        if (sResult != null) {
            return sResult.toString();
        }
        Document dom4jDocument = null;
        dom4jDocument = (Document)wcmDocument.getProperty(KEY_DOM4J);
        if (dom4jDocument == null) {
            String xmlContent = wcmDocument.getContent();
            if (xmlContent == null) {
                return null;
            }
            StringReader reader = new StringReader(xmlContent);
            SAXReader xmlReader = new SAXReader();
            try {
                dom4jDocument = xmlReader.read((Reader)reader);
            }
            catch (Exception e) {
                s_logger.error((Object)I18NMessage.get(InfoViewDataHelper.class, "InfoViewDataHelper.label1", "\u5c06\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u683c\u5f0f\u5316\u4e3aDOM4J\u5bf9\u8c61\u51fa\u9519"), (Throwable)e);
            }
            if (dom4jDocument == null) {
                return null;
            }
            wcmDocument.setProperty(KEY_DOM4J, dom4jDocument, false);
        }
        return InfoViewDataHelper.getFieldValue(field, dom4jDocument);
    }

    private static HashMap getWcmSystemDisplays() {
        if (WCM_SYSTEM_FIELD_DESCS == null) {
            WCM_SYSTEM_FIELD_DESCS = new HashMap();
            WCM_SYSTEM_FIELD_DESCS.put("DOCTITLE", I18NMessage.get(InfoViewDataHelper.class, "InfoViewDataHelper.label2", "\u6587\u6863\u6807\u9898"));
            WCM_SYSTEM_FIELD_DESCS.put("CRUSER", I18NMessage.get(InfoViewDataHelper.class, "InfoViewDataHelper.label3", "\u53d1\u7a3f\u4eba"));
            WCM_SYSTEM_FIELD_DESCS.put("CRTIME", I18NMessage.get(InfoViewDataHelper.class, "InfoViewDataHelper.label4", "\u521b\u5efa\u65f6\u95f4"));
            WCM_SYSTEM_FIELD_DESCS.put("ARCHIVESERIAL", I18NMessage.get(InfoViewDataHelper.class, "InfoViewDataHelper.label5", "\u5b58\u6863\u7f16\u53f7"));
        }
        return WCM_SYSTEM_FIELD_DESCS;
    }

    private static HashMap getWcmSystemFields() {
        if (WCM_SYSTEM_FIELDS == null) {
            WCM_SYSTEM_FIELDS = new HashMap();
            WCM_SYSTEM_FIELDS.put("DOCTITLE", "DOCTITLE");
            WCM_SYSTEM_FIELDS.put("CRUSER", "CRUSER");
            WCM_SYSTEM_FIELDS.put("CRTIME", "CRTIME");
            WCM_SYSTEM_FIELDS.put("ARCHIVESERIAL", "DOCNO");
        }
        return WCM_SYSTEM_FIELDS;
    }

    private static HashMap getInfoViewFields(InfoView _oInfoView) throws WCMException {
        List lstFields = _oInfoView.allFields();
        HashMap<String, String> hsFields = new HashMap<String, String>();
        for (InfoViewField oInfoViewField : lstFields) {
            String sXPath = oInfoViewField.getXPath();
            String sName = oInfoViewField.getName();
            String sDesc = oInfoViewField.getDesc();
            hsFields.put(sXPath, sDesc);
            hsFields.put(sName, sDesc);
        }
        return hsFields;
    }

    public static String buildContent(InfoView _oInfoView, com.trs.components.wcm.content.persistent.Document wcmDocument, Document _oDom4jDocument) throws WCMException {
        String sDocContentPattern = CMyString.showNull(_oInfoView.getDocContentPattern());
        String[] arrFieldNames = sDocContentPattern.split(",");
        StringBuffer sbResult = new StringBuffer();
        for (int i = 0; i < arrFieldNames.length; ++i) {
            String sFieldName = arrFieldNames[i];
            if (CMyString.isEmpty(sFieldName)) continue;
            String sTrueName = (String)InfoViewDataHelper.getWcmSystemFields().get(sFieldName);
            String sValue = null;
            String sDisplayName = null;
            if (sTrueName != null) {
                sDisplayName = (String)InfoViewDataHelper.getWcmSystemDisplays().get(sFieldName);
                sValue = wcmDocument.getPropertyAsString(sTrueName);
            } else {
                sDisplayName = (String)InfoViewDataHelper.getInfoViewFields(_oInfoView).get(sFieldName);
                sValue = InfoViewDataHelper.getFieldValue(sFieldName, _oDom4jDocument);
            }
            sValue = CMyString.showNull(sValue);
            sDisplayName = CMyString.showNull(sDisplayName, sFieldName);
            sbResult.append(sDisplayName).append("=");
            sbResult.append(sValue).append("\n");
        }
        return sbResult.toString();
    }

    private static final String getFieldValue(String sFieldName, Document dom4jDocument) {
        if (sFieldName.indexOf(58) < 0) {
            String s = dom4jDocument.getRootElement().getNamespacePrefix();
            sFieldName = s + ':' + sFieldName;
        }
        if (sFieldName.charAt(0) != '/') {
            sFieldName = "//" + sFieldName;
        } else if (!sFieldName.startsWith("//")) {
            sFieldName = '/' + sFieldName;
        }
        Node node = dom4jDocument.selectSingleNode(sFieldName);
        if (node == null) {
            return null;
        }
        return node.getStringValue();
    }
}

