/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StyleHelper {
    public static String makeCSSContent(String _sCssFlag, String _sCSSTemplateContent, StyleItems _items) throws WCMException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < _items.size(); ++i) {
            StyleItem item = (StyleItem)_items.getAt(i);
            if (item == null) continue;
            map.put(item.getClassName().toUpperCase(), item.getClassValue());
        }
        String CSSTemplateContent = CMyString.parsePageVariables(_sCSSTemplateContent, map, 40);
        if (_sCssFlag == null || _sCssFlag.trim().equals("")) {
            return CSSTemplateContent + System.getProperty("line.separator");
        }
        List newItem = StyleHelper.parseCssContent(CSSTemplateContent);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < newItem.size(); ++i) {
            StyleItem styleItem = (StyleItem)newItem.get(i);
            if (styleItem == null) continue;
            sb.append(StyleHelper.makeItemCssContent(_sCssFlag, styleItem));
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    private static String makeItemCssContent(String _cssFlag, StyleItem _styleItem) {
        if (_styleItem == null) {
            return "";
        }
        String sClassName = _styleItem.getClassName().trim();
        String sClassValue = _styleItem.getClassValue().trim();
        StringBuffer sb = new StringBuffer();
        if (!_cssFlag.startsWith(".")) {
            _cssFlag = "." + _cssFlag;
        }
        sb.append(StyleHelper.makeClassName(sClassName, _cssFlag));
        sb.append("{").append(sClassValue).append("}");
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    private static String makeClassName(String _className, String _cssFlag) {
        if (_className.indexOf(",") == -1) {
            return _cssFlag + " " + _className;
        }
        String[] classItems = CMyString.split(_className, ",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < classItems.length; ++i) {
            String classItem = classItems[i];
            sb.append("," + _cssFlag + " " + classItem);
        }
        return sb.toString().substring(1);
    }

    public static List parseCssContent(String _cssContent) throws WCMException {
        ArrayList<StyleItem> styleCsses = new ArrayList<StyleItem>();
        if (_cssContent == null || _cssContent.trim().equals("")) {
            return styleCsses;
        }
        boolean bInMemo = false;
        boolean bInCss = false;
        StringBuffer oStringBuffer = new StringBuffer();
        String sCssName = "";
        String sCssValue = "";
        for (int i = 0; i < _cssContent.length(); ++i) {
            char currChar = _cssContent.charAt(i);
            if (bInMemo) {
                if (currChar != '*' || _cssContent.charAt(i + 1) != '/') continue;
                bInMemo = false;
                i = i + "*/".length() - 1;
                continue;
            }
            if (!bInMemo && currChar == '/' && _cssContent.charAt(i + 1) == '*') {
                bInMemo = true;
                i = i + "/*".length() - 1;
                continue;
            }
            if (bInCss && (currChar == '\n' || currChar == '\r' || currChar == '\t')) continue;
            if (!bInCss && currChar == '{') {
                sCssName = oStringBuffer.toString();
                oStringBuffer.delete(0, oStringBuffer.length());
                bInCss = true;
                continue;
            }
            if (bInCss && currChar == '}') {
                sCssValue = oStringBuffer.toString();
                oStringBuffer.delete(0, oStringBuffer.length());
                bInCss = false;
                if (sCssName == null || sCssName.trim().equals("")) continue;
                StyleItem styleItem = new StyleItem();
                styleItem.setClassName(sCssName.trim());
                styleItem.setClassValue(sCssValue);
                styleCsses.add(styleItem);
                continue;
            }
            oStringBuffer.append(currChar);
        }
        return styleCsses;
    }

    public static String getCssTemplateFilePath() throws WCMException {
        return StylePathHelper.getCssTemplateFilePath();
    }

    public static String makeCustomCssContent(String _sCssFlag, String _sCustomStyle) throws WCMException {
        if (_sCssFlag == null || _sCssFlag.trim().equals("")) {
            return _sCustomStyle + System.getProperty("line.separator");
        }
        List newItem = StyleHelper.parseCssContent(_sCustomStyle);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < newItem.size(); ++i) {
            StyleItem styleItem = (StyleItem)newItem.get(i);
            if (styleItem == null) continue;
            sb.append(StyleHelper.makeItemCssContent(_sCssFlag, styleItem));
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }
}

