/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyleXmlConverter;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ResourceStyleExporter {
    private static Logger logger = Logger.getLogger(ResourceStyleExporter.class);
    private String m_sXMLEncoding = "utf-8";
    private String[] m_aImageClassNameStyleItems = new String[]{"p_w_head_background", "p_w_more_background", "p_w_body_background", "p_w_body_bg_background", "p_w_foot_background", "p_w_foot_bg_background", "p_w_content_background"};
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");

    public String export(ResourceStyles _currResourceStyles, int _nPageStyleId) throws Exception {
        if (_currResourceStyles == null) {
            throw new WCMException("\u5bfc\u51fa\u7684ResourceStyle\u5bf9\u8c61\u4e3anull!");
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sZipFile = filesMan.getNextFileName("ST", "zip", null, true);
        CMyZip myZip = new CMyZip();
        myZip.setZipFileName(sZipFile);
        String sTempFilePath = CMyFile.extractFilePath(sZipFile);
        CMyDateTime nowDateTime = CMyDateTime.now();
        String sTempPath = sTempFilePath + nowDateTime.toString("yyyy-MM-dd") + "_" + System.currentTimeMillis() + "_temp";
        CMyFile.makeDir(sTempPath, true);
        try {
            int i;
            if (_nPageStyleId > 0) {
                PageStyle pageStyle = PageStyle.findById(_nPageStyleId);
                this.exportResourceStylesForOnePageStyle(_currResourceStyles, pageStyle, sTempPath);
            } else {
                PageStyles pageStyles = this.m_oPageStyleMgr.query(null);
                int nSize = pageStyles.size();
                for (i = 0; i < nSize; ++i) {
                    PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
                    if (pageStyle == null) continue;
                    int nPageStyleId = pageStyle.getId();
                    ResourceStyles resourceStyles = new ResourceStyles(this.getLoginUser());
                    int nResourceStyleSize = _currResourceStyles.size();
                    for (int j = 0; j < nResourceStyleSize; ++j) {
                        String sCssFlag;
                        ResourceStyles oSameNameResorcestyles;
                        ResourceStyle resource = (ResourceStyle)_currResourceStyles.getAt(j);
                        if (resource == null || (oSameNameResorcestyles = ResourceStyles.findSameCssFlagStyles(sCssFlag = resource.getCssFlag(), nPageStyleId)) == null || oSameNameResorcestyles.size() == 0) continue;
                        resourceStyles.addElement(oSameNameResorcestyles.getAt(0));
                    }
                    this.exportResourceStylesForOnePageStyle(resourceStyles, pageStyle, sTempPath);
                }
            }
            myZip.setZipWithChildDirPath(true);
            FileStore[] files = CMyFile.listSubDirectories(sTempPath);
            for (i = 0; i < files.length; ++i) {
                FileStore oFile = files[i];
                String sPath = oFile.getAbsolutePath();
                myZip.addToZip(sPath, false);
            }
            myZip.done();
        }
        catch (Exception e) {
            logger.error((Object)"failed to zip files!", (Throwable)e);
            CMyFile.deleteFile(sZipFile);
            throw new WCMException(1100, "\u538b\u7f29\u6587\u4ef6\u5931\u8d25!", e);
        }
        finally {
            CMyFile.deleteDir(sTempPath);
        }
        return CMyFile.extractFileName(sZipFile);
    }

    private void exportResourceStylesForOnePageStyle(ResourceStyles _resourceStyles, PageStyle _oPageStyle, String _sTempPath) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        ResourceStyleXmlConverter resourceStyleXmlConvertor = new ResourceStyleXmlConverter();
        resourceStyleXmlConvertor.setXmlEncoding(this.m_sXMLEncoding);
        resourceStyleXmlConvertor.toXMLFile(_resourceStyles, sXmlFile);
        String sPageStyleName = _oPageStyle.getStyleName();
        String sStylePath = _sTempPath + File.separator + sPageStyleName + File.separator;
        CMyFile.makeDir(sStylePath, true);
        String sXmlFileName = CMyFile.extractFileName(sXmlFile);
        CMyFile.copyFile(sXmlFile, sStylePath + sXmlFileName);
        CMyFile.deleteFile(sXmlFile);
        for (int m = 0; m < _resourceStyles.size(); ++m) {
            ResourceStyle oResource = (ResourceStyle)_resourceStyles.getAt(m);
            if (oResource == null) continue;
            String sTempThumbPath = sStylePath + "thumb" + File.separator;
            if (!CMyFile.fileExists(sTempThumbPath)) {
                CMyFile.makeDir(sTempThumbPath, true);
            }
            this.addResourceStyleThumbFolder(oResource, sTempThumbPath);
            String sStyleCommonDir = StylePathHelper.getStyleCommonDir();
            this.addStyleItemImagesFolder(oResource, sStyleCommonDir, _sTempPath);
        }
    }

    private void addStyleItemImagesFolder(ResourceStyle _currResourceStyle, String _sCommonDir, String _sTempPath) throws Exception {
        if (_currResourceStyle == null) {
            return;
        }
        ArrayList thumbAndImageList = this.getResourceStyleItemImages(_currResourceStyle, _sCommonDir);
        for (int i = 0; i < thumbAndImageList.size(); ++i) {
            FileService currFile;
            String sThumbFilePath = (String)thumbAndImageList.get(i);
            if (CMyString.isEmpty(sThumbFilePath) || !(currFile = new FileService(sThumbFilePath)).exists()) continue;
            String sFileName = currFile.getName();
            String sFilePath = CMyFile.extractFilePath(sThumbFilePath);
            sFilePath = sFilePath.substring(0, sFilePath.length() - 1);
            int nLastIndex = sFilePath.lastIndexOf(File.separatorChar);
            String _sTargetTempPath = CMyString.setStrEndWith(_sTempPath, File.separatorChar);
            String sLastFileName = sFilePath.substring(nLastIndex + 1);
            if (!CMyFile.fileExists(_sTargetTempPath = _sTargetTempPath + sLastFileName + File.separatorChar + "resource" + File.separatorChar)) {
                CMyFile.makeDir(_sTargetTempPath, true);
            }
            CMyFile.copyFile(sThumbFilePath, _sTargetTempPath + sFileName, false);
        }
    }

    private void addResourceStyleThumbFolder(ResourceStyle _currResourceStyle, String _sTempPageStylePath) throws Exception {
        if (_currResourceStyle == null) {
            return;
        }
        String sStyleThumb = _currResourceStyle.getStyleThumb();
        if (CMyString.isEmpty(sStyleThumb)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sResourceStyleThumb = filesMan.mapFilePath(sStyleThumb, 0) + sStyleThumb;
        CMyFile.copyFile(sResourceStyleThumb, _sTempPageStylePath + sStyleThumb);
    }

    public ArrayList getResourceStyleItemImages(ResourceStyle _currResourceStyle, String _sConmmonDir) throws WCMException {
        if (_currResourceStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684\u5185\u5bb9\u6837\u5f0f\u5bf9\u8c61\u4e3anull\uff01");
        }
        if (_sConmmonDir == null) {
            throw new WCMException("\u8bf7\u4f20\u5165\u5f53\u524d\u5185\u5bb9\u6837\u5f0f\u7f29\u7565\u56fe\u5b58\u653e\u7684\u8def\u5f84\uff01");
        }
        ArrayList<String> thumbFilesList = new ArrayList<String>();
        WCMFilter aFilter = new WCMFilter("", "StyleObjType=? and StyleObjId=?", "");
        aFilter.addSearchValues(0, _currResourceStyle.getWCMType());
        aFilter.addSearchValues(1, _currResourceStyle.getId());
        StyleItems allStyleItems = StyleItems.openWCMObjs(this.getLoginUser(), aFilter);
        if (CMyString.isEmpty(_sConmmonDir)) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c[Id=" + _currResourceStyle.getId() + "]\u7684styleItem\u7684\u8def\u5f84\u5931\u8d25\uff01");
        }
        for (int i = 0; i < allStyleItems.size(); ++i) {
            String sImageAbsolutePath;
            String sItemClassValue;
            StyleItem aStyleItem = (StyleItem)allStyleItems.getAt(i);
            if (aStyleItem == null || !this.isImageStyleItem(aStyleItem) || CMyString.isEmpty(sItemClassValue = aStyleItem.getClassValue()) || CMyString.isEmpty(sImageAbsolutePath = this.calculteStyleItemImage(_sConmmonDir, sItemClassValue)) || !CMyFile.fileExists(sImageAbsolutePath)) continue;
            thumbFilesList.add(sImageAbsolutePath);
        }
        return thumbFilesList;
    }

    private String calculteStyleItemImage(String _sStyleItemImagePath, String _sItemClassValue) {
        if (CMyString.isEmpty(_sStyleItemImagePath) || CMyString.isEmpty(_sItemClassValue)) {
            return null;
        }
        _sItemClassValue = _sItemClassValue.replace('\\', File.separatorChar);
        _sItemClassValue = _sItemClassValue.replace('/', File.separatorChar);
        String sFileName = CMyFile.extractFileName(_sItemClassValue);
        String sFilePath = CMyFile.extractFilePath(_sItemClassValue);
        int nLastIndex = (sFilePath = sFilePath.substring(0, sFilePath.length() - 1)).lastIndexOf(File.separatorChar);
        if (nLastIndex < 0 || nLastIndex + 1 >= _sItemClassValue.length()) {
            return null;
        }
        String sLastFileName = sFilePath.substring(nLastIndex + 1);
        return CMyString.setStrEndWith(_sStyleItemImagePath, File.separatorChar) + sLastFileName + File.separatorChar + sFileName;
    }

    private boolean isImageStyleItem(StyleItem _styleItm) {
        if (_styleItm == null) {
            return false;
        }
        for (int i = 0; i < this.m_aImageClassNameStyleItems.length; ++i) {
            if (!this.m_aImageClassNameStyleItems[i].equalsIgnoreCase(_styleItm.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void setXMLEncoding(String _sXMLEncoding) {
        this.m_sXMLEncoding = _sXMLEncoding;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] args) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        ResourceStyleExporter export = new ResourceStyleExporter();
        ResourceStyles styles = ResourceStyles.findByIds(ContextHelper.getLoginUser(), "20065,20067");
        String spath = export.export(styles, 0);
        System.out.println("------------" + spath);
    }
}

