/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.FileDistributorImpUnion;
import com.trs.components.common.publish.domain.distribute.PublishDistributionCacheMgr;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class FileDistributeShip
implements IClearable {
    private static final Logger s_logger = Logger.getLogger(FileDistributeShip.class);
    private boolean m_zAsyncMode;
    private boolean m_zBatchMode;
    private Map m_oDistributorsCache;
    private PublishDistributionCacheMgr m_oDistributionCache;
    private PublishPathCompass m_pathCompass = null;
    private Comparator compartor = new Comparator(){

        public int compare(Object o1, Object o2) {
            FileStore file1 = (FileStore)o1;
            FileStore file2 = (FileStore)o2;
            return file1.getName().compareTo(file2.getName());
        }
    };

    public FileDistributeShip() {
        this(null);
    }

    public FileDistributeShip(PublishPathCompass _pathCompass) {
        this.m_oDistributorsCache = new HashMap();
        this.m_pathCompass = _pathCompass;
        this.m_oDistributionCache = (PublishDistributionCacheMgr)DreamFactory.createObjectById("PublishDistributionCacheMgr");
    }

    public boolean getAsyncMode() {
        return this.m_zAsyncMode;
    }

    public void setAsyncMode(boolean asyncMode) {
        this.m_zAsyncMode = asyncMode;
    }

    public boolean getBatchMode() {
        return this.m_zBatchMode;
    }

    public void setBatchMode(boolean batchMode) {
        if (batchMode && this.m_oDistributorsCache == null) {
            this.m_oDistributorsCache = new HashMap();
        }
        this.m_zBatchMode = batchMode;
    }

    public void clear() {
        if (this.m_oDistributorsCache != null) {
            if (this.m_zBatchMode) {
                for (FileDistributorImpUnion union : this.m_oDistributorsCache.values()) {
                    if (union == null) continue;
                    this.m_oDistributionCache.removeChangeListener(union);
                }
            }
            this.m_oDistributorsCache.clear();
            this.m_oDistributorsCache = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDistributorImpUnion getRootDistributorUnion(IPublishFolder _folder) throws WCMException {
        IPublishFolder root = _folder.getRoot();
        if (!this.m_zBatchMode) {
            return this.m_oDistributionCache.getDistributorUnion(root);
        }
        String sKey = PublishDistributionCacheMgr.makeCaheKey(root.getType(), root.getId());
        FileDistributorImpUnion union = (FileDistributorImpUnion)this.m_oDistributorsCache.get(sKey);
        if (union == null) {
            Map map = this.m_oDistributorsCache;
            synchronized (map) {
                union = (FileDistributorImpUnion)this.m_oDistributorsCache.get(sKey);
                if (union == null && (union = this.m_oDistributionCache.getDistributorUnion(root)) != null) {
                    this.m_oDistributionCache.addChangeListener(union);
                    this.m_oDistributorsCache.put(sKey, union);
                }
            }
        }
        return union;
    }

    private String getFullDataPath(IPublishElement _element) throws WCMException {
        if (this.m_pathCompass == null) {
            return PublishPathCompass.calFullDataPath(_element, false);
        }
        return this.m_pathCompass.getFullDataPath(_element, false);
    }

    public int distributeFile(String _sLocalFile, IPublishElement _fileOwner) throws WCMException {
        return this.distributeFile(_sLocalFile, _fileOwner, null);
    }

    public int distributeFile(String _sLocalFile, IPublishElement _fileOwner, String _sSubDir) throws WCMException {
        return this.distributeFile(_sLocalFile, _fileOwner, _sSubDir, false);
    }

    public int distributeFile(String _sLocalFile, IPublishElement _fileOwner, String _sSubDir, boolean _bCheckDstFileExits) throws WCMException {
        DebugTimer aTimer = new DebugTimer();
        aTimer.start();
        try {
            FileDistributorImpUnion distributor;
            IPublishFolder folder;
            String sFullDataPath = this.getFullDataPath(_fileOwner);
            if (_sSubDir != null && (_sSubDir = _sSubDir.trim()).length() > 0) {
                sFullDataPath = sFullDataPath + CMyString.setStrEndWith(_sSubDir, '/');
            }
            if ((folder = _fileOwner.getFolder()) == null) {
                s_logger.warn((Object)("can't find folder of:" + _fileOwner.getInfo()));
                if (_fileOwner instanceof IPublishContent) {
                    s_logger.info((Object)"PublishContent instance,use originalhome!");
                    folder = ((IPublishContent)_fileOwner).getRealHome();
                }
            }
            if ((distributor = this.getRootDistributorUnion(folder)) == null) {
                int n = 0;
                return n;
            }
            distributor.distributeFile(_sLocalFile, sFullDataPath, _bCheckDstFileExits);
            if (folder != null) {
                SimpleLogServer.distribute(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), "", String.format("\u6dfb\u52a0\u6216\u4fee\u6539\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", CMyFile.extractFileName(_sLocalFile), sFullDataPath));
            }
            int n = distributor.size();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label4", "\u5206\u53d1[{0}]\u4e0a\u7684\u6587\u4ef6[{1}]\u5931\u8d25\uff01"), new String[]{_fileOwner.getInfo(), _sLocalFile}), ex);
        }
        finally {
            aTimer.stop();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("distribute the file [" + _sLocalFile + "] of [" + _fileOwner.getInfo() + "] use [" + aTimer.getTime() + "]ms"));
            }
        }
    }

    public void distributeFileDir(String _sFileDir, IPublishElement _fileOwner, String _sSubDir, boolean _bCheckDstFileExits) throws WCMException {
        FileService dir = new FileService(_sFileDir);
        if (!(dir.exists() && dir.canRead() && dir.isDirectory())) {
            return;
        }
        FileStore[] files = dir.listFiles();
        Arrays.sort(files, this.compartor);
        for (int i = 0; i < files.length; ++i) {
            FileStore oFile = files[i];
            if (oFile.isDirectory()) {
                this.distributeFileDir(oFile.getAbsolutePath(), _fileOwner, _sSubDir, _bCheckDstFileExits);
                continue;
            }
            this.distributeFile(oFile.getAbsolutePath(), _fileOwner, _sSubDir, _bCheckDstFileExits);
        }
    }

    public int withdrawFolder(IPublishFolder _folder) throws WCMException {
        try {
            FileDistributorImpUnion distributor = this.getRootDistributorUnion(_folder);
            if (distributor == null) {
                return 0;
            }
            distributor.withdrawPath(this.getFullDataPath(_folder));
            return distributor.size();
        }
        catch (Exception ex) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label1", "\u64a4\u9500\u53d1\u5e03[{0}]\u5931\u8d25\uff01"), new String[]{_folder.getInfo()}), ex);
        }
    }

    public int withdrawFolder(IPublishFolder _folder, List subdirs) throws WCMException {
        if (subdirs == null || subdirs.isEmpty()) {
            return 0;
        }
        try {
            FileDistributorImpUnion distributor = this.getRootDistributorUnion(_folder);
            if (distributor == null) {
                return 0;
            }
            int result = 0;
            int size = subdirs.size();
            for (int i = 0; i < size; ++i) {
                String path = (String)subdirs.get(i);
                if (File.separatorChar != '/') {
                    path = path.replace(File.separatorChar, '/');
                }
                distributor.withdrawPath(path);
                result += distributor.size();
            }
            return result;
        }
        catch (Exception ex) {
            throw new WCMException(236, "Failed to withdraw the " + _folder.getInfo(), ex);
        }
    }

    public int withdrawFile(String _sFileName, IPublishElement _fileOwner) throws WCMException {
        return this.withdrawFile(_sFileName, _fileOwner, this.getFullDataPath(_fileOwner));
    }

    public int withdrawFile(String _sFileName, IPublishElement _fileOwner, String _sFullDataPath) throws WCMException {
        try {
            IPublishFolder folder = _fileOwner.getFolder();
            FileDistributorImpUnion distributor = this.getRootDistributorUnion(folder);
            if (distributor == null) {
                return 0;
            }
            distributor.withdrawFile(_sFileName, _sFullDataPath);
            return distributor.size();
        }
        catch (Exception ex) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label2", "\u5220\u9664[{0}]\u5931\u8d25\uff01"), new String[]{_sFileName}), ex);
        }
    }

    public int renameFile(IPublishFolder _folder, String _sSourceFile, String _sTargetFile) throws WCMException {
        return this.renameFile(_folder, _sSourceFile, _sTargetFile, this.getFullDataPath(_folder));
    }

    public int renameFile(IPublishFolder _folder, String _sSourceFile, String _sTargetFile, String _sFullDataPath) throws WCMException {
        try {
            FileDistributorImpUnion distributor = this.getRootDistributorUnion(_folder);
            if (distributor == null) {
                return 0;
            }
            distributor.renameFile(_sSourceFile, _sTargetFile, _sFullDataPath);
            return distributor.size();
        }
        catch (Exception ex) {
            throw new WCMException(236, CMyString.format(I18NMessage.get(FileDistributeShip.class, "FileDistributeShip.label3", "\u4e3a{0}\u8def\u5f84{1}\u7684\u6587\u4ef6{2}\u91cd\u547d\u540d\u4e3a{3}\u5931\u8d25\uff01"), new String[]{_folder.getInfo(), _sFullDataPath, _sSourceFile, _sTargetFile}), ex);
        }
    }
}

