/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.DreamFactory;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.LockManager;
import com.trs.cms.content.Locker;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class LockerMgr {
    private static Logger s_logger = Logger.getLogger(LockerMgr.class);
    protected Hashtable hLockers = new Hashtable();
    private boolean m_bClusterStarted = true;

    public LockerMgr() {
        TRSWCMClusterServer clusterServer = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        this.m_bClusterStarted = clusterServer.getContext() != null && clusterServer.getContext().getConfig().isEnabled();
    }

    public Locker getLocker(CMSObj _obj, boolean _bCreateWhenNotExists) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().getLocker(_obj, _bCreateWhenNotExists);
        }
        if (_obj == null || !_obj.isValidInstance()) {
            return null;
        }
        return this.getLocker(_obj.getWCMType(), _obj.getId(), _bCreateWhenNotExists);
    }

    public Locker getLocker(int _nObjType, int _nObjId, boolean _bCreateWhenNotExists) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().getLocker(_nObjType, _nObjId, _bCreateWhenNotExists);
        }
        try {
            Hashtable hLockersOfThisType = this.getLockersOfType(_nObjType, _bCreateWhenNotExists);
            if (hLockersOfThisType == null) {
                return null;
            }
            Integer key = new Integer(_nObjId);
            Locker locker = (Locker)hLockersOfThisType.get(key);
            if (locker == null && _bCreateWhenNotExists) {
                locker = new Locker();
                hLockersOfThisType.put(key, locker);
            }
            return locker;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Locker removeLocker(CMSObj _obj) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().removeLocker(_obj);
        }
        if (_obj == null || this.hLockers == null) {
            return null;
        }
        return this.removeLocker(_obj.getWCMType(), _obj.getId());
    }

    public Locker removeLocker(int _nObjType, int _nObjId) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().removeLocker(_nObjType, _nObjId);
        }
        try {
            if (this.hLockers == null) {
                return null;
            }
            Hashtable hLockerOfThisType = this.getLockersOfType(_nObjType, false);
            if (hLockerOfThisType == null) {
                return null;
            }
            return (Locker)hLockerOfThisType.remove(new Integer(_nObjId));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getLockedObjIds(int _nObjType) {
        if (this.m_bClusterStarted) {
            return LockManager.instance().getLockedObjIds(_nObjType);
        }
        Hashtable lockers = this.getLockersOfType(_nObjType, false);
        String ids = "";
        if (lockers != null) {
            Enumeration keys = lockers.keys();
            while (keys.hasMoreElements()) {
                ids = ids + "," + keys.nextElement();
            }
            if (ids.length() > 0) {
                ids = ids.substring(1);
            }
        }
        return ids;
    }

    private Hashtable getLockersOfType(int _nObjType, boolean _bCreateWhenNotExists) {
        Integer iKey = new Integer(_nObjType);
        Hashtable hLockersOfThisType = (Hashtable)this.hLockers.get(iKey);
        if (hLockersOfThisType == null && _bCreateWhenNotExists) {
            hLockersOfThisType = new Hashtable();
            this.hLockers.put(iKey, hLockersOfThisType);
        }
        return hLockersOfThisType;
    }

    public void freeLockedObjBy(User _currUser) {
        if (this.m_bClusterStarted) {
            LockManager.instance().freeLockedObjBy(_currUser);
            return;
        }
        if (_currUser == null) {
            return;
        }
        try {
            Enumeration lockers = this.hLockers.elements();
            Hashtable typelockers = null;
            Enumeration keys = null;
            Locker locker = null;
            Object lockerKey = null;
            while (lockers.hasMoreElements()) {
                typelockers = (Hashtable)lockers.nextElement();
                keys = typelockers.keys();
                while (keys.hasMoreElements()) {
                    lockerKey = keys.nextElement();
                    locker = (Locker)typelockers.get(lockerKey);
                    if (locker == null || !locker.lockUserIs(_currUser)) continue;
                    typelockers.remove(lockerKey);
                }
            }
        }
        catch (Exception e) {
            s_logger.error((Object)("Failed to free object locked by:" + _currUser), (Throwable)e);
        }
    }
}

