/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class RightDef
extends CMSObj {
    public static final int OBJ_TYPE = 205;
    public static final String DB_TABLE_NAME = "WCMRIGHTDEF";
    public static final String DB_ID_NAME = "RIGHTDEFID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 205;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _nObjType) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(RightDef.class, "RightDef.label1", "\u5c5e\u6027ObjType\u4e0d\u5141\u8bb8\u4fee\u6539(RightConfnig.setObjType)"));
        }
        return this.setProperty("OBJTYPE", _nObjType);
    }

    public int getIndex() {
        return this.getPropertyAsInt("RIGHTINDEX", -1);
    }

    public boolean setIndex(int _index) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(RightDef.class, "RightDef.label2", "\u5c5e\u6027Position\u4e0d\u5141\u8bb8\u4fee\u6539(RightConfnig.setPosition)"));
        }
        if (_index < 0 || _index >= 100) {
            throw new WCMException(1102, I18NMessage.get(RightDef.class, "RightDef.label3", "\u5c5e\u6027Position\u503c\u8d8a\u754c\uff08\u5fc5\u987b\u57280-99\u4e4b\u95f4\uff09(RightConfnig.setPosition)"));
        }
        return this.setProperty("RIGHTINDEX", _index);
    }

    public String getName() {
        return (String)this.getProperty("RIGHTNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("RIGHTNAME", _name);
    }

    public boolean isSysDefined() {
        return this.getPropertyAsBoolean("SYSDEFINED", true);
    }

    public boolean setSysDefined(boolean _bSysDefined) throws WCMException {
        return this.setProperty("SYSDEFINED", _bSysDefined);
    }

    public String getDesc() {
        return (String)this.getProperty("RIGHTDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("RIGHTDESC", _desc);
    }

    @Override
    public boolean isValid() throws WCMException {
        Number iObjType = (Number)this.getProperty("OBJTYPE");
        Number iIndex = (Number)this.getProperty("RIGHTINDEX");
        String sName = this.getPropertyAsString("RIGHTNAME");
        String sIndexCondition = null;
        String sNameCondition = null;
        if (this.isAddMode()) {
            if (iObjType == null) {
                throw new WCMException(1106, I18NMessage.get(RightDef.class, "RightDef.label4", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(RightDef.isValid)"));
            }
            if (iIndex == null) {
                throw new WCMException(1106, I18NMessage.get(RightDef.class, "RightDef.label5", "\u5c5e\u6027Index\u6ca1\u6709\u8bbe\u7f6e(RightDef.isValid)"));
            }
            sIndexCondition = "(ObjType=" + iObjType + ") AND (RightIndex=" + iIndex + ")";
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(RightDef.class, "RightDef.label6", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(RightDef.isValid)"));
            }
            sNameCondition = "(ObjType=" + iObjType + ") AND (RightName='" + CMyString.filterForSQL(sName) + "')";
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(RightDef.class, "RightDef.label7", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(RightDef.isValid)"));
            }
            String sExtraCondition = " AND (RIGHTDEFID>" + this.getId() + " OR " + DB_ID_NAME + "<" + this.getId() + ")";
            if (this.isChangeProperty("OBJTYPE")) {
                iObjType = (Number)this.getNewProperty("OBJTYPE");
            }
            if (this.isChangeProperty("RIGHTINDEX")) {
                iIndex = (Number)this.getNewProperty("RIGHTINDEX");
            }
            sIndexCondition = "(ObjType=" + iObjType + ") AND (RightIndex=" + iIndex + ")" + sExtraCondition;
            if (this.isChangeProperty("RIGHTNAME")) {
                sName = this.getNewPropertyAsString("RIGHTNAME");
            }
            sNameCondition = "(ObjType=" + iObjType + ") AND (RightName='" + CMyString.filterForSQL(sName) + "')" + sExtraCondition;
        }
        if (this.checkExists(sIndexCondition)) {
            throw new WCMException(1108, I18NMessage.get(RightDef.class, "RightDef.label8", "Index\u5df2\u7ecf\u5360\u7528\uff08RightDef.isValid\uff09"));
        }
        if (this.checkExists(sNameCondition)) {
            throw new WCMException(1108, I18NMessage.get(RightDef.class, "RightDef.label9", "Name\u5df2\u7ecf\u5b58\u5728\uff08RightDef.isValid\uff09"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("SYSDEFINED") == null) {
                this.setSysDefined(false);
            }
            super.insert(_currUser);
        }
    }

    public static final RightDef findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (RightDef)BaseObj.findById(RightDef.class, _nId);
    }

    public static final RightDef createNewInstance() throws WCMException {
        return (RightDef)BaseObj.createNewInstance(RightDef.class);
    }

    public static final RightDef findByKey(Object _oKey) throws WCMException {
        return (RightDef)BaseObj.findByKey(RightDef.class, _oKey);
    }
}

