/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.listener;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;

public class MoveChannelListenerForChannel
implements IServiceListener {
    private IObjectMemberMgr m_oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");

    @Override
    public void afterServiceExecuted(ServiceListenerConfig listenerConfig, MethodContext methodContext, Object serviceResult) {
        String sSrcChannelIds = methodContext.getValue("SrcChannelIds");
        int nChannelId = methodContext.getValue("DstChannelId", 0);
        int nSiteId = methodContext.getValue("DstSiteId", 0);
        User loginUser = this.getLoginUser();
        try {
            BaseChannel dstSiteOrChannel = null;
            dstSiteOrChannel = nChannelId == 0 ? WebSite.findById(nSiteId) : Channel.findById(nChannelId);
            if (dstSiteOrChannel == null) {
                return;
            }
            Channels channels = Channels.findByIds(loginUser, sSrcChannelIds);
            for (int i = 0; i < channels.size(); ++i) {
                Channel currChnl = (Channel)channels.getAt(i);
                if (currChnl == null) continue;
                this.setPathVisible(currChnl, dstSiteOrChannel);
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    private void setPathVisible(Channel _currChnl, BaseChannel _dstSiteOrChannel) {
        try {
            WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=?", "");
            filter.addSearchValues(_currChnl.getWCMType());
            filter.addSearchValues(_currChnl.getId());
            ObjectMembers objectMembers = ObjectMembers.openWCMObjs(this.getLoginUser(), filter);
            if (objectMembers.isEmpty()) {
                return;
            }
            for (int i = 0; i < objectMembers.size(); ++i) {
                ObjectMember currObjMember = (ObjectMember)objectMembers.getAt(i);
                if (currObjMember == null || !currObjMember.isVisible()) continue;
                BaseChannel parent = _dstSiteOrChannel;
                do {
                    this.addVisible(currObjMember.getMemberType(), currObjMember.getMemberId(), parent.getWCMType(), parent.getId());
                } while (!parent.isSite() && (parent = parent.getHost()) != null);
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    private void addVisible(int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        CMSObj _oOperator = (CMSObj)BaseObj.findById(_nMemberType, _nMemberId);
        if (this.m_oObjectMemberMgr.isVisible(_oOperator, _nObjType, _nObjId)) {
            return;
        }
        User user = this.getLoginUser();
        ObjectMember oObjectMember = this.m_oObjectMemberMgr.getObjectMember(_nMemberType, _nMemberId, _nObjType, _nObjId);
        if (oObjectMember != null) {
            oObjectMember.setVisible(true);
            oObjectMember.save(user);
        } else {
            oObjectMember = ObjectMember.createNewInstance();
            oObjectMember.setMemberType(_nMemberType);
            oObjectMember.setMemberId(_nMemberId);
            oObjectMember.setObjType(_nObjType);
            oObjectMember.setObjId(_nObjId);
            oObjectMember.setVisible(true);
            oObjectMember.insert(this.getLoginUser());
        }
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }
}

