/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ParameterError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.database.TableInfo;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.AuthError;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMAJAXServiceHelper {
    private static Logger logger = Logger.getLogger(WCMAJAXServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMSObj setWCMObjectProperties(User _loginUser, MethodContext _methodContext, CMSObj _oCMSObj, String[] _pLogicFields) throws WCMException {
        if (!_oCMSObj.isAddMode() && !_oCMSObj.canEdit(_loginUser)) {
            throw new AuthError("\u5bf9\u8c61[" + _oCMSObj + "]\u88ab\u5176\u5b83\u7528\u6237[" + _oCMSObj.getLockerUserName() + "]\u9501\u5b9a\uff0c\u4e0d\u80fd\u88ab\u4fee\u6539\uff01");
        }
        boolean bSuccess = false;
        try {
            TableInfo currTableInfo = DBManager.getDBManager().getTableInfo(_oCMSObj.getDbTableName());
            Iterator params = _methodContext.getParams().keySet().iterator();
            String sParamValue = null;
            while (params.hasNext()) {
                String sParamName = (String)params.next();
                if (sParamName.equalsIgnoreCase(_oCMSObj.getIdFieldName()) || WCMAJAXServiceHelper.isContainsStr(_pLogicFields, sParamName)) continue;
                if (currTableInfo.getFieldInfo(sParamName) == null) {
                    logger.warn((Object)(I18NMessage.get(WCMAJAXServiceHelper.class, "WCMAJAXServiceHelper.label4", "\u66f4\u65b0\u5bf9\u8c61[") + _oCMSObj + I18NMessage.get(WCMAJAXServiceHelper.class, "WCMAJAXServiceHelper.label5", "]\u65f6\u5019\uff0c\u7531\u4e8e\u5b57\u6bb5[") + sParamName + I18NMessage.get(WCMAJAXServiceHelper.class, "WCMAJAXServiceHelper.label6", "]\u5728\u8868[") + _oCMSObj.getDbTableName() + I18NMessage.get(WCMAJAXServiceHelper.class, "WCMAJAXServiceHelper.label7", "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u6570\u636e\uff01")));
                    continue;
                }
                sParamValue = _methodContext.getValue(sParamName);
                if (!_oCMSObj.isAddMode() && "attribute".equals(sParamName.toLowerCase())) {
                    AttributesString oldattrs = _oCMSObj.getAttributesString();
                    AttributesString newattrs = new AttributesString(sParamValue);
                    List arNames = newattrs.getNameList();
                    int nSize = arNames.size();
                    for (int i = 0; i < nSize; ++i) {
                        String sName = (String)arNames.get(i);
                        oldattrs.putAttributeValue(sName, newattrs.getAttributeValue(sName));
                    }
                    sParamValue = oldattrs.getAttributes();
                }
                _oCMSObj.setPropertyWithString(sParamName, sParamValue);
            }
            bSuccess = true;
        }
        finally {
            if (!bSuccess) {
                _oCMSObj.cancelUpdate(_loginUser);
            }
        }
        return _oCMSObj;
    }

    private static boolean isContainsStr(String[] _pSearchStr, String _sContainsStr) {
        if (_pSearchStr == null) {
            return false;
        }
        for (int i = 0; i < _pSearchStr.length; ++i) {
            if (!_sContainsStr.equalsIgnoreCase(_pSearchStr[i])) continue;
            return true;
        }
        return false;
    }

    public static void validateFile(String _sImportFile) throws WCMException {
        String sFilePath;
        if (_sImportFile == null) {
            return;
        }
        if (!CMyFile.fileExists(_sImportFile) && !CMyFile.fileExists((sFilePath = FilesMan.getFilesMan().mapFilePath(_sImportFile, 0)) + _sImportFile)) {
            throw new WCMException(I18NMessage.get(WCMAJAXServiceHelper.class, "WCMAJAXServiceHelper.label8", "\u6307\u5b9a\u7684\u6587\u4ef6[") + _sImportFile + I18NMessage.get(WCMAJAXServiceHelper.class, "WCMAJAXServiceHelper.label9", "]\u5728\u670d\u52a1\u5668\u4e2d\u4e0d\u5b58\u5728\uff01"));
        }
    }

    public static BaseChannel makeHost(MethodContext methodContext) throws ParameterError, WCMException {
        return WCMAJAXServiceHelper.makeHost(methodContext, false);
    }

    public static BaseChannel makeHost(MethodContext methodContext, boolean allowEmptyHost) throws ParameterError, WCMException {
        BaseChannel oSiteOrChannel;
        int nSiteId = methodContext.getValue("SITEID", 0);
        int nChannelId = methodContext.getValue("CHANNELID", 0);
        if (nSiteId <= 0 && nChannelId <= 0) {
            if (allowEmptyHost) {
                return WebSite.createNewInstance();
            }
            throw new ParameterError("\u6ca1\u6709\u6307\u5b9aChannelId\u6216\u8005SiteId");
        }
        if (nChannelId > 0) {
            oSiteOrChannel = Channel.findById(nChannelId);
            if (oSiteOrChannel == null) {
                throw new ParameterError("\u680f\u76eeID[" + nChannelId + "]\u65e0\u6548\uff01");
            }
        } else {
            oSiteOrChannel = WebSite.findById(nSiteId);
            if (oSiteOrChannel == null) {
                throw new ParameterError("\u7ad9\u70b9ID[" + nSiteId + "]\u65e0\u6548\uff01");
            }
        }
        return oSiteOrChannel;
    }
}

