/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.JobScheduleServer;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import com.trs.service.IScheduleService;

public class ScheduleService
implements IScheduleService {
    @Override
    public Schedule savePublishSchedule(Schedule _currSchedule, BaseChannel _currChannel) throws WCMException {
        return this.saveSchedule(_currSchedule, _currChannel, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label1", "\u7ad9\u70b9\u6216\u9891\u9053"), 17);
    }

    @Override
    public Schedule deletePublishSchedule(BaseChannel _currChannel) throws WCMException {
        return this.deleteSchedule(_currChannel, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label1", "\u7ad9\u70b9\u6216\u9891\u9053"), 17);
    }

    @Override
    public Schedule findPublishSchedule(BaseChannel _currChannel) throws WCMException {
        return this.findSchedule(this.findPublishWorker(), _currChannel, I18NMessage.get(ScheduleService.class, "ScheduleService.label1", "\u7ad9\u70b9\u6216\u9891\u9053"));
    }

    @Override
    public Schedule savePublishSchedule(Schedule _currSchedule, Document _currDocument) throws WCMException {
        return this.saveSchedule(_currSchedule, _currDocument, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label2", "\u6587\u6863"), 39);
    }

    @Override
    public Schedule deletePublishSchedule(Document _currDocument) throws WCMException {
        return this.deleteSchedule(_currDocument, this.findPublishWorker(), I18NMessage.get(ScheduleService.class, "ScheduleService.label2", "\u6587\u6863"), 39);
    }

    @Override
    public Schedule findPublishSchedule(Document _currDocument) throws WCMException {
        return this.findSchedule(this.findPublishWorker(), _currDocument, I18NMessage.get(ScheduleService.class, "ScheduleService.label2", "\u6587\u6863"));
    }

    @Override
    public void delete(String scheduleIds) throws WCMException {
        Schedules currSchedules = Schedules.findByIds(this.getLoginUser(), scheduleIds);
        if (currSchedules != null) {
            currSchedules.removeAll(true);
        }
    }

    private Schedule saveSchedule(Schedule _currSchedule, CMSObj _currObj, JobWorkerType _currWorker, String _sObjDesc, int _nRightIndex) throws WCMException {
        String sOperDesc = CMyString.format(I18NMessage.get(ScheduleService.class, "ScheduleService.label15", "\u8bbe\u7f6e{0}\u7684{1}"), new Object[]{_currObj, _currWorker.getDesc()});
        if (_currSchedule == null || _currObj == null) {
            throw new WCMException(sOperDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a") + _sObjDesc + "\uff01");
        }
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), _currObj, _nRightIndex)) {
            throw new WCMException(sOperDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label5", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "SCHEDULE_SAVE", sOperDesc, _currObj);
        try {
            Schedule aSchedule = JobScheduleServer.saveSchedule(_currWorker, _currSchedule, _currObj);
            LogServer.endRecordSucceedOperation(lStartTime);
            return aSchedule;
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sOperDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label6", "\u5931\u8d25!"), e);
        }
    }

    private Schedule deleteSchedule(CMSObj _currChannel, JobWorkerType _currWorkerType, String _sObjDesc, int _nRightIndex) throws WCMException {
        String sDesc = CMyString.format(I18NMessage.get(ScheduleService.class, "ScheduleService.label14", "\u5220\u9664{0}\u7684{1}"), new Object[]{_currChannel, _currWorkerType.getDesc()});
        if (_currChannel == null) {
            throw new WCMException(sDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label4", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a") + _sObjDesc + "\uff01");
        }
        if (!AuthServer.hasRight(ContextHelper.getLoginUser(), _currChannel, _nRightIndex)) {
            throw new WCMException(sDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label5", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "SCHEDULE_DELETE", sDesc, _currChannel);
        try {
            Schedule aSchedule = JobScheduleServer.deleteSchedule(_currWorkerType, _currChannel);
            LogServer.endRecordSucceedOperation(lStartTime);
            return aSchedule;
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(sDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label6", "\u5931\u8d25!"), e);
        }
    }

    private Schedule findSchedule(JobWorkerType _currWorkerType, CMSObj _currChannel, String _sObjDesc) throws WCMException {
        String sDesc = I18NMessage.get(ScheduleService.class, "ScheduleService.label9", "\u83b7\u53d6") + _currChannel + I18NMessage.get(ScheduleService.class, "ScheduleService.label10", "\u7684\u8ba1\u5212\u53d1\u5e03");
        if (_currChannel == null) {
            throw new WCMException(sDesc + I18NMessage.get(ScheduleService.class, "ScheduleService.label11", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u7684") + _sObjDesc + "\uff01");
        }
        return JobScheduleServer.findSchedule(_currWorkerType, _currChannel);
    }

    private JobWorkerType findPublishWorker() throws WCMException {
        return this.findWorkerById(4);
    }

    private JobWorkerType findWorkerById(int _nWorkerId) throws WCMException {
        JobWorkerType currWorker = JobWorkerType.findById(_nWorkerId);
        if (currWorker == null) {
            throw new WCMException(I18NMessage.get(ScheduleService.class, "ScheduleService.label12", "\u7cfb\u7edf\u914d\u7f6e\u9519\u8bef\uff01\u627e\u4e0d\u5230Id\u4e3a[") + _nWorkerId + I18NMessage.get(ScheduleService.class, "ScheduleService.label13", "]\u7684Worker\uff01"));
        }
        return currWorker;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }
}

