/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.Parameter;
import org.dom4j.Element;

public class PageParameter
extends Parameter {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_DATETIME = "datetime";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final int TYPE_STRING_HASHCODE = -891985903;
    public static final int TYPE_INT_HASHCODE = 104431;
    public static final int TYPE_LONG_HASHCODE = 3327612;
    public static final int TYPE_FLOAT_HASHCODE = 97526364;
    public static final int TYPE_DOUBLE_HASHCODE = -1325958191;
    public static final int TYPE_DATE_HASHCODE = 3076014;
    public static final int TYPE_TIME_HASHCODE = 3560141;
    public static final int TYPE_DATETIME_HASHCODE = 1793702779;
    public static final int TYPE_BOOLEAN_HASHCODE = 64711720;
    public static final String[] TYPES_SUPPORTED = new String[]{"string", "int", "long", "float", "double", "date", "time", "datetime", "boolean"};
    private String m_sName;
    private String m_sDesc;
    private boolean m_bRequired;
    private String m_sType;
    private String m_sDefault;
    private int m_nMaxLength = -1;
    private int m_nMinLength = -1;
    private String m_sMaxValue;
    private String m_sMinValue;
    private boolean m_bSearch;
    private String m_sSearchOperator;
    private String m_sSearchField;
    private String m_sSearchType;
    private String m_sExcludeValue;

    public boolean isRequired() {
        return this.m_bRequired;
    }

    public void setRequired(boolean required) {
        this.m_bRequired = required;
    }

    public String getType() {
        if (this.m_sType == null) {
            return TYPE_STRING;
        }
        return this.m_sType;
    }

    public void setType(String _sType) throws WCMException {
        if (!this.isSupportedType(_sType)) {
            throw new WCMException(10, I18NMessage.get(PageParameter.class, "PageParameter.label1", "\u7c7b\u578b[") + _sType + I18NMessage.get(PageParameter.class, "PageParameter.label2", "]\u65e0\u6548!"));
        }
        this.m_sType = _sType.toLowerCase();
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String desc) {
        this.m_sDesc = desc;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public int getMaxLength() {
        return this.m_nMaxLength;
    }

    public void setMaxLength(int maxLength) {
        this.m_nMaxLength = maxLength;
    }

    public int getMinLength() {
        return this.m_nMinLength;
    }

    public void setMinLength(int minLength) {
        this.m_nMinLength = minLength;
    }

    public String getDefault() {
        return this.m_sDefault;
    }

    public int getDefaultAsInt(int _nDefaultValue) throws WCMException {
        if (this.getDefault() == null) {
            return _nDefaultValue;
        }
        try {
            return Integer.parseInt(this.getDefault());
        }
        catch (Exception ex) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label5", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6574\u578b!"), ex);
        }
    }

    public long getDefaultAsLong(long _lDefaultValue) throws WCMException {
        if (this.getDefault() == null) {
            return _lDefaultValue;
        }
        try {
            return Long.parseLong(this.getDefault());
        }
        catch (Exception ex) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label6", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u957f\u6574\u578b!"), ex);
        }
    }

    public float getDefaultAsFloat(float _fDefaultValue) throws WCMException {
        if (this.getDefault() == null) {
            return _fDefaultValue;
        }
        try {
            return Float.parseFloat(this.getDefault());
        }
        catch (Exception ex) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label7", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6d6e\u70b9\u6570!"), ex);
        }
    }

    public boolean getDefaultAsBoolean(boolean _bDefaultValue) throws WCMException {
        if (this.getDefault() == null) {
            return _bDefaultValue;
        }
        if ("true".equals(this.getDefault())) {
            return true;
        }
        if ("false".equals(this.getDefault())) {
            return true;
        }
        try {
            return this.getDefaultAsInt(0) == 1;
        }
        catch (Exception ex) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label8", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u5e03\u5c14\u578b!"), ex);
        }
    }

    public double getDefaultAsDouble(double _dDefaultValue) throws WCMException {
        if (this.getDefault() == null) {
            return _dDefaultValue;
        }
        try {
            return Double.parseDouble(this.getDefault());
        }
        catch (Exception ex) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label9", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u53cc\u7cbe\u5ea6\u6570!"), ex);
        }
    }

    public CMyDateTime getDefaultAsDateTime() throws WCMException {
        if (this.getDefault() == null) {
            return null;
        }
        try {
            CMyDateTime dtTemp = new CMyDateTime();
            dtTemp.setDateTimeWithString(this.getDefault());
            return dtTemp;
        }
        catch (Exception ex) {
            throw new WCMException(2, CMyString.format(I18NMessage.get(PageParameter.class, "PageParameter.label3", "\u53c2\u6570[{0}]\u7684\u9ed8\u8ba4\u503c[{1}]"), new String[]{this.getName(), this.getDefault()}) + I18NMessage.get(PageParameter.class, "PageParameter.label10", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65f6\u95f4\u7c7b\u578b!"), ex);
        }
    }

    public void setDefault(String default1) {
        this.m_sDefault = default1;
    }

    public String getMaxValue() {
        return this.m_sMaxValue;
    }

    public void setMaxValue(String maxValue) {
        this.m_sMaxValue = maxValue;
    }

    public String getMinValue() {
        return this.m_sMinValue;
    }

    public void setMinValue(String minValue) {
        this.m_sMinValue = minValue;
    }

    @Override
    protected void validXMLElement(Element _element) throws WCMException {
        String sName = _element.attributeValue("name");
        if (sName == null || (sName = sName.trim()).length() <= 0) {
            throw new WCMException(10, I18NMessage.get(PageParameter.class, "PageParameter.label11", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aName\u5c5e\u6027!"));
        }
        String sDesc = _element.attributeValue("desc");
        if (sDesc == null || (sDesc = sDesc.trim()).length() <= 0) {
            throw new WCMException(10, I18NMessage.get(PageParameter.class, "PageParameter.label12", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aDesc\u5c5e\u6027!"));
        }
    }

    @Override
    public boolean fromXML(Element _element) throws WCMException {
        super.fromXML(_element);
        this.setDefault(this.getPropertyAsString("default"));
        this.setName(this.getPropertyAsString("name"));
        this.setDesc(this.getPropertyAsString("desc"));
        this.setType(this.getPropertyAsString("type"));
        this.setRequired("true".equals(this.getPropertyAsString("required")));
        this.setMaxLength(this.getPropertyAsInt("max-length", -1));
        this.setMinLength(this.getPropertyAsInt("min-length", -1));
        this.setMaxValue(this.getPropertyAsString("max-value"));
        this.setMinValue(this.getPropertyAsString("min-value"));
        this.setSearch("true".equals(this.getPropertyAsString("search")));
        this.setSearchOperator(this.getPropertyAsString("search-operator"));
        this.setSearchField(this.getPropertyAsString("search-field"));
        this.setSearchType(this.getPropertyAsString("search-type"));
        this.setExcludeValue(this.getPropertyAsString("exclude-value"));
        return true;
    }

    public static PageParameter createPageParameterFromXML(Element _elParameter) throws WCMException {
        PageParameter newPageParameter = new PageParameter();
        newPageParameter.fromXML(_elParameter);
        return newPageParameter;
    }

    private boolean isSupportedType(String _sType) {
        for (int i = 0; i < TYPES_SUPPORTED.length; ++i) {
            if (!TYPES_SUPPORTED[i].equals(_sType)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearch() {
        return this.m_bSearch;
    }

    public void setSearch(boolean search) {
        this.m_bSearch = search;
    }

    public String getSearchOperator() {
        return this.m_sSearchOperator;
    }

    public void setSearchOperator(String searchOperator) {
        this.m_sSearchOperator = searchOperator;
    }

    public static void main(String[] args) {
        for (int i = 0; i < TYPES_SUPPORTED.length; ++i) {
            String type = TYPES_SUPPORTED[i];
            System.out.println(type + ".hashCode:" + type.hashCode());
        }
    }

    public String getSearchField() {
        return this.m_sSearchField;
    }

    public void setSearchField(String searchField) {
        this.m_sSearchField = searchField;
    }

    public String getSearchType() {
        return this.m_sSearchType;
    }

    public void setSearchType(String searchType) {
        this.m_sSearchType = searchType;
    }

    public String getExcludeValue() {
        return this.m_sExcludeValue;
    }

    public void setExcludeValue(String excludeValue) {
        this.m_sExcludeValue = excludeValue;
    }
}

