/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClusterDBIdManager {
    private static Logger logger = Logger.getLogger(ClusterDBIdManager.class);
    private static final Map LOCKS = new HashMap(100, 0.2f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNextId(String tablename, String idFieldName) throws WCMException {
        int n;
        DBManager dbmanager;
        Connection conn;
        block21: {
            conn = null;
            Statement pstmt = null;
            tablename = tablename.toUpperCase();
            idFieldName = idFieldName.toUpperCase();
            dbmanager = DBManager.getDBManager();
            String sql = "select NEXTID from WCMID where TABLENAME=?";
            int id = 0;
            try {
                Map map;
                Object lock = LOCKS.get(tablename);
                if (lock == null) {
                    map = LOCKS;
                    synchronized (map) {
                        lock = LOCKS.get(tablename);
                        if (lock == null) {
                            lock = new byte[0];
                            LOCKS.put(tablename, lock);
                        }
                    }
                }
                map = lock;
                synchronized (map) {
                    conn = dbmanager.getConnection();
                    pstmt = conn.prepareStatement(sql);
                    int nMaxTryTimes = 5;
                    int nCurrTryTimes = 0;
                    while (id == 0) {
                        id = ClusterDBIdManager.getNextId0(conn, (PreparedStatement)pstmt, tablename, idFieldName);
                        if (++nCurrTryTimes < nMaxTryTimes) continue;
                        throw new WCMException("max times[" + nMaxTryTimes + "] arrived.");
                    }
                    n = id;
                    if (pstmt == null) break block21;
                }
            }
            catch (Throwable throwable) {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn == null) throw throwable;
                try {
                    dbmanager.freeConnection(conn);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                catch (Exception ex) {
                    throw new WCMException(40, "fail to get avaliable object id", ex);
                }
            }
            try {
                pstmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (conn == null) return n;
        try {
            dbmanager.freeConnection(conn);
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextId0(Connection conn, PreparedStatement pstmt4Sel, String tableName, String idFieldName) {
        int nextId = 0;
        ResultSet rs = null;
        Statement pstmt4Upd = null;
        Statement pstmt4Insert = null;
        try {
            pstmt4Sel.setString(1, tableName);
            rs = pstmt4Sel.executeQuery();
            if (rs.next()) {
                int maxTableId;
                nextId = rs.getInt(1);
                if (nextId <= (maxTableId = ClusterDBIdManager.getMaxTableId(conn, tableName, idFieldName))) {
                    nextId = maxTableId + 1;
                }
                String sql = "update WCMID set NEXTID=? where TABLENAME=? and IDFIELDNAME=?";
                pstmt4Upd = conn.prepareStatement(sql);
                pstmt4Upd.setInt(1, nextId + 1);
                pstmt4Upd.setString(2, tableName);
                pstmt4Upd.setString(3, idFieldName);
                int result = pstmt4Upd.executeUpdate();
                if (result != 1) {
                    nextId = 0;
                }
            } else {
                nextId = ClusterDBIdManager.getMaxTableId(conn, tableName, idFieldName) + 1;
                String sql = "insert into WCMID(TABLENAME,NEXTID,CACHESIZE,IDFIELDNAME) values(?,?,?,?)";
                pstmt4Insert = conn.prepareStatement(sql);
                pstmt4Insert.setString(1, tableName);
                pstmt4Insert.setInt(2, nextId + 1);
                pstmt4Insert.setInt(3, 1);
                pstmt4Insert.setString(4, idFieldName);
                int result = pstmt4Insert.executeUpdate();
                if (result != 1) {
                    nextId = 0;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("\u83b7\u53d6\u4e0b\u4e00\u4e2aID[tablename:" + tableName + ",idFieldName:" + idFieldName + "]\u51fa\u73b0\u5f02\u5e38"), (Throwable)ex);
            nextId = 0;
        }
        finally {
            if (pstmt4Upd != null) {
                try {
                    pstmt4Upd.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt4Insert != null) {
                try {
                    pstmt4Insert.close();
                }
                catch (Exception exception) {}
            }
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaxTableId(Connection conn, String tableName, String idFieldName) throws SQLException {
        Statement oStmt = null;
        ResultSet rsMax = null;
        try {
            String sql = "select MAX(" + idFieldName + ") from " + tableName;
            oStmt = conn.createStatement();
            rsMax = oStmt.executeQuery(sql);
            int maxId = rsMax.next() ? rsMax.getInt(1) : 0;
            rsMax.close();
            rsMax = null;
            int n = maxId;
            return n;
        }
        finally {
            if (rsMax != null) {
                try {
                    rsMax.close();
                }
                catch (Exception e) {
                    logger.error((Object)"ERROR-", (Throwable)e);
                }
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception e) {
                    logger.error((Object)"ERROR-", (Throwable)e);
                }
            }
        }
    }
}

