/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.ConnectionPool;
import com.trs.infra.util.database.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class MyDBManager {
    ConnectionPool m_oDBPool = null;
    public DBConnectionConfig dbConfig = null;
    DBType m_oCurrDBType = null;

    public MyDBManager(String _sSrcName, String _sURL, String _sUserName, String _sPassword, Class _dbTypeClass) throws Exception {
        this.m_oCurrDBType = (DBType)_dbTypeClass.newInstance();
        this.connect(_sSrcName, _sURL, _sUserName, _sPassword, _dbTypeClass.getName());
    }

    public DBType getDbType() {
        return this.m_oCurrDBType;
    }

    public String getSrcNameOfDB() {
        return this.dbConfig.getName();
    }

    private void connect(String _sSrcName, String _sURL, String _sUserName, String _sPassword, String _sClassName) throws Exception {
        if (this.m_oDBPool != null) {
            return;
        }
        this.dbConfig = this.makeDBConfig(_sURL, _sUserName, _sPassword, _sClassName);
        this.dbConfig.setName(_sSrcName);
        try {
            this.m_oDBPool = new ConnectionPool(this.dbConfig);
        }
        catch (SQLException ex) {
            throw new WCMException(41, "\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\uff1a" + this.dbConfig, ex);
        }
    }

    private DBConnectionConfig makeDBConfig(String _sURL, String _sUserName, String _sPassword, String _sClassName) {
        DBManager dbMgr = DBManager.getDBManager();
        DBConnectionConfig currDBConfig = dbMgr.getDBConnConfig();
        DBConnectionConfig dbConfig = new DBConnectionConfig();
        dbConfig.setConnectionURL(_sURL);
        dbConfig.setConnectionUser(_sUserName);
        dbConfig.setConnectionPassword(_sPassword);
        dbConfig.setClassName(_sClassName);
        dbConfig.setCacheScheme(currDBConfig.getCacheScheme());
        dbConfig.setDowithClob(currDBConfig.isDowithClob());
        dbConfig.setTimeToLiveOverUse(currDBConfig.getTimeToLiveOverUse());
        dbConfig.setMonitorInterval(currDBConfig.getMonitorInterval());
        dbConfig.setInitConnects(5);
        dbConfig.setMaxConnects(20);
        return dbConfig;
    }

    public Connection getConnection() throws Exception {
        if (this.m_oDBPool == null) {
            throw new Exception("Please connect db\uff01");
        }
        Connection oConn = null;
        try {
            oConn = this.m_oDBPool.getConnection();
        }
        catch (Exception ex) {
            throw new WCMException(41, "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u5931\u8d25(Application.getConnection)", ex);
        }
        if (oConn == null) {
            throw new WCMException(41, "\u6ca1\u6709\u627e\u5230\u6709\u6548\u53ef\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5(Application.getConnection)");
        }
        return oConn;
    }

    public void freeConnection(Connection _oConn) {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.free(_oConn);
    }

    public void close() {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.close();
        this.m_oDBPool = null;
    }

    public DBType getDBType() {
        return this.dbConfig.getDBType();
    }

    public void setParameters(PreparedStatement _oPreStmt, List listSearchValues) throws WCMException {
        if (_oPreStmt == null || listSearchValues == null || listSearchValues.size() <= 0) {
            return;
        }
        DBType currDbType = this.getDBType();
        Object value = null;
        int i = 0;
        try {
            int nSize = listSearchValues.size();
            for (i = 0; i < nSize; ++i) {
                value = listSearchValues.get(i);
                if (value == null) continue;
                if (value instanceof Long) {
                    _oPreStmt.setLong(i + 1, (Long)value);
                    continue;
                }
                if (value instanceof Float) {
                    _oPreStmt.setFloat(i + 1, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    _oPreStmt.setDouble(i + 1, (Double)value);
                    continue;
                }
                if (value instanceof Integer) {
                    _oPreStmt.setInt(i + 1, (Integer)value);
                    continue;
                }
                if (value instanceof String) {
                    currDbType.setStringFieldValue(_oPreStmt, i + 1, value);
                    continue;
                }
                if (value instanceof CMyDateTime) {
                    _oPreStmt.setTimestamp(i + 1, ((CMyDateTime)value).toTimestamp());
                    continue;
                }
                if (value instanceof CDBText) {
                    _oPreStmt.setString(i + 1, ((CDBText)value).getText());
                    continue;
                }
                throw new WCMException(1103, "\u672a\u77e5\u7684\u5bf9\u8c61" + (i + 1) + "\u5c5e\u6027\u7c7b\u578b");
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570[Index=" + (i + 1) + ", value=" + value + "]\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570[Index=" + (i + 1) + ", value=" + value + "]\u65f6\u51fa\u9519", ex);
        }
    }

    public String sqlExecuteQueryString(String _sSQL, List _lParameters) throws WCMException {
        Object oValue = this.sqlExecuteQuery(_sSQL, _lParameters);
        if (oValue == null) {
            return null;
        }
        return oValue.toString();
    }

    public int sqlExecuteQueryInt(String _sSQL, List _lParameters) throws WCMException {
        Object oValue = this.sqlExecuteQuery(_sSQL, _lParameters);
        if (oValue == null) {
            return -999;
        }
        return ((Number)oValue).intValue();
    }

    public Object sqlExecuteQuery(String _sSQL, List _lParameters) throws WCMException {
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        try {
            oConn = this.getConnection();
            oStmt = oConn.prepareStatement(_sSQL);
            oStmt.setMaxRows(1);
            this.setParameters(oStmt, _lParameters);
            rsData = oStmt.executeQuery();
            if (rsData.next()) {
                Object object = rsData.getObject(1);
                return object;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + _sSQL, ex);
        }
        finally {
            try {
                if (oConn != null) {
                    this.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

