/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;

public class TagWmlContentParser
implements ITagParser {
    private static final String DEF_SEP = "--sep--";
    private static final int DEF_PAGINGNUM = 900;
    private static final String NAV_VAR = "${OUTLINE_NAV}";
    private static TagBeanInfo s_TagBeanInfo;

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_WMLCONTENT");
            tbi.setDesc("wml\u5185\u5bb9\u53d1\u5e03");
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("PAGENUM");
            tbai.setDesc("\u5206\u9875\u5b57\u6570");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAVBYNUM");
            tbai.setDesc("\u4ee5\u6570\u5b57\u65b9\u5f0f\u5206\u9875");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MANUALSEP");
            tbai.setDesc("\u624b\u5de5\u5206\u9875\u7684\u5206\u9694\u6807\u8bb0");
            tbai.setDefaultValue(DEF_SEP);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_self");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AIDPREFIX");
            tbai.setDesc("\u94fe\u63a5id\u524d\u7f00");
            tbai.setDefaultValue("pagenav");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SHOWPRENEXT");
            tbai.setDesc("\u663e\u793a\u4e0a\u4e00\u9875,\u4e0b\u4e00\u9875");
            tbai.setDefaultValue("true");
            tbai.setRequired(false);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SHOWHEADTAIL");
            tbai.setDesc("\u663e\u793a\u9996\u9875,\u5c3e\u9875");
            tbai.setDefaultValue("false");
            tbai.setRequired(false);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAVPAGES");
            tbai.setDesc("\u5206\u9875\u94fe\u63a5\u5206\u7ec4\u6570\u76ee");
            tbai.setDefaultValue("5");
            tbai.setRequired(false);
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAVBEGIN");
            tbai.setDesc("\u94fe\u63a5\u5f00\u59cb\u5bb9\u5668");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAVEND");
            tbai.setDesc("\u94fe\u63a5\u5bb9\u5668\u7ed3\u675f");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setDesc("\u662f\u5426\u683c\u5f0f\u5316\u6587\u672c");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setDesc("\u6587\u672c\u683c\u5f0f\u5316\u7684\u7c7b\u578b");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String content;
        IPublishElement element = _context.getPageElement();
        if (!(element instanceof IPublishContent)) {
            throw new IllegalArgumentException("\u53ea\u80fd\u7528\u5728\u7ec6\u89c8\u4e0a.");
        }
        String field = _context.getAttribute("FIELD");
        if (field == null) {
            field = "DOCCONTENT";
        }
        if ((content = this.getContent(element.getSubstance(), field)) == null) {
            return null;
        }
        String fn = PublishPathCompass.makeDetailPageFileName((IPublishContent)element);
        String fext = _context.getPageContext().getTemplate().getOutputFileExt();
        return this.parseText(_context, content, fn, fext);
    }

    protected String getContent(CMSObj substance, String field) {
        return substance.getPropertyAsString(field);
    }

    private String[] parseText(PublishTagContext context, String content, String fn, String fext) throws WCMException {
        String navend;
        ArrayList<String> list = new ArrayList<String>(5);
        StringBuffer buff = new StringBuffer(1024);
        int nPageIndex = 0;
        int nImgCount = 0;
        try {
            String temp = context.getPageContext().getExtraAttribute("PAGVAR_WMLIMGCOUNT");
            nImgCount = Integer.parseInt(temp) - 1;
        }
        catch (Exception temp) {
            // empty catch block
        }
        boolean zNavByNum = "true".equals(context.getAttribute("NAVBYNUM"));
        String sep = context.getAttribute("");
        if (sep == null) {
            sep = DEF_SEP;
        }
        String[] contents = content.split(sep);
        String navbegin = context.getAttribute("NAVBEGIN");
        if (navbegin == null) {
            navbegin = "";
        }
        if ((navend = context.getAttribute("NAVEND")) == null) {
            navend = "";
        }
        if (contents.length > 1) {
            int len = contents.length;
            for (int i = 0; i < len; ++i) {
                buff.append(TagParseHelper.formatTextIfNeeded(context, contents[i]));
                buff.append(navbegin);
                if (zNavByNum) {
                    buff.append(NAV_VAR);
                } else {
                    buff.append(TagWmlContentParser.makeNav(fn, fext, nPageIndex, i < len - 1 || nImgCount > nPageIndex));
                }
                buff.append(navend);
                list.add(buff.toString());
                buff.setLength(0);
                ++nPageIndex;
            }
        } else {
            int nMaxNum = context.getAttribute("PAGENUM", 900);
            int nEnLen = 1;
            int nChLen = 3;
            int nCurrLen = 0;
            int nGet = 0;
            String temp = null;
            char[] chars = content.toCharArray();
            char ch2 = '\u0000';
            for (char ch2 : chars) {
                int n = nCurrLen = ch2 <= '\u007f' ? nEnLen : nChLen;
                if ((nGet += nCurrLen) > nMaxNum) {
                    temp = TagParseHelper.formatTextIfNeeded(context, buff.toString());
                    buff.setLength(0);
                    buff.append(temp);
                    buff.append(navbegin);
                    if (zNavByNum) {
                        buff.append(NAV_VAR);
                    } else {
                        buff.append(TagWmlContentParser.makeNav(fn, fext, nPageIndex, true));
                    }
                    buff.append(navend);
                    list.add(buff.toString());
                    buff.setLength(0);
                    ++nPageIndex;
                    nGet = nCurrLen;
                }
                buff.append(ch2);
            }
            if (buff.length() > 0) {
                temp = TagParseHelper.formatTextIfNeeded(context, buff.toString());
                buff.setLength(0);
                buff.append(temp);
                if (nPageIndex > 0 || nImgCount > nPageIndex) {
                    buff.append(navbegin);
                    if (zNavByNum) {
                        buff.append(NAV_VAR);
                    } else {
                        buff.append(TagWmlContentParser.makeNav(fn, fext, nPageIndex, nImgCount > nPageIndex));
                    }
                    buff.append(navend);
                }
                list.add(buff.toString());
                buff.setLength(0);
            }
            buff.setLength(0);
        }
        nImgCount -= nPageIndex;
        while (--nImgCount >= 0) {
            buff.append(navbegin);
            if (zNavByNum) {
                buff.append(NAV_VAR);
                ++nPageIndex;
            } else {
                buff.append(TagWmlContentParser.makeNav(fn, fext, ++nPageIndex, nImgCount > 0));
            }
            buff.append(navend);
            list.add(buff.toString());
            buff.setLength(0);
        }
        if (zNavByNum) {
            this.setNavVar(context);
        }
        String[] result = new String[list.size()];
        result = list.toArray(result);
        return result;
    }

    private void setNavVar(PublishTagContext _context) {
        PublishPageContext pageContext = _context.getPageContext();
        String temp = _context.getAttribute("TARGET");
        if (CMyString.isEmpty(temp)) {
            temp = "_self";
        }
        pageContext.setExtraAttribute("NAV_TARGET", temp);
        temp = _context.getAttribute("AIDPREFIX");
        if (CMyString.isEmpty(temp)) {
            temp = "pagenav_";
        }
        pageContext.setExtraAttribute("NAV_IDPRE", temp);
        temp = _context.getAttribute("SHOWPRENEXT");
        if (CMyString.isEmpty(temp)) {
            temp = "true";
        }
        pageContext.setExtraAttribute("NAV_SHOWPRENEXT", temp);
        temp = _context.getAttribute("SHOWHEADTAIL");
        if (CMyString.isEmpty(temp)) {
            temp = "false";
        }
        pageContext.setExtraAttribute("NAV_SHOWHT", temp);
        temp = _context.getAttribute("NAVPAGES");
        try {
            Integer.parseInt(temp);
        }
        catch (Exception ex) {
            temp = "5";
        }
        pageContext.setExtraAttribute("NAV_PAGES", temp);
    }

    private static String makeNav(String fn, String fext, int index, boolean nextDisplayed) {
        StringBuffer buff = new StringBuffer();
        if (index > 0) {
            StringBuffer url = new StringBuffer(128);
            url.append(fn);
            if (index > 1) {
                url.append('_').append(index - 1);
            }
            url.append(".").append(fext);
            buff.append("<a href=\"");
            buff.append(url);
            buff.append("\">&lt;&lt;\u4e0a\u4e00\u9875</a>");
            buff.append("&nbsp;&nbsp;");
            url.setLength(0);
        }
        if (nextDisplayed) {
            buff.append("<a href=\"");
            buff.append(fn);
            buff.append('_');
            buff.append(index + 1);
            buff.append('.');
            buff.append(fext);
            buff.append("\">\u4e0b\u4e00\u9875&gt;&gt;</a>");
        }
        return buff.toString();
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    public void clear() {
    }
}

