/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.database.DBType;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;

public class DocumentsTemp {
    public void publishDocuments(HttpSession session, JspWriter out, int nYear, int nStartDocId) throws Exception {
        DBType dbType = DBManager.getDBManager().getDBType();
        String sStartDate = nYear + "-01-01 00:00:00";
        sStartDate = dbType.sqlDate(sStartDate);
        String sEndDate = nYear + "-12-31 23:59:59";
        sEndDate = dbType.sqlDate(sEndDate);
        String sWhere = "DocId>? and DocStatus=? and CrTime>=" + sStartDate + " and CrTime<=" + sEndDate + " and DocChannel>0";
        WCMFilter filter = new WCMFilter("", sWhere, "DocId");
        filter.addSearchValues(nStartDocId);
        filter.addSearchValues(10);
        DebugTimer timer = new DebugTimer();
        timer.start();
        Documents documents = Documents.openWCMObjs(null, filter);
        timer.stop();
        String sInfo = CMyDateTime.now() + ": \u3010" + nYear + "\u3011\u5e74\u5171\u6709\u3010" + documents.size() + "\u3011\u7bc7\u6587\u6863\u9700\u8981\u8fdb\u884c\u91cd\u65b0\u53d1\u5e03\uff01\u67e5\u8be2\u8017\u65f6\u3010" + timer.getTime() + "\u3011\u6beb\u79d2";
        out.println(sInfo + "<BR>");
        out.flush();
        session.setAttribute("ForcePublishTitle", (Object)sInfo);
        timer.start();
        PublishServer oPublishServer = PublishServer.getInstance();
        int i = 0;
        int nSize = documents.size();
        int nCount = 1;
        while (i < nSize) {
            Document document = (Document)documents.getAt(i);
            if (document != null) {
                String sSingleInfo = CMyDateTime.now() + ": \u6b63\u5728\u521b\u5efa" + document + "\u53d1\u5e03\u4efb\u52a1.......";
                session.setAttribute("ForcePublishDocumentStart", (Object)sSingleInfo);
                try {
                    IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(document);
                    content.setFolder(content.getOriginalHome());
                    oPublishServer.publishContent(content, 8);
                    sSingleInfo = CMyDateTime.now() + ": \u521b\u5efa" + document + "\u53d1\u5e03\u4efb\u52a1\u6210\u529f\uff01";
                    session.setAttribute("ForcePublishDocumentEnd", (Object)sSingleInfo);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    sSingleInfo = CMyDateTime.now() + ": \u521b\u5efa" + document + "\u53d1\u5e03\u4efb\u52a1\u5931\u8d25\uff01" + e;
                    session.setAttribute("ForcePublishDocumentEnd", (Object)sSingleInfo);
                }
                if (nCount >= 100) {
                    out.println(CMyDateTime.now() + ": \u5df2\u7ecf\u53d1\u5e03\u4e86\u3010" + (i + 1) + "\u3011\u7bc7\u6587\u6863\uff01<BR>");
                    nCount = 0;
                }
                session.setAttribute("CurrForcePublishInfo", (Object)(CMyDateTime.now() + ": \u5df2\u7ecf\u53d1\u5e03\u4e86\u3010" + (i + 1) + "\u3011\u7bc7\u6587\u6863\uff01"));
                Integer iValue = new Integer(document.getId());
                session.setAttribute("CurrForcePublishDocumentId", (Object)iValue);
            }
            ++i;
            ++nCount;
        }
        timer.stop();
        sInfo = CMyDateTime.now() + ": \u53d1\u5e03\u5b8c\u6210\uff01\u8017\u65f6\u3010" + timer.getTime() + "\u3011\u6beb\u79d2";
        out.println(sInfo + "<BR>");
        session.setAttribute("CurrForcePublishInfo", (Object)sInfo);
    }
}

