/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import org.apache.log4j.Logger;

public class WCMFolderPublishConfig
extends CMSObj {
    private static Logger logger = Logger.getLogger(WCMFolderPublishConfig.class);
    protected boolean m_bCheckPropertyValid = false;
    private boolean m_bSaveing = false;
    private Schedule m_oSchedule = null;
    private FolderPublishConfig m_oFolderPublishConfig = null;
    private BaseChannel m_oChannel = null;
    private WCMPubStatusConfig m_oStatusConfig = null;
    private IPublishFolder m_oFolder = null;
    public static final int OBJ_TYPE = 1326635776;
    public static final String DB_TABLE_NAME = "WCMFOLDERPUBLISHINFO";
    public static final String DB_ID_NAME = "FOLDERPUBLISHCONFIGID";
    private boolean m_bIsSavePublishConfig = true;
    private boolean m_bScheduleInited = false;
    private Templates m_oOutlineTemplates = null;
    private Template m_oDetailTemplate = null;
    private boolean m_bFolderPublishConfigInited = false;
    private boolean m_bWCMPubStatusConfigInited = false;

    public WCMFolderPublishConfig() {
    }

    public WCMFolderPublishConfig(IPublishFolder _folder) {
        this.m_bSaveing = false;
        try {
            this.setFolderType(_folder.getType(), _folder.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_oChannel = (BaseChannel)_folder.getSubstance();
        this.id = _folder.getId();
        this.m_oFolder = _folder;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1326635776 + this.getFolderType();
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public boolean setFolderType(int _nFolderType, int _nFolderId) throws WCMException {
        return this.setProperty("FOLDERTYPE", _nFolderType) && this.setProperty("FOLDERID", _nFolderId);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public String getOutlineFileName() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getOutlineFileName();
        }
        return this.getPropertyAsString("OUTLINEFILENAME");
    }

    public boolean setOutlineFileName(String _sOutlineFileName) throws WCMException {
        return this.setProperty("OUTLINEFILENAME", _sOutlineFileName);
    }

    public String getDetailFileExt() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getDetailFileExt();
        }
        return this.getPropertyAsString("DETAILFILEEXT");
    }

    public boolean setDetailFileExt(String _sDetailFileExt) throws WCMException {
        return this.setProperty("DETAILFILEEXT", _sDetailFileExt);
    }

    public String getDataPath() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getDataPath();
        }
        return this.getPropertyAsString("DATAPATH");
    }

    public boolean setDataPath(String _sDataPath) throws WCMException {
        return this.setProperty("DATAPATH", _sDataPath);
    }

    public String getRootDomain() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getRootDomain();
        }
        return this.getPropertyAsString("ROOTDOMAIN");
    }

    public boolean setRootDomain(String _sRootDomain) throws WCMException {
        return this.setProperty("ROOTDOMAIN", _sRootDomain);
    }

    public Templates getOutlineTemplates() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.m_oOutlineTemplates == null) {
                this.m_oOutlineTemplates = this.getTemplateEmployMgr().getOutlineTemplates(this.getFolder());
            }
            return this.m_oOutlineTemplates;
        }
        return Templates.findByIds(null, this.getPropertyAsString("OUTLINETEMPLATEID"));
    }

    public String getOutlineTemplateIds() throws WCMException {
        String templateIds = null;
        if (!this.m_bSaveing) {
            if (this.m_oOutlineTemplates == null) {
                this.m_oOutlineTemplates = this.getTemplateEmployMgr().getOutlineTemplates(this.getFolder());
            }
            templateIds = this.m_oOutlineTemplates.getIdListAsString();
            logger.debug((Object)("========getOutlineTemplateIds : from outlineTemplates cache : " + templateIds));
        } else {
            templateIds = this.getPropertyAsString("OUTLINETEMPLATEID");
            logger.debug((Object)("========getOutlineTemplateIds : from DB : " + templateIds));
        }
        return "null".equalsIgnoreCase(String.valueOf(templateIds)) ? null : templateIds;
    }

    public int getDefaultOutlineTemplateId() throws WCMException {
        Template template = this.getTemplateEmployMgr().getDefaultOutlineTemplate(this.getFolder());
        if (template == null) {
            return 0;
        }
        return template.getId();
    }

    public String getOtherOutlineTemplateIds() throws WCMException {
        Templates templats = this.getTemplateEmployMgr().getOtherOutlineTemplates(this.getFolder());
        return templats.getIdListAsString();
    }

    public boolean setOutlineTemplateId(String _sOutlineTemplateId) throws WCMException {
        return this.setProperty("OUTLINETEMPLATEID", _sOutlineTemplateId, false);
    }

    public boolean setChnlOutLineTempId(int _sChnlOutLineTempId) throws WCMException {
        return this.setProperty("CHNLOUTLINETEMPID", _sChnlOutLineTempId, false);
    }

    public Template getDetailTemplate() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.m_oDetailTemplate == null) {
                this.m_oDetailTemplate = this.getTemplateEmployMgr().getDetailTemplate(this.getFolder());
            }
            return this.m_oDetailTemplate;
        }
        return Template.findById(this.getPropertyAsInt("DETAILTEMPLATEID", 0));
    }

    public int getDetailTemplateId() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.m_oDetailTemplate == null) {
                this.m_oDetailTemplate = this.getTemplateEmployMgr().getDetailTemplate(this.getFolder());
            }
            return this.m_oDetailTemplate == null ? 0 : this.m_oDetailTemplate.getId();
        }
        return this.getPropertyAsInt("DETAILTEMPLATEID", 0);
    }

    public boolean setDetailTemplateId(int _nDetailTemplateId) throws WCMException {
        return this.setProperty("DETAILTEMPLATEID", _nDetailTemplateId);
    }

    public boolean setInfoviewPrintTemplateId(int _nInfoviewPrintTemplateId) throws WCMException {
        return this.setProperty("INFOVIEWPRINTTEMPLATEID", _nInfoviewPrintTemplateId);
    }

    public int getInfoviewPrintTemplateId() throws WCMException {
        if (!this.m_bSaveing) {
            Template aTemplate = this.getTemplateEmployMgr().getDetailTemplate(this.getFolder(), 3);
            return aTemplate == null ? 0 : aTemplate.getId();
        }
        return this.getPropertyAsInt("InfoviewPrintTemplateId", 0);
    }

    public String getStatusesCanDoPub() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.getStatusConfig() == null) {
                return "";
            }
            return this.getStatusConfig().getStatusesCanDoPub();
        }
        return this.getPropertyAsString("STATUSESCANDOPUB");
    }

    public boolean setStatusesCanDoPub(String _sStatusesCanDoPub) throws WCMException {
        return this.setProperty("STATUSESCANDOPUB", _sStatusesCanDoPub);
    }

    public int getStatusIdAfterModify() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.getStatusConfig() == null) {
                return 0;
            }
            return this.getStatusConfig().getStatusIdAfterModify();
        }
        return this.getPropertyAsInt("STATUSIDAFTERMODIFY", 0);
    }

    public boolean setStatusIdAfterModify(int _nStatusIdAfterModify) throws WCMException {
        return this.setProperty("STATUSIDAFTERMODIFY", _nStatusIdAfterModify);
    }

    public int getScheduleMode() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getMode();
        }
        return this.getPropertyAsInt("SCHEDULEMODE", 0);
    }

    public int getScheduleId() throws WCMException {
        Schedule schedule = this.getSchedule();
        return schedule == null ? 0 : schedule.getId();
    }

    public boolean setScheduleMode(int _nScheduleMode) throws WCMException {
        return this.setProperty("SCHEDULEMODE", _nScheduleMode);
    }

    public String getStartTime() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getStartTime().toString("HH:mm");
        }
        return this.getPropertyAsString("STARTTIME");
    }

    public boolean setStartTime(String _sStartTime) throws WCMException {
        return this.setProperty("STARTTIME", _sStartTime);
    }

    public String getEndTime() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getEndTime().toString("HH:mm");
        }
        return this.getPropertyAsString("ENDTIME");
    }

    public boolean setEndTime(String _sEndTime) throws WCMException {
        return this.setProperty("ENDTIME", _sEndTime);
    }

    public int getInterval() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getParam();
        }
        return this.getPropertyAsInt("INTERVAL", 0);
    }

    public boolean setInterval(int _nInterval) throws WCMException {
        return this.setProperty("INTERVAL", _nInterval);
    }

    public String getExecTime() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getExeTime().toString("HH:mm");
        }
        return this.getPropertyAsString("EXECTIME");
    }

    public boolean setExecTime(String _sExecTime) throws WCMException {
        return this.setProperty("EXECTIME", _sExecTime);
    }

    public boolean isDefineFileRule() throws WCMException {
        if (!this.m_bSaveing) {
            return this.getFolderPublishConfig() != null;
        }
        return this.getPropertyAsBoolean("DEFINEFILERULE", false);
    }

    public boolean setDefineFileRule(boolean _bDefineFileRule) throws WCMException {
        return this.setProperty("DEFINEFILERULE", _bDefineFileRule);
    }

    public boolean isDefineSchedule() throws WCMException {
        if (!this.m_bSaveing) {
            return this.getSchedule() != null;
        }
        return this.getPropertyAsBoolean("DEFINESCHEDULE", false);
    }

    public boolean setDefineSchedule(boolean _bDefineSchedule) throws WCMException {
        return this.setProperty("DEFINESCHEDULE", _bDefineSchedule);
    }

    public boolean isDefineStatus() throws WCMException {
        if (!this.m_bSaveing) {
            return this.getStatusConfig() != null;
        }
        return this.getPropertyAsBoolean("DEFINESTATUS", false);
    }

    public boolean setDefineStatus(boolean _bDefineStatus) throws WCMException {
        return this.setProperty("DEFINESTATUS", _bDefineStatus);
    }

    public boolean isResetChildrenTemplates() {
        return this.getPropertyAsBoolean("ISRESETCHILDRENTEMPLATES", false);
    }

    public boolean setIsResetChildrenTemplates(boolean _bReset) throws WCMException {
        return this.setProperty("ISRESETCHILDRENTEMPLATES", _bReset);
    }

    public int getSiteLanguage() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getSiteLanguage();
        }
        return this.getPropertyAsInt("SITELANGUAGE", 0);
    }

    public boolean setSiteLanguage(int _nSiteLanguage) throws WCMException {
        return this.setProperty("SITELANGUAGE", _nSiteLanguage);
    }

    public String getPageEncoding() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getPageEncoding();
        }
        return this.getPropertyAsString("PAGEENCODING");
    }

    public boolean setPageEncoding(String _sPageEncoding) throws WCMException {
        return this.setProperty("PAGEENCODING", _sPageEncoding);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.getProperty("DEFINEFILERULE") != null && !this.getPropertyAsBoolean("DEFINEFILERULE", false)) {
            this.setSavePublishConfig(false);
        }
        if (this.getProperty("FOLDERTYPE") == null) {
            throw new WCMException(1106, I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label1", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e(WCMFolderPublishConfig.isValid)"));
        }
        if (this.getProperty("FOLDERID") == null) {
            throw new WCMException(1106, I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e(WCMFolderPublishConfig.isValid)"));
        }
        String sDataPath = this.getFinalPropertyAsString("DATAPATH", "");
        if (sDataPath.matches("^.*[\\.\\\\//].*$")) {
            throw new WCMException("The datapath contains invalid chars [.\\/].");
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    @Override
    public void save(User _currUser) throws WCMException {
        if (this.id <= 0) {
            this.id = this.getFolderId();
        }
        if (!this.canEdit(_currUser)) {
            throw new WCMException(1012, I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label4", "\u5bf9\u8c61\u6ca1\u6709\u9501\u5b9a\u6216\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539!\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237:[") + _currUser + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label5", "] \u9501\u5b9a\u7684\u7528\u6237:[") + this.getLockerUser() + "]");
        }
        try {
            this.m_bSaveing = true;
            this.isValid();
            if (this.isSavePublishConfig()) {
                this.saveTemplateEmploys();
                this.saveFolderPublishConfig(_currUser);
                this.saveWCMPubStatusConfig(_currUser);
            }
            this.saveScheduleInfo(_currUser);
            this.m_bSaveing = false;
        }
        finally {
            this.bAddMode = false;
            if (this.isLocked() && this.getLocker(false).lockUserIs(_currUser)) {
                this.unlock();
            }
        }
    }

    @Override
    public synchronized void update(User _user) throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    @Override
    public void insert() throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    @Override
    public void save() throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    @Override
    public synchronized void update() throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    private void saveScheduleInfo(User _currUser) throws WCMException {
        if (!this.containsProperty("DEFINESCHEDULE")) {
            return;
        }
        Schedule aSchedule = this.getSchedule();
        if (!this.isDefineSchedule()) {
            if (aSchedule == null) {
                return;
            }
            aSchedule.delete(_currUser);
            return;
        }
        try {
            int nSchMode = this.getScheduleMode();
            if (aSchedule == null) {
                if (nSchMode != 0) {
                    this.m_oSchedule = this.saveScheduleInfo(_currUser, Schedule.createNewInstance(), nSchMode, this.getStartTime(), this.getEndTime(), this.getInterval(), this.getExecTime());
                }
            } else if (nSchMode != 0) {
                this.m_oSchedule = this.saveScheduleInfo(_currUser, aSchedule, nSchMode, this.getStartTime(), this.getEndTime(), this.getInterval(), this.getExecTime());
            } else {
                aSchedule.delete(_currUser);
                this.m_oSchedule = null;
            }
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label6", "\u8ba1\u5212\u53d1\u5e03\u7684\u65e5\u671f\u6570\u636e\u6709\u8bef\uff01"), ex);
        }
    }

    private Schedule saveScheduleInfo(User _currUser, Schedule _currSchedule, int _nSchMode, String _sStartTime, String _sEndTime, int _nInterval, String _sExecTime) throws WCMException {
        try {
            CMyDateTime dtTime = new CMyDateTime();
            if (_currSchedule.isAddMode()) {
                String sName = this.getFolder().getInfo() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label7", "-\u8ba1\u5212\u53d1\u5e03");
                _currSchedule.setName(sName);
                _currSchedule.setDesc(sName);
                _currSchedule.setWorkerType(4);
                _currSchedule.setSender(this.getFolderType(), this.getFolderId());
            } else if (!_currSchedule.canEdit(_currUser)) {
                throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label8", "Schedule\u88ab\uff3b") + _currSchedule.getLockerUserName() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label9", "\uff3d\u9501\u5b9a"));
            }
            _currSchedule.setMode(_nSchMode);
            switch (_nSchMode) {
                case 1: {
                    dtTime.setDateTimeWithString("2005-04-01 " + _sExecTime);
                    _currSchedule.setExeTime(dtTime);
                    break;
                }
                case 2: {
                    dtTime = CMyDateTime.now();
                    dtTime.setTimeWithString(_sStartTime + ":00", 0);
                    _currSchedule.setStartTime(dtTime);
                    dtTime = CMyDateTime.now();
                    dtTime.setTimeWithString(_sEndTime + ":00", 0);
                    _currSchedule.setEndTime(dtTime);
                    _currSchedule.setParam(_nInterval);
                    break;
                }
                case 3: {
                    dtTime.setDateTimeWithString(_sExecTime);
                    _currSchedule.setExeTime(dtTime);
                }
            }
            _currSchedule.save(_currUser);
            return _currSchedule;
        }
        catch (CMyException ex) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label6", "\u8ba1\u5212\u53d1\u5e03\u7684\u65e5\u671f\u6570\u636e\u6709\u8bef\uff01"), ex);
        }
    }

    public static final WCMFolderPublishConfig findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (WCMFolderPublishConfig)BaseObj.findById(WCMFolderPublishConfig.class, _nId);
    }

    public static final WCMFolderPublishConfig createNewInstance() throws WCMException {
        return (WCMFolderPublishConfig)BaseObj.createNewInstance(WCMFolderPublishConfig.class);
    }

    public static final WCMFolderPublishConfig findByKey(Object _oKey) throws WCMException {
        return (WCMFolderPublishConfig)BaseObj.findByKey(WCMFolderPublishConfig.class, _oKey);
    }

    private BaseChannel getChannel() throws WCMException {
        if (this.m_oChannel == null) {
            this.initChannel();
        }
        return this.m_oChannel;
    }

    private void initChannel() throws WCMException {
        BaseChannel aChannel = (BaseChannel)BaseObj.findById(this.getFolderType(), this.getFolderId());
        if (aChannel == null) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label10", "\u6307\u5b9a\u7684FolderType[") + this.getFolderType() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label11", "]\u548cFolderId[") + this.getFolderId() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label12", "]\u65e0\u6548\uff01"));
        }
        this.setChannel(aChannel);
    }

    private void setChannel(BaseChannel channel) {
        this.m_oChannel = channel;
    }

    private FolderPublishConfig getFolderPublishConfig() throws WCMException {
        if (this.m_oFolderPublishConfig == null) {
            this.initFolderPublishConfig();
        }
        return this.m_oFolderPublishConfig;
    }

    private void initFolderPublishConfig() throws WCMException {
        if (this.m_bFolderPublishConfigInited) {
            return;
        }
        this.setFolderPublishConfig(FolderPublishConfig.findOf(this.getFolderType(), this.getFolderId()));
        this.m_bFolderPublishConfigInited = true;
    }

    private void setFolderPublishConfig(FolderPublishConfig folderPublishConfig) {
        this.m_oFolderPublishConfig = folderPublishConfig;
    }

    private Schedule getSchedule() throws WCMException {
        if (this.m_oSchedule == null) {
            this.initSchedule();
        }
        return this.m_oSchedule;
    }

    private void initSchedule() throws WCMException {
        if (this.m_bScheduleInited) {
            return;
        }
        this.setSchedule(Schedule.findBySender(4, this.getChannel()));
        this.m_bScheduleInited = true;
    }

    private void setSchedule(Schedule schedule) {
        this.m_oSchedule = schedule;
    }

    private WCMPubStatusConfig getStatusConfig() throws WCMException {
        if (this.m_oStatusConfig == null) {
            this.initWCMPubStatusConfig();
        }
        return this.m_oStatusConfig;
    }

    private void initWCMPubStatusConfig() throws WCMException {
        if (this.m_bWCMPubStatusConfigInited) {
            return;
        }
        this.setStatusConfig(WCMPubStatusConfig.findOf(this.getFolderType(), this.getFolderId()));
        this.m_bWCMPubStatusConfigInited = true;
    }

    private void setStatusConfig(WCMPubStatusConfig statusConfig) {
        this.m_oStatusConfig = statusConfig;
    }

    protected TemplateEmployMgr getTemplateEmployMgr() {
        return (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    }

    private void saveFolderPublishConfig(User _currUser) throws WCMException {
        FolderPublishConfig aConfig = this.getFolderPublishConfig();
        if (aConfig == null) {
            aConfig = FolderPublishConfig.createNewInstance();
        }
        if (aConfig.isAddMode()) {
            aConfig.setFolder(this.getFolderType(), this.getFolderId());
        }
        if (this.getDataPath() != null) {
            aConfig.setDataPath(this.getDataPath());
        }
        if (this.getDetailFileExt() != null) {
            aConfig.setDetailFileExt(this.getDetailFileExt());
        }
        if (this.getOutlineFileName() != null) {
            aConfig.setOutlineFileName(this.getOutlineFileName());
        }
        if (this.getRootDomain() != null) {
            aConfig.setRootDomain(this.getRootDomain());
        }
        if (this.getSiteLanguage() != 0) {
            aConfig.setSiteLanguage(this.getSiteLanguage());
        }
        if (this.getPageEncoding() != null) {
            aConfig.setPageEncoding(this.getPageEncoding());
        }
        if (aConfig.isAddMode() && aConfig.getProperties().size() > 2 || aConfig.getNewProperties() != null) {
            if (!aConfig.isAddMode() && !aConfig.canEdit(_currUser)) {
                throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label13", "\u5bf9\u8c61\u88ab\u7528\u6237[") + aConfig.getLockerUserName() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label14", "]\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539!"));
            }
            aConfig.save(_currUser);
        }
        this.m_oFolderPublishConfig = aConfig;
    }

    private void saveTemplateEmploys() throws WCMException {
        TemplateEmployMgr mgr = this.getTemplateEmployMgr();
        if (this.isAddMode() && this.containsProperty("DETAILTEMPLATEID") || this.containsNewProperty("DETAILTEMPLATEID")) {
            mgr.setDetailTemplate(this.getFolder(), this.getDetailTemplateId(), this.isResetChildrenTemplates());
        }
        if (this.getOutlineTemplateIds() != null) {
            mgr.setOutlineTemplates(this.getFolder(), this.getOutlineTemplateIds(), this.isResetChildrenTemplates());
        }
        if (this.isAddMode() && this.containsProperty("INFOVIEWPRINTTEMPLATEID")) {
            mgr.setDetailTemplate(this.getFolder(), this.getInfoviewPrintTemplateId(), this.isResetChildrenTemplates(), 3);
        }
    }

    public String getURL() throws WCMException {
        PublishPathCompass compass = new PublishPathCompass();
        return compass.getAbsoluteHttpPath(this.getFolder());
    }

    public IPublishFolder getFolder() throws WCMException {
        if (this.m_oFolder == null) {
            this.m_oFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.getChannel());
        }
        return this.m_oFolder;
    }

    private void saveWCMPubStatusConfig(User _currUser) throws WCMException {
        if (!this.containsProperty("DEFINESTATUS")) {
            return;
        }
        WCMPubStatusConfig aConfig = this.getStatusConfig();
        if (!this.isDefineStatus()) {
            if (aConfig == null) {
                return;
            }
            aConfig.delete(_currUser);
            return;
        }
        if (aConfig == null) {
            aConfig = WCMPubStatusConfig.createNewInstance();
        } else if (!aConfig.canEdit(_currUser)) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label15", "\u5bf9\u8c61\u88ab[") + aConfig.getLockerUserName() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label14", "]\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539!"));
        }
        aConfig.setFolderType(this.getChannel());
        aConfig.setStatusesCanDoPub(this.getStatusesCanDoPub());
        aConfig.setStatusIdAfterModify(this.getStatusIdAfterModify());
        aConfig.save(_currUser);
    }

    public static final WCMFolderPublishConfig findOf(int _nFolderType, int _nFolderId) throws WCMException {
        WCMFolderPublishConfig aWCMFolderPublishConfig = WCMFolderPublishConfig.createNewInstance();
        aWCMFolderPublishConfig.m_bSaveing = false;
        aWCMFolderPublishConfig.setFolderType(_nFolderType, _nFolderId);
        aWCMFolderPublishConfig.m_oChannel = (BaseChannel)BaseObj.findById(_nFolderType, _nFolderId);
        aWCMFolderPublishConfig.id = _nFolderId;
        return aWCMFolderPublishConfig;
    }

    @Override
    public boolean canEdit(User user) {
        if (this.id <= 0) {
            this.id = this.getFolderId();
        }
        return super.canEdit(user);
    }

    @Override
    public boolean isValidInstance() {
        return true;
    }

    public boolean isSavePublishConfig() {
        return this.m_bIsSavePublishConfig;
    }

    public void setSavePublishConfig(boolean isSavePublishConfig) {
        this.m_bIsSavePublishConfig = isSavePublishConfig;
    }
}

