/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class FlowEmployLCListenerForChange
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(FlowEmployLCListenerForChange.class);
    private FlowServer m_oFlowServer = null;

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof FlowEmploy)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        FlowEmploy flowEmploy = (FlowEmploy)_oObjModified;
        int nEmployerId = flowEmploy.getEmployerId();
        int nOldFlowId = flowEmploy.getPropertyAsInt("FLOWID", 0);
        int nNewFlowId = flowEmploy.getNewPropertyAsInt("FLOWID", 0);
        if (nOldFlowId <= 0 || nOldFlowId == nNewFlowId) {
            return;
        }
        String sWhere = "exists(select NodeId from WCMFlowNode where WCMFlowDoc.NodeId=NodeId and FlowId=" + nOldFlowId + ")";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        FlowDocs flowDocs = FlowDocs.openWCMObjs(User.getSystem(), aFilter);
        if (flowDocs == null || flowDocs.size() <= 0) {
            return;
        }
        for (int i = 0; i < flowDocs.size(); ++i) {
            this.updateFolwDoc((FlowDoc)flowDocs.getAt(i), nEmployerId, nNewFlowId);
        }
    }

    private void updateFolwDoc(FlowDoc flowDoc, int iChannelId, int nNewFlowId) throws WCMException {
        if (flowDoc == null) {
            return;
        }
        IFlowContent content = flowDoc.getFlowContent();
        if (content.getContentType() != 605) {
            return;
        }
        Document currDocument = (Document)content.getSubinstance();
        if (currDocument == null || currDocument.getChannelId() != iChannelId) {
            return;
        }
        try {
            this.getFlowServer().forceDocToEnd(content, User.getSystem());
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label3", "\u5f3a\u5236\u7ed3\u675f\u6d41\u8f6c\u53d1\u751f\u5f02\u5e38"), e);
        }
        if (nNewFlowId > 0) {
            String sPostDesc = I18NMessage.get(FlowEmployLCListenerForChange.class, "FlowEmployLCListenerForChange.label4", "\u56e0\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6539\u53d8\u800c\u91cd\u65b0\u6d41\u8f6c");
            this.getFlowServer().startContentInFlow(User.getSystem(), content, sPostDesc);
        }
    }

    private FlowServer getFlowServer() throws WCMException {
        if (this.m_oFlowServer == null) {
            this.m_oFlowServer = FlowServer.getFlowServer();
        }
        return this.m_oFlowServer;
    }
}

