/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSResultSet;
import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.trsserver.ClassInfo;
import com.trs.components.wcm.content.trsserver.KMTRSServer;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DocsFromTRSServer {
    private static Logger logger = Logger.getLogger(DocsFromTRSServer.class);
    private List m_ClassInfos = new ArrayList();
    private long m_SearchTime;
    private String m_sClassField = "DocChannel";
    private static String m_sTRSDocDBName = null;
    private static String m_sTRSDocIdDBName = null;
    private static final HashSet DEFAULT_FIELDS_SET = new HashSet();

    public static void setTRSDocDBName(String _sTRSDBName) {
        m_sTRSDocDBName = _sTRSDBName;
    }

    public static String getTRSDocDBName() {
        if (m_sTRSDocDBName == null) {
            ConfigServer configServer = ConfigServer.getServer();
            m_sTRSDocDBName = CMyString.showNull(configServer.getInitProperty("TRS_DOC_DB"), "WCMDocument");
        }
        return m_sTRSDocDBName;
    }

    public static void setTRSDocIdDBName(String _sTRSIDDBName) {
        m_sTRSDocIdDBName = _sTRSIDDBName;
    }

    public static String getTRSDocIdDBName() {
        if (m_sTRSDocIdDBName == null) {
            ConfigServer configServer = ConfigServer.getServer();
            m_sTRSDocIdDBName = CMyString.showNull(configServer.getInitProperty("TRS_DOC_ID_DB"), "DOCID2");
        }
        return m_sTRSDocIdDBName;
    }

    private static String filterBlank(String str) {
        boolean blankFlag = false;
        if (str == null || str.length() == 0) {
            return str;
        }
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (blankFlag) {
                if (c == ' ') continue;
                buf.append(c);
                blankFlag = false;
                continue;
            }
            buf.append(c);
            if (c != ' ') continue;
            blankFlag = true;
        }
        return buf.toString();
    }

    public static String filterForHTMLValue(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        block6: for (int i = 0; i < nLen; ++i) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '&': {
                    if (i + 1 < nLen) {
                        cTemp = srcBuff[i + 1];
                        if (cTemp == '#') {
                            retBuff.append("&");
                            continue block6;
                        }
                        retBuff.append("&amp;");
                        continue block6;
                    }
                    retBuff.append("&amp;");
                    continue block6;
                }
                case '<': {
                    retBuff.append("&lt;");
                    continue block6;
                }
                case '>': {
                    retBuff.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    continue block6;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
        }
        return retBuff.toString();
    }

    public static String getBodyCablet(String strColName, TRSResultSet _trsRs, String _sColorValue) {
        String sHitFlag = "__TRSHIT__";
        String sHitHTMLFlag = "<font color=" + sHitFlag + ">";
        int nHitHTMLFlagLen = sHitHTMLFlag.length();
        String sHitHTMLEndFlag = "</font>";
        int nHitHTMLEndFlagLen = sHitHTMLEndFlag.length();
        String sHitStartHTML = "<font color='" + _sColorValue + "'>";
        int nSize = 200;
        String sTemp = "";
        try {
            int nResult = (int)((double)nSize * 1.5);
            StringBuffer sbResult = new StringBuffer(nResult);
            String sContent = DocsFromTRSServer.filterBlank(_trsRs.getSummaryStringWithCutsize(strColName, nSize, sHitFlag));
            int nContentLen = sContent.length();
            if (nContentLen <= nHitHTMLFlagLen) {
                return sContent;
            }
            int nStartPose = 0;
            int nEndPose = 0;
            while (nEndPose < nContentLen - 1 && nStartPose < nContentLen - 1) {
                nEndPose = sContent.indexOf(sHitHTMLFlag, nStartPose);
                if (nEndPose < 0) {
                    nEndPose = nContentLen;
                }
                sTemp = sContent.substring(nStartPose, nEndPose);
                sTemp = DocsFromTRSServer.filterForHTMLValue(sTemp);
                sbResult.append(sTemp);
                if (nEndPose >= nContentLen) break;
                nStartPose = nEndPose + nHitHTMLFlagLen;
                nEndPose = (nEndPose = sContent.indexOf(sHitHTMLEndFlag, nStartPose)) < 0 ? nContentLen : (nEndPose += nHitHTMLEndFlagLen);
                sbResult.append(sHitStartHTML);
                sTemp = sContent.substring(nStartPose, nEndPose);
                sbResult.append(sTemp);
                nStartPose = nEndPose;
            }
            return sbResult.toString();
        }
        catch (Exception ex) {
            logger.warn((Object)"Excpetion info: ", (Throwable)ex);
            return "";
        }
    }

    public Documents openDocs(User _currUser, WCMFilter _filter, int _nCurrPage, int _nPageSize) throws WCMException {
        KMTRSServer currServer = KMTRSServer.getKMTRSServer();
        if (!currServer.isStarted() && !currServer.isStarting()) {
            return new Documents(_currUser);
        }
        TRSToWCMFilter trsFilter = this.toTRSFilter(_filter);
        if (trsFilter == null) {
            return new Documents(null);
        }
        if (currServer.getOpenProgram() != null) {
            return this.openDocsByLocal(_currUser, trsFilter, _nCurrPage, _nPageSize);
        }
        return this.openDocs(_currUser, trsFilter, _nCurrPage, _nPageSize);
    }

    public TRSToWCMFilter toTRSFilter(WCMFilter _filter) throws WCMException {
        String[] fields;
        TRSToWCMFilter trsFilter = new TRSToWCMFilter();
        trsFilter.setIDFieldName(DocsFromTRSServer.getTRSDocIdDBName());
        trsFilter.setTRSFrom(DocsFromTRSServer.getTRSDocDBName());
        if (DEFAULT_FIELDS_SET.isEmpty()) {
            fields = new String[]{"DOCTITLE", "DOCCHANNEL", "DOCCONTENT", "DOCAUTHOR", "CRTIME", "CRUSER", "DOCSTATUS", "DOCTYPE"};
            DEFAULT_FIELDS_SET.addAll(Arrays.asList(fields));
        }
        fields = new HashSet(DEFAULT_FIELDS_SET);
        String sSQLSelectFields = _filter.getSelect();
        if (!CMyString.isEmpty(sSQLSelectFields)) {
            sSQLSelectFields = sSQLSelectFields.toUpperCase();
            String[] pSQLSelectFields = CMyString.split(sSQLSelectFields, ",");
            int len = pSQLSelectFields.length;
            for (int i = 0; i < len; ++i) {
                String field = DocsFromTRSServer.truncateTablePrefixIfExist(pSQLSelectFields[i], "WCMDOCUEMNT");
                if (fields.contains(field)) continue;
                fields.add(field);
            }
        }
        fields.remove("DOCID");
        trsFilter.setSelect("DOCID", "DOCID2");
        for (String field : fields) {
            trsFilter.setSelect(field, field);
        }
        fields.clear();
        String sSQLWhere = _filter.getWhere();
        String sTRSWhere = null;
        if (sSQLWhere != null && (sSQLWhere = sSQLWhere.trim()).length() > 0) {
            sTRSWhere = DocsFromTRSServer.truncateTablePrefixIfExist(sSQLWhere, "WCMChnlDoc.");
            sTRSWhere = DocsFromTRSServer.truncateTablePrefixIfExist(sTRSWhere, "WCMDocument.");
            sTRSWhere = CMyString.replaceStr(sTRSWhere, "%", "");
            sTRSWhere = CMyString.replaceStr(sTRSWhere, "DOCID", "DOCID2");
            sTRSWhere = CMyString.replaceStr(sTRSWhere, " like ", "=");
            sTRSWhere = CMyString.replaceStr(sTRSWhere, " in ", "=");
            sTRSWhere = DocsFromTRSServer.convertClobSearch(sTRSWhere);
            List values = _filter.getSearchValues();
            if (values != null && !values.isEmpty()) {
                StringBuffer buff = new StringBuffer(sTRSWhere.length() + 256);
                char[] chars = sTRSWhere.toCharArray();
                int index = 0;
                for (char ch : chars) {
                    if (ch == '?') {
                        buff.append('\'');
                        buff.append(values.get(index++));
                        buff.append('\'');
                        continue;
                    }
                    buff.append(ch);
                }
                sTRSWhere = buff.toString();
                buff.setLength(0);
            }
        }
        trsFilter.setTRSWhere(sTRSWhere);
        String sSQLOrder = _filter.getOrder();
        String sTRSOrder = null;
        if (sSQLOrder != null && (sSQLOrder = sSQLOrder.trim()).length() > 0) {
            sSQLOrder = CMyString.replaceStr(sSQLOrder, "DOCID", "DOCID2");
            sSQLOrder = DocsFromTRSServer.truncateTablePrefixIfExist(sSQLOrder, "WCMChnlDoc.");
            sSQLOrder = DocsFromTRSServer.truncateTablePrefixIfExist(sSQLOrder, "WCMDocument.");
            StringBuffer buff = new StringBuffer(64);
            String[] pSQLOrder = CMyString.split(sSQLOrder, ",");
            int len = pSQLOrder.length;
            for (int i = 0; i < len; ++i) {
                String temp = pSQLOrder[i].toUpperCase().trim();
                int nSpaceCharIndex = temp.indexOf(32);
                String sOrderField = null;
                int chDirection = 45;
                if (nSpaceCharIndex != -1) {
                    sOrderField = temp.substring(0, nSpaceCharIndex);
                    if ("ASC".equals(temp.substring(nSpaceCharIndex).trim())) {
                        chDirection = 43;
                    }
                } else {
                    sOrderField = temp;
                }
                if ("DOCID".equals(sOrderField)) {
                    sOrderField = m_sTRSDocIdDBName;
                }
                if (i > 0) {
                    buff.append(',');
                }
                buff.append((char)chDirection).append(sOrderField);
            }
            sTRSOrder = buff.toString();
            buff.setLength(0);
        } else {
            sTRSOrder = "-CRTIME";
        }
        trsFilter.setTRSOrder(sTRSOrder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)trsFilter);
        }
        return trsFilter;
    }

    private static String convertClobSearch(String _sWhere) {
        String sClobSearchStart = "dbms_lob.instr(";
        int nClobSearchStart = "dbms_lob.instr(".length();
        String sClobSearchEnd = ", 1, 1)>0";
        int nClobSearchEnd = ", 1, 1)>0".length();
        int nPos = _sWhere.indexOf("dbms_lob.instr(");
        if (nPos > 0) {
            int nFieldNameEndPos = _sWhere.indexOf(44, nPos);
            int nEndPos = _sWhere.indexOf(", 1, 1)>0");
            _sWhere = _sWhere.substring(0, nPos) + _sWhere.substring(nPos + nClobSearchStart, nFieldNameEndPos) + "=?" + _sWhere.substring(nEndPos + nClobSearchEnd);
        }
        return _sWhere;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object openViewDocs(User _currUser, TRSToWCMFilter _filter, int _nCurrPage, int _nPageSize) throws WCMException {
        KMTRSServer currServer = KMTRSServer.getKMTRSServer();
        if (!currServer.isStarted() && !currServer.isStarting()) {
            return new ViewDocuments(_currUser);
        }
        DocsFromTRSServer.isValidTRSFilter(_filter);
        DebugTimer aTimer = new DebugTimer();
        TRSConnection trsConn = currServer.getConnection();
        TRSConnection.setCharset((int)3, (boolean)false);
        if (trsConn == null || trsConn.isClosed()) {
            throw new WCMException(1100, I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label2", "\u83b7\u53d6TRS\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\u5931\u8d25\uff01(DocsFromTRSServer.openDocs)"));
        }
        aTimer.stop();
        int nRecCount = 0;
        TRSResultSet trsRs = null;
        ViewDocuments viewDocuments = new ViewDocuments(_currUser);
        try {
            aTimer.start();
            String sExtension = _filter.getExtension();
            this.setAutoExtend(trsConn, sExtension);
            String sOption = _filter.getOption();
            int iOption = this.getOption(sOption);
            trsRs = trsConn.executeSelect(_filter.getTRSFrom(), _filter.getTRSWhere(), _filter.getTRSOrder(), "", _filter.getDefaultCols(), iOption, 115, false);
            aTimer.stop();
            this.m_SearchTime = aTimer.getTime();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label3", "\u67e5\u8be2TRS\u5e93[") + _filter.getTRSFrom() + "][" + _filter.getTRSWhere() + "][" + _filter.getTRSOrder() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label4", "]\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
            trsRs.setBufferSize(_nPageSize, _nPageSize);
            String selectFields = "docid2,doctitle,docchannel,docauthor,crtime,cruser,docstatus,doctype,docsourcename,recid,docorderpri,modal";
            trsRs.setReadOptions(115, selectFields, null);
            trsRs.setCutSize(0, true);
            nRecCount = (int)trsRs.getRecordCount();
            if (nRecCount <= 0) {
                ViewDocuments viewDocuments2 = new ViewDocuments(null);
                return viewDocuments2;
            }
            CPager currPager = new CPager(_nPageSize);
            currPager.setItemCount(nRecCount);
            currPager.setCurrentPageIndex(_nCurrPage);
            aTimer.start();
            viewDocuments.openTRSServerViewDocuments(trsRs, _filter, currPager);
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label6", "\u83b7\u53d6\u6570\u636e\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"query docs from trsserver failed.", (Throwable)ex);
        }
        finally {
            if (trsRs != null) {
                trsRs.close();
            }
            if (trsConn != null) {
                currServer.freeConnection(trsConn);
            }
        }
        return viewDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Documents openDocs(User _currUser, TRSToWCMFilter _filter, int _nCurrPage, int _nPageSize) throws WCMException {
        KMTRSServer currServer = KMTRSServer.getKMTRSServer();
        if (!currServer.isStarted() && !currServer.isStarting()) {
            return new Documents(_currUser);
        }
        DocsFromTRSServer.isValidTRSFilter(_filter);
        DebugTimer aTimer = new DebugTimer();
        TRSConnection trsConn = currServer.getConnection();
        TRSConnection.setCharset((int)3, (boolean)false);
        if (trsConn == null || trsConn.isClosed()) {
            throw new WCMException(1100, I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label2", "\u83b7\u53d6TRS\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\u5931\u8d25\uff01(DocsFromTRSServer.openDocs)"));
        }
        aTimer.stop();
        int nRecCount = 0;
        StringBuffer sbIds = new StringBuffer();
        TRSResultSet trsRs = null;
        try {
            aTimer.start();
            String sExtension = _filter.getExtension();
            this.setAutoExtend(trsConn, sExtension);
            String sOption = _filter.getOption();
            int iOption = this.getOption(sOption);
            trsRs = trsConn.executeSelect(_filter.getTRSFrom(), _filter.getTRSWhere(), _filter.getTRSOrder(), "", _filter.getDefaultCols(), iOption, 115, false);
            aTimer.stop();
            this.m_SearchTime = aTimer.getTime();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label3", "\u67e5\u8be2TRS\u5e93[") + _filter.getTRSFrom() + "][" + _filter.getTRSWhere() + "][" + _filter.getTRSOrder() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label4", "]\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
            trsRs.setBufferSize(_nPageSize, _nPageSize);
            trsRs.setReadOptions(115, _filter.getIDFieldName(), null);
            trsRs.setCutSize(0, true);
            nRecCount = (int)trsRs.getRecordCount();
            if (nRecCount <= 0) {
                Documents documents = new Documents(null);
                return documents;
            }
            int nStartIndex = (_nCurrPage - 1) * _nPageSize;
            for (int nCount = 0; nCount < _nPageSize && trsRs.moveTo(0, (long)(nStartIndex + nCount)); ++nCount) {
                int nDocId = trsRs.getInt(_filter.getIDFieldName());
                sbIds.append(nDocId);
                sbIds.append(",");
            }
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label6", "\u83b7\u53d6\u6570\u636e\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
            sbIds.setLength(sbIds.length() - 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (trsRs != null) {
                trsRs.close();
            }
            if (trsConn != null) {
                currServer.freeConnection(trsConn);
            }
        }
        Documents documents = Documents.findByIds(null, sbIds.toString());
        documents.setPageSize(nRecCount);
        documents.setMaxBufferSize(nRecCount);
        documents.setSelect(_filter.getWCMSelect());
        documents.setRecCount(nRecCount);
        return documents;
    }

    private int getOption(String sOption) {
        int iOption = 0;
        String[] sOptionParts = CMyString.split(sOption, ",");
        if (sOptionParts != null) {
            for (int i = 0; i < sOptionParts.length; ++i) {
                String aOptionPart = sOptionParts[i];
                if (aOptionPart.equalsIgnoreCase("MIXSORT")) {
                    iOption |= 1;
                }
                if (aOptionPart.equalsIgnoreCase("NOTSEGMENT")) {
                    iOption |= 2;
                }
                if (aOptionPart.equalsIgnoreCase("IDEOSINGLE")) {
                    iOption |= 2;
                }
                if (aOptionPart.equalsIgnoreCase("NOTHISTORY")) {
                    iOption |= 4;
                }
                if (aOptionPart.equalsIgnoreCase("NOTPOINT")) {
                    iOption |= 8;
                }
                if (aOptionPart.equalsIgnoreCase("DOCAND")) {
                    iOption |= 0x10;
                }
                if (aOptionPart.equalsIgnoreCase("DOCOR")) {
                    iOption |= 0x20;
                }
                if (aOptionPart.equalsIgnoreCase("DOCNOT")) {
                    iOption |= 0x30;
                }
                if (aOptionPart.equalsIgnoreCase("DOCXOR")) {
                    iOption |= 0x40;
                }
                if (aOptionPart.equalsIgnoreCase("PRIORDEFCOL")) {
                    iOption |= 0x100;
                }
                if (aOptionPart.equalsIgnoreCase("SORTALWAYS")) {
                    iOption |= 0x200;
                }
                if (aOptionPart.equalsIgnoreCase("SORTWORDV1")) {
                    iOption |= 0x400;
                }
                if (aOptionPart.equalsIgnoreCase("SORTWORDV2")) {
                    iOption |= 0x800;
                }
                if (aOptionPart.equalsIgnoreCase("LIFOSPARE")) {
                    iOption |= 0x1000;
                }
                if (aOptionPart.equalsIgnoreCase("IGNOREHFW")) {
                    iOption |= 0x2000;
                }
                if (!aOptionPart.equalsIgnoreCase("VIRTUALSET")) continue;
                iOption |= 0x4000;
            }
        }
        return iOption;
    }

    private void setAutoExtend(TRSConnection trsConn, String sExtension) throws TRSException {
        String[] sExtensionParts = CMyString.split(sExtension, ",");
        if (sExtensionParts != null) {
            int iExtension = 0;
            for (int i = 0; i < sExtensionParts.length; ++i) {
                String aExtensionPart = sExtensionParts[i];
                if (aExtensionPart.equalsIgnoreCase("KAXST")) {
                    iExtension |= 1;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXAT")) {
                    iExtension |= 2;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXPT")) {
                    iExtension |= 4;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXUF")) {
                    iExtension |= 8;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXAB")) {
                    iExtension |= 0x10;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXABF")) {
                    iExtension |= 0x20;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXRT")) {
                    iExtension |= 0x40;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXBT")) {
                    iExtension |= 0x80;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXALLBT")) {
                    iExtension |= 0x200;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXALLNT")) {
                    iExtension |= 0x400;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXECX")) {
                    iExtension |= 0x8000;
                }
                if (aExtensionPart.equalsIgnoreCase("ALLKAX")) {
                    iExtension |= 0x7FF;
                }
                if (aExtensionPart.equalsIgnoreCase("KAXECX")) {
                    iExtension |= 0x8000;
                }
                if (!aExtensionPart.equalsIgnoreCase("KAXCST")) continue;
                iExtension |= 0x4000;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("iExtension:" + iExtension));
            }
            trsConn.setAutoExtend("", "", "", iExtension);
        }
    }

    public Documents openDocsByLocal(User _currUser, TRSToWCMFilter _filter, int _nCurrPage, int _nPageSize) throws WCMException {
        KMTRSServer currServer = KMTRSServer.getKMTRSServer();
        if (!currServer.isStarted() && !currServer.isStarting()) {
            return new Documents(_currUser);
        }
        if (currServer.getOpenProgram() == null) {
            logger.error((Object)I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label7", "\u6ca1\u6709\u6307\u5b9aOPEN_TRS_SERVER_PROGRAM\uff01"));
            return new Documents(_currUser);
        }
        DocsFromTRSServer.isValidTRSFilter(_filter);
        DebugTimer aTimer = new DebugTimer();
        Documents currDocs = new Documents(_currUser);
        currDocs.setPageSize(_nPageSize);
        try {
            aTimer.start();
            Class.forName("com.trs.jdbc.broker.BrokerDriver");
            Connection conn = DriverManager.getConnection("jdbc:trs:broker:test");
            PreparedStatement stmt = conn.prepareStatement("");
            stmt = currServer.setPrepareStatments(_filter, stmt);
            stmt.setString(7, DocsFromTRSServer.getTRSDocDBName());
            int nStartRow = (_nCurrPage - 1) * _nPageSize;
            int nEndRow = nStartRow + _nPageSize - 1;
            stmt.setInt(12, nStartRow);
            stmt.setInt(13, nEndRow + 3);
            ResultSet rs = stmt.executeQuery();
            int nRecCount = rs.getInt(-1);
            currDocs.setRecCount(nRecCount);
            if (nRecCount <= 0) {
                return currDocs;
            }
            boolean bExists = rs.absolute(nStartRow + 1);
            currDocs.setCurrPage(_nCurrPage - 1);
            currDocs.setCurrentStartIndex((_nCurrPage - 1) * _nPageSize);
            for (int i = 0; i < _nPageSize && bExists; ++i) {
                int nDocId = Integer.parseInt(rs.getString(_filter.getIDFieldName()));
                Document aDoc = new Document();
                aDoc.setId(nDocId);
                Enumeration enTRSFields = _filter.getTRSFields();
                while (enTRSFields.hasMoreElements()) {
                    String sTRSFieldName = (String)enTRSFields.nextElement();
                    String sWCMFiledName = _filter.getWCMField(sTRSFieldName);
                    aDoc.setPropertyWithString(sWCMFiledName, rs.getString(sTRSFieldName));
                }
                currDocs.addElement(aDoc);
                bExists = rs.next();
            }
            rs.close();
            stmt.close();
            conn.close();
            aTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label6", "\u83b7\u53d6\u6570\u636e\u6240\u7528\u65f6\u95f4\u4e3a\uff1a") + aTimer.getTime() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label5", "\u6beb\u79d2")));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Fail to Get Data From TRSServer!\n" + _filter), (Throwable)ex);
        }
        return currDocs;
    }

    private static void isValidTRSFilter(TRSToWCMFilter _filter) throws WCMException {
        if (_filter.getIDFieldName().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label8", "\u6ca1\u6709\u6307\u5b9aID\u5b57\u6bb5\uff01DocsFromTRSServer.isValidTRSFilter"));
        }
        if (_filter.getTRSFrom().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label9", "\u6ca1\u6709\u6307\u5b9a\u67e5\u8be2\u7684\u6570\u636e\u8868\uff01DocsFromTRSServer.isValidTRSFilter"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arArgs) {
        try {
            DocsFromTRSServer aDocsFromTRSServer = (DocsFromTRSServer)DreamFactory.createObjectById("DocsFromTRSServer");
            TRSToWCMFilter filter = new TRSToWCMFilter();
            filter.setIDFieldName(DocsFromTRSServer.getTRSDocIdDBName());
            String sWCMSelectFields = "docid,doctitle,docchannel,docauthor,crtime,cruser,docstatus,doctype,dockeywords,docsource,docreltime,docpuburl ";
            String sTRSSelectFields = "docid2,doctitle,docchannel,docauthor,crtime,cruser,docstatus,doctype,dockeywords,docsource,docreltime,docpuburl ";
            filter.setTRSFrom(DocsFromTRSServer.getTRSDocDBName());
            filter.setSelect(sWCMSelectFields, sTRSSelectFields);
            filter.setTRSWhere(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label10", "SiteId=2 and DocContent='\u4e2d\u56fd' and CRTime='2006-04-13' to '2006-04-21' and CrUser=('\u738b\u575a', '\u683e\u82f1\u5251') "));
            filter.setTRSOrder("-" + DocsFromTRSServer.getTRSDocIdDBName());
            int nPageIndex = 1;
            int nPageSize = 15;
            Documents aDocs = aDocsFromTRSServer.openDocsByLocal(User.getSystem(), filter, nPageIndex, nPageSize);
            System.out.println(I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label11", "\u8f93\u51fa\u6784\u9020\u7684\u6587\u6863\u7ed3\u679c\uff01\u5171\u627e\u5230\uff1a") + aDocs.getRecCount() + I18NMessage.get(DocsFromTRSServer.class, "DocsFromTRSServer.label12", "\u6761\u8bb0\u5f55\uff01"));
            int nCurrRecCount = Math.min(aDocs.size(), nPageIndex * nPageSize);
            for (int i = (nPageIndex - 1) * nPageSize; i < nCurrRecCount; ++i) {
                Document aDoc = (Document)aDocs.getAt(i);
                if (aDoc == null) continue;
                System.out.println(i + 1 + "\u3001" + aDoc);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            KMTRSServer.shutdownWCMForTRS();
        }
    }

    public static String getTRSWhere(HttpServletRequest request) throws Exception {
        int nDocSource;
        int nSiteId = Integer.parseInt(request.getParameter("SiteId"));
        StringBuffer sbTRSWhere = new StringBuffer(1000);
        sbTRSWhere.append("SiteId=");
        sbTRSWhere.append(nSiteId);
        String sContentValue = CMyString.showNull(request.getParameter("ContentValue")).trim();
        String sContentKey = CMyString.showNull(request.getParameter("ContentKey"), "DocTitle,DocKeyWords,DocContent");
        if (sContentValue.length() > 0) {
            sContentValue = CMyString.getStr(sContentValue, false);
            String[] pContentValue = CMyString.split(sContentValue, "");
            String[] pContentKey = CMyString.split(sContentKey, ",");
            for (int i = 0; i < pContentKey.length; ++i) {
                sbTRSWhere.append(" and ");
                sbTRSWhere.append(pContentKey[i]);
                sbTRSWhere.append("=(");
                for (int j = 0; j < pContentValue.length; ++j) {
                    if (j > 0) {
                        sbTRSWhere.append(',');
                    }
                    sbTRSWhere.append('\'');
                    sbTRSWhere.append(pContentValue[j]);
                    sbTRSWhere.append('\'');
                }
                sbTRSWhere.append(")");
            }
        }
        String sUserValue = CMyString.showNull(request.getParameter("UserValue")).trim();
        String sUserKey = CMyString.showNull(request.getParameter("UserKey"), "CrUser");
        if (sUserValue.length() > 0) {
            sUserValue = CMyString.getStr(sUserValue, false);
            String[] pUserValue = CMyString.split(sUserValue, "");
            String[] pUserKey = CMyString.split(sUserKey, ",");
            for (int i = 0; i < pUserKey.length; ++i) {
                sbTRSWhere.append(" and ");
                sbTRSWhere.append(pUserKey[i]);
                sbTRSWhere.append("=(");
                for (int j = 0; j < pUserValue.length; ++j) {
                    if (j > 0) {
                        sbTRSWhere.append(',');
                    }
                    sbTRSWhere.append('\'');
                    sbTRSWhere.append(pUserValue[j]);
                    sbTRSWhere.append('\'');
                }
            }
        }
        if ((nDocSource = Integer.parseInt(CMyString.showNull(request.getParameter("DocSource"), "0"))) > 0) {
            sbTRSWhere.append(" and DocSource=");
            sbTRSWhere.append(nDocSource);
        }
        String sStartCrTime = CMyDateTime.now().dateAdd(3, -7).toString("yyyy-MM-dd");
        String sEndCrTime = CMyDateTime.now().toString("yyyy-MM-dd");
        int nSearchTime = Integer.parseInt(CMyString.showNull(request.getParameter("SearchTime"), "0"));
        if (nSearchTime > 0) {
            sbTRSWhere.append(" and DocRelTime='");
            sbTRSWhere.append(sStartCrTime);
            sbTRSWhere.append("' to '");
            sbTRSWhere.append(sEndCrTime);
            sbTRSWhere.append('\'');
        }
        return sbTRSWhere.toString();
    }

    public List getClassInfos() {
        return this.m_ClassInfos;
    }

    public String getClassInfoAsString() {
        String sResultStr = "";
        for (int i = 0; i < this.m_ClassInfos.size(); ++i) {
            ClassInfo currInfo = (ClassInfo)this.m_ClassInfos.get(i);
            if (currInfo == null) continue;
            sResultStr = sResultStr + currInfo.getValue() + "," + currInfo.getRecordNum() + ",";
        }
        if (sResultStr.length() > 0) {
            sResultStr = sResultStr.substring(0, sResultStr.length() - 1);
        }
        return sResultStr;
    }

    public long getSearchTime() {
        return this.m_SearchTime;
    }

    public String getClassField() {
        return this.m_sClassField;
    }

    public void setClassField(String classField) {
        this.m_sClassField = classField;
    }

    private static String truncateTablePrefixIfExist(String string, String tablePrefix) {
        if (CMyString.isEmpty(string) || CMyString.isEmpty(tablePrefix)) {
            return string;
        }
        String sUpperString = string.toUpperCase();
        String sUpperPrefix = tablePrefix.toUpperCase();
        char[] upperSrc = sUpperString.toCharArray();
        int nSrcLen = upperSrc.length;
        char[] prefix = sUpperPrefix.toCharArray();
        int nPrefixLen = prefix.length;
        char[] src = string.toCharArray();
        StringBuffer retBuff = new StringBuffer(nSrcLen);
        boolean bIsFound = false;
        int i = 0;
        while (i < nSrcLen) {
            bIsFound = false;
            if (upperSrc[i] == prefix[0]) {
                int j;
                for (j = 1; j < nPrefixLen && i + j < nSrcLen && upperSrc[i + j] == prefix[j]; ++j) {
                }
                boolean bl = bIsFound = j == nPrefixLen;
            }
            if (bIsFound) {
                i += nPrefixLen;
                continue;
            }
            int nSkipTo = i + nPrefixLen >= nSrcLen ? nSrcLen - 1 : i;
            while (i <= nSkipTo) {
                retBuff.append(src[i]);
                ++i;
            }
        }
        return retBuff.toString();
    }
}

