/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.AdvisorExporter;
import com.trs.components.wcm.advisor.AdvisorImporter;
import com.trs.components.wcm.advisor.AdvisorMgr;
import com.trs.components.wcm.advisor.Advisors;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class AdvisorCenterServiceProvider
implements IGlueServiceProvider {
    private AdvisorMgr m_oAdvisorMgr = (AdvisorMgr)DreamFactory.createObjectById("AdvisorMgr");

    public Steps queryStepsByAdvisor(MethodContext context) throws Throwable {
        int nAdvisorId = context.getObjectId();
        User loginUser = this.getLoginUser();
        Advisor advisor = Advisor.findById(nAdvisorId);
        this.validRight(advisor, loginUser, 14);
        return this.m_oAdvisorMgr.queryStepsByAdvisor(advisor, null);
    }

    public OptionGroups queryOptionGroupsByStep(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nStepId = context.getObjectId();
        Step oStep = Step.findById(nStepId);
        if (oStep == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nStepId), WCMTypes.getLowerObjName(78549201)}));
        }
        this.validStep(oStep, 0, loginUser, 14);
        return this.m_oAdvisorMgr.queryOptionGroupsByStep(oStep, null);
    }

    public Options queryOptionsByGroup(MethodContext context) throws Throwable {
        int nGroupId = context.getObjectId();
        OptionGroup oGroup = OptionGroup.findById(nGroupId);
        if (oGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nGroupId), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOptionGroup(oGroup, 0, this.getLoginUser(), 14);
        return this.m_oAdvisorMgr.queryOptionsByOptionGroup(oGroup, null);
    }

    public Options queryOptionsOtherSteps(MethodContext context) throws WCMException {
        int nCurrStepId = context.getValue("StepId", 0);
        Step oStep = Step.findById(nCurrStepId);
        if (oStep == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nCurrStepId), WCMTypes.getLowerObjName(78549201)}));
        }
        int nAdvisorId = oStep.getAdvisorId();
        this.validStep(oStep, 0, this.getLoginUser(), 14);
        WCMFilter filter = new WCMFilter("", "STEPID <> ? AND STEPID IN (SELECT STEPID FROM XWCMSTEP where ADVISORID=?)", "STEPID,AORDER");
        filter.addSearchValues(nCurrStepId);
        filter.addSearchValues(nAdvisorId);
        return Options.openWCMObjs(null, filter);
    }

    public Options queryOtherOptionsInOneGroup(MethodContext context) throws WCMException {
        int nCurrOptionId = context.getValue("OptionId", 0);
        Option oOption = Option.findById(nCurrOptionId);
        if (oOption == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nCurrOptionId), WCMTypes.getLowerObjName(1705862168)}));
        }
        int nGroupId = oOption.getGroupId();
        this.validOption(oOption, nGroupId, this.getLoginUser(), 14);
        WCMFilter filter = new WCMFilter("", "GroupId = ? and optionid <> ?", "AORDER");
        filter.addSearchValues(nGroupId);
        filter.addSearchValues(nCurrOptionId);
        return Options.openWCMObjs(null, filter);
    }

    public int saveStep(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nStepId = context.getObjectId();
        int nAdvisorId = context.getValue("AdvisorId", 0);
        Step step = null;
        step = nStepId == 0 ? new Step() : Step.findById(nStepId);
        if (nStepId == 0 && nAdvisorId == 0) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label1", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validStep(step, nAdvisorId, loginUser, 13);
        String[] pLogicFields = new String[]{"ObjectId"};
        step = (Step)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, step, pLogicFields);
        step.save(loginUser);
        return step.getId();
    }

    public int saveOptionGroup(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOptionGroupId = context.getObjectId();
        int nStepId = context.getValue("StepId", 0);
        OptionGroup optionGroup = null;
        optionGroup = nOptionGroupId == 0 ? new OptionGroup() : OptionGroup.findById(nOptionGroupId);
        if (nOptionGroupId == 0 && nStepId == 0) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label1", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validOptionGroup(optionGroup, nStepId, loginUser, 13);
        String[] pLogicFields = new String[]{"ObjectId"};
        optionGroup = (OptionGroup)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, optionGroup, pLogicFields);
        optionGroup.save(loginUser);
        return optionGroup.getId();
    }

    public int saveOption(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOptionId = context.getObjectId();
        int nOptionGroupId = context.getValue("GroupId", 0);
        Option option = null;
        option = nOptionId == 0 ? new Option() : Option.findById(nOptionId);
        if (nOptionId == 0 && nOptionGroupId == 0) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label1", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validOption(option, nOptionGroupId, loginUser, 13);
        String[] pLogicFields = new String[]{"ObjectId"};
        option = (Option)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, option, pLogicFields);
        option.save(loginUser);
        return option.getId();
    }

    public void deleteAdvisor(MethodContext context) throws WCMException {
        User loginUser = this.getLoginUser();
        String sAdvisorIds = context.getValue("AdvisorIds");
        Advisors advisors = Advisors.findByIds(loginUser, sAdvisorIds);
        for (int i = advisors.size() - 1; i >= 0; --i) {
            Advisor advisor = (Advisor)advisors.getAt(i);
            if (advisor == null) continue;
            this.validRight(advisor, loginUser, 13);
            this.m_oAdvisorMgr.deleteAdvisor(advisor);
        }
    }

    public void deleteStep(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nStepId = context.getObjectId();
        Step currStep = Step.findById(nStepId);
        if (currStep == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nStepId), WCMTypes.getLowerObjName(78549201)}));
        }
        this.validStep(currStep, 0, loginUser, 13);
        this.m_oAdvisorMgr.deleteStep(currStep);
    }

    public void deleteOptionGroup(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOptionGroupId = context.getObjectId();
        OptionGroup currOptionGroup = OptionGroup.findById(nOptionGroupId);
        if (currOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nOptionGroupId), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOptionGroup(currOptionGroup, 0, loginUser, 13);
        this.m_oAdvisorMgr.deleteOptionGroup(currOptionGroup);
    }

    public void deleteOption(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOptionId = context.getObjectId();
        Option currOption = Option.findById(nOptionId);
        if (currOption == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nOptionId), WCMTypes.getLowerObjName(1705862168)}));
        }
        this.validOption(currOption, 0, loginUser, 13);
        this.m_oAdvisorMgr.deleteOption(currOption);
    }

    public void createXMLForAdvisor(MethodContext context) throws Throwable {
        int nChannelId = context.getValue("ChannelId", 0);
        Channel channel = Channel.findById(nChannelId);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nChannelId), WCMTypes.getLowerObjName(101)}));
        }
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 13);
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + nChannelId + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
        String sAdvisorIds = context.getValue("AdvisorIds");
        if (CMyString.isEmpty(sAdvisorIds)) {
            this.createAdvisorXML(null, nChannelId, context);
            return;
        }
        int[] nAdvisorIds = CMyString.splitToInt(sAdvisorIds, ",");
        for (int i = 0; i < nAdvisorIds.length; ++i) {
            int nAdvisorId = nAdvisorIds[i];
            Advisor oAdvisor = Advisor.findById(nAdvisorId);
            this.createAdvisorXML(oAdvisor, nChannelId, context);
        }
    }

    public void copy(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sAdvisorIds = context.getValue("AdvisorIds");
        String sChnlIds = context.getValue("ChannelIds");
        Channels channels = Channels.findByIds(loginUser, sChnlIds);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.validateRight(channel, loginUser, 13);
        }
        Advisors advisors = Advisors.findByIds(loginUser, sAdvisorIds);
        for (int i = advisors.size() - 1; i >= 0; --i) {
            Advisor advisor = (Advisor)advisors.getAt(i);
            if (advisor == null) continue;
            this.validRight(advisor, loginUser, 13);
            this.m_oAdvisorMgr.copy(advisor, channels, loginUser);
        }
    }

    public String export(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sAdvisorIds = context.getValue("AdvisorIds");
        Advisors advisors = Advisors.findByIds(loginUser, sAdvisorIds);
        int nSize = advisors.size();
        for (int i = 0; i < nSize; ++i) {
            Advisor advisor = (Advisor)advisors.getAt(i);
            if (advisor == null) continue;
            this.validRight(advisor, loginUser, 14);
        }
        AdvisorExporter exporter = new AdvisorExporter();
        return exporter.export(advisors);
    }

    public void importAdvisors(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nImportType = context.getValue("ImportType", 1);
        int nChnlId = context.getValue("ChannelId", 0);
        Channel channel = Channel.findById(nChnlId);
        if (channel == null) {
            throw new WCMException("\u4f20\u5165\u7684\u680f\u76eeId[" + nChnlId + "]\u4e0d\u5b58\u5728");
        }
        this.validateRight(channel, loginUser, 13);
        String sImportFile = context.getValue("ImportFile");
        AdvisorImporter importer = new AdvisorImporter(nImportType, channel);
        importer.setImportToCurrChnl(context.getValue("ImportToCurrChnl", true));
        importer.importFromZip(sImportFile);
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validOption(Option _option, int _nOptionGroupId, User _currUser, int _rightIndex) throws WCMException {
        int nOptionGroupId = _nOptionGroupId;
        OptionGroup optionGroup = null;
        if (nOptionGroupId == 0) {
            nOptionGroupId = _option.getGroupId();
        }
        if ((optionGroup = OptionGroup.findById(nOptionGroupId)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nOptionGroupId), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOptionGroup(optionGroup, 0, _currUser, _rightIndex);
    }

    private void validOptionGroup(OptionGroup _optionGroup, int _nStepId, User _currUser, int _rightIndex) throws WCMException {
        int nStepId = _nStepId;
        Step step = null;
        if (nStepId == 0) {
            nStepId = _optionGroup.getStepId();
        }
        if ((step = Step.findById(nStepId)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nStepId), WCMTypes.getLowerObjName(78549201)}));
        }
        this.validStep(step, 0, _currUser, _rightIndex);
    }

    private void validStep(Step _step, int _nAdvisorId, User _currUser, int _rightIndex) throws WCMException {
        int nAdvisorId = _nAdvisorId;
        Advisor advisor = null;
        if (nAdvisorId == 0) {
            nAdvisorId = _step.getAdvisorId();
        }
        if ((advisor = Advisor.findById(nAdvisorId)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nAdvisorId), WCMTypes.getLowerObjName(1460271229)}));
        }
        this.validRight(advisor, _currUser, _rightIndex);
    }

    private void validRight(Advisor _advisor, User _currUser, int _rightIndex) throws WCMException {
        int nChannelId = _advisor.getChannelId();
        Channel oChannel = Channel.findById(nChannelId);
        if (oChannel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nChannelId), WCMTypes.getLowerObjName(101)}));
        }
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)oChannel, _rightIndex);
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + nChannelId + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
    }

    private void validateRight(Channel _channel, User _currUser, int _rightIndex) throws WCMException {
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)_channel, _rightIndex);
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + _channel.getId() + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
    }

    private void createAdvisorXML(Advisor _advisor, int _channelId, MethodContext context) throws CMyException {
        String sTemplateContent = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        String sAdvisorName = "";
        if (_advisor == null) {
            sTemplateContent = sTemplateContent + "<TRS_WIZARD FIELD=\"XML\" disFile=\"true\"/>";
        } else {
            sAdvisorName = _advisor.getAdvisorName();
            sTemplateContent = sTemplateContent + "<TRS_WIZARD FIELD=\"XML\" name=\"" + sAdvisorName + "\" DisFile=\"true\"/>";
        }
        String sXMLContent = null;
        PublishTaskContext taskContext = new PublishTaskContext(null, null);
        IPublishElement pagePublishElement = this.makeElement(_channelId);
        PublishPageContext oPageContext = new PublishPageContext(pagePublishElement, taskContext);
        PublishTagContext tagContext = new PublishTagContext(oPageContext);
        PublishPathCompass compass = new PublishPathCompass();
        String sPubUrl = compass.getLocalPath(pagePublishElement, context.getValue("isPreview", true));
        try {
            TagDocument tagDoc = TagDocumentReader.read(sTemplateContent);
            if (tagDoc == null) {
                throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label4", "\u5c06\u6a21\u677f\u5185\u5bb9\u8f6c\u6362\u4e3aTagDocument\u5931\u8d25\uff01"));
            }
            String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
            sXMLContent = results[0];
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label5", "\u89e3\u6790\u7f6e\u6807\u3010TRS_WIZARD\u3011\u5931\u8d25\uff01"), e);
        }
        String sFileName = "wizard";
        String sPubFilePath = sPubUrl + sFileName + ".xml";
        CMyFile.writeFile(sPubFilePath, sXMLContent, CMyString.GET_ENCODING_DEFAULT);
        tagContext.getFileDistributeShip().distributeFile(sPubFilePath, pagePublishElement, null, false);
    }

    private IPublishElement makeElement(int _channelId) throws WCMException {
        IPublishElement pubElement = null;
        pubElement = PublishElementFactory.lookupElement(101, _channelId);
        if (pubElement == null) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label6", "\u6307\u5b9a\u7684\u680f\u76ee[Id=") + _channelId + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label7", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return pubElement;
    }
}

