/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class StatDocCountByChannel {
    public static final int MODAL_STAT_NORM = 1;
    public static final int MODAL_STAT_SNAP = 2;
    public int m_nStatModal = 2;
    private String m_sSQL = null;

    public StatDocCountByChannel(String _sStatSQL) {
        this.m_sSQL = _sStatSQL;
    }

    public HashMap stat(int _nSiteId, CMyDateTime _dtStartTime) throws Exception {
        DBType currDBType = DBManager.getDBManager().getDBType();
        String sStartTime = _dtStartTime.toString("yyyy-MM-dd 00:00:00");
        sStartTime = currDBType.sqlDate(sStartTime);
        String sEndTime = _dtStartTime.toString("yyyy-MM-dd 23:59:59");
        sEndTime = currDBType.sqlDate(sEndTime);
        HashMap hResult = this.queryData(_nSiteId, sStartTime, sEndTime);
        if (this.m_nStatModal == 2) {
            this.mergeChildCountToParent(hResult);
        }
        return hResult;
    }

    public HashMap stat(int _nSiteId, CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        DBType currDBType = DBManager.getDBManager().getDBType();
        String sStartTime = currDBType.sqlDate(_dtStartTime.toString());
        String sEndTime = currDBType.sqlDate(_dtEndTime.toString());
        HashMap hResult = this.queryData(_nSiteId, sStartTime, sEndTime);
        if (this.m_nStatModal == 2) {
            this.mergeChildCountToParent(hResult);
        }
        return hResult;
    }

    public CMyDateTime createStatDataInTempTableByDay(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        return null;
    }

    private HashMap queryData(int _nSiteId, String _sStartTime, String _sEndTime) throws WCMException {
        HashMap<String, String> hParameters = new HashMap<String, String>();
        hParameters.put("SITEID", String.valueOf(_nSiteId));
        hParameters.put("STARTTIME", _sStartTime);
        hParameters.put("ENDTIME", _sEndTime);
        String sSQL = CMyString.parsePageVariables(this.m_sSQL, hParameters);
        HashMap<Integer, HashMap<String, Integer>> hResult = new HashMap<Integer, HashMap<String, Integer>>(2000);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = sSQL;
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                int nDataCount = rsData.getInt(1);
                int nChannelId = rsData.getInt(2);
                String sCrUserName = rsData.getString(3);
                Integer iChannelKey = new Integer(nChannelId);
                HashMap<String, Integer> hCrUserDataCount = (HashMap<String, Integer>)hResult.get(iChannelKey);
                if (hCrUserDataCount == null) {
                    hCrUserDataCount = new HashMap<String, Integer>();
                    hResult.put(iChannelKey, hCrUserDataCount);
                }
                hCrUserDataCount.put(sCrUserName, new Integer(nDataCount));
                this.addDataCountOfSite(hResult, nDataCount, sCrUserName);
            }
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
        return hResult;
    }

    private void mergeChildCountToParent(HashMap _hResult) throws WCMException {
        HashMap hTemp = new HashMap();
        for (Integer iCurrChannel : _hResult.keySet()) {
            Channel channel;
            int nChannelId = iCurrChannel;
            if (nChannelId == 0 || (channel = Channel.findById(nChannelId)) == null) continue;
            HashMap hUserDataCountOnCurrChannel = (HashMap)_hResult.get(iCurrChannel);
            Object[] pUserNamesOnCurrChannel = hUserDataCountOnCurrChannel.keySet().toArray();
            for (Channel parent = channel.getParent(); parent != null; parent = parent.getParent()) {
                this.addToParentChannel(parent, hTemp, hUserDataCountOnCurrChannel, pUserNamesOnCurrChannel);
            }
        }
        for (Object iTempChannelKey : hTemp.keySet()) {
            HashMap hTempUserDatas = (HashMap)hTemp.get(iTempChannelKey);
            HashMap hExistsDataMap = (HashMap)_hResult.get(iTempChannelKey);
            if (hExistsDataMap == null) {
                _hResult.put(iTempChannelKey, hTempUserDatas);
                continue;
            }
            for (Object sUserName : hTempUserDatas.keySet()) {
                Integer iMergeDataCount = (Integer)hTempUserDatas.get(sUserName);
                Integer iExistsDataCount = (Integer)hExistsDataMap.get(sUserName);
                int iFinalCount = iExistsDataCount == null ? 0 : iExistsDataCount;
                hExistsDataMap.put(sUserName, new Integer(iFinalCount += iMergeDataCount.intValue()));
            }
        }
    }

    private void addToParentChannel(Channel _parent, HashMap _hResultTemp, HashMap _hUserDataCountOnCurrChannel, Object[] _pUserNamesOnCurrChannel) {
        Integer iParentKey = new Integer(_parent.getId());
        HashMap<String, Integer> hCrUserDataCountOnParent = (HashMap<String, Integer>)_hResultTemp.get(iParentKey);
        if (hCrUserDataCountOnParent == null) {
            hCrUserDataCountOnParent = new HashMap<String, Integer>();
            _hResultTemp.put(iParentKey, hCrUserDataCountOnParent);
        }
        for (int i = 0; i < _pUserNamesOnCurrChannel.length; ++i) {
            String sUserName = _pUserNamesOnCurrChannel[i].toString();
            int nCurrCount = (Integer)_hUserDataCountOnCurrChannel.get(sUserName);
            Integer iDataCountOnParent = (Integer)hCrUserDataCountOnParent.get(sUserName);
            int nDataCountOnParent = iDataCountOnParent == null ? 0 : iDataCountOnParent;
            hCrUserDataCountOnParent.put(sUserName, new Integer(nDataCountOnParent += nCurrCount));
        }
    }

    private void addDataCountOfSite(HashMap _hResult, int _nDataCountOfChannel, String _sCrUserName) {
        Integer iDataCount;
        Integer iSiteKey = new Integer(0);
        HashMap<String, Integer> hCrUserDataCountOnSite = (HashMap<String, Integer>)_hResult.get(iSiteKey);
        if (hCrUserDataCountOnSite == null) {
            hCrUserDataCountOnSite = new HashMap<String, Integer>();
            _hResult.put(iSiteKey, hCrUserDataCountOnSite);
        }
        int nDataCountOnSite = (iDataCount = (Integer)hCrUserDataCountOnSite.get(_sCrUserName)) == null ? 0 : iDataCount;
        hCrUserDataCountOnSite.put(_sCrUserName, new Integer(nDataCountOnSite += _nDataCountOfChannel));
    }
}

