/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.components.metadata.center.IMetaDataFieldValueCreator;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class GovInfoIndexCreator
implements IMetaDataFieldValueCreator {
    private static Logger logger = Logger.getLogger(GovInfoIndexCreator.class);

    @Override
    public String getCreatorName() {
        return "\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u76ee\u5f55\u7d22\u5f15\u4ea7\u751f\u5668";
    }

    @Override
    public String[] registerRelateTables() {
        return new String[]{"WCMMetaTableGovInfo", "WCMMetaTablexingzheng", "WCMMetaTableleader", "WCMMetaTabledepartment", "WCMMetaTableguifan", "WCMMetaTableguizhang", "WCMMetaTableGovOpenData"};
    }

    @Override
    public void setFieldValueBeforeSaveMetaData(MetaViewData _oMetaViewData) throws WCMException {
        if (!_oMetaViewData.isAddMode()) {
            return;
        }
        String sIdxID = this.makeIndexId(_oMetaViewData);
        if (sIdxID == null) {
            return;
        }
        _oMetaViewData.setProperty("IdxID", sIdxID);
    }

    @Override
    public void resetFieldValueOnMetaData() throws WCMException {
        String[] pTableName;
        for (String sTableName : pTableName = new String[]{"WCMMetaTableGovInfo", "WCMMetaTableGovOpenData"}) {
            this.resetIndexOfTable(sTableName);
        }
    }

    private void resetIndexOfTable(String _sTableName) throws WCMException {
        String[] pUpdateIndexIdSQL = new String[]{"update " + _sTableName + " set IdxId=? where MetaDataId=?"};
        MetaViewDatas viewDatas = new MetaViewDatas(_sTableName);
        viewDatas.open(null);
        int nSize = viewDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData viewData = (MetaViewData)viewDatas.getAt(i);
            String sIndexId = this.makeIndexId(viewData);
            if (sIndexId == null) continue;
            Object[] pParameters = new Object[]{sIndexId, new Integer(viewData.getId())};
            DBManager.getDBManager().sqlExecuteUpdate(pUpdateIndexIdSQL, pParameters);
        }
    }

    private String makeIndexId(MetaViewData _oMetaViewData) throws WCMException {
        String sCode;
        String sDeptCode = ConfigServer.getServer().getSysConfigValue("DEPARTMENT_CODE", "000014349");
        int nOrgnCat = _oMetaViewData.getPropertyAsInt("OrganCat", 0);
        ClassInfo classInfo = null;
        if (nOrgnCat > 0) {
            classInfo = ClassInfo.findById(nOrgnCat);
        }
        if (classInfo != null && !CMyString.isEmpty(sCode = classInfo.getCode())) {
            sDeptCode = sDeptCode + sCode;
        }
        return sDeptCode + "/" + this.makeIndexIdOfLastRange(_oMetaViewData);
    }

    private boolean equalsDate(String _sDateTime1, String _sDateTime2) {
        String sDate2;
        if (_sDateTime1 == null || _sDateTime2 == null) {
            return false;
        }
        String sDate1 = _sDateTime1.trim();
        int nPos = sDate1.indexOf(" ");
        if (nPos > 0) {
            sDate1 = sDate1.substring(0, nPos);
        }
        if ((nPos = (sDate2 = _sDateTime2.trim()).indexOf(" ")) > 0) {
            sDate2 = sDate2.substring(0, nPos);
        }
        return sDate2.equals(sDate1);
    }

    private String makeIndexIdOfLastRange(MetaViewData _oMetaViewData) throws WCMException {
        String sPubDateFieldName = "PubDate";
        if (DBManager.getDBManager().getFieldInfo(_oMetaViewData.getDbTableName(), "PubDate") == null) {
            sPubDateFieldName = "CrTime";
        }
        String sIdxId = null;
        String sPubDate = _oMetaViewData.getPropertyAsString(sPubDateFieldName);
        if (_oMetaViewData.isAddMode()) {
            if (CMyString.isEmpty(sPubDate)) {
                sPubDate = CMyDateTime.now().toString();
            }
        } else {
            sIdxId = _oMetaViewData.getPropertyAsString("IdxID");
            String sNewPubDate = _oMetaViewData.getNewPropertyAsString(sPubDateFieldName);
            if (sNewPubDate != null && !this.equalsDate(sPubDate, sNewPubDate)) {
                sPubDate = sNewPubDate;
                sIdxId = null;
            }
        }
        if (sPubDate == null || sPubDate.trim().length() == 0) {
            return "";
        }
        if (sIdxId == null) {
            String sDate = sPubDate.substring(0, 4);
            try {
                WCMFilter filter = new WCMFilter(_oMetaViewData.getDbTableName(), sPubDateFieldName + ">=? and " + sPubDateFieldName + "<=?", "MetaDataId Desc", "IdxId");
                filter.setMaxRowNumber(1);
                CMyDateTime dtStartTime = new CMyDateTime();
                dtStartTime.setDateTimeWithString(sDate + "-01-01 00:00:00");
                filter.addSearchValues(dtStartTime);
                CMyDateTime dtEndTime = new CMyDateTime();
                dtEndTime.setDateTimeWithString(sDate + "-12-31 23:59:59");
                filter.addSearchValues(dtEndTime);
                sIdxId = GovInfoIndexCreator.sqlExecuteIntQuery(filter.toSQL(), filter.getSearchValues());
                if (sIdxId == null || sIdxId.length() < 10) {
                    return sPubDate.substring(0, 4) + "-00001";
                }
                sIdxId = sIdxId.substring(sIdxId.length() - 5);
                char cTemp = sIdxId.charAt(0);
                while (cTemp == '\u0000') {
                    sIdxId = sIdxId.substring(1);
                    cTemp = sIdxId.charAt(0);
                }
                sIdxId = "00000" + (Integer.parseInt(sIdxId) + 1);
                return sPubDate.substring(0, 4) + "-" + sIdxId.substring(sIdxId.length() - 5);
            }
            catch (Exception e) {
                logger.error((Object)("\u8ba1\u7b97\u6d41\u6c34\u53f7\u5931\u8d25![PubDate=" + sPubDate + ", ID=" + _oMetaViewData.getId() + "]"), (Throwable)e);
                return "";
            }
        }
        int nPos = sIdxId.lastIndexOf("/");
        if (nPos >= 0) {
            sIdxId = sIdxId.substring(nPos + 1);
        }
        return sIdxId;
    }

    private static String sqlExecuteIntQuery(String _sSQL, List _lParameters) throws WCMException {
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oStmt = oConn.prepareStatement(_sSQL);
            oStmt.setMaxRows(1);
            DBManager.setParameters(oStmt, _lParameters);
            rsData = oStmt.executeQuery();
            if (rsData.next()) {
                String string = rsData.getString(1);
                return string;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + _sSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + _sSQL, ex);
        }
        finally {
            try {
                if (oConn != null) {
                    dbManager.freeConnection(oConn);
                }
                if (oStmt != null) {
                    oStmt.close();
                }
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

