/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataDefCacheMgr
implements IMetaDataDefCacheMgr {
    private static Logger logger = Logger.getLogger(MetaDataDefCacheMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    private String getKey() {
        return MetaDataDefCacheMgr.class.getName();
    }

    @Override
    public synchronized void clear() {
    }

    @Override
    public synchronized boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        cache.set(this.getKey(), "true");
        MetaViewFields viewFields = MetaViewFields.openWCMObjs(null, null);
        int nSize = viewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField viewField = (MetaViewField)viewFields.getAt(i);
            this.putToViewCache(viewField);
        }
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        this.init();
        return true;
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (_oObjAdded instanceof MetaViewField) {
            this.putToViewCache((MetaViewField)_oObjAdded);
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        if (_oObjDeleted instanceof MetaViewField) {
            MetaViewField viewField = (MetaViewField)_oObjDeleted;
            this.removeFromViewCache(viewField);
        } else if (_oObjDeleted instanceof MetaView) {
            this.removeFromViewCache(_oObjDeleted.getId());
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        logger.debug((Object)"The cache of the metaviewfield is updated.");
        if (_oObjModified instanceof MetaViewField) {
            this.putToViewCache((MetaViewField)_oObjModified, true);
        }
    }

    @Override
    public MetaViewField getMetaViewField(int _nViewId, String _sViewFieldName) throws WCMException {
        Integer hkeys = (Integer)cache.hget(this.makeViewKey(new Integer(_nViewId)), _sViewFieldName.toUpperCase());
        if (hkeys == null) {
            return null;
        }
        MetaViewField metaViewField = MetaViewField.findById(hkeys);
        return metaViewField;
    }

    @Override
    public HashMap getMetaViewFields(int _nViewId) throws WCMException {
        Map hViewFields = cache.hgetAll(this.makeViewKey(new Integer(_nViewId)));
        HashMap result = new HashMap();
        for (Map.Entry entry : hViewFields.entrySet()) {
            MetaViewField metaViewField = MetaViewField.findByKey(entry.getValue());
            result.put(entry.getKey(), metaViewField);
        }
        return result;
    }

    @Override
    public Map getMetaViewFields(int viewId, int fieldType) throws WCMException {
        HashMap oMap = this.getMetaViewFields(viewId);
        HashMap oResultMap = new HashMap(oMap.size());
        for (Map.Entry entry : oMap.entrySet()) {
            MetaViewField oViewField = (MetaViewField)entry.getValue();
            if (oViewField.getType() != fieldType) continue;
            oResultMap.put(entry.getKey(), oViewField);
        }
        return oResultMap;
    }

    @Override
    public List getSortedMetaViewFields(int _nViewId) throws WCMException {
        HashMap viewFieldMap = this.getMetaViewFields(_nViewId);
        if (viewFieldMap == null) {
            return null;
        }
        Object[] viewFields = viewFieldMap.values().toArray();
        Arrays.sort(viewFields, new Comparator(){

            public int compare(Object o1, Object o2) {
                MetaViewField field1 = (MetaViewField)o1;
                MetaViewField field2 = (MetaViewField)o2;
                return field2.getOrder() - field1.getOrder();
            }
        });
        return Arrays.asList(viewFields);
    }

    @Override
    public boolean isTitleFieldName(int _nViewId, String _sViewFieldName) throws WCMException {
        MetaViewField viewField = this.getMetaViewField(_nViewId, _sViewFieldName);
        if (viewField == null) {
            return false;
        }
        return viewField.isTitleField();
    }

    @Override
    public boolean isFieldWithType(int _nViewId, String _sViewFieldName, int _nViewFieldType) throws WCMException {
        MetaViewField viewField = this.getMetaViewField(_nViewId, _sViewFieldName);
        if (viewField == null) {
            return false;
        }
        return viewField.getType() == _nViewFieldType;
    }

    @Override
    public boolean isEditorField(MetaViewField _oViewField) throws WCMException {
        if (_oViewField == null) {
            return false;
        }
        int nFieldType = _oViewField.getType();
        if (nFieldType == 12 || nFieldType == 16) {
            return true;
        }
        return nFieldType == 1 && _oViewField.getDBType() == 2005;
    }

    @Override
    public boolean isEditorField(int _nViewId, String _sViewFieldName) throws WCMException {
        MetaViewField viewField = this.getMetaViewField(_nViewId, _sViewFieldName);
        return this.isEditorField(viewField);
    }

    @Override
    public synchronized void reloadViewCache(int _nViewId) throws WCMException {
        this.removeFromViewCache(_nViewId);
        WCMFilter filter = new WCMFilter("", "ViewId=?", "");
        filter.addSearchValues(_nViewId);
        MetaViewFields viewFields = MetaViewFields.openWCMObjs(null, filter);
        int nSize = viewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField viewField = (MetaViewField)viewFields.getAt(i);
            this.putToViewCache(viewField);
        }
    }

    private void putToViewCache(MetaViewField _viewField) throws WCMException {
        this.putToViewCache(_viewField, false);
    }

    private String makeViewKey(int viewId) {
        return this.getKey() + "." + viewId;
    }

    private void putToViewCache(MetaViewField _viewField, boolean _bOnModify) throws WCMException {
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.init();
        }
        Integer iViewKey = new Integer(_viewField.getViewId());
        String sViewKey = this.makeViewKey(iViewKey);
        String sFieldName = null;
        if (_bOnModify) {
            sFieldName = _viewField.getNewPropertyAsString("FieldName");
            if (sFieldName != null) {
                cache.hdel(sViewKey, _viewField.getName().toUpperCase());
            } else {
                sFieldName = _viewField.getName();
            }
        } else {
            sFieldName = _viewField.getName();
        }
        cache.hset(sViewKey, sFieldName.toUpperCase(), _viewField.getKey());
    }

    private void removeFromViewCache(MetaViewField _viewField) {
        if (!cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        Integer iViewKey = new Integer(_viewField.getViewId());
        cache.hdel(this.makeViewKey(iViewKey), _viewField.getName().toUpperCase());
    }

    private void removeFromViewCache(int _nViewId) {
        if (!cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        Integer iKey = new Integer(_nViewId);
        cache.clear(this.makeViewKey(iKey));
    }
}

