/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;

public class TemplateArgument
extends CMSObj {
    public static final int OBJ_TYPE = 957;
    public static final String DB_TABLE_NAME = "WCMTEMPLATEARGUMENT";
    public static final String DB_ID_NAME = "TEMPLATEARGUMENTID";

    public static final TemplateArgument findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (TemplateArgument)BaseObj.findById(TemplateArgument.class, _nId);
    }

    public static final TemplateArgument createNewInstance() throws WCMException {
        return (TemplateArgument)BaseObj.createNewInstance(TemplateArgument.class);
    }

    public static final String makeCacheKey(String sPrefix, String sName) {
        if (sPrefix == null) {
            return sName;
        }
        return sPrefix + ':' + sName;
    }

    public static final TemplateArgument findByKey(Object _oKey) throws WCMException {
        return (TemplateArgument)BaseObj.findByKey(TemplateArgument.class, _oKey);
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 957;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("EMPLOYERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateArgument.class, "TemplateArgument.label1", "\u5c5e\u6027EmployerType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("EMPLOYERID") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateArgument.class, "TemplateArgument.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TEMPLATEID") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateArgument.class, "TemplateArgument.label3", "\u5c5e\u6027TemplateId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("ARGUMENTNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateArgument.class, "TemplateArgument.label4", "\u5c5e\u6027ArgumentName\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("ARGUMENTVALUE") == null) {
                throw new WCMException(1106, I18NMessage.get(TemplateArgument.class, "TemplateArgument.label5", "\u5c5e\u6027ArgumentValue\u6ca1\u6709\u8bbe\u7f6e"));
            }
        }
        return true;
    }

    public String getCacheKey() {
        String sPrefix = this.getPrefixOfName();
        String sName = this.getArgumentName();
        return TemplateArgument.makeCacheKey(sPrefix, sName);
    }

    public int getEmployerType() {
        return this.getPropertyAsInt("EMPLOYERTYPE", 0);
    }

    public int getEmployerId() {
        return this.getPropertyAsInt("EMPLOYERID", 0);
    }

    public IPublishElement getEmployer() throws Exception {
        return PublishElementFactory.lookupElement(this.getEmployerType(), this.getEmployerId());
    }

    public boolean setEmployer(int _nType, int _nId) throws WCMException {
        return this.setProperty("EMPLOYERTYPE", _nType) && this.setProperty("EMPLOYERID", _nId);
    }

    public boolean setEmployer(IPublishElement _employer) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, "Valid employer required!");
        }
        return this.setEmployer(_employer.getType(), _employer.getId());
    }

    public int getTemplateId() {
        return this.getPropertyAsInt("TEMPLATEID", 0);
    }

    public boolean setTemplateId(int _nTemplateId) throws WCMException {
        return this.setProperty("TEMPLATEID", _nTemplateId);
    }

    public Template getTemplate() throws WCMException {
        return Template.findById(this.getTemplateId());
    }

    public boolean setTemplate(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        return this.setTemplateId(_template.getId());
    }

    public String getArgumentName() {
        return this.getPropertyAsString("ARGUMENTNAME");
    }

    public boolean setArgumentName(String _name) throws WCMException {
        return this.setProperty("ARGUMENTNAME", _name);
    }

    public String getArgumentValue() {
        return this.getPropertyAsString("ARGUMENTVALUE");
    }

    public boolean setArgumentValue(String _value) throws WCMException {
        return this.setProperty("ARGUMENTVALUE", _value);
    }

    public boolean setArgumentValue(int _value) throws WCMException {
        return this.setArgumentValue(String.valueOf(_value));
    }

    public boolean setArgumentValue(boolean _value) throws WCMException {
        return this.setArgumentValue(String.valueOf(_value));
    }

    public String getPrefixOfName() {
        return this.getPropertyAsString("PREFIXOFNAME");
    }

    public boolean setPrefixOfName(String _value) throws WCMException {
        return this.setProperty("PREFIXOFNAME", _value);
    }

    public static TemplateArgument findOf(String _sArgName, String _sPrexName) throws WCMException {
        String sWhere = null;
        sWhere = _sPrexName == null || _sPrexName.length() == 0 ? "ARGUMENTNAME=? and PREFIXOFNAME is null" : "ARGUMENTNAME=? and PREFIXOFNAME=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _sArgName);
        if (_sPrexName != null && _sPrexName.length() > 0) {
            filter.addSearchValues(1, _sPrexName);
        }
        filter.setMaxRowNumber(1);
        TemplateArguments templateArguments = TemplateArguments.openWCMObjs(null, filter);
        if (templateArguments.isEmpty()) {
            return null;
        }
        return (TemplateArgument)templateArguments.getAt(0);
    }
}

