/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateXmlConverter;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.PinyinHelper;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.io.File;

public class TemplateExporter {
    private String m_sTempApdName = "";
    private static ObjToXmlConverter m_converter = new ObjToXmlConverter();
    public static final String TEMPLATETYPEINFOS_XMLFILE = "TemplateTypeInfos.xml";

    public String exportToXMLFile(Template _currTemplate) throws WCMException {
        if (_currTemplate == null) {
            throw new WCMException(10, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label1", "\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        TemplateXmlConverter tempConverter = new TemplateXmlConverter();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sTempXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        tempConverter.toXMLFile(_currTemplate, sTempXmlFile);
        return CMyFile.extractFileName(sTempXmlFile);
    }

    public String exportToXMLFile(Templates _currTemplates) throws WCMException {
        if (_currTemplates == null) {
            throw new WCMException(10, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label2", "\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        TemplateXmlConverter tempConverter = new TemplateXmlConverter();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sTempXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        tempConverter.toXMLFile(_currTemplates, sTempXmlFile);
        return CMyFile.extractFileName(sTempXmlFile);
    }

    public String export(Templates _currTemplates) throws WCMException {
        if (_currTemplates == null || _currTemplates.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label3", "\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u6a21\u677f,\u65e0\u6cd5\u5b8c\u6210\u5bfc\u51fa!"));
        }
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String sPath = aFilesMan.getNextFilePathName("ST", "zip");
        CMyZip oMyZip = new CMyZip();
        try {
            Template template;
            BaseChannel baseChannel;
            oMyZip.setEncoding("GBK");
            oMyZip.setZipFileName(sPath);
            Template currTemplate = null;
            String systemName = "";
            String tempNames = "";
            String tempIds = "";
            for (int i = 0; i < _currTemplates.size(); ++i) {
                currTemplate = (Template)_currTemplates.getAt(i);
                this.export(currTemplate, oMyZip);
                tempNames = tempNames + currTemplate.getName() + ",";
                tempIds = tempIds + currTemplate.getId() + ",";
            }
            if (!tempIds.isEmpty()) {
                tempIds = tempIds.substring(0, tempIds.length() - 1);
            }
            if (!tempNames.isEmpty()) {
                tempNames = tempNames.substring(0, tempNames.length() - 1);
            }
            if ((baseChannel = (BaseChannel)BaseChannel.findById((template = (Template)_currTemplates.getAt(0)).getRootType(), template.getRootId())) != null && baseChannel.getId() > 0) {
                systemName = baseChannel.isSite() ? baseChannel.getName() : ((Channel)baseChannel).queryChnlNav();
            }
            SimpleLogServer.operation(LogConstant.Module.EDITORCENTER.desc, LogUserUtil.getLogUser(), "\u5bfc\u51fa\u6a21\u677f", "\u5bfc\u51fa\u6a21\u677f[" + tempNames + "][\u6a21\u677fID=" + tempIds + "]", systemName);
            this.exportTypeInfos(_currTemplates, oMyZip);
            oMyZip.done();
            this.m_sTempApdName = "";
        }
        catch (CMyException ex) {
            try {
                aFilesMan.deleteFile(sPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WCMException(1100, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label4", "\u5bfc\u51fa\u6a21\u677f\u65f6,\u538b\u7f29\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), ex);
        }
        return CMyFile.extractFileName(sPath);
    }

    private void export(Template _currTemplate, CMyZip _oMyZip) throws WCMException, CMyException {
        String sTemplateContent = _currTemplate.getTextWithImgFilter("../site" + _currTemplate.getRootId() + "/", true, false);
        String sTemplateExt = _currTemplate.getOutputFileExt();
        sTemplateExt = sTemplateExt != null && sTemplateExt.length() > 0 ? "." + sTemplateExt : "";
        String sFileName = "temp" + File.separator + PinyinHelper.convert(_currTemplate.getName()) + sTemplateExt;
        try {
            CMyFile.writeFile(sFileName, sTemplateContent, _currTemplate.getCharSet());
        }
        catch (CMyException ex) {
            throw new WCMException(1100, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label5", "\u6839\u636e\u6a21\u677f\u7684\u5185\u5bb9\u521b\u5efa\u76f8\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), ex);
        }
        _oMyZip.addToZip(sFileName, _currTemplate.getName());
        CMyFile.deleteFile(sFileName);
        TempAppendixes aTempApds = _currTemplate.getAppendixes(ContextHelper.getLoginUser());
        String sApdFilePath = FilesMan.getFilesMan().getTemplateAppendixPath(_currTemplate.getRootType(), _currTemplate.getRootId(), 0, true);
        String sTempApdFileName = "";
        for (int i = 0; i < aTempApds.size(); ++i) {
            TempAppendix aTempApd = (TempAppendix)aTempApds.getAt(i);
            if (aTempApd == null || this.m_sTempApdName.indexOf((sTempApdFileName = aTempApd.getFile()) + "*") != -1 || !CMyFile.fileExists(sFileName = sApdFilePath + sTempApdFileName)) continue;
            _oMyZip.addToZip(sFileName);
            this.m_sTempApdName = this.m_sTempApdName + sTempApdFileName + "*";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTypeInfos(Templates _templates, CMyZip _oMyZip) throws CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXmlFile = filesMan.getNextFilePathName("ST", ".xml");
        String sTargetFile = CMyFile.extractFilePath(sXmlFile) + "temp" + System.currentTimeMillis() + File.separator + TEMPLATETYPEINFOS_XMLFILE;
        try {
            m_converter.toXMLFile(_templates, sXmlFile, null, "TempName,TempType,TempExt,OutputFileName,Visual,TempDesc");
            CMyFile.copyFile(sXmlFile, sTargetFile, true);
            _oMyZip.addToZip(sTargetFile, false);
        }
        finally {
            CMyFile.deleteFile(sXmlFile);
            CMyFile.deleteDir(CMyFile.extractFilePath(sTargetFile));
        }
    }
}

