/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.ILaborResourceMgr;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPageTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishProgressMonitor;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PageTaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.ProgressMonitorImpl;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskAnalyzer;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskDispatcherImpl;
import com.trs.components.common.publish.domain.taskdispatch.ThreadPool;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;
import org.aton.util.Counter;

public class PublishTaskWorker
implements Runnable,
IPageTaskDispatcher,
IClearable {
    private static final Logger logger = Logger.getLogger(PublishTaskWorker.class);
    public static final int RUN_INTERVAL = 100;
    private static int threadInitNumber = 1;
    private boolean m_bCanceled = false;
    private PublishTaskAnalyzer m_taskAnalyzer;
    private PublishTaskContext m_taskContext = null;
    private ILaborResourceMgr m_laborResourceMgr;
    private ThreadPool m_oThreadPool;
    private Counter m_busyWorkerCounter;
    private PublishTask m_task = null;
    private int m_nPriority;
    private CMyDateTime m_dtStart = null;
    PageTaskWorker[] m_workers = null;
    private int m_nLaborsApplied;
    private int m_nWorkersCreated;
    private int m_nResult = 10;
    private boolean m_bHasWarnings = false;
    private boolean m_bTaskUpdatedAfterStarted = false;
    private String m_sException = null;
    private IPublishProgressMonitor m_oProgressMonitor = null;
    private PublishTaskDispatcherImpl m_oDispatcherImpl = null;
    private String m_sWorkerName = "PublishTaskWorker-" + PublishTaskWorker.nextThreadNum();
    private boolean m_zStarted;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public PublishTaskWorker() {
        this(null);
    }

    PublishTaskWorker(PublishTaskDispatcherImpl dispatcherImpl) {
        this.m_oThreadPool = (ThreadPool)DreamFactory.createObjectById("PublishThreadPool");
        this.m_laborResourceMgr = (ILaborResourceMgr)DreamFactory.createObjectById("ILaborResourceMgr.Publish");
        this.m_taskAnalyzer = new PublishTaskAnalyzer();
        this.m_taskAnalyzer.setTaskWorker(this);
        this.m_busyWorkerCounter = new Counter();
        this.m_oProgressMonitor = this.newProgressMonitor();
        this.m_oDispatcherImpl = dispatcherImpl;
    }

    public synchronized void clear() {
        this.m_taskAnalyzer.clear();
        if (this.m_taskContext != null) {
            this.m_taskContext.clear();
            this.m_taskContext = null;
        }
        this.m_busyWorkerCounter.reset();
        if (this.m_workers != null) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                if (this.m_workers[i] == null) continue;
                this.m_workers[i].clear();
            }
            this.m_workers = null;
        }
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.clear();
        }
    }

    public void setTask(PublishTask _task) {
        this.m_task = _task;
        this.m_nPriority = this.m_task.getPriority();
        this.m_bTaskUpdatedAfterStarted = false;
        this.m_sException = null;
        this.m_nLaborsApplied = 1;
        this.m_nWorkersCreated = 0;
    }

    public PublishTask getTask() {
        return this.m_task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyzerCanceled() {
        PublishTaskWorker publishTaskWorker = this;
        synchronized (publishTaskWorker) {
            this.m_bCanceled = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        logger.debug((Object)"to cacnel this task ...");
        IClearable iClearable = this;
        synchronized (iClearable) {
            this.m_bCanceled = true;
            this.m_taskAnalyzer.cancel();
            this.notifyAll();
        }
        iClearable = this.m_busyWorkerCounter;
        synchronized (iClearable) {
            this.m_busyWorkerCounter.notifyAll();
        }
        iClearable = this.m_laborResourceMgr;
        synchronized (iClearable) {
            this.m_laborResourceMgr.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label1", "\u7ebf\u7a0b\u542f\u52a8"));
        this.m_dtStart = CMyDateTime.now();
        this.m_nResult = 10;
        try {
            if (this.m_bCanceled) {
                return;
            }
            logger.debug((Object)("Task[" + this.m_task.getId() + "] is started ..."));
            if (this.m_oDispatcherImpl != null) {
                this.m_oDispatcherImpl.onWorkerStartup(this);
            }
            ContextHelper.setLoginUser(User.getSystem());
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label2", "\u5f00\u59cb\u5206\u89e3\u4efb\u52a1"));
            this.m_taskAnalyzer.start(this.m_task);
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label3", "\u4efb\u52a1\u5206\u89e3\u7ed3\u675f"));
            int nPageTaskCount = this.m_taskAnalyzer.getPageTaskCount();
            if (nPageTaskCount == 0) {
                this.m_nResult = 7;
                return;
            }
            if (this.m_bCanceled) {
                return;
            }
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label4", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u6b63\u5728\u6267\u884c"));
            this.updateTaskWhenStarted();
            int nWorkersMaxNeed = this.m_laborResourceMgr.calMaxLaborNeeded(nPageTaskCount, this.m_nPriority);
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label5", "\u9700\u8981\u6267\u884c\u7ebf\u7a0b") + nWorkersMaxNeed + I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label6", "\u4e2a"));
            if (nWorkersMaxNeed > this.m_nLaborsApplied) {
                this.m_nLaborsApplied += this.m_laborResourceMgr.applyForLabor(nWorkersMaxNeed - this.m_nLaborsApplied, this.m_nPriority);
            }
            logger.debug((Object)("Task[" + this.m_task.getId() + "] applied labors total: " + this.m_nLaborsApplied));
            this.m_workers = new PageTaskWorker[nWorkersMaxNeed];
            this.m_busyWorkerCounter.reset();
            this.createWorkers(this.m_nLaborsApplied);
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label7", "\u521b\u5efa\u6267\u884c\u7ebf\u7a0b") + this.m_nWorkersCreated + I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label6", "\u4e2a"));
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label8", "\u7b49\u5f85\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
            while (this.m_busyWorkerCounter.value() > 0) {
                if (this.m_bCanceled) {
                    return;
                }
                if (this.m_nLaborsApplied > 0 && nWorkersMaxNeed <= this.m_nLaborsApplied * 2 || this.m_taskAnalyzer.getWaitingPageTaskCount() <= this.m_nLaborsApplied * 2) {
                    PublishTaskWorker.waitOn(this.m_busyWorkerCounter);
                    continue;
                }
                int nNewApplied = this.m_laborResourceMgr.applyForLabor(nWorkersMaxNeed - this.m_nLaborsApplied, this.m_nPriority);
                if (nNewApplied <= 0) {
                    PublishTaskWorker.waitOn(this.m_laborResourceMgr);
                    continue;
                }
                this.m_nLaborsApplied += nNewApplied;
                logger.debug((Object)("Task[" + this.m_task.getId() + "] new applied labors: " + nNewApplied));
                this.createWorkers(nNewApplied);
                this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label9", "\u8865\u5145\u521b\u5efa\u6267\u884c\u7ebf\u7a0b\u81f3") + this.m_nWorkersCreated + I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label6", "\u4e2a"));
            }
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label10", "\u6267\u884c\u7ebf\u7a0b\u5168\u90e8\u7ed3\u675f"));
            if (!this.m_bCanceled) {
                this.m_sException = this.m_taskAnalyzer.getErrors();
                this.m_nResult = this.m_sException != null ? 9 : (this.m_bHasWarnings ? 6 : 7);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"failed to execute publish task!", (Throwable)ex);
            this.m_sException = CMyException.getStackTraceText(ex);
            this.m_nResult = ex instanceof CMyException && ((CMyException)ex).getErrNo() == 10 ? 11 : 9;
        }
        finally {
            if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
            }
            if (this.m_bCanceled) {
                this.m_sException = this.m_taskAnalyzer.getErrors();
            }
            if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
                logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                    this.m_workers[i].cancel();
                }
            }
            if (this.m_busyWorkerCounter.value() > 0) {
                this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                while (this.m_busyWorkerCounter.value() > 0) {
                    try {
                        this.m_busyWorkerCounter.wait(400L);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (this.m_oDispatcherImpl != null) {
                this.m_oDispatcherImpl.onWorkerCleanup(this);
            }
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
            this.updateTaskWhenFinished();
            this.sendNotificationAfterTaskExecuted();
            this.clear();
            ContextHelper.clear();
            ContextHelper.setLoginUser(User.getSystem());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOn(Object _object) {
        Object object = _object;
        synchronized (object) {
            try {
                _object.wait(400L);
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void createWorkers(int _nCount) {
        for (int i = 0; i < _nCount; ++i) {
            PageTaskWorker worker;
            if (this.m_bCanceled) {
                return;
            }
            if (this.m_taskContext == null) {
                this.m_taskContext = new PublishTaskContext(this.m_task, this.m_taskAnalyzer.getFolder());
            }
            if (!this.m_oThreadPool.runIt(worker = new PageTaskWorker(this, this.m_taskContext, this.newProgressMonitor()))) {
                worker.start();
            }
            this.m_workers[this.m_nWorkersCreated++] = worker;
            this.m_busyWorkerCounter.add(1);
        }
    }

    private void updateTaskWhenStarted() {
        try {
            IPublishTaskMgr mgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
            this.m_task.canEdit(ContextHelper.getLoginUser());
            this.m_task.setPageTaskCount(this.m_taskAnalyzer.getPageTaskCount());
            this.m_task.setStartTime(this.m_dtStart);
            this.m_task.setStatus(5);
            mgr.save(this.m_task);
            this.m_bTaskUpdatedAfterStarted = true;
        }
        catch (Exception ex) {
            logger.error((Object)("Task[" + this.m_task.getId() + "]: failed to update task record when started."), (Throwable)ex);
        }
    }

    private void updateTaskWhenFinished() {
        try {
            IPublishTaskMgr mgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
            this.m_task.canEdit(ContextHelper.getLoginUser());
            CMyDateTime dtEnd = CMyDateTime.now();
            if (!this.m_bTaskUpdatedAfterStarted) {
                this.m_task.setPageTaskCount(this.m_taskAnalyzer.getPageTaskCount());
                this.m_task.setStartTime(this.m_dtStart);
            }
            this.m_task.setEndTime(dtEnd);
            this.m_task.setTimeUsed((int)(dtEnd.getTimeInMillis() - this.m_dtStart.getTimeInMillis()));
            this.m_task.setStatus(this.m_nResult);
            this.m_task.setHasWarnings(this.m_bHasWarnings);
            if (this.m_sException != null) {
                this.m_task.setAnalyzeError(this.m_sException);
            }
            if (this.m_nResult == 7 || this.m_nResult == 6) {
                try {
                    this.m_task.setURL(PublishTaskWorker.getTaskPreviewURL(this.m_task));
                }
                catch (Exception e) {
                    this.m_task.setURL(new String[0]);
                }
            }
            this.m_task.setDetailPageCount(this.getDetailPageCount());
            this.m_task.setOutlinePageCount(this.getOutlinePageCount());
            mgr.save(this.m_task);
        }
        catch (Exception ex) {
            logger.error((Object)("Task[" + this.m_task.getId() + "]: failed to update task when finished."), (Throwable)ex);
        }
    }

    private void sendNotificationAfterTaskExecuted() {
        try {
            String sEvent;
            switch (this.m_nResult) {
                case 7: {
                    sEvent = "Publish.WhenTaskFinished";
                    break;
                }
                case 6: {
                    sEvent = "Publish.WhenTaskFinishedWithWarning";
                    break;
                }
                default: {
                    sEvent = "Publish.WhenTaskFailed";
                }
            }
            if (NotificationServer.getInstance().needNotifyForEvent(sEvent)) {
                Notifier notifier = new Notifier();
                notifier.setParameter("title", this.m_task.getTitle());
                notifier.setParameter("Id", String.valueOf(this.m_task.getId()));
                notifier.setParameter("Submitter", this.m_task.getCrUserName());
                notifier.executeOnEvent(sEvent);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Task[" + this.m_task.getId() + "]: failed to send notification after task is executed."), (Throwable)ex);
        }
    }

    @Override
    public IPageTask getNextPageTask() {
        return this.m_taskAnalyzer.getNextPageTask();
    }

    @Override
    public void notifyPageTaskFinished(IPageTask _task) {
        this.m_taskAnalyzer.notifyPageTaskFinished(_task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPageTaskWorkerFinished(int _nResult) {
        this.m_busyWorkerCounter.minus(1);
        this.m_laborResourceMgr.releaseLabor(1, this.m_nPriority);
        IClearable iClearable = this;
        synchronized (iClearable) {
            --this.m_nLaborsApplied;
        }
        if (_nResult == 9) {
            this.m_nResult = 9;
            this.cancel();
        } else {
            if (_nResult == 6 && !this.m_bHasWarnings) {
                this.m_bHasWarnings = true;
            }
            if (this.m_busyWorkerCounter.value() <= 0) {
                iClearable = this.m_busyWorkerCounter;
                synchronized (iClearable) {
                    this.m_busyWorkerCounter.notifyAll();
                    logger.debug((Object)"m_busyWorkerCounter.notifyAll");
                }
                iClearable = this.m_laborResourceMgr;
                synchronized (iClearable) {
                    this.m_laborResourceMgr.notifyAll();
                    logger.debug((Object)"m_laborResourceMgr.notifyAll");
                }
            }
        }
        logger.debug((Object)("TaskId=" + this.m_task.getId() + ", Result=" + _nResult + "->" + this.m_nResult + ", busyWorkerCount=" + this.m_busyWorkerCounter.value()));
    }

    private static String[] getTaskPreviewURL(PublishTask _task) throws WCMException {
        String[] sPreviewURL;
        block6: {
            PublishPathCompass compass;
            IPublishFolder m_folder;
            block5: {
                m_folder = _task.getFolder();
                if (m_folder == null) {
                    throw new WCMException(200006, "Publish folder is not found: Type=" + _task.getFolderType() + ", Id=" + _task.getFolderId());
                }
                sPreviewURL = null;
                compass = new PublishPathCompass();
                if (!_task.isPublishContent()) break block5;
                IPublishElements publishElements = _task.getContents();
                if (publishElements == null) break block6;
                sPreviewURL = new String[publishElements.size()];
                int nSize = publishElements.size();
                for (int i = 0; i < nSize; ++i) {
                    IPublishContent element = (IPublishContent)publishElements.get(i);
                    if (element == null) continue;
                    element.setFolder(m_folder);
                    sPreviewURL[i] = compass.getPublishHttpUrl(element, 0);
                }
                break block6;
            }
            Templates templates = m_folder.getOutlineTemplates();
            if (templates == null || templates.isEmpty()) {
                throw new WCMException(230, "Outline templates required for current folder: " + m_folder.getInfo());
            }
            sPreviewURL = new String[templates.size()];
            TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            int nSize = templates.size();
            for (int i = 0; i < nSize; ++i) {
                String temp;
                Template template = (Template)templates.getAt(i);
                String sFileName = template.getOutputFileName();
                if (!template.equals(employMgr.getDefaultOutlineTemplate(m_folder)) && !"true".equals((temp = ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false")).toLowerCase())) {
                    sFileName = sFileName + "_" + template.getId();
                }
                sPreviewURL[i] = compass.getPublishHttpPath(m_folder) + sFileName + '.' + template.getOutputFileExt();
            }
        }
        return sPreviewURL;
    }

    public void log2Monitor(String msg) {
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.info(msg);
        }
    }

    private IPublishProgressMonitor newProgressMonitor() {
        return new ProgressMonitorImpl();
    }

    public IPublishProgressMonitor getProgressMonitor() {
        return this.m_oProgressMonitor;
    }

    public Iterator allProgressMonitor() {
        Iterator itr = new Iterator(){
            private int m_iIndex = -1;

            @Override
            public boolean hasNext() {
                return this.m_iIndex < PublishTaskWorker.this.m_nWorkersCreated;
            }

            public Object next() {
                if (this.m_iIndex < PublishTaskWorker.this.m_nWorkersCreated) {
                    IPublishProgressMonitor monitor = null;
                    monitor = this.m_iIndex < 0 ? PublishTaskWorker.this.m_oProgressMonitor : PublishTaskWorker.this.m_workers[this.m_iIndex].getProgressMonitor();
                    ++this.m_iIndex;
                    return monitor;
                }
                return null;
            }

            @Override
            public void remove() {
            }
        };
        return itr;
    }

    public int getDetailPageCount() {
        return this.m_taskContext == null ? 0 : this.m_taskContext.getDetailPageCount();
    }

    public int getOutlinePageCount() {
        return this.m_taskContext == null ? 0 : this.m_taskContext.getOutlinePageCount();
    }

    public String getName() {
        return this.m_sWorkerName;
    }

    public void start() {
        if (!this.m_zStarted) {
            new Thread(this).start();
            this.m_zStarted = true;
        }
    }
}

