/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.taskdispatch.BatchDetailPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.PageDestoryTask;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.SinglePageTask;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;
import org.aton.container.IQueue;
import org.aton.container.QueueLinkImpl;

public class PublishTaskAnalyzer
implements IClearable {
    private boolean m_bTaskElementIsRoot = false;
    private static final Logger logger = Logger.getLogger((String)PublishTaskAnalyzer.class.getName());
    public static int RUN_INTERVAL = 100;
    private boolean m_bNewPublishRootModal = false;
    private IPublishFolder m_folder = null;
    private IQueue m_detailPageTaskQueue;
    private BatchDetailPageTask m_currBatchDetailPageTask = null;
    private IQueue m_outlinePageTaskQueue;
    private int m_nPageTaskCount = 0;
    private int m_nDetailPageTaskCount = 0;
    private boolean m_bCanceled = false;
    private Map m_hmExistsOutlineTask = null;
    private String m_sErrors = null;
    private PublishTaskWorker m_oTaskWorker;
    private boolean m_bIsDebugEnabled = logger.isDebugEnabled();

    public PublishTaskAnalyzer() {
        this.m_detailPageTaskQueue = new QueueLinkImpl();
        this.m_outlinePageTaskQueue = new QueueLinkImpl();
        this.m_hmExistsOutlineTask = new HashMap();
    }

    public IPublishFolder getFolder() {
        return this.m_folder;
    }

    public int getPageTaskCount() {
        return this.m_nPageTaskCount;
    }

    public int getWaitingPageTaskCount() {
        return this.m_outlinePageTaskQueue.size() + this.m_detailPageTaskQueue.size();
    }

    void setTaskWorker(PublishTaskWorker taskWorker) {
        this.m_oTaskWorker = taskWorker;
    }

    public boolean isCanceld() {
        return this.m_bCanceled;
    }

    public String getErrors() {
        return this.m_sErrors;
    }

    public void clear() {
        if (this.m_folder != null) {
            this.m_folder = null;
        }
        if (this.m_nPageTaskCount > 0) {
            this.m_detailPageTaskQueue.clear();
            if (this.m_currBatchDetailPageTask != null) {
                this.m_currBatchDetailPageTask.clear();
                this.m_currBatchDetailPageTask = null;
            }
            this.m_outlinePageTaskQueue.clear();
            this.m_nPageTaskCount = 0;
            this.m_nDetailPageTaskCount = 0;
        }
        if (this.m_bCanceled) {
            this.m_bCanceled = false;
        }
        if (this.m_sErrors != null) {
            this.m_sErrors = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        logger.info((Object)"cancle the analyzer...");
        PublishTaskAnalyzer publishTaskAnalyzer = this;
        synchronized (publishTaskAnalyzer) {
            this.m_bCanceled = true;
            this.notifyAll();
        }
        publishTaskAnalyzer = this.m_detailPageTaskQueue;
        synchronized (publishTaskAnalyzer) {
            this.m_detailPageTaskQueue.notifyAll();
        }
        publishTaskAnalyzer = this.m_outlinePageTaskQueue;
        synchronized (publishTaskAnalyzer) {
            this.m_outlinePageTaskQueue.notifyAll();
        }
    }

    public void start(PublishTask _task) throws Exception {
        this.clear();
        int nFolderType = _task.getFolderType();
        int nFolderId = _task.getFolderId();
        this.m_folder = (IPublishFolder)PublishElementFactory.lookupElement(nFolderType, nFolderId);
        if (this.m_folder == null) {
            throw new WCMException(200006, "Publish folder is not found: Type=" + nFolderType + ", Id=" + nFolderId);
        }
        this.m_bTaskElementIsRoot = this.m_folder.isRoot();
        logger.debug((Object)("to analyze publish task [" + _task.getId() + "]: " + _task.getTitle()));
        switch (_task.getPublishType()) {
            case 1: {
                this.analyzeFolderIncreasingPublishTask();
                if (!this.m_folder.isRoot()) break;
                logger.info((Object)(this.m_folder.getInfo() + " Anallyze End!"));
                break;
            }
            case 2: {
                if (this.m_folder.isRoot()) {
                    this.analyzeRootFullyPublishTask();
                    break;
                }
                this.analyzeFolderFullyPublishTask();
                break;
            }
            case 5: 
            case 12: {
                this.analyzeFolderRefreshPublishTask();
                break;
            }
            case 3: {
                this.analyzeContentPublishTask(_task);
                break;
            }
            case 8: {
                if (_task.isPublishContent()) {
                    this.analyzeContentSelfPublishTask(_task);
                    break;
                }
                this.analyzeFolderSelfPublishTask();
                break;
            }
            case 7: {
                if (_task.isPublishContent()) {
                    this.addDetoryPagesTask(_task);
                    break;
                }
                this.addDetoryFolderTask(_task.getFolder());
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.analyzeContentDirectTask(_task);
                break;
            }
            case 13: {
                this.analyzePublishedContentPublishTask(_task);
                break;
            }
            default: {
                throw new WCMException(228, "Unknonw publish type: " + _task.getPublishType());
            }
        }
        if (this.m_bIsDebugEnabled) {
            logger.debug((Object)("Finish analyzing:" + this.m_nPageTaskCount + " page tasks have been created for publish task[" + _task.getId() + "]: " + _task.getTitle()));
        }
    }

    private synchronized IPageTask nextDetailTask() {
        if (this.m_bCanceled) {
            return null;
        }
        IPageTask task = null;
        while (true) {
            if (this.m_currBatchDetailPageTask != null) {
                try {
                    task = this.m_currBatchDetailPageTask.getNext();
                }
                catch (Exception ex) {
                    this.m_bCanceled = true;
                    if (this.m_oTaskWorker != null) {
                        this.m_oTaskWorker.analyzerCanceled();
                    }
                    this.m_sErrors = CMyException.getStackTraceText(ex);
                    this.m_currBatchDetailPageTask.clear();
                    this.m_currBatchDetailPageTask = null;
                    return null;
                }
                if (task == null) {
                    this.m_currBatchDetailPageTask.clear();
                    this.m_currBatchDetailPageTask = null;
                    --this.m_nDetailPageTaskCount;
                } else {
                    ++this.m_nDetailPageTaskCount;
                    break;
                }
            }
            if (this.m_bCanceled) {
                return null;
            }
            task = (IPageTask)this.m_detailPageTaskQueue.pop();
            if (task == null) {
                return null;
            }
            if (!task.isBatch()) break;
            this.m_currBatchDetailPageTask = (BatchDetailPageTask)task;
        }
        return this.m_bCanceled ? null : task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPageTask getNextPageTask() {
        IPageTask task = this.nextDetailTask();
        if (task != null) {
            return task;
        }
        if (this.m_bCanceled) {
            return null;
        }
        while (this.m_nDetailPageTaskCount > 0 && !this.m_bCanceled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("to wait for all detail pages to be generated: left=" + this.m_nDetailPageTaskCount));
            }
            PublishTaskAnalyzer publishTaskAnalyzer = this;
            synchronized (publishTaskAnalyzer) {
                if (this.m_nDetailPageTaskCount > 0 && !this.m_bCanceled) {
                    try {
                        this.wait(400L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.m_bCanceled ? null : (IPageTask)this.m_outlinePageTaskQueue.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPageTaskFinished(IPageTask _pageTask) {
        if (!_pageTask.getPublishElement().isFolder()) {
            PublishTaskAnalyzer publishTaskAnalyzer = this;
            synchronized (publishTaskAnalyzer) {
                --this.m_nDetailPageTaskCount;
                if (this.m_nDetailPageTaskCount <= 0) {
                    logger.debug((Object)"all detail page tasks have finished; to notify all...");
                    this.notifyAll();
                }
            }
            logger.debug((Object)("DetailPageTask left: " + this.m_nDetailPageTaskCount));
        }
    }

    private void analyzeFolderIncreasingPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label2", "]\u7684\u589e\u91cf\u53d1\u5e03..."));
        IPublishElements contents = null;
        try {
            this.addBatchDetailPageTask(this.m_folder, false);
            IPublishElements children = this.m_folder.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                IPublishFolder myself = this.m_folder;
                this.m_folder = (IPublishFolder)children.get(i);
                this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label3", "\u5f00\u59cb\u5206\u89e3\u5b50\u8282\u70b9[") + this.m_folder.getInfo() + "]");
                if (this.m_folder != null && this.m_folder.getDataPath() != null && this.m_folder.getDataPath().length() > 0) {
                    this.analyzeFolderIncreasingPublishTask();
                }
                this.m_folder = myself;
            }
        }
        catch (Exception ex) {
            throw new WCMException(229, "Failed to anaylze the increased contents and children publish tasks!", ex);
        }
        finally {
            if (contents != null) {
                contents.clear();
            }
        }
        this.analyzeFolderRefreshPublishTask();
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label4", "]\u7684\u589e\u91cf\u53d1\u5e03\u7ed3\u675f\uff01"));
    }

    private void analyzeRootFullyPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label5", "]\u7684\u5b8c\u5168\u53d1\u5e03"));
        if (this.m_bNewPublishRootModal && this.m_folder.canDoBatchDetailPageTask()) {
            BatchDetailPageTask task = new BatchDetailPageTask(this.m_folder, true, 2);
            this.m_detailPageTaskQueue.push((Object)task);
            ++this.m_nDetailPageTaskCount;
            ++this.m_nPageTaskCount;
        }
        this.putChildrenToOutlinePageTask(this.m_folder);
    }

    private void putChildrenToOutlinePageTask(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            return;
        }
        if (!this.m_bNewPublishRootModal) {
            this.addBatchDetailPageTask(_folder, true);
        }
        if (!this.isStorageFolder(_folder)) {
            return;
        }
        IPublishElements children = _folder.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            IPublishFolder folder = (IPublishFolder)children.get(i);
            if (folder == null) continue;
            this.putChildrenToOutlinePageTask(folder);
        }
        if (_folder.isValidElement()) {
            this.addOutlinePageTask(_folder);
        }
    }

    private void analyzeFolderFullyPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label5", "]\u7684\u5b8c\u5168\u53d1\u5e03"));
        IPublishElements contents = null;
        try {
            this.addBatchDetailPageTask(this.m_folder, true);
            IPublishElements children = this.m_folder.getChildren();
            int nChildrenCount = children == null ? 0 : children.size();
            for (int i = 0; i < nChildrenCount; ++i) {
                IPublishFolder myself = this.m_folder;
                this.m_folder = (IPublishFolder)children.get(i);
                if (this.m_folder != null && this.m_folder.getDataPath() != null && this.m_folder.getDataPath().length() > 0) {
                    this.analyzeFolderFullyPublishTask();
                }
                this.m_folder = myself;
            }
        }
        catch (Exception ex) {
            throw new WCMException(229, "Failed to anaylze the contents and children publish task for all the contents.", ex);
        }
        finally {
            if (contents != null) {
                contents.clear();
            }
        }
        this.analyzeFolderRefreshPublishTask();
    }

    private void analyzeFolderRefreshPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label6", "]\u7684\u66f4\u65b0\u53d1\u5e03..."));
        if (!this.m_folder.isValidElement()) {
            this.log2Monitor("[" + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label7", "]\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u53d1\u5e03\uff01"));
            return;
        }
        this.addOutlinePageTask(this.m_folder);
        if (this.m_bTaskElementIsRoot) {
            this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label8", "\u5206\u89e3R[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label9", "]\u7684\u66f4\u65b0\u53d1\u5e03\u7ed3\u675f\uff01"));
            return;
        }
        Collection quoters = null;
        try {
            quoters = this.m_folder.getFoldersQuotingMe();
            if (quoters != null && !quoters.isEmpty()) {
                for (IPublishFolder aQuoter : quoters) {
                    if (aQuoter == null || !aQuoter.isValidElement()) continue;
                    this.addOutlinePageTask(aQuoter);
                }
            }
        }
        catch (Exception ex) {
            throw new WCMException(222, "Failed to analyze the outline page taks for the quoting folders.", ex);
        }
        finally {
            if (quoters != null) {
                quoters.clear();
            }
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label9", "]\u7684\u66f4\u65b0\u53d1\u5e03\u7ed3\u675f\uff01"));
    }

    private void analyzeFolderSelfPublishTask() throws Exception {
        this.addOutlinePageTask(this.m_folder);
    }

    private void analyzeContentPublishTask(PublishTask _task) throws Exception {
        this.analyzeContentSelfPublishTask(_task);
        this.analyzeFolderRefreshPublishTask();
    }

    private void analyzeContentSelfPublishTask(PublishTask _task) throws Exception {
        IPublishElements contents = PublishElementFactory.lookupElements(_task.getContentType(), _task.getContentIds());
        if (this.m_folder != null) {
            int nSize = contents.size();
            for (int i = 0; i < nSize; ++i) {
                IPublishContent content = (IPublishContent)contents.get(i);
                if (content == null) continue;
                content.setFolder(this.m_folder);
            }
        }
        this.addDetailPageTasks(contents);
    }

    private SinglePageTask addDetailPageTask(IPublishContent _content) {
        if (_content.getFolder() == null) {
            _content.setFolder(this.m_folder);
        }
        SinglePageTask task = new SinglePageTask(_content);
        this.m_detailPageTaskQueue.push((Object)task);
        ++this.m_nDetailPageTaskCount;
        ++this.m_nPageTaskCount;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("A page task is created: " + task.getInfo()));
        }
        return task;
    }

    private BatchDetailPageTask addBatchDetailPageTask(IPublishFolder _folder, boolean _bPublishAll) {
        if (!_folder.canDoBatchDetailPageTask()) {
            return null;
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + _folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label11", "]\u7684\u6279\u91cf\u7ec6\u89c8\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217\uff0c\u5b8c\u5168=") + _bPublishAll);
        BatchDetailPageTask task = new BatchDetailPageTask(_folder, _bPublishAll);
        this.m_detailPageTaskQueue.push((Object)task);
        ++this.m_nDetailPageTaskCount;
        ++this.m_nPageTaskCount;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("A page task is created: " + task.getInfo()));
        }
        return task;
    }

    private void addBatchDetailPageForPublishedContentsTask(IPublishFolder _folder, boolean _bPublishALL, PublishTask _task) throws Exception {
        if (!_folder.canDoBatchDetailPageTask()) {
            return;
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + _folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label11", "]\u7684\u6279\u91cf\u7ec6\u89c8\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217\uff0c\u5b8c\u5168=") + _bPublishALL + ",\u53ea\u53d1\u5e03\u5df2\u53d1\u7684\u6587\u6863");
        WCMFilter filter = new WCMFilter("", "", "");
        String sStartDocCrtime = _task.getAttributeValue("StartDocCrtime");
        String sEndDocCrtime = _task.getAttributeValue("EndDocCrtime");
        String sWhere = "";
        if (!CMyString.isEmpty(sStartDocCrtime)) {
            CMyDateTime startTime = new CMyDateTime();
            startTime.setDateTimeWithString(sStartDocCrtime);
            sWhere = sWhere + "WCMCHNLDOC.CRTIME >= ?";
            filter.addSearchValues(startTime);
        }
        if (!CMyString.isEmpty(sEndDocCrtime)) {
            CMyDateTime endTime = new CMyDateTime();
            endTime.setDateTimeWithString(sEndDocCrtime);
            sWhere = CMyString.isEmpty(sWhere) ? sWhere + "WCMCHNLDOC.CRTIME <= ?" : sWhere + " AND WCMCHNLDOC.CRTIME <= ?";
            filter.addSearchValues(endTime);
        }
        filter.setWhere(sWhere);
        IPublishElements contents = _folder.getPublishedContents(filter);
        if (contents == null) {
            return;
        }
        if (this.m_folder != null) {
            int nSize = contents.size();
            for (int i = 0; i < nSize; ++i) {
                IPublishContent content = (IPublishContent)contents.get(i);
                if (content == null) continue;
                content.setFolder(this.m_folder);
            }
        }
        this.addDetailPageTasks(contents);
    }

    private SinglePageTask addOutlinePageTask(IPublishFolder _folder) {
        if (this.isExistsOutlinePageTask(_folder)) {
            return null;
        }
        if (!_folder.canDoOutlinePageTask()) {
            return null;
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + _folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label12", "]\u7684\u6982\u89c8\u9875\u9762\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217..."));
        SinglePageTask task = new SinglePageTask(_folder);
        this.m_outlinePageTaskQueue.push((Object)task);
        ++this.m_nPageTaskCount;
        this.m_hmExistsOutlineTask.put(this.makeFolderKey(_folder), "");
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + _folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label13", "]\u7684\u6982\u89c8\u9875\u9762\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217\u7ed3\u675f!"));
        logger.debug((Object)("A page task is created: " + task.getInfo()));
        return task;
    }

    private void addDetoryFolderTask(IPublishFolder _folder) {
        if (_folder == null) {
            return;
        }
        PageDestoryTask task = new PageDestoryTask(_folder);
        this.m_outlinePageTaskQueue.push((Object)task);
        ++this.m_nPageTaskCount;
    }

    private void addDetoryPagesTask(PublishTask _task) throws Exception {
        this.analyzeFolderRefreshPublishTask();
        IPublishElements folders = _task.getFolders();
        if (folders != null) {
            IPublishFolder oldfolder = this.m_folder;
            for (int i = folders.size() - 1; i >= 0; --i) {
                IPublishElement element = folders.get(i);
                if (element == null) continue;
                this.m_folder = (IPublishFolder)element;
                this.analyzeFolderRefreshPublishTask();
            }
            this.m_folder = oldfolder;
        }
    }

    private void addDetailPageTasks(IPublishElements _contents) throws Exception {
        if (_contents == null || _contents.isEmpty()) {
            return;
        }
        for (int i = 0; i < _contents.size(); ++i) {
            IPublishContent aContent = (IPublishContent)_contents.get(i);
            this.addDetailPageTask(aContent);
        }
    }

    private boolean isExistsOutlinePageTask(IPublishFolder _folder) {
        return this.m_hmExistsOutlineTask.containsKey(this.makeFolderKey(_folder));
    }

    private Object makeFolderKey(IPublishElement _folder) {
        return _folder.getType() + "_" + _folder.getId();
    }

    private boolean isStorageFolder(IPublishFolder _folder) {
        try {
            String sDataPath;
            FolderPublishConfig config = FolderPublishConfig.findOf(_folder);
            if (config != null && (sDataPath = config.getDataPath()) != null && sDataPath.length() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void log2Monitor(String msg) {
        if (this.m_oTaskWorker != null) {
            this.m_oTaskWorker.log2Monitor(msg);
        }
    }

    private void analyzeContentDirectTask(PublishTask _task) throws Exception {
        IPublishElements contents = _task.getContents();
        if (contents.isEmpty()) {
            return;
        }
        IPublishElements folders = null;
        IPublishContent content = (IPublishContent)contents.get(0);
        if (content.getType() == 605) {
            HashMap<Integer, String> mapFoldersDowith = new HashMap<Integer, String>();
            int nSize = contents.size();
            for (int nContentIndex = 0; nContentIndex < nSize; ++nContentIndex) {
                IPublishFolder folder;
                int i;
                content = (IPublishContent)contents.get(nContentIndex);
                IPublishElements foldersQuoteContent = this.makeFoldersUseContent(content);
                if (folders == null) {
                    folders = foldersQuoteContent;
                } else {
                    for (i = foldersQuoteContent.size() - 1; i >= 0; --i) {
                        folder = (IPublishFolder)foldersQuoteContent.get(i);
                        Integer keyFolder = folder.getSubstance().getKey();
                        if (mapFoldersDowith.containsKey(keyFolder)) continue;
                        mapFoldersDowith.put(keyFolder, "");
                        folders.add(folder);
                    }
                }
                for (i = folders.size() - 1; i >= 0; --i) {
                    folder = (IPublishFolder)folders.get(i);
                    IPublishContent newContent = PublishElementFactory.makeContentFrom(content.getSubstance(), folder);
                    if (newContent.getModal() != 3) continue;
                    contents.add(newContent);
                }
            }
        } else {
            folders = new PublishElementsListImpl();
            folders.add(content.getOriginalHome());
        }
        this.addDetailPageTasks(contents);
        IPublishFolder oldfolder = this.m_folder;
        for (int i = folders.size() - 1; i >= 0; --i) {
            IPublishElement element = folders.get(i);
            if (element == null) continue;
            this.m_folder = (IPublishFolder)element;
            this.analyzeFolderRefreshPublishTask();
        }
        this.m_folder = oldfolder;
    }

    private void analyzePublishedContentPublishTask(PublishTask _task) throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label2", "]\u7684\u589e\u91cf\u53d1\u5e03..."));
        IPublishElements contents = null;
        try {
            this.addBatchDetailPageForPublishedContentsTask(this.m_folder, false, _task);
            IPublishElements children = this.m_folder.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                IPublishFolder myself = this.m_folder;
                this.m_folder = (IPublishFolder)children.get(i);
                this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label3", "\u5f00\u59cb\u5206\u89e3\u5b50\u8282\u70b9[") + this.m_folder.getInfo() + "]");
                if (this.m_folder != null && this.m_folder.getDataPath() != null && this.m_folder.getDataPath().length() > 0) {
                    this.analyzePublishedContentPublishTask(_task);
                }
                this.m_folder = myself;
            }
        }
        catch (Exception ex) {
            throw new WCMException(229, "Failed to anaylze the increased contents and children publish tasks!", ex);
        }
        finally {
            if (contents != null) {
                contents.clear();
            }
        }
        this.analyzeFolderRefreshPublishTask();
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label4", "]\u7684\u589e\u91cf\u53d1\u5e03\u7ed3\u675f\uff01"));
    }

    private IPublishElements makeFoldersUseContent(IPublishContent _content) throws WCMException, Exception {
        PublishElementsListImpl folders = new PublishElementsListImpl();
        Document document = (Document)_content.getSubstance();
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        String sExtraChnlDocWhere = null;
        String sCanDirectPubStatus = ConfigServer.getServer().getSysConfigValue("CAN_DIRECTPUB_STATUS", "-1").trim();
        if (!"-1".equals(sCanDirectPubStatus)) {
            sExtraChnlDocWhere = "WCMChnlDoc.DOCSTATUS in (" + sCanDirectPubStatus + ")";
        }
        Channels channels = documentMgr.getChannels(document, 0, sExtraChnlDocWhere);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            IPublishFolder folder;
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !(folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel)).canDoOutlinePageTask()) continue;
            folders.add(folder);
        }
        return folders;
    }
}

