/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.config;

import com.trs.components.common.publish.config.PublishDistributionTargetType;
import com.trs.components.common.publish.config.PublishElementType;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.config.persistent.LaborResourceConfig;
import com.trs.components.common.publish.config.persistent.PublishDistributionConfig;
import com.trs.components.common.publish.config.persistent.PublishElementConfig;
import com.trs.components.common.publish.config.persistent.PublishServerConfig;
import com.trs.components.common.publish.config.persistent.TargetTypeConfig;
import com.trs.components.common.publish.config.persistent.TemplateParseConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class PublishServerConfigMapper
implements IClearable {
    private static final Logger logger = Logger.getLogger((String)PublishServerConfigMapper.class.getName());
    private int m_nLoadBatchContentsModal = 1;
    private int m_nLoadBatchContentsPageSize = 30;
    private boolean m_bDirDividedByDate = false;
    private boolean m_bPublishInRootPath = false;
    private boolean m_bDetailPageSeperateTo51Style = false;
    private String m_sDirDividedByDateFormat = null;
    private String m_sDirDividedByDateFormatLocal = null;
    private boolean m_bSendWarningIfFileNotFound = true;
    private boolean m_bIgnoreIfHostNotFound = true;
    private boolean m_bAutoPublishDocInHomeWhenNeeded = false;
    private String m_sDefaultEncoding = null;
    private HashMap m_hElementTypes = new HashMap(3);
    private LaborResourceConfig m_oLaborResourceConfig = null;
    private TemplateParseConfig m_oTemplateParseConfig = null;
    private String[] m_arrTemplateTagsHavingSrc = null;
    private String[] m_arrTemplateTagSrcAttributeNames = null;
    private String[] m_arrTemplateSupportedExts = null;
    private String[] m_arrTemplateSupportedApdExts = null;
    private List m_listTagFormattersConfigs = null;
    private PublishDistributionConfig m_oDistributionConfig = null;
    private Map m_hDistributionTargetTypes = new HashMap(2);
    private boolean m_bLoaded = false;
    private static PublishServerConfigMapper s_instance = new PublishServerConfigMapper();
    private static String m_sPublishSrvId;

    private PublishServerConfigMapper() {
        this.m_listTagFormattersConfigs = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublishServerConfigMapper getInstance() throws WCMException {
        if (!s_instance.isLoaded()) {
            PublishServerConfigMapper publishServerConfigMapper = s_instance;
            synchronized (publishServerConfigMapper) {
                if (!s_instance.isLoaded()) {
                    s_instance.refresh();
                }
            }
        }
        return s_instance;
    }

    public boolean isLoaded() {
        return this.m_bLoaded;
    }

    public synchronized void clear() {
        logger.debug((Object)"to clear configuration...");
        this.m_hElementTypes.clear();
        if (this.m_hDistributionTargetTypes != null) {
            this.m_hDistributionTargetTypes.clear();
        }
    }

    public synchronized void refresh() throws WCMException {
        try {
            this.clear();
            if (this.m_bLoaded) {
                this.m_bLoaded = false;
            }
            this.loadCommonPublishConfiguration();
            this.loadDefinedPublishConfiguration();
            this.m_bLoaded = true;
            logger.debug((Object)"publish server config has been loaded successfully!");
        }
        catch (Exception ex) {
            throw new WCMException(12, "Failed to load from the config", ex);
        }
    }

    private void loadDefinedPublishConfiguration() throws WCMException {
        PublishServerConfig[] configs = this.getPublishServerConfig();
        for (int i = 0; i < configs.length; ++i) {
            PublishServerConfig config = configs[i];
            this.loadOneKindOfElementTypes(config.getFolderTypes(), "FolderTypes", true);
            this.loadOneKindOfElementTypes(config.getContentTypes(), "ContentTypes", false);
            this.loadTagFormatters(config.getTagFormatters());
        }
    }

    private void loadTagFormatters(ArrayList tagFormatters) {
        if (tagFormatters == null || tagFormatters.size() == 0) {
            return;
        }
        this.m_listTagFormattersConfigs.addAll(tagFormatters);
    }

    private void loadCommonPublishConfiguration() throws WCMException {
        PublishServerConfig commonConfig = this.getPublishServerConfig("CommonPublishServer");
        this.m_nLoadBatchContentsModal = commonConfig.getLoadBatchContentsModal();
        this.m_nLoadBatchContentsPageSize = commonConfig.getLoadBatchContentsPageSize();
        this.m_bPublishInRootPath = commonConfig.isPublishInRootPath();
        this.m_bDetailPageSeperateTo51Style = commonConfig.isDetailPageSeperateTo51Style();
        this.m_bDirDividedByDate = commonConfig.isDirDividedByDate();
        if (this.m_bDirDividedByDate) {
            this.m_sDirDividedByDateFormat = commonConfig.getDirDividedByDateFormat();
            char fileSperator = File.separatorChar;
            this.m_sDirDividedByDateFormatLocal = fileSperator == '/' ? this.m_sDirDividedByDateFormat.replace('\\', fileSperator) : this.m_sDirDividedByDateFormat.replace('/', fileSperator);
        } else {
            this.m_sDirDividedByDateFormat = null;
            this.m_sDirDividedByDateFormatLocal = null;
        }
        this.m_bSendWarningIfFileNotFound = commonConfig.isSendWarningIfFileNotFound();
        this.m_bIgnoreIfHostNotFound = commonConfig.isIgnoreIfHostNotFound();
        this.m_bAutoPublishDocInHomeWhenNeeded = commonConfig.isAutoPublishDocInHomeWhenNeeded();
        this.m_sDefaultEncoding = commonConfig.getDefaultEncoding();
        this.m_oLaborResourceConfig = commonConfig.getLaborResource();
        this.m_oTemplateParseConfig = commonConfig.getTemplateParse();
        this.loadTemplateParseConfig(commonConfig.getTemplateParse());
        this.m_oDistributionConfig = commonConfig.getPublishDistribution();
        this.loadDistributionConfig(commonConfig.getPublishDistribution());
    }

    private PublishServerConfig getPublishServerConfig(String _sConfigId) {
        logger.debug((Object)"to load publish server config...");
        List configs = XMLConfigServer.getInstance().getConfigObjects(_sConfigId);
        if (configs == null || configs.size() == 0) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label1", "\u6ca1\u6709\u914d\u7f6e!"));
        }
        return (PublishServerConfig)configs.get(0);
    }

    private PublishServerConfig[] getPublishServerConfig() {
        logger.debug((Object)"to load publish server config...");
        List configs = XMLConfigServer.getInstance().getConfigObjects(PublishServerConfig.class);
        if (configs == null || configs.size() == 0) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label2", "\u6ca1\u6709\u5173\u4e8e\u53d1\u5e03\u5c5e\u6027\u7684\u914d\u7f6e!"));
        }
        PublishServerConfig[] result = new PublishServerConfig[configs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (PublishServerConfig)configs.get(i);
        }
        return result;
    }

    private void loadOneKindOfElementTypes(List _subConfigs, String _sNodeName, boolean _bIsFolder) throws WCMException {
        if (_subConfigs == null) {
            String sElementName = _bIsFolder ? "FolderTypeConfig" : "ContentTypeConfig";
            throw new WCMException(152, "config element of " + sElementName + " is not found!");
        }
        if (_subConfigs.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < _subConfigs.size(); ++i) {
                PublishElementType aFactorType = new PublishElementType();
                aFactorType.fromConfigElement((PublishElementConfig)_subConfigs.get(i));
                aFactorType.setIsFolder(_bIsFolder);
                this.m_hElementTypes.put(new Integer(aFactorType.getType()), aFactorType);
            }
        }
        catch (Exception ex) {
            throw new WCMException(150, "Failed to load the element types from XML element " + _sNodeName, ex);
        }
    }

    private void loadTemplateParseConfig(TemplateParseConfig _oConfig) {
        logger.debug((Object)"to load template parse config ...");
        if (this.m_oTemplateParseConfig != null) {
            String sValue = _oConfig.getTagsHavingSrc();
            if (sValue != null) {
                this.m_arrTemplateTagsHavingSrc = CMyString.split(sValue, ",");
            }
            if ((sValue = _oConfig.getTagSrcAttributeNames()) != null) {
                this.m_arrTemplateTagSrcAttributeNames = CMyString.split(sValue, ",");
            }
            if ((sValue = _oConfig.getSupportedExts()) != null) {
                this.m_arrTemplateSupportedExts = CMyString.split(sValue, ",");
            }
            if ((sValue = _oConfig.getSupportedApdExts()) != null) {
                this.m_arrTemplateSupportedApdExts = CMyString.split(sValue, ",");
            }
        }
    }

    private void loadDistributionConfig(PublishDistributionConfig _oDistributionConfig) throws WCMException {
        logger.debug((Object)"to load distribution config ...");
        ArrayList targetTypeConfigs = _oDistributionConfig.getTargetTypes();
        if (targetTypeConfigs != null) {
            for (int i = 0; i < targetTypeConfigs.size(); ++i) {
                PublishDistributionTargetType type = new PublishDistributionTargetType();
                type.fromConfigElement((TargetTypeConfig)targetTypeConfigs.get(i));
                this.m_hDistributionTargetTypes.put(type.getName().toUpperCase(), type);
            }
        }
    }

    public static boolean isDirDividedByDate() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bDirDividedByDate;
    }

    public static boolean isPublishInRootPath() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bPublishInRootPath;
    }

    public static boolean isDetailPageSeperateTo51Style() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bDetailPageSeperateTo51Style;
    }

    public static int getLoadBatchContentsModal() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_nLoadBatchContentsModal;
    }

    public static int getLoadBatchContentsPageSize() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_nLoadBatchContentsPageSize;
    }

    public static String getDirDividedByDateFormat(boolean _bLocalFileSystemFormat) throws WCMException {
        if (_bLocalFileSystemFormat) {
            return PublishServerConfigMapper.getInstance().m_sDirDividedByDateFormatLocal;
        }
        return PublishServerConfigMapper.getInstance().m_sDirDividedByDateFormat;
    }

    public static boolean isSendWarningIfFileNotFound() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bSendWarningIfFileNotFound;
    }

    public static boolean isIgnoreIfHostNotFound() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bIgnoreIfHostNotFound;
    }

    public static boolean isAutoPublishDocInHomeWhenNeeded() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bAutoPublishDocInHomeWhenNeeded;
    }

    public static String getDefaultEncoding() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_sDefaultEncoding;
    }

    public static PublishElementType getElementType(int _nType) throws WCMException {
        return (PublishElementType)PublishServerConfigMapper.getInstance().m_hElementTypes.get(new Integer(_nType));
    }

    public static LaborResourceConfig getLaborResourceConfig() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_oLaborResourceConfig;
    }

    public static TemplateParseConfig getTemplateParseConfig() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_oTemplateParseConfig;
    }

    public static String[] getTemplateTagsHavingSrc() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateTagsHavingSrc;
    }

    public static String[] getTemplateTagSrcAttributeNames() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateTagSrcAttributeNames;
    }

    public static String[] getTemplateSupportedExts() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateSupportedExts;
    }

    public static String[] getTemplateSupportedApdExts() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateSupportedApdExts;
    }

    public static List getTagFormattersConfigs() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_listTagFormattersConfigs;
    }

    public static PublishDistributionConfig getDistributionConfig() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_oDistributionConfig;
    }

    public static Map getDistributionTargetTypes() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_hDistributionTargetTypes;
    }

    public static PublishDistributionTargetType lookupDistributionTargetTypeByName(String _sName) throws WCMException {
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            return null;
        }
        return (PublishDistributionTargetType)PublishServerConfigMapper.getInstance().m_hDistributionTargetTypes.get(_sName.toUpperCase());
    }

    public static String getPublishSrvId() {
        return m_sPublishSrvId;
    }

    public static void setPublishSrvId(String publishSrvId) {
        m_sPublishSrvId = publishSrvId;
        try {
            PublishServerConfigMapper.getInstance().refresh();
        }
        catch (WCMException ex) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label3", "\u8bd5\u56fe\u8bfb\u53d6[") + publishSrvId + I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label4", "]\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u9519") + ex.getMessage(), ex);
        }
    }

    public static FileNamedStyle getDetailFileNamedStyle(String _sFileNamedStyleId) {
        List configs = XMLConfigServer.getInstance().getConfigObjects(_sFileNamedStyleId);
        if (configs == null || configs.size() == 0) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label5", "\u5728\u6ca1\u6709\u627e\u5230\u5173\u8054\u5230[") + _sFileNamedStyleId + I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label6", "]\u5173\u4e8e\u53d1\u5e03\u6587\u4ef6\u547d\u540d\u7684\u914d\u7f6e\u8bbe\u7f6e!"));
        }
        FileNamedStyle result = (FileNamedStyle)configs.get(0);
        return result;
    }

    public static FileNamedStyle getDetailFileNamedStyle() {
        return PublishServerConfigMapper.getDetailFileNamedStyle("CommonFileNamedStyle");
    }
}

