/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.ckm;

import com.trs.DreamFactory;
import com.trs.ckm.soap.ABSHold;
import com.trs.ckm.soap.ABSResult;
import com.trs.ckm.soap.CkmSoapException;
import com.trs.ckm.soap.CollErrorInfoDetail;
import com.trs.ckm.soap.RevDetail;
import com.trs.ckm.soap.RevHold;
import com.trs.ckm.soap.RuleCATField;
import com.trs.ckm.soap.TrsCkmSoapClient;
import com.trs.cms.auth.persistent.User;
import com.trs.components.ckm.ICKMServer;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TRSCKMServer
extends BaseServer
implements ICKMServer {
    private static Logger logger = Logger.getLogger(TRSCKMServer.class);
    public static final String KEY_CKM_SERVER = "CKM_SERVER";
    public static final String KEY_CKM_PORT = "CKM_PORT";
    public static final String KEY_CKM_USERNAME = "CKM_USERNAME";
    public static final String KEY_CKM_PASSWORD = "CKM_PASSWORD";
    public static final String KEY_CKM_ENABLE_SIMSEARCH = "CKM_ENABLE_SIMSEARCH";
    public static final String KEY_CKM_ENABLE_EXTRACT = "CKM_ENABLE_EXTRACT";
    public static final String KEY_CKM_ENABLE_AUTOCHECK = "CKM_ENABLE_AUTOCHECK";
    public static final String KEY_CKM_HAS_OPEN = "CKM_HAS_OPEN";
    private int m_nKeywordNum = 10;
    private int m_nAbsLenPercent = 50;
    private ConfigServer m_oConfigServer = ConfigServer.createInstance();
    private final String SIM_MODEL_WCM52 = "TRSWCM52";
    private TrsCkmSoapClient m_oCKMSoapClient = null;
    private static ICKMServer s_oCKMServer = null;

    @Override
    public Reports validateCKMServer(String _sServerIP, String _sServerPort, String _sUserName, String _sPassword) {
        Reports result = new Reports(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label1", "\u6821\u9a8cCKM\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38"));
        if (_sServerIP == null || _sServerPort == null || _sUserName == null || _sPassword == null) {
            result.addFailedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label2", "\u53c2\u6570\u65e0\u6548\uff01"), null);
            return result;
        }
        TrsCkmSoapClient oCKMSoapClient = new TrsCkmSoapClient();
        oCKMSoapClient.SetKeepAlive(true);
        oCKMSoapClient.SetServer("http://" + _sServerIP + ":" + _sServerPort, _sUserName, _sPassword);
        ABSHold absParam = new ABSHold(300, 50);
        try {
            oCKMSoapClient.ABSext("test", absParam);
            result.addSucessedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label3", "\u6821\u9a8c\u6210\u529f"));
        }
        catch (Exception e) {
            logger.error((Object)"validateCKMServer failed:", (Throwable)e);
            result.addFailedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label4", "CKM\u670d\u52a1\u5668[http://") + _sServerIP + ":" + _sServerPort + I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label5", "]\u6821\u9a8c\u5931\u8d25\uff01"), e);
        }
        return result;
    }

    @Override
    public void setCKMServer(String _sServerIP, String _sServerPort, String _sUserName, String _sPassword) {
        try {
            this.m_oConfigServer.updateConfigValue(KEY_CKM_SERVER, _sServerIP);
            this.m_oConfigServer.updateConfigValue(KEY_CKM_PORT, _sServerPort);
            this.m_oConfigServer.updateConfigValue(KEY_CKM_USERNAME, _sUserName);
            this.m_oConfigServer.updateConfigValue(KEY_CKM_PASSWORD, _sPassword);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label6", "\u66f4\u65b0CKMServer\u7684\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
        if (!this.isStarted()) {
            this.startup();
        }
    }

    @Override
    public void enableCKMService(boolean _bSimSearch, boolean _bAutorExtract, boolean _bAutoCheck) {
        try {
            this.m_oConfigServer.updateConfigValue(KEY_CKM_ENABLE_SIMSEARCH, _bSimSearch ? "true" : "false");
            this.m_oConfigServer.updateConfigValue(KEY_CKM_ENABLE_EXTRACT, _bAutorExtract ? "true" : "false");
            this.m_oConfigServer.updateConfigValue(KEY_CKM_ENABLE_AUTOCHECK, _bAutoCheck ? "true" : "false");
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label6", "\u66f4\u65b0CKMServer\u7684\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)e);
        }
        try {
            String sWCMPath = this.m_oConfigServer.getInitProperty("WCM_PATH");
            if (sWCMPath == null) {
                logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label7", "WCM_PATH\u8bbe\u7f6e\u9519\u8bef\uff01"));
                return;
            }
            sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
            String sConfigFile = sWCMPath + "html_edit/js/trsckm_config.js";
            String sFileContent = "config.AutoExtract \t= " + (_bAutorExtract ? "true" : "false") + "\n";
            sFileContent = sFileContent + "config.AutoCheck \t= " + (_bAutoCheck ? "true" : "false") + "\n";
            CMyFile.writeFile(sConfigFile, sFileContent);
            String sSimSearchConfigFile = sWCMPath + "js/validator/CWCMCKMDocumentSimValidator_config.js";
            String sSimSearchFileContent = "var WCMCKMSimSearchConfig = new Object();\n";
            sSimSearchFileContent = sSimSearchFileContent + "WCMCKMSimSearchConfig.enable \t= " + (_bSimSearch ? "true" : "false") + "\n";
            CMyFile.writeFile(sSimSearchConfigFile, sSimSearchFileContent);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label8", "\u540c\u6b65\u66f4\u65b0\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    public static ICKMServer getInstance() {
        if (s_oCKMServer == null) {
            s_oCKMServer = (ICKMServer)DreamFactory.createObjectById("ICKMServer");
        }
        try {
            if (s_oCKMServer.isNeedStartup()) {
                s_oCKMServer.startup();
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label9", "\u542f\u52a8CKM Server\u5931\u8d25\uff01"), (Throwable)e);
        }
        return s_oCKMServer;
    }

    @Override
    public String[] extractAbstractAndKeywords(String _sContent) throws WCMException {
        if (this.m_oCKMSoapClient == null) {
            throw new WCMDatainvalidException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"));
        }
        try {
            ABSHold absParam = new ABSHold(this.m_nKeywordNum, this.m_nAbsLenPercent);
            ABSResult result = this.m_oCKMSoapClient.ABSext(_sContent, absParam);
            if (result == null) {
                logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label11", "CKM \u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff01"));
                return null;
            }
            return new String[]{result.getabs(), result.getwordlist()};
        }
        catch (CkmSoapException e) {
            throw new WCMException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Documents simSearch(int _nDocId, String _sContent) {
        User system = User.getSystem();
        if (CMyString.isEmpty(_sContent)) {
            return new Documents(system);
        }
        long start = 0L;
        try {
            RevDetail[] pRevDetail;
            RevHold simParams = new RevHold(0, 0.8f);
            if (logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
                logger.debug((Object)"simsearch begin...");
            }
            if ((pRevDetail = this.m_oCKMSoapClient.SimRetrieveByText("TRSWCM52", simParams, _sContent)) == null || pRevDetail.length == 0) {
                Documents documents = new Documents(system);
                return documents;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("simsearch end...,time used(ms):" + (System.currentTimeMillis() - start)));
            }
            HashSet<String> idSet = new HashSet<String>(pRevDetail.length);
            int len = pRevDetail.length;
            for (int i = 0; i < len; ++i) {
                idSet.add(pRevDetail[i].getid());
            }
            idSet.remove(String.valueOf(_nDocId));
            if (idSet.isEmpty()) {
                Documents i = new Documents(system);
                return i;
            }
            StringBuffer buff = new StringBuffer(128);
            Iterator idItr = idSet.iterator();
            while (idItr.hasNext()) {
                buff.append(',').append(idItr.next());
            }
            idSet.clear();
            Documents documents = Documents.findByIds(system, buff.toString());
            return documents;
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label12", "\u76f8\u4f3c\u6027\u68c0\u7d22\u5931\u8d25\uff01"), e);
            Documents documents = Documents.createNewInstance(system);
            return documents;
        }
        finally {
            long end;
            long total;
            if (logger.isDebugEnabled() && (total = (end = System.currentTimeMillis()) - start) > 10000L) {
                logger.debug((Object)("sim search total time(s):" + total / 1000L));
            }
        }
    }

    @Override
    public CollErrorInfoDetail[] collateText(String _sContent) throws WCMException {
        if (this.m_oCKMSoapClient == null) {
            throw new WCMDatainvalidException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"));
        }
        try {
            CollErrorInfoDetail[] result = this.m_oCKMSoapClient.CollationText(_sContent);
            return result;
        }
        catch (CkmSoapException e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label11", "CKM \u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)e);
            throw new WCMException(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label10", "TRS\u77e5\u8bc6\u7ba1\u7406\u670d\u52a1\u5668\u6ca1\u6709\u542f\u52a8\u6216\u8005\u51fa\u73b0\u4e86\u5176\u5b83\u5f02\u5e38\uff01"), e);
        }
    }

    @Override
    public void updateSimIndex(Document _oDocument) {
        try {
            String content = _oDocument.getContent();
            if (CMyString.isEmpty(content)) {
                return;
            }
            this.m_oCKMSoapClient.SimUpdateIndex("TRSWCM52", _oDocument.getKey().toString(), _oDocument.getContent());
        }
        catch (Exception e) {
            logger.error((Object)("update " + _oDocument + " sim index error!"), (Throwable)e);
        }
    }

    @Override
    public void updateSimIndex(int _nId, String _sContent) {
        if (CMyString.isEmpty(_sContent)) {
            return;
        }
        try {
            this.m_oCKMSoapClient.SimUpdateIndex("TRSWCM52", String.valueOf(_nId), _sContent);
        }
        catch (Exception e) {
            logger.error((Object)("update [id=" + _nId + "] sim index error!"), (Throwable)e);
        }
    }

    @Override
    public void deleteSimIndex(Document _oDocument) {
        try {
            this.m_oCKMSoapClient.SimDeleteIndexByID("TRSWCM52", _oDocument.getKey().toString());
        }
        catch (Exception e) {
            logger.error((Object)("update " + _oDocument + " sim index error!"), (Throwable)e);
        }
    }

    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() {
        if (!this.isOpenCKMServer()) {
            logger.info((Object)"CKMServer is not open by AdminUser!");
            return false;
        }
        if (this.validateCKMServer().getSucessedReporterAt(0) == null) {
            logger.error((Object)"Validate CKM Error!");
            return false;
        }
        this.m_oCKMSoapClient = new TrsCkmSoapClient();
        this.m_oCKMSoapClient.SetKeepAlive(true);
        this.m_oCKMSoapClient.SetServer("http://" + this.getCKMServerIP() + ":" + this.getCKMServerPort(), this.getCKMServerUserName(), this.getCKMServerPassword());
        if (this.isEnableSimSearch()) {
            this.initSimDB();
        }
        try {
            String temp = this.m_oConfigServer.getSysConfigValue("CKM_KEYWORDNUM", "10");
            this.m_nKeywordNum = Integer.parseInt(temp);
            temp = this.m_oConfigServer.getSysConfigValue("CKM_ABSLENPERCENT", "50");
            this.m_nAbsLenPercent = Integer.parseInt(temp);
            if (this.m_nAbsLenPercent > 100) {
                this.m_nAbsLenPercent = 50;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public TrsCkmSoapClient getSoapClient() throws WCMException {
        if (!this.isOpenCKMServer()) {
            logger.debug((Object)"\u6ca1\u6709\u542f\u52a8\u667a\u80fd\u77e5\u8bc6\u670d\u52a1\uff01\u5efa\u8bae\u91c7\u8d2d\u4ee5\u63d0\u5347\u77e5\u8bc6\u5e93\u7684\u4ef7\u503c\uff01");
            return null;
        }
        if (this.m_oCKMSoapClient == null) {
            throw new WCMException("\u83b7\u53d6CKM\u63a5\u53e3\u5931\u8d25\uff0cCKMSoapClient\u6ca1\u6709\u542f\u52a8");
        }
        return this.m_oCKMSoapClient;
    }

    private void initSimDB() {
        final TrsCkmSoapClient client = this.m_oCKMSoapClient;
        new Thread(){

            @Override
            public void run() {
                try {
                    client.SimDropModel("TRSWCM52");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    client.SimCreateModel("TRSWCM52");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    User system = User.getSystem();
                    CMyDateTime dtStart = CMyDateTime.now().dateAdd(2, -3);
                    String sWhere = "DocStatus>0 and DocChannel>=0 and DocType in(20,10) and CRTIME>=" + DBManager.getDBManager().getDBType().sqlDateTime(dtStart.toString(), "YYYY-MM-DD HH24:MI:SS");
                    String sSelectField = "DocId,DocChannel,DocTitle,DocContent";
                    WCMFilter filter = new WCMFilter("", sWhere, "", sSelectField);
                    Documents documents = Documents.openWCMObjs(system, filter);
                    int nSize = documents.size();
                    for (int i = 0; i < nSize; ++i) {
                        Document document = (Document)documents.getAt(i);
                        if (document == null) continue;
                        client.SimUpdateIndex("TRSWCM52", String.valueOf(document.getId()), document.getContent());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Override
    public Reports validateCKMServer() {
        try {
            String sServer = this.m_oConfigServer.getSysConfigValue(KEY_CKM_SERVER, "localhost");
            String sPort = this.m_oConfigServer.getSysConfigValue(KEY_CKM_PORT, "8000");
            String sUserName = this.m_oConfigServer.getSysConfigValue(KEY_CKM_USERNAME, "admin");
            String sPassword = this.m_oConfigServer.getSysConfigValue(KEY_CKM_PASSWORD, "admin");
            return this.validateCKMServer(sServer, sPort, sUserName, sPassword);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label13", "\u6821\u9a8cCKM\u8bbe\u7f6e\u5931\u8d25"), (Throwable)e);
            Reports reports = new Reports(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label14", "\u6821\u9a8cCKM\u8bbe\u7f6e\u5931\u8d25!"));
            reports.addFailedReport(I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label13", "\u6821\u9a8cCKM\u8bbe\u7f6e\u5931\u8d25"), e);
            return reports;
        }
    }

    @Override
    public String getCKMServerIP() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_SERVER, "localhost");
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label15", "\u83b7\u53d6CKMServer\u7684IP\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCKMServerPort() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_PORT, "8000");
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label16", "\u83b7\u53d6CKMServer\u7684Port\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCKMServerUserName() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_USERNAME, "admin");
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label17", "\u83b7\u53d6CKMServer\u7684User\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCKMServerPassword() {
        try {
            return this.m_oConfigServer.getSysConfigValue(KEY_CKM_PASSWORD, "admin");
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isEnableSimSearch() {
        try {
            return "TRUE".equalsIgnoreCase(this.m_oConfigServer.getSysConfigValue(KEY_CKM_ENABLE_SIMSEARCH, "false"));
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isEnableAutoExtract() {
        try {
            return "TRUE".equalsIgnoreCase(this.m_oConfigServer.getSysConfigValue(KEY_CKM_ENABLE_EXTRACT, "false"));
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isEnableAutoCheck() {
        try {
            return "TRUE".equalsIgnoreCase(this.m_oConfigServer.getSysConfigValue(KEY_CKM_ENABLE_AUTOCHECK, "false"));
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684Password\u5931\u8d25"), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isNeedStartup() {
        return !this.isStarted() && (this.isEnableAutoCheck() || this.isEnableAutoExtract() || this.isEnableSimSearch());
    }

    public boolean isOpenCKMServer() {
        return this.isEnableSimSearch() || this.isEnableAutoCheck() || this.isEnableAutoExtract();
    }

    private String getCKMModelName() {
        try {
            return this.m_oConfigServer.getSysConfigValue("TRS_CKM_MODELNAME", "demo");
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSCKMServer.class, "TRSCKMServer.label18", "\u83b7\u53d6CKMServer\u7684TRS_CKM_MODELNAME\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    public String[] pySearch(String _sCurrWord) throws WCMException {
        TrsCkmSoapClient aSoapClient = this.getSoapClient();
        if (aSoapClient != null) {
            try {
                return aSoapClient.PySearch(_sCurrWord, this.getCKMModelName(), 0);
            }
            catch (CkmSoapException e) {
                throw new WCMException(0, "\u62fc\u97f3\u68c0\u7d22\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + e.getMessage() + "]");
            }
        }
        return null;
    }

    public String[] dySearch(String _sCurrWord) throws WCMException {
        TrsCkmSoapClient aSoapClient = this.getSoapClient();
        if (aSoapClient != null) {
            try {
                return aSoapClient.DySearch(_sCurrWord, this.getCKMModelName(), 0);
            }
            catch (CkmSoapException e) {
                throw new WCMException(0, "\u77ed\u8bed\u68c0\u7d22\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + e.getMessage() + "]");
            }
        }
        return null;
    }

    @Override
    public int doRuleCATUploadModel(String _sCATModelName, int _iOption, String _sDirPath) throws WCMException {
        TrsCkmSoapClient aSoapClient = this.getSoapClient();
        if (aSoapClient != null) {
            try {
                return aSoapClient.RuleCATUploadModel(_sCATModelName, _iOption, _sDirPath);
            }
            catch (CkmSoapException e) {
                throw new WCMException(0, "\u4e0a\u4f20\u89c4\u5219\u5206\u7c7b\u6a21\u677f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + e.getMessage() + "]");
            }
        }
        return 0;
    }

    @Override
    public String[] doRuleCATClassify(String _sCATModelName, String[] sContents, String[] sContentNames) throws WCMException {
        TrsCkmSoapClient aSoapClient = this.getSoapClient();
        if (sContents == null || sContentNames == null) {
            return null;
        }
        if (sContents.length != sContentNames.length) {
            return null;
        }
        if (aSoapClient != null) {
            RuleCATField[] aRuleCATFields = new RuleCATField[sContents.length];
            for (int i = 0; i < sContents.length; ++i) {
                RuleCATField aRuleCATField;
                aRuleCATFields[i] = aRuleCATField = new RuleCATField(sContents[i], sContentNames[i]);
            }
            try {
                if (logger.isDebugEnabled()) {
                    System.out.println(aRuleCATFields.length + ":" + _sCATModelName + ":" + sContents[0] + ":" + sContentNames[0]);
                }
                String sClassifyResult = aSoapClient.RuleCATClassifyText(_sCATModelName, aRuleCATFields);
                if (logger.isDebugEnabled()) {
                    System.out.println("sClassifyResult:" + sClassifyResult);
                }
                if (sClassifyResult != null) {
                    return CMyString.split(sClassifyResult, ";");
                }
                return null;
            }
            catch (CkmSoapException e) {
                throw new WCMException(0, "\u8c03\u7528CKM\u89c4\u5219\u5206\u7c7b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[" + e.getMessage() + "]");
            }
        }
        return null;
    }
}

