/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.ProcessConstants;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowDocBaks;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FlowDoc
extends CMSObj {
    private static Logger logger = Logger.getLogger(FlowDoc.class);
    public static final int OBJ_TYPE = 405;
    public static final String DB_TABLE_NAME = "WCMFLOWDOC";
    public static final String DB_ID_NAME = "FLOWDOCID";
    private IFlowContent m_oCurrContent = null;
    private static final int[] OPERATIONS_SYSTEM = new int[]{2, 6, 7, 8, 4, 18, 13, 14};

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 405;
    }

    public int getNodeId() {
        return this.getPropertyAsInt("NODEID", 0);
    }

    public FlowNode getNode() throws WCMException {
        return FlowNode.findById(this.getNodeId());
    }

    public boolean setNode(int _nodeId) throws WCMException {
        return this.setProperty("NODEID", _nodeId);
    }

    public boolean setNode(FlowNode _flowNode) throws WCMException {
        if (_flowNode == null || !_flowNode.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label1", "\u65e0\u6548\u7684\u8282\u70b9\u5bf9\u8c61\uff08FlowDoc.setNode\uff09"));
        }
        return this.setProperty("NODEID", _flowNode.getId());
    }

    public int getToUserId() {
        return this.getPropertyAsInt("ToUserId", 0);
    }

    public User getToUser() throws WCMException {
        return User.findById(this.getToUserId());
    }

    public String getToUserNames() throws WCMException {
        if (this.getToUserId() > 0) {
            User toUser = this.getToUser();
            if (toUser == null) {
                return I18NMessage.get(FlowDoc.class, "FlowDoc.label2", "\u672a\u77e5[") + this.getToUserId() + "]";
            }
            return toUser.getName();
        }
        if (this.getToUserIds() == "") {
            return "";
        }
        Users toUsers = this.getToUsers(null);
        StringBuffer sbUserNames = null;
        int nSize = toUsers.size();
        for (int i = 0; i < nSize; ++i) {
            User toUser = (User)toUsers.getAt(i);
            if (toUser == null) continue;
            if (sbUserNames == null) {
                sbUserNames = new StringBuffer(nSize * 7);
            } else {
                sbUserNames.append(',');
            }
            sbUserNames.append(toUser.getName());
        }
        if (sbUserNames != null) {
            return sbUserNames.toString();
        }
        return "";
    }

    public boolean setToUser(int _nToUserId) throws WCMException {
        return this.setToUser(User.findById(_nToUserId));
    }

    public boolean setToUser(User _toUser) throws WCMException {
        if (_toUser == null || !_toUser.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label3", "\u65e0\u6548\u7684\u63a5\u6536\u8005\uff01"));
        }
        return this.setProperty("ToUserId", _toUser.getId());
    }

    public int getContentType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setContentType(int _nContentType) throws WCMException {
        return this.setProperty("OBJTYPE", _nContentType);
    }

    public int getContentId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setContentId(int _nContentId) throws WCMException {
        return this.setProperty("OBJID", _nContentId);
    }

    public IFlowContent getFlowContent() throws WCMException {
        if (this.m_oCurrContent == null) {
            this.m_oCurrContent = FlowContentHelper.createFlowContent(this.getContentType(), this.getContentId());
            FlowNode node = this.getNode();
            if (node != null) {
                if (this.m_oCurrContent == null) {
                    return null;
                }
                this.m_oCurrContent.setFlow(node.getFlow());
            }
        }
        this.m_oCurrContent.setFlowDoc(this);
        return this.m_oCurrContent;
    }

    public boolean setFlowContent(int _nObjType, int _nObjId) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label4", "\u4e0d\u5141\u8bb8\u4fee\u6539\u5c5e\u6027Doc\uff08FlowDoc.setDoc\uff09"));
        }
        return this.setContentType(_nObjType) && this.setContentId(_nObjId);
    }

    public boolean setFlowContent(IFlowContent _content) throws WCMException {
        if (_content == null) {
            throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label5", "\u65e0\u6548\u7684\u6d41\u8f6c\u5185\u5bb9(FlowDoc.setDoc)"));
        }
        return this.setFlowContent(_content.getContentType(), _content.getSubinstanceId());
    }

    public int getFlag() {
        return this.getPropertyAsInt("FLAG", 0);
    }

    public String getFlagDesc() {
        int nFlag = this.getFlag();
        for (int i = 0; i < OPERATIONS_SYSTEM.length; ++i) {
            if (nFlag != OPERATIONS_SYSTEM[i]) continue;
            return ProcessConstants.getFlagDesc(nFlag);
        }
        try {
            String sName;
            FlowNodeBranch branch = this.getBranchComeFrom(null);
            if (branch != null && !CMyString.isEmpty(sName = branch.getName())) {
                return sName;
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(FlowDoc.class, "FlowDoc.label6", "\u83b7\u53d6\u5206\u652f\u53d1\u751f\u5f02\u5e38"), (Throwable)e);
            return I18NMessage.get(FlowDoc.class, "FlowDoc.label6", "\u83b7\u53d6\u5206\u652f\u53d1\u751f\u5f02\u5e38");
        }
        return ProcessConstants.getFlagDesc(nFlag);
    }

    public boolean setFlag(int _flag) throws WCMException {
        return this.setProperty("FLAG", _flag);
    }

    public int getWorkModal() {
        return this.getPropertyAsInt("WorkModal", 0);
    }

    public String getWorkModalDesc() {
        return ProcessConstants.getWorkModalDesc(this.getWorkModal());
    }

    public boolean setWorkModal(int _nWorkModal) throws WCMException {
        return this.setProperty("WorkModal", _nWorkModal);
    }

    public boolean isWorked() {
        return this.getPropertyAsBoolean("Worked", false);
    }

    public boolean setWorked(boolean _bWorked) throws WCMException {
        if (_bWorked && !this.isWorked()) {
            this.setProperty("WorkTime", CMyDateTime.now());
        }
        return this.setProperty("Worked", _bWorked);
    }

    public int getPreFlowDocId() {
        return this.getPropertyAsInt("PreFlowDocId", 0);
    }

    public FlowDoc getPreFlowDoc() throws WCMException {
        int nPreFlowDocId = this.getPreFlowDocId();
        if (nPreFlowDocId == 0) {
            return null;
        }
        return FlowDoc.findById(nPreFlowDocId);
    }

    public boolean setPreFlowDoc(int _nPreFlowDocId) throws WCMException {
        return this.setProperty("PreFlowDocId", _nPreFlowDocId);
    }

    public int getParentId() {
        return this.getPropertyAsInt("ParentId", 0);
    }

    public FlowDoc getParent() throws WCMException {
        int nParentId = this.getParentId();
        if (nParentId == 0) {
            return this;
        }
        return FlowDoc.findById(nParentId);
    }

    public boolean setParent(int _nParentId) throws WCMException {
        return this.setProperty("ParentId", _nParentId);
    }

    public String getPostUserName() {
        return (String)this.getProperty("POSTUSER");
    }

    public String getPostUserTrueName() {
        String sPostUserName = (String)this.getProperty("POSTUSER");
        User oUser = User.findByName(sPostUserName);
        String sPostUserTrueName = sPostUserName;
        if (oUser != null) {
            sPostUserTrueName = oUser.getTrueName();
        }
        if (sPostUserTrueName != null && !sPostUserTrueName.equals("")) {
            sPostUserName = sPostUserTrueName;
        }
        return sPostUserName;
    }

    public String getRealPostUserNames() {
        String sTogetherUsers = this.getPropertyAsString("TogetherUsers");
        if (sTogetherUsers != null && (sTogetherUsers = sTogetherUsers.trim()).length() > 0) {
            return sTogetherUsers;
        }
        return this.getPostUserName();
    }

    public User getPostUser() {
        return User.findByName(this.getPostUserName());
    }

    public boolean setPostUser(String _userName) throws WCMException {
        return this.setPostUser(User.findByName(_userName));
    }

    public boolean setPostUser(User _postUser) throws WCMException {
        if (_postUser == null || !_postUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label7", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61\uff08FlowDoc.setPostUser\uff09"));
        }
        return this.setProperty("POSTUSER", _postUser.getName());
    }

    public CMyDateTime getPostTime() {
        return (CMyDateTime)this.getProperty("POSTTIME");
    }

    public boolean setPostTime(CMyDateTime _postTime) throws WCMException {
        return this.setProperty("POSTTIME", _postTime);
    }

    public String getPostDesc() {
        return (String)this.getProperty("POSTDESC");
    }

    public boolean setPostDesc(String _desc) throws WCMException {
        return this.setProperty("POSTDESC", _desc);
    }

    public String getToUserIds() {
        String sIds = this.getPropertyAsString("TOUSERS");
        return sIds == null ? "" : sIds;
    }

    public Users getToUsers(User _currUser) throws WCMException {
        String sToUserIds = this.getToUserIds();
        if (CMyString.isEmpty(sToUserIds)) {
            sToUserIds = String.valueOf(this.getToUserId());
        }
        return Users.findByIds(_currUser, sToUserIds);
    }

    public boolean setToUsers(String _userIds) throws WCMException {
        if (_userIds == null) {
            _userIds = "";
        } else if ((_userIds = _userIds.trim()).length() > 0) {
            StringTokenizer stIds = new StringTokenizer(_userIds, ",");
            while (stIds.hasMoreElements()) {
                String sId = (String)stIds.nextElement();
                try {
                    Integer.parseInt(sId);
                }
                catch (Exception ex) {
                    throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label8", "\u65e0\u6548\u7684\u7528\u6237\uff1a") + sId + "\uff08FlowDoc.setToUsers\uff09");
                }
            }
        }
        return this.setProperty("TOUSERS", _userIds);
    }

    public boolean addToUser(int _userId) throws WCMException {
        return this.addToUser(User.findById(_userId));
    }

    public boolean addToUser(User _user) throws WCMException {
        if (_user == null) {
            throw new WCMException(10, I18NMessage.get(FlowDoc.class, "FlowDoc.label9", "\u6307\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a\uff08FlowDoc.addToUser\uff09"));
        }
        try {
            String sIdNew = String.valueOf(_user.getId());
            String sIds = "";
            sIds = this.isAddMode() ? (String)this.getProperty("TOUSERS") : (String)this.getNewProperty("TOUSERS");
            if (sIds == null) {
                sIds = this.getToUserIds();
            }
            if (("," + sIds + ",").indexOf("," + sIdNew + ",") >= 0) {
                return false;
            }
            return this.setProperty("TOUSERS", (sIds.length() == 0 ? "" : sIds + ",") + sIdNew);
        }
        catch (WCMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label10", "\u6dfb\u52a0\u9012\u9001\u7528\u6237\u5931\u8d25\uff08FlowDoc.addToUser\uff09"), ex);
        }
    }

    public int getPreNodeId() {
        return this.getPropertyAsInt("PRENODEID", 0);
    }

    public FlowNode getPreNode() throws WCMException {
        return FlowNode.findById(this.getPreNodeId());
    }

    public boolean setPreNode(int _nodeId) throws WCMException {
        return this.setProperty("PRENODEID", _nodeId);
    }

    public boolean setPreNode(FlowNode _flowNode) throws WCMException {
        if (_flowNode != null && !_flowNode.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label11", "\u65e0\u6548\u7684\u8282\u70b9\u5bf9\u8c61\uff08FlowDoc.setPreNode\uff09"));
        }
        int nNodeId = _flowNode == null ? 0 : _flowNode.getId();
        return this.setProperty("PRENODEID", nNodeId);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowDoc.class, "FlowDoc.label12", "\u5c5e\u6027OBJTYPE\u6ca1\u6709\u8bbe\u7f6e(FlowDoc.isValid)"));
            }
            if (this.getProperty("OBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowDoc.class, "FlowDoc.label13", "\u5c5e\u6027OBJID\u6ca1\u6709\u8bbe\u7f6e(FlowDoc.isValid)"));
            }
            if (this.getProperty("NODEID") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowDoc.class, "FlowDoc.label14", "\u5c5e\u6027NodeId\u6ca1\u6709\u8bbe\u7f6e(FlowDoc.isValid)"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode()) {
            this.setCrTime();
            this.setPostTime(CMyDateTime.now());
            super.insert(_currUser);
        }
    }

    public FlowDoc getPrevious(User _currUser, boolean _bGoBack) throws WCMException {
        try {
            int nNodeId = _bGoBack && this.getFlag() == 2 ? this.getNodeId() : this.getPreNodeId();
            if (nNodeId <= 0) {
                return null;
            }
            String sWhere = "ObjType=" + this.getContentType() + " and Objid=" + this.getContentId() + " and NODEID=" + nNodeId;
            FlowDocBaks flowDocs = new FlowDocBaks(_currUser);
            flowDocs.open(new WCMFilter("", sWhere, "FLOWDOCID desc"));
            return flowDocs.isEmpty() ? null : (FlowDoc)flowDocs.getAt(0);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label15", "\u53d6\u524d\u4e00\u4e2a\u6d41\u8f6c\u7ecf\u8fc7\u7684FlowDoc\u5bf9\u8c61\u5931\u8d25\uff08FlowDoc.getPrevious\uff09"), ex);
        }
    }

    public FlowNodeBranch getBranchComeFrom(User _currUser) throws WCMException {
        try {
            FlowNode preNode = this.getPreNode();
            if (preNode == null) {
                return null;
            }
            FlowNode currNode = this.getNode();
            if (currNode == null) {
                return null;
            }
            return preNode.getBranchTo(_currUser, currNode);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowDoc.class, "FlowDoc.label16", "\u83b7\u53d6\u7ecf\u8fc7\u7684\u5206\u652f\u5931\u8d25\uff08FlowDoc.getBranchComeFrom\uff09"), ex);
        }
    }

    public boolean isReceived() {
        CMyDateTime dtReceiveTime = this.getPropertyAsDateTime("ReceiveTime");
        return dtReceiveTime != null && !dtReceiveTime.isNull();
    }

    public boolean setReceiveTime() throws WCMException {
        return this.setProperty("ReceiveTime", CMyDateTime.now());
    }

    public CMyDateTime getReceiveTime() {
        return this.getPropertyAsDateTime("ReceiveTime");
    }

    public boolean setAcceptTime() throws WCMException {
        return this.setProperty("AcceptTime", CMyDateTime.now());
    }

    public CMyDateTime getAcceptTime() {
        return this.getPropertyAsDateTime("AcceptTime");
    }

    public boolean isAccepted() {
        return this.getPropertyAsBoolean("Accepted", false);
    }

    public boolean setAccepted() throws WCMException {
        if (this.isAccepted()) {
            return false;
        }
        this.setProperty("Accepted", true);
        this.setAcceptTime();
        return true;
    }

    public static final FlowDoc findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (FlowDoc)BaseObj.findById(FlowDoc.class, _nId);
    }

    public static final FlowDoc createNewInstance() throws WCMException {
        return (FlowDoc)BaseObj.createNewInstance(FlowDoc.class);
    }

    public static final FlowDoc findByKey(Object _oKey) throws WCMException {
        return (FlowDoc)BaseObj.findByKey(FlowDoc.class, _oKey);
    }

    public boolean setContent(int contentType, int contentId) throws WCMException {
        return this.setContentType(contentType) && this.setContentId(contentId);
    }

    public FlowDocs getChildren(User _currUser, WCMFilter _filter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=?", "");
        filter.addSearchValues(this.getId());
        filter.mergeWith(_filter);
        return FlowDocs.openWCMObjs(_currUser, filter);
    }

    public void setContent(IFlowContent flowContent) throws WCMException {
        if (flowContent == null) {
            return;
        }
        this.setContent(flowContent.getType(), flowContent.getId());
    }

    public boolean setPreFlowDoc(FlowDoc currFlowDoc) throws WCMException {
        if (currFlowDoc == null) {
            return this.setPreFlowDoc(0);
        }
        return this.setPreFlowDoc(currFlowDoc.getId());
    }

    public long getSerialNum() {
        return this.getPropertyAsLong("SerialNum", 0L);
    }

    public boolean setSerialNum(long _lSerialNum) throws WCMException {
        return this.setProperty("SerialNum", _lSerialNum);
    }

    public long getBranchSerialNum() {
        return this.getPropertyAsLong("BranchSerialNum", 0L);
    }

    public boolean setBranchSerialNum(long _lSerialNum) throws WCMException {
        return this.setProperty("BranchSerialNum", _lSerialNum);
    }

    public String getToUserTrueNames() throws WCMException {
        if (this.getToUserId() > 0) {
            User toUser = this.getToUser();
            if (toUser == null) {
                return "\u672a\u77e5[" + this.getToUserId() + "]";
            }
            String sToUserName = toUser.getName();
            String sToUserTrueName = toUser.getTrueName();
            if (sToUserTrueName != null && !"".equals(sToUserTrueName)) {
                return sToUserTrueName;
            }
            return sToUserName;
        }
        if (this.getToUserIds() == "") {
            return "";
        }
        Users toUsers = this.getToUsers(null);
        StringBuffer sbUserNames = null;
        int nSize = toUsers.size();
        for (int i = 0; i < nSize; ++i) {
            User toUser = (User)toUsers.getAt(i);
            if (toUser == null) continue;
            if (sbUserNames == null) {
                sbUserNames = new StringBuffer(nSize * 7);
            } else {
                sbUserNames.append(',');
            }
            String sUserName = toUser.getName();
            String sToUserTrueName = toUser.getTrueName();
            if (sToUserTrueName != null && !"".equals(sToUserTrueName)) {
                sUserName = sToUserTrueName;
            }
            sbUserNames.append(sUserName);
        }
        if (sbUserNames != null) {
            return sbUserNames.toString();
        }
        return "";
    }

    public boolean setObjDeleted(boolean isObjDeleted) throws WCMException {
        return this.setProperty("ISOBJDELETED", isObjDeleted);
    }

    public boolean isObjDeleted() {
        return this.getPropertyAsBoolean("ISOBJDELETED", false);
    }
}

