/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.common.WCMException;
import com.trs.webframework.context.MethodContext;

public class TemplateAuthHelper {
    public static RightValue makeHostRightValue(MethodContext _context, User _loginUser, IPublishFolder _host) throws WCMException {
        String sHostRightValueKey = "HostRighValue." + _host.getType() + "." + _host.getId();
        RightValue hostRightValue = (RightValue)_context.getContextCacheData(sHostRightValueKey);
        if (hostRightValue == null) {
            IObjectMemberMgr oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
            hostRightValue = oObjectMemberMgr.canOperate(_loginUser, _host.getType(), _host.getId()) ? AuthServer.getRightValue(_host.getSubstance(), _loginUser) : new RightValue();
            _context.putContextCacheData(sHostRightValueKey, hostRightValue);
        }
        return hostRightValue;
    }

    public static RightValue makeTemplateRightValue(MethodContext _context, User _loginUser, Template _template, IPublishFolder _host) throws WCMException {
        String sHostRightValueKey = "HostRighValue." + _template.getFolderType() + "." + _template.getFolderId();
        RightValue templateFolderRightValue = (RightValue)_context.getContextCacheData(sHostRightValueKey);
        if (templateFolderRightValue == null) {
            IPublishFolder folder = _template.getFolder();
            if (folder == null) {
                templateFolderRightValue = new RightValue(0L);
            } else {
                templateFolderRightValue = AuthServer.getRightValue(folder.getSubstance(), _loginUser);
                if (_host != null) {
                    templateFolderRightValue.or(TemplateAuthHelper.makeHostRightValue(_context, _loginUser, _host));
                }
            }
            _context.putContextCacheData(sHostRightValueKey, templateFolderRightValue);
        }
        return templateFolderRightValue;
    }
}

