/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.UnZipFile4Batch;
import com.trs.ajaxservice.ViewDocumentServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.gyl.imagesmetadatas.ImagesMetaDatas;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import com.trs.service.IDocumentService;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.ImageInfo;
import com.trs.wcm.photo.ImageLibConstants;
import com.trs.wcm.photo.ImageLibHelper;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class PhotoServiceProvider
extends ViewDocumentServiceProvider
implements IGlueServiceProvider {
    static final Logger s_logger = Logger.getLogger(PhotoServiceProvider.class);
    private IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private IImageLibMgr m_libManager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
    private IDocumentService m_docService = (IDocumentService)DreamFactory.createObjectById("IDocumentService");
    private ContentExtFieldMgr m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    private static final String FIELDS_OF_CHNLDOC = "RecId,ChnlId,DocId,DocStatus,CrTime,CrUser,DocChannel";
    private static final String FIELDS_OF_DOCUMENT = "DocId,DocTitle,DocContent,DocType,DocSource,DocAbstract,DocRelWords,DocPeople,DocPlace,DocRelTime,Attribute,CrTime,CrUser";

    @Override
    public void delete(MethodContext _context) throws Throwable {
    }

    @Override
    public Object query(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        BaseChannel host = this.getHost(_context);
        if (host != null && !AuthServer.hasRight(loginUser, (CMSObj)host, 30)) {
            throw new WCMException(1002, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label1", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u67e5\u770b\u56fe\u7247\u5217\u8868\uff01"));
        }
        _context.setValue("ChannelIds", _context.getValue("ChannelId"));
        _context.setValue("SiteIds", _context.getValue("SiteId"));
        _context.setValue("ChnlDocSelectFields", FIELDS_OF_CHNLDOC);
        _context.setValue("DocumentSelectFields", FIELDS_OF_DOCUMENT);
        return super.query(_context);
    }

    @Override
    public ViewDocuments queryRecycle(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        BaseChannel host = this.getHost(_context);
        if (host != null && !AuthServer.hasRight(loginUser, (CMSObj)host, 30)) {
            throw new WCMException(1002, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label1", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u67e5\u770b\u56fe\u7247\u5217\u8868\uff01"));
        }
        _context.setValue("ChannelIds", _context.getValue("ChannelId"));
        _context.setValue("SiteIds", _context.getValue("SiteId"));
        _context.setValue("ChnlDocSelectFields", FIELDS_OF_CHNLDOC);
        _context.setValue("DocumentSelectFields", FIELDS_OF_DOCUMENT);
        return super.queryRecycle(_context);
    }

    public Object getPublishUrls(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        String sChnlDocIds = _context.getValue("ChnlDocIds");
        int nScaleIndex = _context.getValue("ScaleIndex", 0);
        ChnlDocs currChnlDocs = ChnlDocs.findByIds(loginUser, sChnlDocIds);
        HashMap<String, String[][]> retVal = new HashMap<String, String[][]>(1);
        if (currChnlDocs == null || currChnlDocs.size() == 0) {
            retVal.put("urls", new String[0][2]);
        } else {
            String[][] urls = new String[currChnlDocs.size()][3];
            for (int i = 0; i < currChnlDocs.size(); ++i) {
                ChnlDoc currChnlDoc = (ChnlDoc)currChnlDocs.getAt(i);
                urls[i][2] = "";
                if (currChnlDoc != null) {
                    Document currDocument = currChnlDoc.getDocument();
                    urls[i][0] = ImageLibHelper.getImageFileNameByScaleIndex(currDocument, nScaleIndex, false);
                    urls[i][1] = ImageLibHelper.getOrigImageFilePath(currDocument, false);
                    if (currChnlDoc.getStatusId() != 10) continue;
                    urls[i][2] = I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label2", "\u5df2\u53d1");
                    continue;
                }
                urls[i][0] = "";
                urls[i][1] = "";
            }
            retVal.put("urls", urls);
        }
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON2(retVal, 0);
    }

    public Object getOriginalUrls(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        String sChnlDocIds = _context.getValue("ChnlDocIds");
        if (CMyString.isEmpty(sChnlDocIds)) {
            throw new WCMException(10, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label3", "\u65e0\u6548\u7684ID\u5e8f\u5217!"));
        }
        ChnlDocs currChnlDocs = ChnlDocs.findByIds(loginUser, sChnlDocIds);
        HashMap<String, String[][]> retVal = new HashMap<String, String[][]>(1);
        if (currChnlDocs == null || currChnlDocs.size() == 0) {
            retVal.put("urls", new String[0][2]);
        } else {
            String[][] urls = new String[currChnlDocs.size()][3];
            Document currDocument = null;
            String fn = null;
            IPublishContent content = null;
            IPublishFolder folder = null;
            PublishPathCompass compass = new PublishPathCompass();
            FilesMan fileman = FilesMan.getFilesMan();
            int nChnlId = 0;
            int size = currChnlDocs.size();
            for (int i = 0; i < size; ++i) {
                ChnlDoc currChnlDoc = (ChnlDoc)currChnlDocs.getAt(i);
                urls[i][2] = "";
                if (currChnlDoc != null) {
                    currDocument = currChnlDoc.getDocument();
                    fn = currDocument.getAttributeValue("SRCFILE");
                    if (currDocument.getStatusId() == 10) {
                        if (nChnlId != currChnlDoc.getChannelId()) {
                            nChnlId = currChnlDoc.getChannelId();
                            folder = (IPublishFolder)PublishElementFactory.lookupElement(101, nChnlId);
                        }
                        content = PublishElementFactory.makeContentFrom(currDocument, folder);
                        fn = compass.getAbsoluteHttpPath(content) + fn;
                    } else {
                        fn = fileman.mapFilePath(fn, 1) + fn;
                    }
                    urls[i][0] = fn;
                    urls[i][1] = fn;
                    if (currChnlDoc.getStatusId() != 10) continue;
                    urls[i][2] = I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label2", "\u5df2\u53d1");
                    continue;
                }
                urls[i][0] = "";
                urls[i][1] = "";
            }
            retVal.put("urls", urls);
        }
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON2(retVal, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepCode(User loginUser, String sChnlDocIds) {
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt4Doc = null;
        ResultSet rs = null;
        ResultSet docrs = null;
        int[] recids = CMyString.splitToInt(sChnlDocIds, ",");
        StringBuffer sql = new StringBuffer(128);
        sql.append("select recid,docid,chnlid,docstatus from wcmdocument");
        sql.append(" where recid in(");
        sql.append("?");
        int len = recids.length;
        for (int i = 1; i < len; ++i) {
            sql.append(",?");
        }
        sql.append(')');
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql.toString());
            sql.setLength(0);
            sql.append("select docid,docchannel,crtime,docstatus,attribute");
            sql.append("  from wcmdocument where docid=?");
            pstmt4Doc = conn.prepareStatement(sql.toString());
            sql.setLength(0);
            int ix = 1;
            pstmt.setInt(ix++, recids[0]);
            int len2 = recids.length;
            for (int i = 1; i < len2; ++i) {
                pstmt.setInt(ix++, recids[i]);
            }
            rs = pstmt.executeQuery();
            ChnlDoc chnldoc = null;
            while (rs.next()) {
                chnldoc = new ChnlDoc();
                chnldoc.readFromRs(rs, null);
                pstmt4Doc.setInt(1, chnldoc.getDocId());
                docrs = pstmt4Doc.executeQuery();
                if (!docrs.next()) continue;
            }
        }
        catch (Exception exception) {
        }
    }

    private BaseChannel getHost(MethodContext _context) throws WCMException {
        int nHostId = _context.getValue("ChannelId", 0);
        BaseChannel host = null;
        boolean zSite = false;
        if (nHostId > 0) {
            host = Channel.findById(nHostId);
        } else {
            nHostId = _context.getValue("SiteId", 0);
            host = WebSite.findById(nHostId);
            zSite = true;
        }
        int nSiteType = _context.getValue("SiteType", -1);
        if (nSiteType < 0) {
            this.assertHostValid(nHostId, host, zSite);
        }
        return host;
    }

    private void assertHostValid(int nHostId, BaseChannel host, boolean zSite) throws WCMException {
        if (host == null) {
            String msg = I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label4", "\u6ca1\u6709\u627e\u5230[id=") + nHostId + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label5", "]\u7684");
            msg = zSite ? msg + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label6", "\u56fe\u7247\u5e93") : msg + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label7", "\u56fe\u7247\u5206\u7c7b");
            throw new WCMException(200006, msg);
        }
        if (host.isDeleted()) {
            String msg = "[id=" + nHostId + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label5", "]\u7684");
            msg = zSite ? msg + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label6", "\u56fe\u7247\u5e93") : msg + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label7", "\u56fe\u7247\u5206\u7c7b");
            msg = msg + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label8", "\u5df2\u88ab\u5220\u9664\uff01\u8bf7\u5237\u65b0\u60a8\u7684\u5bfc\u822a\u6811");
            throw new WCMException(200006, msg);
        }
    }

    @Override
    public int save(MethodContext _context) throws Throwable {
        String watermarkPos;
        int nPhotoDocId = _context.getValue("PhotoDocId", 0);
        Document doc = Document.findById(nPhotoDocId);
        if (doc == null) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label9", "\u6ca1\u6709\u627e\u5230[Id=") + nPhotoDocId + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label10", "]\u7684\u56fe\u7247\uff01"));
        }
        String image = _context.getValue("PhotoFile");
        String wmpic = _context.getValue("WatermarkFile");
        boolean zAddWatermark = false;
        int[] pos = null;
        if (FilesMan.isValidFile(wmpic, "W0") && !CMyString.isEmpty(watermarkPos = _context.getValue("WatermarkPos"))) {
            zAddWatermark = true;
            pos = CMyString.splitToInt(watermarkPos, ",");
        }
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setImageFileName(image);
        imageInfo.setId(nPhotoDocId);
        imageInfo.setAddMark(zAddWatermark);
        imageInfo.setMarkImageFile(wmpic);
        imageInfo.setMarkPos(pos);
        String bmp2Type = _context.getValue("BmpConverType");
        imageInfo.setConvertToImageType(bmp2Type);
        IImageLibMgr libmanager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        libmanager.saveImageInfo(imageInfo);
        return nPhotoDocId;
    }

    public String addWaterMark(MethodContext _context) throws Throwable {
        String uploadFiles = _context.getValue("UploadedFiles");
        if (CMyString.isEmpty(uploadFiles)) {
            throw new WCMException(10, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label11", "\u6ca1\u6709\u6307\u5b9a\u8981\u4fdd\u5b58\u7684\u56fe\u7247\uff01"));
        }
        String watermarkFile = _context.getValue("WatermarkFile");
        String watermarkPos = _context.getValue("WatermarkPos");
        if (!CMyString.isEmpty(watermarkPos) && !CMyString.isEmpty(watermarkFile)) {
            IImageLibMgr libmanager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
            String[] images = uploadFiles.split(",");
            int[] pos = CMyString.splitToInt(watermarkPos, ",");
            for (int i = images.length - 1; i >= 0; --i) {
                libmanager.addWaterMark(images[i], watermarkFile, pos);
            }
        }
        return uploadFiles;
    }

    public String saveImageInfo(MethodContext _context) throws Throwable {
        String watermarkPos;
        int nMainKindId = _context.getValue("MainKindId", 0);
        Channel channel = Channel.findById(nMainKindId);
        this.assertHostValid(nMainKindId, channel, false);
        this.assertHasRight(channel);
        String uploadFiles = _context.getValue("UploadedFiles");
        if (CMyString.isEmpty(uploadFiles)) {
            throw new WCMException(10, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label11", "\u6ca1\u6709\u6307\u5b9a\u8981\u4fdd\u5b58\u7684\u56fe\u7247\uff01"));
        }
        boolean zBatchMode = _context.getValue("BatchMode", false);
        String[] images = null;
        String[] names = null;
        if (zBatchMode) {
            String[][] pics = this.extractPicFiles0(uploadFiles);
            names = pics[0];
            images = pics[1];
            if (images.length == 0) {
                throw new WCMDatainvalidException(I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label12", "\u5bfc\u5165\u7684zip\u6587\u4ef6\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u56fe\u7247\uff01"));
            }
        } else {
            images = uploadFiles.split(",");
            String sourceFiles = _context.getValue("SourceFiles");
            names = !CMyString.isEmpty(sourceFiles) ? sourceFiles.split(",") : images;
        }
        String watermarkFile = _context.getValue("WatermarkFile");
        boolean zAddWatermark = false;
        int[] pos = null;
        if (FilesMan.isValidFile(watermarkFile, "W0") && !CMyString.isEmpty(watermarkPos = _context.getValue("WatermarkPos"))) {
            zAddWatermark = true;
            pos = CMyString.splitToInt(watermarkPos, ",");
        }
        String otherKindIds = _context.getValue("OtherKindIds");
        int[] kindIds = null;
        kindIds = CMyString.isEmpty(otherKindIds) ? new int[]{} : CMyString.splitToInt(otherKindIds, ",");
        String bmp2Type = _context.getValue("BmpConverType");
        IImageLibMgr libmanager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        StringBuffer result = new StringBuffer(64);
        ImageInfo imageInfo = null;
        for (int i = images.length - 1; i >= 0; --i) {
            imageInfo = new ImageInfo();
            imageInfo.setImageKindId(nMainKindId);
            imageInfo.setOtherImageKinedId(kindIds);
            imageInfo.setImageFileName(images[i]);
            imageInfo.setSrcFileName(names[i]);
            imageInfo.setAddMark(zAddWatermark);
            imageInfo.setMarkImageFile(watermarkFile);
            imageInfo.setMarkPos(pos);
            imageInfo.setConvertToImageType(bmp2Type);
            imageInfo = libmanager.saveImageInfo(imageInfo);
            result.append(",").append(imageInfo.getId());
        }
        String docids = result.substring(1);
        this.startFlowIfNeed(channel, docids, _context);
        return docids;
    }

    private void startFlowIfNeed(Channel _channel, String _docids, MethodContext _context) throws WCMException {
        Channel channel = _channel;
        final String docids = _docids;
        FlowEmployMgr manager = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
        Flow flow = manager.getFlow(channel);
        if (flow == null) {
            return;
        }
        final User loginUser = ContextHelper.getLoginUser();
        final MethodContext context = _context;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
                IFlowContent flowContent = null;
                Documents documents = null;
                ContextHelper.initContext(loginUser);
                try {
                    documents = Documents.findByIds(loginUser, docids);
                    FlowContext flowContext = null;
                    if (context.getValue("DefaultFlowModal", true)) {
                        Document document = null;
                        int size = documents.size();
                        for (int i = 0; i < size; ++i) {
                            document = (Document)documents.getAt(i);
                            if (document == null) continue;
                            flowContent = FlowContentFactory.makeFlowContent(document);
                            flowContext = new FlowContext(loginUser, flowContent);
                            flowContext.setPostDesc(I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label13", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
                            flowServer.submitTo(flowContext);
                        }
                    } else {
                        s_logger.warn((Object)"Flow Modal Not implement!");
                    }
                }
                catch (Exception e) {
                    s_logger.error((Object)"put the image into flow failed!", (Throwable)e);
                }
                finally {
                    if (documents != null) {
                        documents.clear();
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] extractPicFiles(String _fn) throws CMyException {
        String zipfile = _fn;
        if (!CMyFile.fileExists(zipfile)) {
            zipfile = FilesMan.getFilesMan().mapFilePath(zipfile, 0) + zipfile;
        }
        String unzipPath = CMyFile.extractFilePath(zipfile);
        unzipPath = unzipPath + "unziptemp" + File.separator + System.currentTimeMillis() + File.separator;
        IImageLibConfig libconf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        String[] supportPicFormat = libconf.getSupportImageFileExt();
        try {
            CMyUnZipFile unzipper = new CMyUnZipFile(zipfile, unzipPath);
            unzipper.setZipFile(zipfile);
            int p = supportPicFormat.length;
            for (int i = 0; i < p; ++i) {
                unzipper.addFileExtFilters(supportPicFormat[i]);
            }
            unzipper.doUnZipAnd();
            String[] a = new String[]{};
            ArrayList r = unzipper.getFilteredFiles();
            if (r != null) {
                String[] stringArray = r.toArray(a);
                return stringArray;
            }
            String[] stringArray = a;
            return stringArray;
        }
        finally {
            CMyFile.deleteFile(zipfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] extractPicFiles0(String _fn) throws CMyException {
        String zipfile = _fn;
        if (!CMyFile.fileExists(zipfile)) {
            zipfile = FilesMan.getFilesMan().mapFilePath(zipfile, 0) + zipfile;
        }
        String unzipPath = CMyFile.extractFilePath(zipfile);
        unzipPath = unzipPath + "unziptemp" + File.separator + System.currentTimeMillis() + File.separator;
        IImageLibConfig libconf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        try {
            UnZipFile4Batch unzipper = new UnZipFile4Batch(zipfile, unzipPath);
            unzipper.setZipFile(zipfile);
            unzipper.setFilters(libconf.getSupportImageFileExt());
            unzipper.doUnZipAnd();
            SortedMap files = unzipper.getSortedFileNameIndex();
            Iterator itrFile = files.keySet().iterator();
            ArrayList<String> names = new ArrayList<String>(files.size());
            ArrayList images = new ArrayList(files.size());
            String name = null;
            while (itrFile.hasNext()) {
                name = (String)itrFile.next();
                names.add(name);
                images.add(files.get(name));
            }
            String[][] result = new String[2][names.size()];
            names.toArray(result[0]);
            images.toArray(result[1]);
            String[][] stringArray = result;
            return stringArray;
        }
        finally {
            CMyFile.deleteFile(zipfile);
        }
    }

    private void assertHasRight(BaseChannel _host) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (!AuthServer.hasRight(loginUser, (CMSObj)_host, 31)) {
            throw new WCMException(1002, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label14", "\u5bf9\u4e0d\u8d77\u60a8\u6ca1\u6709\u6743\u9650\u4e0a\u4f20\u56fe\u7247\uff01"));
        }
    }

    @Override
    public Object findById(MethodContext _context) throws Throwable {
        _context.setValue("SelectFieldsOfChnlDoc", FIELDS_OF_CHNLDOC);
        _context.setValue("SelectFieldsOfDocument", FIELDS_OF_DOCUMENT);
        return super.findById(_context);
    }

    @Override
    public Object findByIds(MethodContext _context) throws Throwable {
        throw new UnsupportedOperationException("never use:" + _context);
    }

    public Object getSupportedFormat(MethodContext _context) throws Throwable {
        _context.setReturnJSON(false);
        String[] supported = this.m_libConf.getSupportImageFileExt();
        StringBuffer buff = new StringBuffer(32);
        buff.append("{");
        buff.append(supported[0]);
        buff.append(":");
        buff.append(1);
        int p = supported.length;
        for (int i = 1; i < p; ++i) {
            buff.append(",");
            buff.append(supported[i]);
            buff.append(":");
            buff.append(i + 1);
        }
        buff.append("}");
        return buff.toString();
    }

    public Object getSacledImages(MethodContext _context) throws Throwable {
        _context.setReturnJSON(false);
        int nDocId = _context.getObjectId();
        Document doc = Document.findById(nDocId);
        if (doc == null) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label9", "\u6ca1\u6709\u627e\u5230[Id=") + nDocId + I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label15", "]\u7684\u56fe\u7247!"));
        }
        String[] images = CMyString.split(doc.getRelateWords(), ",");
        String image = null;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("doctitle", doc.getTitle());
        HashMap<String, String> temp = null;
        ArrayList scaleImages = new ArrayList(images.length + 1);
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
            int len = images.length;
            for (int i = 0; i < len; ++i) {
                image = images[i];
                temp = new HashMap<String, String>(4);
                imageObj.setFilename(image);
                temp.put("file", image);
                temp.put("width", String.valueOf(imageObj.width));
                temp.put("height", String.valueOf(imageObj.height));
                temp.put("desc", this.m_libConf.getScaleDescAt(i));
                scaleImages.add(temp);
            }
            if (images.length == 1) {
                image = doc.getAttributeValue("SRCFILE");
                temp = new HashMap(4);
                temp.put("file", image);
                imageObj.setFilename(image);
                temp.put("width", String.valueOf(imageObj.width));
                temp.put("height", String.valueOf(imageObj.height));
                temp.put("desc", this.m_libConf.getScaleDescAt(1));
                scaleImages.add(temp);
            }
        } else {
            MagicImageImpl magicImage = new MagicImageImpl();
            int len = images.length;
            for (int i = 0; i < len; ++i) {
                image = images[i];
                magicImage.initMagicImage(image);
                temp = new HashMap(4);
                temp.put("file", image);
                temp.put("width", String.valueOf((int)magicImage.getWidth()));
                temp.put("height", String.valueOf((int)magicImage.getHeight()));
                temp.put("desc", this.m_libConf.getScaleDescAt(i));
                scaleImages.add(temp);
            }
            if (images.length == 1) {
                image = doc.getAttributeValue("SRCFILE");
                magicImage.initMagicImage(image);
                temp = new HashMap(4);
                temp.put("file", image);
                temp.put("width", String.valueOf((int)magicImage.getWidth()));
                temp.put("height", String.valueOf((int)magicImage.getHeight()));
                temp.put("desc", this.m_libConf.getScaleDescAt(1));
                scaleImages.add(temp);
            }
        }
        result.put("ScaleImages", scaleImages.toArray());
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public Object loadLibConf(MethodContext _context) throws Throwable {
        int[] sizes = this.m_libConf.getScaleSizes();
        int size = sizes[1];
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        Boolean firstInstall = !this.m_libConf.isInstalled();
        result.put("firstInstall", firstInstall);
        result.put("surpportedExt", CMyString.join(this.m_libConf.getSupportImageFileExt(), ","));
        result.put("bmp2type", this.m_libConf.getDefaultConvertImageFileExt());
        int len = sizes.length;
        Object[] imageSizes = new Object[len];
        HashMap<String, Object> temp = null;
        String wmSize = null;
        for (int i = 1; i < len; ++i) {
            size = sizes[i];
            temp = new HashMap<String, Object>(4);
            temp.put("size", String.valueOf(size));
            temp.put("sizeEditable", firstInstall);
            wmSize = String.valueOf(this.m_libConf.getWaterMarkSize(size));
            temp.put("wmsize", wmSize);
            temp.put("desc", this.m_libConf.getScaleDescAt(i));
            imageSizes[i] = temp;
        }
        result.put("iamgeSizes", imageSizes);
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public void saveLibConf(MethodContext _context) throws Throwable {
        String supportedExt = _context.getValue("SupportedExt");
        String bmp2type = _context.getValue("DefaultConvertType");
        String scaleSizes = _context.getValue("ScaleSizes");
        String scaleSizeDescs = _context.getValue("ScaleSizeDescs");
        String wmSizes = _context.getValue("WatermarkSizes");
        this.m_libConf.setImageFileExt(this.split(supportedExt), bmp2type);
        this.m_libConf.setScaleSizes(this.split2Int(scaleSizes), this.split(scaleSizeDescs), this.split2Int(wmSizes));
        this.m_libConf.saveConfig();
    }

    private int[] split2Int(String _string) {
        return CMyString.splitToInt(_string, ",");
    }

    private String[] split(String _string) {
        return CMyString.split(_string, ",");
    }

    public Object getQuoteKinds(MethodContext _context) throws Throwable {
        int nPhotoDocId = _context.getObjectId();
        Document doc = Document.findById(nPhotoDocId);
        if (doc == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        int nRecId = _context.getValue("RecId", 0);
        ChnlDoc chnldoc = ChnlDoc.findById(nRecId);
        if (chnldoc != null) {
            result.put("CurrentPath", this.getChnlPath(chnldoc.getChannel()));
        } else {
            result.put("CurrentPath", this.getChnlPath(doc.getChannel()));
        }
        result.put("MainKind", this.getChnlPath(doc.getChannel()));
        Channels channels = this.m_docService.getQuoteChannels(doc);
        if (channels != null && !channels.isEmpty()) {
            ArrayList<String> kinds = new ArrayList<String>(channels.size());
            Channel channel = null;
            int size = channels.size();
            for (int i = 0; i < size; ++i) {
                channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                kinds.add(this.getChnlPath(channel));
            }
            result.put("OtherKinds", kinds.toArray());
        } else {
            result.put("OtherKinds", new String[0]);
        }
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public Object getQuoteDocs(MethodContext _context) throws Throwable {
        int nPhotoDocId = _context.getObjectId();
        Documents docs = this.m_libManager.getDocumentsQuoteImage(nPhotoDocId);
        HashMap<String, Object[]> result = new HashMap<String, Object[]>(docs.size());
        ArrayList images = new ArrayList(docs.size());
        Document doc = null;
        HashMap<String, String> temp = null;
        int size = docs.size();
        for (int i = 0; i < size; ++i) {
            doc = (Document)docs.getAt(i);
            if (doc == null) continue;
            temp = new HashMap<String, String>(3);
            temp.put("DocTitle", doc.getTitle());
            temp.put("ChnlPath", this.getChnlPath(doc.getChannel()));
            temp.put("DocStatus", String.valueOf(doc.getStatusId()));
            images.add(temp);
        }
        result.put("Documents", images.toArray());
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    private String getChnlPath(Channel _channel) throws WCMException {
        if (_channel == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append(_channel.getSite().getDesc());
        buff.append("&nbsp;>&nbsp;");
        for (Channel parent = _channel.getParent(); parent != null; parent = parent.getParent()) {
            buff.append(parent.getDesc());
            buff.append("&nbsp;>&nbsp;");
        }
        buff.append(_channel.getDesc());
        return buff.toString();
    }

    public Object getExtendedProps(MethodContext _context) throws Throwable {
        int nPhotoDocId = _context.getObjectId();
        Document doc = Document.findById(nPhotoDocId);
        if (doc == null) {
            return null;
        }
        Channel host = doc.getChannel();
        ContentExtFields fields = this.m_oExtFieldMgr.getExtFields(host, null);
        if (fields.isEmpty()) {
            return null;
        }
        HashMap<String, Object[]> result = new HashMap<String, Object[]>(1);
        ArrayList props = new ArrayList(fields.size());
        HashMap<String, String> temp = null;
        ContentExtField field = null;
        String fieldValue = null;
        String fieldName = null;
        DataType dataType = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = (ContentExtField)fields.getAt(i);
            if (field == null) continue;
            temp = new HashMap<String, String>(5);
            temp.put("desc", field.getDesc());
            fieldName = field.getName();
            temp.put("name", fieldName);
            fieldValue = doc.getPropertyAsString(fieldName);
            temp.put("value", CMyString.transDisplay(fieldValue, false));
            dataType = field.getType();
            temp.put("type", this.mapExtfieldType(dataType.getType()));
            temp.put("maxlen", this.mapExtfieldMaxLength(dataType, field.getMaxLength()));
            temp.put("minlen", this.mapExtfeildMinLength(dataType));
            props.add(temp);
        }
        result.put("ExtendedProps", props.toArray());
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    private String mapExtfieldMaxLength(DataType _dataType, int _definedMaxLen) {
        int nType = _dataType.getType();
        switch (nType) {
            case 4: {
                return "2147483647";
            }
            case 2: 
            case 5: {
                return "32767";
            }
            case -5: 
            case 6: 
            case 8: {
                return "9223372036854775807";
            }
            case 91: 
            case 93: {
                return "8";
            }
            case 2005: {
                return "";
            }
        }
        return String.valueOf(_definedMaxLen);
    }

    private String mapExtfeildMinLength(DataType _dataType) {
        if (_dataType.isLengthDefinedByUser()) {
            return "0";
        }
        int nType = _dataType.getType();
        String result = "-";
        result = -5 == nType ? result + "9223372036854775807" : (4 == nType ? result + "2147483647" : result + "32767");
        return result;
    }

    private String mapExtfieldType(int _sqltype) {
        switch (_sqltype) {
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return "int";
            }
            case 6: 
            case 8: {
                return "float";
            }
            case 91: 
            case 93: {
                return "date";
            }
            case 2005: {
                return "";
            }
        }
        return "string";
    }

    public Object getDefaultBmpConverType(MethodContext _context) throws Throwable {
        _context.setReturnJSON(false);
        String type = this.m_libConf.getDefaultConvertImageFileExt();
        if (type == null) {
            type = "";
        }
        return type;
    }

    public Object loadOriginImg(MethodContext _context) throws Throwable {
        int nPhotoId = _context.getValue("PhotoId", 0);
        Document photodoc = Document.findById(nPhotoId, "DocId,Attribute,DocChannel,DocTitle");
        if (photodoc == null) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label16", "\u6ca1\u6709\u627e\u5230\u56fe\u7247[Id=") + nPhotoId + "]!");
        }
        String fn = photodoc.getAttributeValue("SrcFile");
        if (CMyString.isEmpty(fn)) {
            throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label17", "\u6ca1\u6709\u627e\u5230\u539f\u56fe!"));
        }
        int nHeight = 0;
        int nWidth = 0;
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
            imageObj.setFilename(fn);
            nHeight = imageObj.height;
            nWidth = imageObj.width;
        } else {
            MagicImageImpl oMagicImage = new MagicImageImpl();
            oMagicImage.initMagicImage(fn);
            nHeight = (int)oMagicImage.getHeight();
            nWidth = (int)oMagicImage.getWidth();
        }
        HashMap<String, String> result = new HashMap<String, String>(5);
        result.put("fn", fn);
        result.put("width", String.valueOf(nWidth));
        result.put("height", String.valueOf(nHeight));
        result.put("libid", String.valueOf(photodoc.getChannel().getSiteId()));
        result.put("doctitle", photodoc.getTitle());
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public Object scaleImage(MethodContext _context) throws Throwable {
        String fn = _context.getValue("FileName");
        int width = _context.getValue("ScaleWidth", 0);
        int height = _context.getValue("ScaleHeight", 0);
        String sFolderExt = _context.getValue("FolderExt");
        if (sFolderExt == null) {
            sFolderExt = "ST";
        }
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj();
            srcimg.setFilename(fn);
            FilesMan fileman = FilesMan.getFilesMan();
            String filename = fileman.getNextFileName(sFolderExt, CMyFile.extractFileExt(srcimg.filename), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj dstimg = new ImageMagickCmd.ImageObj(filename, width, height);
            ImageMagickCmd.scale(srcimg, dstimg);
            return this.newImage(_context, dstimg);
        }
        MagicImageImpl oMagicImage = new MagicImageImpl();
        oMagicImage.initMagicImage(fn);
        oMagicImage.scaleImage(width, height);
        String result = oMagicImage.writeImageToSystemTemp();
        return this.newImage(_context, result);
    }

    private Object newImage(MethodContext _context, String _fn) throws Throwable {
        _context.setReturnJSON(true);
        String fn = CMyFile.extractFileName(_fn);
        MagicImageImpl oMagicImage = new MagicImageImpl();
        oMagicImage.initMagicImage(fn);
        int nHeight = (int)oMagicImage.getHeight();
        int nWidth = (int)oMagicImage.getWidth();
        HashMap<String, String> result = new HashMap<String, String>(3);
        result.put("fn", fn);
        result.put("width", String.valueOf(nWidth));
        result.put("height", String.valueOf(nHeight));
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public Object rotateImage(MethodContext _context) throws Throwable {
        String fn = _context.getValue("FileName");
        String rotateDegree = _context.getValue("Degree");
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj(fn);
            ImageMagickCmd.roateImg(srcimg, rotateDegree);
            return this.newImage(_context, srcimg);
        }
        MagicImageImpl oMagicImage = new MagicImageImpl();
        oMagicImage.initMagicImage(fn);
        oMagicImage.rotateImage(Double.parseDouble(rotateDegree));
        String result = oMagicImage.writeImageToSystemTemp();
        return this.newImage(_context, result);
    }

    private Object newImage(MethodContext _context, ImageMagickCmd.ImageObj img) throws Throwable {
        _context.setReturnJSON(true);
        HashMap<String, String> result = new HashMap<String, String>(3);
        result.put("fn", CMyFile.extractFileName(img.filename));
        result.put("width", String.valueOf(img.width));
        result.put("height", String.valueOf(img.height));
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public Object addBorder(MethodContext _context) throws Throwable {
        String fn = _context.getValue("FileName");
        int borderWidth = _context.getValue("BorderWidth", 0);
        int borderHeight = _context.getValue("BorderHeight", 0);
        String borderColor = _context.getValue("BorderColor");
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj(fn);
            ImageMagickCmd.borderImg(srcimg, borderColor, borderWidth, borderHeight);
            return this.newImage(_context, srcimg);
        }
        MagicImageImpl oMagicImage = new MagicImageImpl();
        oMagicImage.initMagicImage(fn);
        oMagicImage.borderImage(borderColor, borderWidth, borderHeight);
        String result = oMagicImage.writeImageToSystemTemp();
        return this.newImage(_context, result);
    }

    public Object raiseImage(MethodContext _context) throws Throwable {
        String fn = _context.getValue("FileName");
        int width = _context.getValue("RaiseWidth", 0);
        int height = _context.getValue("RaiseHeight", 0);
        boolean zRaised = _context.getValue("IsRaised", false);
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj(fn);
            ImageMagickCmd.raiseImg(srcimg, width, height, zRaised);
            return this.newImage(_context, srcimg);
        }
        MagicImageImpl oMagicImage = new MagicImageImpl();
        oMagicImage.initMagicImage(fn);
        oMagicImage.raiseImage(width, height, zRaised);
        String result = oMagicImage.writeImageToSystemTemp();
        return this.newImage(_context, result);
    }

    public Object saveOriginImg(MethodContext _context) throws Throwable {
        String fn = _context.getValue("FileName");
        String srcf = _context.getValue("SrcFile");
        int nPhotoId = _context.getValue("PhotoId", 0);
        String wmfile = _context.getValue("WaterMarkFile");
        boolean zAddWaterMark = !CMyString.isEmpty(wmfile);
        int[] pos = null;
        if (FilesMan.isValidFile(wmfile, "W0")) {
            String watermarkPos = _context.getValue("WaterMarkPos");
            zAddWaterMark = true;
            pos = !CMyString.isEmpty(watermarkPos) ? CMyString.splitToInt(watermarkPos, ",") : new int[]{ImageLibConstants.MARKPOS_RIGHT_BOTTOM};
        }
        String bmp2type = _context.getValue("ConvertType");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setId(nPhotoId);
        imageInfo.setImageFileName(fn);
        imageInfo.setSrcFileName(srcf);
        imageInfo.setAddMark(zAddWaterMark);
        imageInfo.setMarkImageFile(wmfile);
        imageInfo.setMarkPos(pos);
        imageInfo.setConvertToImageType(bmp2type);
        imageInfo = this.m_libManager.saveImageInfo(imageInfo);
        return String.valueOf(imageInfo.getId());
    }

    public Object getSysPics(MethodContext _context) throws Throwable {
        int nHostId;
        String dtEnd;
        String dtStart;
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer buff = new StringBuffer(128);
        buff.append("EXISTS(");
        buff.append("SELECT docid FROM wcmdocument WHERE");
        buff.append(" wcmappendix.AppFlag=20 AND ");
        buff.append(" DocStatus>0 AND ");
        buff.append(" docid=wcmappendix.appdocid AND ");
        String searchKey = _context.getValue("SearchKey");
        String searchValue = _context.getValue("SearchValue");
        if (!CMyString.isEmpty(searchKey) && !CMyString.isEmpty(searchValue)) {
            String[] keys = searchKey.toUpperCase().split(",");
            String key = keys[0];
            buff.append("(");
            DBType db = DBManager.getDBManager().getDBType();
            if ("DOCHTMLCON".equals(key)) {
                buff.append(db.sqlFilterForClob(key, searchValue));
            } else {
                buff.append(key);
                buff.append(" LIKE ? ");
                filter.addSearchValues("%" + searchValue + "%");
            }
            int len = keys.length;
            for (int i = 1; i < len; ++i) {
                key = keys[i];
                buff.append(" OR ");
                if ("DOCHTMLCON".equals(key)) {
                    buff.append(db.sqlFilterForClob(key, searchValue));
                    continue;
                }
                buff.append(key);
                buff.append(" LIKE ? ");
                filter.addSearchValues("%" + searchValue + "%");
            }
            buff.append(")");
            buff.append(" AND ");
        }
        if (!CMyString.isEmpty(dtStart = _context.getValue("StartTime"))) {
            buff.append(" WCMDocument.CrTime>? AND ");
            CMyDateTime dt = new CMyDateTime();
            dt.setDateTimeWithString(dtStart);
            filter.addSearchValues(dt);
        }
        if (!CMyString.isEmpty(dtEnd = _context.getValue("EndTime"))) {
            buff.append(" WCMDocument.CrTime<? AND ");
            CMyDateTime dt = new CMyDateTime();
            dt.setDateTimeWithString(dtEnd);
            filter.addSearchValues(dt);
        }
        if ((nHostId = _context.getValue("ChannelId", 0)) > 0) {
            buff.append(" wcmdocument.DocChannel=?");
            filter.addSearchValues(nHostId);
        } else {
            nHostId = _context.getValue("SiteId", 0);
            buff.append(" EXISTS(SELECT channelid FROM WCMChannel WHERE ");
            buff.append(" wcmdocument.DocChannel=ChannelId AND SiteId=?)");
            filter.addSearchValues(nHostId);
        }
        buff.append(")");
        filter.setWhere(buff.toString());
        filter.setSelect("AppendixId,AppDocId,AppFile,AppDesc");
        Appendixes appendixs = new Appendixes(null);
        appendixs.open(filter);
        Appendix appendix = null;
        FilesMan fileman = FilesMan.getFilesMan();
        List<String> supported = Arrays.asList(this.m_libConf.getSupportImageFileExt());
        String fn = null;
        String fext = null;
        for (int i = appendixs.size() - 1; i >= 0; --i) {
            appendix = (Appendix)appendixs.getAt(i);
            if (appendix == null) continue;
            fn = appendix.getFile();
            fext = appendix.getFileExt().toLowerCase();
            if (fileman.fileExists(fn) && supported.contains(fext)) continue;
            appendixs.remove(appendix, false);
        }
        return appendixs;
    }

    public Object importSysPics(MethodContext _context) throws Throwable {
        String watermarkPos;
        int nMainKindId = _context.getValue("MainKindId", 0);
        Channel channel = Channel.findById(nMainKindId);
        this.assertHostValid(nMainKindId, channel, false);
        this.assertHasRight(channel);
        String picids = _context.getValue("PicIds");
        User loginUser = ContextHelper.getLoginUser();
        Appendixes pics = Appendixes.findByIds(loginUser, picids);
        String watermarkFile = _context.getValue("WatermarkFile");
        boolean zAddWatermark = false;
        int[] pos = null;
        if (FilesMan.isValidFile(watermarkFile, "W0") && !CMyString.isEmpty(watermarkPos = _context.getValue("WatermarkPos"))) {
            zAddWatermark = true;
            pos = CMyString.splitToInt(watermarkPos, ",");
        }
        String otherKindIds = _context.getValue("OtherKindIds");
        int[] kindIds = null;
        kindIds = CMyString.isEmpty(otherKindIds) ? new int[]{} : CMyString.splitToInt(otherKindIds, ",");
        String bmp2Type = _context.getValue("BmpConverType");
        Appendix pic = null;
        IImageLibMgr libmanager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        StringBuffer result = new StringBuffer(64);
        ImageInfo imageInfo = null;
        Document appdoc = null;
        int size = pics.size();
        for (int i = 0; i < size; ++i) {
            pic = (Appendix)pics.getAt(i);
            if (pic == null || pic.getFlag() != 20 || (appdoc = Document.findById(pic.getDocId())) == null) continue;
            imageInfo = new ImageInfo();
            imageInfo.setImageKindId(nMainKindId);
            imageInfo.setOtherImageKinedId(kindIds);
            imageInfo.setImageFileName(pic.getFile());
            imageInfo.setSrcFileName(appdoc.getTitle());
            imageInfo.setAddMark(zAddWatermark);
            imageInfo.setMarkImageFile(watermarkFile);
            imageInfo.setMarkPos(pos);
            imageInfo.setConvertToImageType(bmp2Type);
            imageInfo = libmanager.saveImageInfo(imageInfo);
            result.append(",").append(imageInfo.getId());
        }
        String docids = result.substring(1);
        this.startFlowIfNeed(channel, docids, _context);
        return docids;
    }

    public Object loadSysPicProps(MethodContext _context) throws WCMException {
        int nPhotoId = _context.getValue("PhotoId", 0);
        String fields = "DocTitle,CrUser,CrTime,DocKeywords,DocChannel";
        Document photodoc = Document.findById(nPhotoId, fields);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("DocTitle", photodoc.getTitle());
        result.put("CrTime", photodoc.getCrTime());
        result.put("CrUser", photodoc.getCrUser());
        result.put("DocKeywords", CMyString.showNull(photodoc.getKeywords(), ""));
        result.put("DocPath", this.getChnlPath(photodoc.getChannel()));
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    public Object cropImage(MethodContext _context) throws Throwable {
        String sFileName = _context.getValue("Filename");
        int nX = _context.getValue("x", 0);
        int nY = _context.getValue("y", 0);
        int nWidth = _context.getValue("width", 0);
        int nHeight = _context.getValue("height", 0);
        if (this.m_libConf.isCmdUsed()) {
            ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj();
            srcimg.setFilename(sFileName);
            ImageMagickCmd.crop(srcimg, nX, nY, nWidth, nHeight);
            return this.newImage(_context, srcimg);
        }
        FilesMan fileman = FilesMan.getFilesMan();
        String sNewAbsoluteFileName = fileman.getNextFileName("ST", CMyFile.extractFileExt(sFileName), CMyDateTime.now(), true);
        MagicImageImpl oMagicImage = new MagicImageImpl();
        oMagicImage.initMagicImage(sFileName);
        oMagicImage.cropImage(nX, nY, nWidth, nHeight, sNewAbsoluteFileName);
        return this.newImage(_context, sNewAbsoluteFileName);
    }

    public void saveExtif(MethodContext _context) throws Throwable {
        int nSrcLength;
        User loginUser = ContextHelper.getLoginUser();
        String sFileName = _context.getValue("SrcFiles");
        String sObjids = _context.getValue("ObjectIds");
        String results = "";
        String sSrc = "";
        Document currDocument = null;
        int nIdLength = sObjids.split(",").length;
        if (nIdLength != (nSrcLength = sFileName.split(",").length)) {
            return;
        }
        if (nIdLength > 0) {
            for (int i = 0; i < nIdLength; ++i) {
                currDocument = Document.findById(Integer.parseInt(sObjids.split(",")[i]));
                if (currDocument == null) {
                    throw new WCMException(200006, I18NMessage.get(PhotoServiceProvider.class, "PhotoServiceProvider.label16", "\u6ca1\u6709\u627e\u5230\u56fe\u7247[Id=") + sObjids.split(",")[i] + "]!");
                }
                sSrc = FilesMan.getFilesMan().mapFilePath(sFileName.split(",")[i], 0);
                results = ImagesMetaDatas.getWCMExif((String)(sSrc + sFileName.split(",")[i]));
                if (results.trim().length() < 10 && (results = ImagesMetaDatas.getWCMIptc((String)(sSrc + sFileName.split(",")[i]))).trim().length() < 10) continue;
                currDocument.setAbstract(results);
                currDocument.save(loginUser);
            }
        }
    }
}

