/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bbs.plad.upload;

import com.trs.bbs.plad.upload.RFC1867Exception;
import com.trs.bbs.plad.upload.RFC1867InputStream;
import com.trs.bbs.plad.upload.RFC1867OutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class RFC1867FormPart {
    private File m_fTemporalPath;
    protected int m_iBrotherCount = 1;
    protected RFC1867FormPart m_rfNextBrother = null;
    protected String m_strName;
    protected String m_strFileName;
    private String m_strFileType;
    protected String m_strMimeType;
    protected String m_strStringValue;
    protected RFC1867OutputStream m_osOutputStream;

    public void delete() {
        this.m_osOutputStream.delete();
    }

    protected void fillPartData(RFC1867InputStream inputStream) throws RFC1867Exception {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = this.getOutputStream();
                inputStream.readBody(outputStream);
            }
            catch (IOException ex) {
                throw new RFC1867Exception(ex);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getFileName() {
        return this.m_strFileName;
    }

    public void setFileName(String strFileName) {
        if (strFileName == null) {
            return;
        }
        if (strFileName.length() > 256) {
            strFileName = strFileName.substring(0, 255);
        }
        this.m_strFileName = strFileName;
        this.setFileType(strFileName);
    }

    public String getFileType() {
        return this.m_strFileType;
    }

    public void setFileType(String strFileType) {
        if (strFileType == null) {
            return;
        }
        int dotIndex = strFileType.lastIndexOf(46);
        if (dotIndex <= 0) {
            return;
        }
        this.m_strFileType = strFileType.substring(dotIndex + 1);
        if (this.m_strFileType.length() > 16) {
            this.m_strFileType = this.m_strFileType.substring(0, 15);
        }
        this.m_strFileType = this.m_strFileType.toLowerCase();
    }

    public String getMimeType() {
        return this.m_strMimeType;
    }

    public void setMimeType(String strMimeType) {
        if (strMimeType == null) {
            return;
        }
        if (strMimeType.length() > 64) {
            strMimeType = strMimeType.substring(0, 63);
        }
        this.m_strMimeType = strMimeType;
    }

    public String getName() {
        return this.m_strName;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.m_osOutputStream == null) {
            this.m_osOutputStream = new RFC1867OutputStream();
            this.m_osOutputStream.setTemporalPath(this.m_fTemporalPath);
        }
        return this.m_osOutputStream;
    }

    public long getSize() {
        return this.isInMemory() ? (long)this.getValue().length : this.getStore().length();
    }

    public File getStore() {
        if (this.m_osOutputStream != null) {
            return this.m_osOutputStream.getFile();
        }
        return null;
    }

    public InputStream getStream() throws IOException {
        if (this.isInMemory()) {
            return new ByteArrayInputStream(this.getValue());
        }
        return new FileInputStream(this.getStore());
    }

    public String getString() {
        if (this.m_strStringValue == null && this.getValue() != null) {
            try {
                this.m_strStringValue = new String(this.getValue(), "GBK");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.m_strStringValue;
    }

    public byte[] getValue() {
        return this.m_osOutputStream.getData();
    }

    public boolean isInMemory() {
        return this.m_osOutputStream.isInMemory();
    }

    protected void setTemporalPath(File paramFile) {
        this.m_fTemporalPath = paramFile;
    }

    public void writeTo(File paramFile) throws Exception {
        block13: {
            if (!this.isInMemory() && this.getStore().renameTo(paramFile)) {
                return;
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(paramFile);
                    this.writeTo(fos);
                }
                catch (Exception ex) {
                    System.out.println("write to file failed.");
                    ex.printStackTrace(System.out);
                    if (fos == null) break block13;
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        block13: {
            byte[] buffer = new byte[4096];
            InputStream ins = this.getStream();
            try {
                try {
                    int len = 0;
                    while ((len = ins.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    if (ins == null) break block13;
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.m_strName) + ":" + this.getSize();
    }
}

