/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.StringHelper;
import java.sql.Timestamp;

public class LogUtil {
    public static void log(Object obj) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(new Timestamp(System.currentTimeMillis()));
        sb.append('\t');
        sb.append(LogUtil.getCaller(3));
        sb.append(obj);
        System.out.println(sb);
    }

    public static String getCaller() {
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        if (stacks.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(0x100000);
        int i = 0;
        while (i < stacks.length) {
            StackTraceElement element = stacks[i];
            if (element != null && i != 0) {
                if (i >= 5) break;
                if (StringHelper.isEmpty(sb.toString())) {
                    sb.append(element.toString());
                } else {
                    sb.append("<-").append(element.toString());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getCaller(int n) {
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        if (n < 0 || n >= stacks.length) {
            n = 0;
        }
        return stacks[n].toString();
    }

    public static String getCallerAndThreadName() {
        StringBuffer sb = new StringBuffer(96);
        sb.append(LogUtil.getCaller(3));
        sb.append('[').append(Thread.currentThread().getName()).append(']');
        return sb.toString();
    }
}

