/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.protocol;

import com.trs.idm.interact.protocol.AbstractPU;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolConst;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

class JDK14PUImpl
extends AbstractPU {
    private static final Logger LOG = Logger.getLogger(JDK14PUImpl.class);

    JDK14PUImpl() {
    }

    @Override
    byte[] convertPacketHead2Bytes(short bodyLen, byte type, short packetID, byte cmdOrErrcode, byte encryptAlgo, byte reversed1, byte reversed2, byte processCmd) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.put(ProtocolConst.PROTOCOL_ID);
        buffer.put((byte)2);
        buffer.put((byte)0);
        buffer.putShort(bodyLen);
        buffer.put(type);
        buffer.putShort(packetID);
        buffer.put(cmdOrErrcode);
        buffer.put(encryptAlgo);
        buffer.put(reversed1);
        buffer.put(reversed2);
        buffer.put(processCmd);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(buffer + ", hasArray()=" + buffer.hasArray()));
        }
        return buffer.array();
    }

    @Override
    short parseBodyLength(byte[] data) {
        if (data == null || data.length < 16) {
            throw new IllegalArgumentException("the bytes is null, or its length < 16");
        }
        return ByteBuffer.wrap(data).getShort(6);
    }

    @Override
    byte[] short2Bytes(short value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value);
        return buffer.array();
    }

    @Override
    byte[] stringArray2PacketBodyBytes(String[] body, short bodyLen, byte majorVersion, String idmServerCharset) {
        String charsetName = PacketUtil.getCharsetName(majorVersion, idmServerCharset);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("get charsetName[" + charsetName + "] by majorVersion[" + majorVersion + "]"));
        }
        ByteBuffer buffer = ByteBuffer.allocate(bodyLen);
        int i = 0;
        while (i < body.length) {
            try {
                if (body[i] == null) {
                    body[i] = "";
                }
                byte[] temp = body[i].getBytes(charsetName);
                buffer.put(temp);
                buffer.put("\n\r".getBytes(charsetName));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("UnsupportedEncoding[" + charsetName + "] by majorVersion[" + majorVersion + "]"));
            }
            ++i;
        }
        return buffer.array();
    }

    @Override
    byte[] stringArray2PacketBodyBytes(String[] body, short bodyLen) {
        boolean PROTOCOL_MAJ_OLD_VER = true;
        return this.stringArray2PacketBodyBytes(body, bodyLen, (byte)1, null);
    }

    @Override
    ProtocolPacket parseFromBytes(byte[] data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("packetData=" + StringHelper.toString(data)));
        }
        if (data == null) {
            LOG.warn((Object)"data=null! skip and return null!");
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte type = buffer.get(8);
        short bodyLen = buffer.getShort(6);
        byte majorVersion = buffer.get(4);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("packetType=" + type + ", bodyLen=" + bodyLen + ", majorVersion[" + majorVersion + "]"));
        }
        byte[] bodyDatas = new byte[bodyLen];
        System.arraycopy(data, 16, bodyDatas, 0, bodyDatas.length);
        try {
            if (type == 0) {
                byte cmd = buffer.get(11);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("new RequestPacket by bodyDatas[" + bodyDatas + "], processCmd[" + cmd + "], packetType=" + type + ", bodyLen=" + bodyLen + ", majorVersion[" + majorVersion + "]"));
                }
                return new RequestPacket(cmd, bodyDatas, majorVersion, null);
            }
            if (type == 1) {
                byte errcode = buffer.get(11);
                byte processCmd = buffer.get(15);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("new ResponsePacket by errcode[" + errcode + "], bodyDatas[" + bodyDatas + "], processCmd[" + processCmd + "], packetType=" + type + ", bodyLen=" + bodyLen + ", majorVersion[" + majorVersion + "]"));
                }
                return new ResponsePacket(errcode, bodyDatas, processCmd, majorVersion);
            }
            LOG.error((Object)("invalid packet type! type=" + type + "bodyDatas[" + bodyDatas + "], packetType=" + type + ", bodyLen=" + bodyLen + ", majorVersion[" + majorVersion + "]"));
        }
        catch (Exception e) {
            LOG.error((Object)("fail on try to create packet!bytes=" + StringHelper.toString(data)), (Throwable)e);
        }
        LOG.warn((Object)("get ProtocolPacket is null by packetType=" + type + ", bodyLen=" + bodyLen + ", majorVersion[" + majorVersion + "]"));
        return null;
    }
}

