/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.StringHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    private static final String DEFAULT_MIILITIME_PATTERN = "yyyy-MM-dd HH:mm:ss:SSS";

    public static String timeToString(long msUsed) {
        if (msUsed < 0L) {
            return String.valueOf(msUsed);
        }
        if (msUsed < 1000L) {
            return String.valueOf(String.valueOf(msUsed)) + "\u6beb\u79d2";
        }
        if ((msUsed /= 1000L) < 60L) {
            return String.valueOf(String.valueOf(msUsed)) + "\u79d2";
        }
        if (msUsed < 3600L) {
            long nMinute = msUsed / 60L;
            long nSecond = msUsed % 60L;
            return String.valueOf(String.valueOf(nMinute)) + "\u5206" + String.valueOf(nSecond) + "\u79d2";
        }
        if (msUsed < 86400L) {
            long nHour = msUsed / 3600L;
            long nMinute = (msUsed - nHour * 3600L) / 60L;
            long nSecond = (msUsed - nHour * 3600L) % 60L;
            return String.valueOf(String.valueOf(nHour)) + "\u5c0f\u65f6" + String.valueOf(nMinute) + "\u5206" + String.valueOf(nSecond) + "\u79d2";
        }
        long nDay = msUsed / 86400L;
        long nHour = (msUsed - nDay * 86400L) / 3600L;
        long nMinute = (msUsed - nDay * 86400L - nHour * 3600L) / 60L;
        long nSecond = (msUsed - nDay * 86400L - nHour * 3600L) % 60L;
        return String.valueOf(String.valueOf(nDay)) + "\u5929" + String.valueOf(nHour) + "\u5c0f\u65f6" + String.valueOf(nMinute) + "\u5206" + String.valueOf(nSecond) + "\u79d2";
    }

    public static Calendar getThisMonday() {
        return DateUtil.getThatMonday(Calendar.getInstance());
    }

    public static Calendar getThatMonday(Calendar cal) {
        int n = cal.get(7) - 2;
        cal.add(5, n);
        return cal;
    }

    public static Calendar getThisSunday() {
        return DateUtil.getThatSunday(Calendar.getInstance());
    }

    public static Calendar getThatSunday(Calendar cal) {
        int n = 8 - cal.get(7);
        cal.add(5, n);
        return cal;
    }

    public static int betweenDays(Calendar begin, Calendar end) {
        long msBegin = begin.getTimeInMillis();
        long msEnd = end.getTimeInMillis();
        long between_days = (msEnd - msBegin) / 86400000L;
        between_days = Math.abs(between_days);
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int minusWithoutAbs(Calendar calBegin, Calendar calEnd) {
        long msBegin = calBegin.getTimeInMillis();
        long msEnd = calEnd.getTimeInMillis();
        long between_days = (msEnd - msBegin) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int minusWithoutAbs(Date begin, Date end) {
        long between_days = (end.getTime() - begin.getTime()) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static boolean isBeforeToday(Date someDate) {
        Date today = new Date();
        if (today.getTime() - someDate.getTime() > 0L && today.getTime() - someDate.getTime() < 86400000L && today.getDay() != someDate.getDay()) {
            return true;
        }
        return DateUtil.minusWithoutAbs(someDate, new Date()) > 0;
    }

    public static boolean isAfterToday(Date date) {
        return DateUtil.minusWithoutAbs(Calendar.getInstance(), DateUtil.toCalendar(date)) > 0;
    }

    public static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal;
    }

    /*
     * Unable to fully structure code
     */
    public static Date stringToDate(String dateString, String dateFormat) {
        if ("".equals(dateString) || dateString == null) {
            return null;
        }
        try {
            simpleDateFormat = new SimpleDateFormat(dateFormat);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            ** for (pattern : DateUtil.prepareDefaultPatterns())
        }
lbl-1000:
        // 1 sources

        {
            try {
                simpleDateFormat = new SimpleDateFormat(pattern);
                simpleDateFormat.setLenient(false);
                return simpleDateFormat.parse(dateString);
            }
            catch (Exception var5_6) {
                // empty catch block
            }
            continue;
        }
lbl16:
        // 1 sources

        return null;
    }

    public static String DateToString(Date date, String dateFormat) {
        if (date == null) {
            return "";
        }
        try {
            return new SimpleDateFormat(dateFormat).format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String DateToString(Date date) {
        return DateUtil.DateToString(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeMillisToString(long timeMillis) {
        return DateUtil.timeMillisToString(timeMillis, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeMillisToString(long timeMillis, String dateFormat) {
        if (timeMillis == 0L) {
            return "";
        }
        if ("".equals(dateFormat) || dateFormat == null) {
            return "";
        }
        try {
            return new SimpleDateFormat(dateFormat).format(new Date(timeMillis));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date stringToDate(String dateString) {
        return DateUtil.stringToDate(dateString, "yyyy-MM-dd HH:mm:ss");
    }

    public static long stringToTimeMillis(String dateStr, String dateFormat) {
        Date date;
        if (dateStr == null || "".equals(dateStr)) {
            return -1L;
        }
        if (StringHelper.isEmpty(dateFormat)) {
            dateFormat = DEFAULT_MIILITIME_PATTERN;
        }
        return (date = DateUtil.stringToDate(dateStr, dateFormat)) == null ? -1L : date.getTime();
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDateTime(String dateFormat) {
        return DateUtil.timeMillisToString(System.currentTimeMillis(), dateFormat);
    }

    public static Calendar getCalendar(Calendar cal, int relativeDay) {
        cal.add(5, relativeDay);
        return cal;
    }

    public static Date getDate(int relativeDay) {
        return DateUtil.getCalendar(Calendar.getInstance(), relativeDay).getTime();
    }

    public static Date getDate(Date date, int relativeDay) {
        return DateUtil.getCalendar(DateUtil.toCalendar(date), relativeDay).getTime();
    }

    public static int month2second(int month) {
        return month * 30 * 24 * 3600;
    }

    public static int month2second(double month) {
        return (int)(month * 30.0 * 24.0 * 3600.0);
    }

    public static String formatDate(Date date) {
        return DateUtil.DateToString(date, "yyyy-MM-dd");
    }

    public static Date parseDate(String date) {
        return DateUtil.parseDate(date, DateUtil.prepareDefaultPatterns());
    }

    public static Date parseDate(String date, List patterns) {
        if (date == null) {
            return null;
        }
        for (String pattern : patterns) {
            try {
                return new SimpleDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static List prepareDefaultPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(DEFAULT_MIILITIME_PATTERN);
        patterns.add("yyyy-MM-dd HH:mm:ss");
        patterns.add("yyyy-MM-dd HH:mm");
        patterns.add("yyyy-MM-dd HH");
        patterns.add("yyyy-MM-dd");
        patterns.add("yyyyMMdd");
        return patterns;
    }

    public static long getThisMorning() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static int getMillisecond(int day) {
        int totlMillisecond = day * 24 * 60 * 60 * 1000;
        return totlMillisecond;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.timeMillisToString(new Long("1286558400000")));
    }
}

