/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.core;

import com.trs.idm.client.IWebCoAppActor;
import com.trs.idm.client.actor.IServletAppActor;
import com.trs.idm.client.actor.LegacyActorAdapter;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.client.actor.v2.LegacyActorAdapterV2;
import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.interact.agent.validator.IAgentPropertiesValidator;
import com.trs.idm.interact.agent.validator.SSOAPIPropertiesValidator;
import com.trs.idm.saml.common.IDSUser;
import com.trs.idm.saml.interact.IRequest;
import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.interact.impl.simple.request.SimpleRedirectCheckSSOStatusRequest;
import com.trs.idm.saml.protocol.IClientProtocolManager;
import com.trs.idm.saml.protocol.SimpleTokenClientProtocolManager;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.core.ServiceProviderBase;
import com.trs.idm.saml.sp.resource.IResourceManager;
import com.trs.idm.saml.sp.resource.StdResourceManager;
import com.trs.idm.saml.sp.transporter.impl.StdTransporterManager;
import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;

public class SimpleServiceProvider
extends ServiceProviderBase {
    private static final Logger LOG = Logger.getLogger(SimpleServiceProvider.class);
    private String coAppActorClassName;
    private boolean isFristTimeCheckSSOLogin;
    protected IServletAppActorV2 actorV2;
    private boolean reportSPStatusToIDS;
    private Thread spStatusReporterThread;
    private IAgentPropertiesValidator agentPropertiesValidator;
    private boolean useStdHttpSession;

    public String getSPType() {
        return "simpleToken";
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        super.start();
        LOG.info((Object)"SimpleServiceProvider starting");
        this.agentPropertiesValidator = new SSOAPIPropertiesValidator();
        if (!this.agentPropertiesValidator.check()) {
            LOG.error((Object)"IDS Agent properties is not correct, Agent start failed !!!!!!!");
            this.isStarted = false;
            return;
        }
        this.transporterManager = new StdTransporterManager(this);
        this.transporterManager.start();
        this.clientProtocolManager = new SimpleTokenClientProtocolManager(this);
        this.requestBuilder = this.clientProtocolManager.getRequestBuilder();
        this.resourceManager = new StdResourceManager(this);
        this.resourceManager.start();
        this.coAppActorClassName = this.getConfig().getConfig("coAppActor.className");
        this.actorV2 = this.createServletAppActorV2();
        this.useStdHttpSession = this.getConfig().getConfigAsBool("sp.simple.sso.useStandardHttpSession", true);
        this.reportSPStatusToIDS = true;
        this.isStarted = true;
        LOG.info((Object)"SimpleServiceProvider started");
    }

    public void stop() {
        LOG.info((Object)"SimpleServiceProvider stopping");
        this.transporterManager.stop();
        this.transporterManager = null;
        this.resourceManager.stop();
        this.resourceManager = null;
        super.stop();
        this.reportSPStatusToIDS = false;
        this.isStarted = false;
        LOG.info((Object)"SimpleServiceProvider stopped");
    }

    private IDSUser processSSO(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        if (this.spStatusReporterThread == null) {
            LOG.info((Object)"start spStatusReporter");
            this.spStatusReporterThread = new Thread(new SPStatusReporter(this, request, response));
            this.spStatusReporterThread.setName("TRSIDS.SpStatusReporter");
            this.spStatusReporterThread.start();
        }
        IRequest tokenRequest = this.requestBuilder.build(request);
        IResponse tokenResponse = null;
        LOG.info((Object)("tokenRequest is: " + tokenRequest));
        if (tokenRequest == null) {
            LOG.error((Object)"tokenRequest is null");
            throw new ServiceProviderException("tokenRequest is null");
        }
        tokenResponse = tokenRequest.doRequest(request, response);
        LOG.info((Object)("tokenResponse is: " + tokenResponse));
        if (tokenResponse == null) {
            LOG.info((Object)("there is no tokenResponse of " + tokenRequest + ",so finish process"));
            return null;
        }
        if ("401".equals(tokenResponse.getResponseCode())) {
            LOG.info((Object)"Token in tokenRequest is not found in IDS Server, so create a SimpleRedirectCheckSSOStatusRequest to check ssostatus again");
            tokenRequest = new SimpleRedirectCheckSSOStatusRequest(this, request);
            tokenRequest.doRequest(request, response);
            return null;
        }
        if (!tokenResponse.validate(request, response)) {
            LOG.info((Object)("validate response is false, reponse type: " + tokenResponse.getResponseType() + "; responseCode: " + tokenResponse.getResponseCode() + "; responseBody: " + tokenResponse.getResponseBody()));
            if ("500".equals(tokenResponse.getResponseCode()) && !StringHelper.isEmpty(tokenResponse.getResponseBody())) {
                throw new ServiceProviderException("\u767b\u5f55\u5931\u8d25! \u539f\u56e0\uff1a " + tokenResponse.getResponseBody());
            }
            return null;
        }
        IDSUser idsUser = tokenResponse.getIDSUser();
        return idsUser;
    }

    private IDSUser doSSOLoginInternal(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        this.checkSPStatus();
        IDSUser idsUser = this.processSSO(request, response);
        LOG.info((Object)("idsUser is: " + idsUser));
        if (idsUser == null) {
            LOG.warn((Object)"loginWithoutHttpSession returns null, so loginFail,return null");
            return null;
        }
        this.setIDSUserInHttpSession(request, idsUser);
        return idsUser;
    }

    private void checkSPStatus() throws ServiceProviderException {
        if (!this.isStarted) {
            throw new ServiceProviderException("Service Provider \u672a\u542f\u52a8\u6210\u529f");
        }
    }

    private void setIDSUserInHttpSession(HttpServletRequest request, IDSUser idsUser) {
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("ids.login.flag", (Object)idsUser);
        LOG.info((Object)("set idsUser: " + idsUser + " with flag: " + "ids.login.flag" + " in HttpSession: " + httpSession.getId()));
    }

    public IClientProtocolManager getClientProtocolManager() {
        return this.clientProtocolManager;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private IServletAppActorV2 createServletAppActorV2() {
        LOG.info((Object)("start create actor: " + this.coAppActorClassName));
        if (StringHelper.isEmpty(this.coAppActorClassName)) {
            LOG.info((Object)"coAppActorClassName is null , so do not create Actor instance");
            return null;
        }
        Object obj = null;
        try {
            obj = Class.forName(this.coAppActorClassName).newInstance();
        }
        catch (Throwable t) {
            System.err.println("createServletAppActor: [ " + this.coAppActorClassName + " ] fail!");
            t.printStackTrace(System.err);
            LOG.error((Object)("createServletAppActor: [ " + this.coAppActorClassName + " ] fail!"), t);
        }
        LOG.info((Object)("create actor success: " + obj));
        if (obj instanceof IServletAppActor) {
            return new LegacyActorAdapterV2(obj);
        }
        if (obj instanceof IWebCoAppActor) {
            return new LegacyActorAdapterV2(new LegacyActorAdapter(obj));
        }
        if (obj instanceof IServletAppActorV2) {
            return obj;
        }
        LOG.error((Object)("created Actor type is unknown, coAppActorClassName: " + this.coAppActorClassName + ",type: " + obj));
        throw new RuntimeException("created Actor type is unknown, coAppActorClassName: " + this.coAppActorClassName + ",type: " + obj);
    }

    public IDSUser checkSSOLogin(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        if (this.isIDSPingRequest(request)) {
            LOG.debug((Object)"This is an IDS ping cmd, so do nothing and return");
            return null;
        }
        if (!this.isStarted) {
            this.start();
        }
        if (!this.isStarted) {
            if (!this.agentPropertiesValidator.check()) {
                try {
                    request.getRequestDispatcher("checkIDSAgentConfig.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
                catch (ServletException e) {
                    throw new ServiceProviderException("forword to checkIDSAgentConfig.jsp error", e);
                }
                catch (IOException e) {
                    throw new ServiceProviderException("forword to checkIDSAgentConfig.jsp error", e);
                }
            }
            throw new ServiceProviderException("ServiceProvider\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u662f\u5426\u6b63\u786e");
        }
        HttpSession session = request.getSession();
        String ssoSessionIdInRequestParam = RequestUtil.getParameterAndTrim(request, "com.trs.idm.gSessionId");
        LOG.debug((Object)("com.trs.idm.gSessionId in HttpRequest is: " + ssoSessionIdInRequestParam));
        if (!StringHelper.isEmpty(ssoSessionIdInRequestParam)) {
            LOG.info((Object)("This is  first time redirect, com.trs.idm.gSessionIdis: " + ssoSessionIdInRequestParam + "; set ssoSessionId in " + (this.useStdHttpSession ? " httpSession" : " cookie")));
            this.saveSSOId(request, response, ssoSessionIdInRequestParam, session.getId());
            this.isFristTimeCheckSSOLogin = false;
        }
        if (this.alreadyBindSSOId(request, response) || !StringHelper.isEmpty(ssoSessionIdInRequestParam)) {
            LOG.info((Object)("This is NOT the first time HttpSession: " + session + ", use SP.CheckSSOLogin to check SSO status"));
            request.setAttribute("si.simple.check.ssoLogin.flag", (Object)"si.simple.check.ssoLogin.second");
            this.isFristTimeCheckSSOLogin = false;
        } else {
            LOG.info((Object)("This is the first time HttpSession: " + session.getId() + ", use SP.CheckSSOLogin, about to redirect to IDP to check SSO status"));
            request.setAttribute("si.simple.check.ssoLogin.flag", (Object)"si.simple.check.ssoLogin.first");
            this.isFristTimeCheckSSOLogin = true;
        }
        IDSUser idsUser = this.processSSO(request, response);
        LOG.info((Object)("idsUser: " + idsUser));
        if (idsUser != null) {
            this.setIDSUserInHttpSession(request, idsUser);
            if (this.useActor()) {
                this.doLocalLogin(request, response, idsUser);
            }
        }
        return idsUser;
    }

    private boolean isIDSPingRequest(HttpServletRequest request) {
        return "ping".equals(request.getHeader("trs-ids-cmd"));
    }

    public IDSUser doSSOLogin(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        if (this.isIDSPingRequest(request)) {
            LOG.debug((Object)"This is an IDS ping cmd, so do nothing and return");
            return null;
        }
        if (!this.isStarted) {
            this.start();
        }
        if (!this.isStarted) {
            if (!this.agentPropertiesValidator.check()) {
                try {
                    request.getRequestDispatcher("checkIDSAgentConfig.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
                catch (ServletException e) {
                    throw new ServiceProviderException("forword to checkIDSAgentConfig.jsp error", e);
                }
                catch (IOException e) {
                    throw new ServiceProviderException("forword to checkIDSAgentConfig.jsp error", e);
                }
            }
            throw new ServiceProviderException("ServiceProvider\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u662f\u5426\u6b63\u786e");
        }
        IDSUser idsUser = this.doSSOLoginInternal(request, response);
        if (idsUser != null) {
            this.doLocalLogin(request, response, idsUser);
        }
        return idsUser;
    }

    public boolean isLocalLogin(HttpServletRequest request, HttpServletResponse response) {
        if (this.actorV2 == null) {
            LOG.info((Object)"actor is null, so return true directly");
            return true;
        }
        boolean result = this.actorV2.checkLocalLogin(request, response);
        LOG.info((Object)("checkLocalLogin() of Actor[" + this.actorV2 + "] is: " + result));
        return result;
    }

    public void doLocalLogin(HttpServletRequest request, HttpServletResponse response, IDSUser idsUser) {
        if (this.actorV2 == null) {
            LOG.info((Object)"not use actor, so return directly");
            return;
        }
        LOG.info((Object)("use actor[" + this.actorV2 + "] to do localLogin"));
        Properties props = new Properties();
        props.setProperty("userName", idsUser.getUserName());
        SSOUser ssoUser = new SSOUser(props);
        this.actorV2.loadLoginUser(request, response, ssoUser);
    }

    public void doLocalLogout(HttpServletRequest request, HttpServletResponse response) {
        if (this.actorV2 == null) {
            LOG.info((Object)"actor is null, so return true directly");
            return;
        }
        LOG.info((Object)("use actor[" + this.actorV2 + "] to do localLogout"));
        this.actorV2.logout(request, response);
    }

    public void doSSOLogout(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        if (this.isIDSPingRequest(request)) {
            LOG.debug((Object)"This is an IDS ping cmd, so do nothing and return");
            return;
        }
        if (!this.isStarted) {
            this.start();
        }
        LOG.info((Object)"about to doSSOLogout");
        HttpSession session = request.getSession();
        session.removeAttribute("ids.login.flag");
        LOG.info((Object)("remove IDSUser from HttpSession: " + session.getId()));
        String coAppName = this.getCoAppName();
        String coSessionId = session.getId();
        request.setAttribute("coAppName", (Object)coAppName);
        request.setAttribute("coSessionId", (Object)coSessionId);
        boolean isNotifyLogout = "SimpleNotifyLogoutRequest".equals(RequestUtil.getParameterAndTrim(request, "request_type"));
        LOG.info((Object)("isNotifyLogout: " + isNotifyLogout));
        this.removeSSOBind(request, response);
        if (!isNotifyLogout) {
            LOG.info((Object)"notify IDS to doSSOLogout");
            if (!"SimpleSSOLogoutRedirectRequest".equals(RequestUtil.getAttributeAsTrimStr(request, "request_type"))) {
                request.setAttribute("request_type", (Object)"SimpleSSOLogoutHttpPostRequest");
            }
            LOG.info((Object)("SSOLogout type: " + RequestUtil.getAttributeAsTrimStr(request, "request_type")));
            this.processSSO(request, response);
        }
    }

    private void removeSSOBind(HttpServletRequest request, HttpServletResponse response) {
        if (this.useStdHttpSession) {
            HttpSession httpSession = request.getSession();
            if (httpSession == null) {
                LOG.warn((Object)"get HttpSession by request.getSession() is null, so will not save ssoSessionId in HttpSession, return directly");
                return;
            }
            LOG.debug((Object)("remove com.trs.idm.gSessionId from httpSession[" + httpSession.getAttribute("com.trs.idm.gSessionId") + "]"));
            httpSession.removeAttribute("com.trs.idm.gSessionId");
        } else {
            LOG.debug((Object)"about to remove SSOSessionId and CoSessionId in Cookie");
            CookieHelper cookiehelper = new CookieHelper(request, response);
            cookiehelper.removeCookie("com.trs.idm.gSessionId");
            cookiehelper.removeCookie("com.trs.idm.coSessionId");
        }
    }

    private void saveSSOId(HttpServletRequest request, HttpServletResponse response, String ssoSessionId, String coSessionId) {
        LOG.debug((Object)("about to add SSOSessionId[" + ssoSessionId + "] and CoSessionId[" + coSessionId + "] in " + (this.useStdHttpSession ? "HttpSession" : "Cookie")));
        if (this.useStdHttpSession) {
            HttpSession httpSession = request.getSession();
            if (httpSession == null) {
                LOG.warn((Object)"get HttpSession by request.getSession() is null, so will not save ssoSessionId in HttpSession, return directly");
                return;
            }
            httpSession.setAttribute("com.trs.idm.gSessionId", (Object)ssoSessionId);
            LOG.debug((Object)("save SSOSessionId[" + httpSession.getAttribute("com.trs.idm.gSessionId") + "] and CoSessionId[" + coSessionId + "] in " + (this.useStdHttpSession ? "HttpSession" : "Cookie")));
        } else {
            CookieHelper cookiehelper = new CookieHelper(request, response);
            cookiehelper.addCookie("com.trs.idm.gSessionId", ssoSessionId);
            cookiehelper.addCookie("com.trs.idm.coSessionId", coSessionId);
        }
    }

    private boolean alreadyBindSSOId(HttpServletRequest request, HttpServletResponse response) {
        boolean result = false;
        if (this.useStdHttpSession) {
            HttpSession httpSession = request.getSession();
            if (httpSession == null) {
                LOG.warn((Object)"get HttpSession by request.getSession() is null, so return false directly");
                return false;
            }
            result = httpSession.getAttribute("com.trs.idm.gSessionId") != null;
            LOG.debug((Object)("com.trs.idm.gSessionId in HttpSession[" + httpSession.getId() + "] is: " + (String)httpSession.getAttribute("com.trs.idm.gSessionId")));
        } else {
            CookieHelper cookiehelper = new CookieHelper(request, response);
            String ssoSessionIdInCookie = cookiehelper.getValue("com.trs.idm.gSessionId");
            if (!StringHelper.isEmpty(ssoSessionIdInCookie) && this.httpSessionChanged(cookiehelper, request)) {
                result = true;
            }
            LOG.debug((Object)("alreadyBindSSOByCookie: " + result));
        }
        LOG.debug((Object)("alreadyBindSSOId return " + result));
        return result;
    }

    private boolean httpSessionChanged(CookieHelper cookiehelper, HttpServletRequest request) {
        String ssoSessionIdInCookie = cookiehelper.getValue("com.trs.idm.gSessionId");
        String coSessionIdInCookie = cookiehelper.getValue("com.trs.idm.coSessionId");
        String currentcoSessionId = request.getSession(true).getId();
        LOG.debug((Object)("currentcoSessionId: " + currentcoSessionId + "; coSessionIdInCookie: " + coSessionIdInCookie + "; ssoSessionIdInCookie: " + ssoSessionIdInCookie));
        return !currentcoSessionId.equals(ssoSessionIdInCookie);
    }

    public boolean useActor() {
        return this.actorV2 != null;
    }

    void showLoginFailPage(HttpServletRequest request, HttpServletResponse response, String msg) throws ServletException, IOException {
        String loginFailUrl = this.getConfig().getConfig("afterLoginFail.gotoUrl", "/idsSPPages/loginFail.jsp");
        request.setAttribute("sp.simple.login.fail.message", (Object)msg);
        response.setContentType("text/html; charset=GBK");
        PrintWriter pw = response.getWriter();
        StringBuffer sb = new StringBuffer(256);
        sb.append("<HTML><HEAD><TITLE>TRS\u8eab\u4efd\u670d\u52a1\u5668</TITLE></HEAD>");
        sb.append("<body>");
        sb.append("<script>");
        sb.append("alert('" + msg + "');\n");
        sb.append("document.location.href='" + request.getContextPath() + "/" + loginFailUrl + "';");
        sb.append("</script>");
        pw.println(sb);
        pw.println("</body></html>");
    }

    public boolean isFirstTimeCheckSSOLogin(HttpServletRequest request, HttpServletResponse response) {
        return this.isFristTimeCheckSSOLogin;
    }

    public String getIDPUrl() {
        return String.valueOf(super.getIDSUrl()) + "/service?idsServiceType=ssoapi";
    }

    private String reportStatus(HttpClient httpClient, String operation, String coAppName, HttpServletRequest request, HttpServletResponse response, boolean releaseConnection) {
        String reportUrl = String.valueOf(this.getIDSUrl()) + "/service?idsServiceType=coAppStatusMonitor";
        PostMethod methodPost = new PostMethod(reportUrl);
        methodPost.addParameter("operation", operation);
        methodPost.addParameter("coAppName", coAppName);
        String responseBody = "";
        try {
            try {
                httpClient.executeMethod((HttpMethod)methodPost);
                InputStream responseStream = methodPost.getResponseBodyAsStream();
                responseBody = StringHelper.convertStreamToString(responseStream, "UTF-8");
            }
            catch (Exception e) {
                LOG.warn((Object)"report ServiceProvider status to IDS fail! ");
                if (releaseConnection) {
                    methodPost.releaseConnection();
                }
                return "";
            }
        }
        finally {
            if (releaseConnection) {
                methodPost.releaseConnection();
            }
        }
        return responseBody;
    }

    public IAgentPropertiesValidator getPropertiesValidator() {
        return this.agentPropertiesValidator;
    }

    protected class SPStatusReporter
    implements Runnable {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private HttpClient httpClient;

        public SPStatusReporter(IServiceProvider sp, HttpServletRequest request, HttpServletResponse respose) {
            this.request = request;
            this.response = respose;
            this.httpClient = this.buildHttpClient();
        }

        private HttpClient buildHttpClient() {
            HttpClient httpClient = new HttpClient();
            HttpConnectionManager httpConnManager = httpClient.getHttpConnectionManager();
            if (httpConnManager != null) {
                HttpConnectionManagerParams mgrParams = new HttpConnectionManagerParams();
                mgrParams.setSoTimeout(20000);
                mgrParams.setTcpNoDelay(true);
                mgrParams.setConnectionTimeout(20000);
                mgrParams.setLinger(0);
                mgrParams.setStaleCheckingEnabled(false);
                httpConnManager.setParams(mgrParams);
            }
            return httpClient;
        }

        public void run() {
            while (SimpleServiceProvider.this.reportSPStatusToIDS) {
                try {
                    SimpleServiceProvider.this.reportStatus(this.httpClient, "operationReport", SimpleServiceProvider.this.getCoAppName(), this.request, this.response, false);
                }
                catch (Exception e) {
                    LOG.error((Object)"report status to IDS Error", (Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"interrrupted when sleep in SPStatusReporter.");
                }
            }
        }
    }
}

