/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dl.util;

import com.trs.dl.util.ConfigFileModifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Properties;
import junit.framework.TestCase;

public class ConfigFileModifierTest
extends TestCase {
    public void testModify() {
        File f = new File("testdata/cfm_test.properties");
        ConfigFileModifierTest.assertTrue((String)"file: testdata/cfm_test.properties not found!", (boolean)f.isFile());
        String key1 = "hibernate.dialect";
        String value1 = "net.sf.hibernate.dialect.SQLServerSQLDialect";
        String key2 = "hibernate.query.substitutions";
        String value2 = "true 1, false 0, yes 'Y', no 'N'";
        String key3 = "chineseValue";
        String gbValue = "\u65b0\u4e2d\u6587\u503c@" + new Timestamp(System.currentTimeMillis());
        ConfigFileModifier modifier = new ConfigFileModifier(f);
        try {
            modifier.modifyProperty(key1, value1);
            modifier.modifyProperty(key2, value2);
            modifier.modifyProperty(key3, gbValue);
            modifier.modifyProperty("sys.name", "\u6d4b\u8bd5\u7528\u7cfb\u7edf");
            modifier.saveModifies();
        }
        catch (IOException e) {
            ConfigFileModifierTest.fail((String)"failed because IOException!");
            e.printStackTrace();
        }
        Properties props = this.loadProperties(f);
        ConfigFileModifierTest.assertEquals((String)value1, (String)props.getProperty(key1));
        ConfigFileModifierTest.assertEquals((String)value2, (String)props.getProperty(key2));
        try {
            ConfigFileModifierTest.assertEquals((String)gbValue, (String)new String(props.getProperty(key3).getBytes("ISO8859_1"), "GBK"));
        }
        catch (UnsupportedEncodingException e1) {
            ConfigFileModifierTest.fail((String)"encoding fail!");
        }
    }

    public void testNewConfigItem() throws Exception {
        URL fileUrl = ((Object)((Object)this)).getClass().getResource("/forTest/testidscfg_origin.properties");
        File fSrc = null;
        try {
            fSrc = new File(new URI(fileUrl.toString()));
        }
        catch (URISyntaxException e) {
            ConfigFileModifierTest.fail((String)"failed because URI Error!");
            e.printStackTrace();
        }
        ConfigFileModifierTest.assertNotNull((String)"file not found!", (Object)fSrc);
    }

    private Properties loadProperties(File f) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(f));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }
}

