/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigFileModifier {
    private static final Logger LOG;
    private File file;
    private StringBuffer sb;
    private Properties modifiedProps;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.dl.util.ConfigFileModifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public ConfigFileModifier(String fileName) {
        this(new File(fileName));
    }

    public ConfigFileModifier(File f) {
        this.file = f;
        this.modifiedProps = new Properties();
    }

    public ConfigFileModifier(URL fileUrl) {
        this(fileUrl.getFile());
    }

    public void modifyProperty(String key, String newValue) {
        if (newValue != null) {
            try {
                this.modifiedProps.put(key, new String(newValue.getBytes(), "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
    }

    public void modifyProperty(String key, int newValue) {
        this.modifiedProps.put(key, String.valueOf(newValue));
    }

    public void modifyProperty(String key, long newValue) {
        this.modifiedProps.put(key, String.valueOf(newValue));
    }

    public void modifyProperty(String key, boolean bool) {
        this.modifiedProps.put(key, String.valueOf(bool));
    }

    public void modifyProperties(Properties changedConfigs) {
        Enumeration<Object> enu = changedConfigs.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.modifyProperty(key, changedConfigs.getProperty(key));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveModifies() throws IOException {
        if (!this.file.isFile()) {
            throw new FileNotFoundException("The file: " + this.file.getAbsolutePath() + " not exist or not a file!");
        }
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.file), "ISO-8859-1");
        BufferedReader br = new BufferedReader(isr);
        int bufferSize = this.file.length() > 32767L ? Short.MAX_VALUE : (int)this.file.length();
        this.sb = new StringBuffer(bufferSize);
        String key = null;
        String newValue = null;
        boolean lineDone = false;
        try {
            try {
                String line = br.readLine();
                while (true) {
                    if (line == null) break;
                    lineDone = false;
                    Iterator<Object> iter = this.modifiedProps.keySet().iterator();
                    while (iter.hasNext()) {
                        key = (String)iter.next();
                        newValue = this.modifiedProps.getProperty(key);
                        if (!line.trim().startsWith(key) || line.trim().startsWith(String.valueOf(key) + ".")) continue;
                        this.sb.append(key).append('=').append(newValue);
                        this.sb.append(System.getProperty("line.separator"));
                        lineDone = true;
                        this.modifiedProps.remove(key);
                        break;
                    }
                    if (!lineDone) {
                        this.sb.append(line);
                        this.sb.append(System.getProperty("line.separator"));
                    }
                    line = br.readLine();
                }
                Iterator<Object> iter = this.modifiedProps.keySet().iterator();
                while (true) {
                    block10: {
                        if (iter.hasNext()) break block10;
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "ISO-8859-1");
                        writer.write(this.sb.toString());
                        ((Writer)writer).close();
                        break;
                    }
                    key = (String)iter.next();
                    newValue = this.modifiedProps.getProperty(key);
                    this.sb.append(key).append('=').append(newValue);
                    this.sb.append(System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("fail! key=" + key + ", value=" + newValue), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            br.close();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        br.close();
    }
}

