/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.RecordReport;
import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSJNIV61;
import com.eprobiti.trs.TRSObject;
import com.eprobiti.trs.TRSViewColumn;
import java.util.Vector;

public class TRSView
extends TRSObject {
    private String m_sDelColumns = null;
    private Vector m_vAddColumns = new Vector();
    private Vector m_vModColumns = new Vector();
    private static final String[] m_saViewPropertyNames = new String[]{"ID", "NAME", "COMMENT", "CREATEDATE", "UPDATEDATE", "OWNER", "TYPE", "COLUMNNUM", "DATABASENUM", "PUBLIC", "ALIAS", "FIRSTTEXTCOL", "CONDITION", "DATABASES"};

    TRSView(String strPropertyValue, TRSConnection conn) throws TRSException {
        super(conn, 20, m_saViewPropertyNames, strPropertyValue);
        if (conn == null) {
            throw TRSException.New(500002, "");
        }
        if (strPropertyValue == null) {
            throw TRSException.New(500011, "");
        }
    }

    public TRSView(TRSConnection conn, String strName) throws TRSException {
        super(conn, 20, strName, m_saViewPropertyNames);
        if (conn == null) {
            throw TRSException.New(500002, "");
        }
        if (strName == null) {
            throw TRSException.New(500014, "");
        }
    }

    public boolean addColumn(TRSViewColumn[] oaAddCols) {
        if (oaAddCols == null) {
            return false;
        }
        int i = 0;
        while (i < oaAddCols.length) {
            this.m_vAddColumns.add(oaAddCols[i]);
            ++i;
        }
        return true;
    }

    public boolean alterColumn(TRSViewColumn[] oaAlterCols) {
        if (oaAlterCols == null) {
            return false;
        }
        int i = 0;
        while (i < oaAlterCols.length) {
            this.m_vModColumns.add(oaAlterCols[i]);
            ++i;
        }
        return true;
    }

    public void cancelAlter() {
        super.cancelAlter();
        this.m_vAddColumns.removeAllElements();
        this.m_vModColumns.removeAllElements();
        this.m_sDelColumns = null;
    }

    public RecordReport copyRecords(String strSrcName, String strSrcOwner, String strColumns, String strWhereExpr, String strSortMethod, boolean bSyncIndex) throws TRSException {
        return super.getConnection().copyRecords(super.getName(), super.getOwner(), strSrcName, strSrcOwner, strColumns, strWhereExpr, strSortMethod, bSyncIndex);
    }

    public boolean create() throws TRSException {
        int _ret;
        String[] _saColumnProperties = null;
        String _sViewProperties = super.getUpdateProperties();
        if (this.m_vAddColumns.size() != 0) {
            _saColumnProperties = new String[this.m_vAddColumns.size()];
            int i = 0;
            while (i < this.m_vAddColumns.size()) {
                _saColumnProperties[i] = ((TRSObject)this.m_vAddColumns.elementAt(i)).getUpdateProperties();
                ++i;
            }
        }
        if ((_ret = TRSJNIV61.TRS_Admin_CreateView(super.getHandle(), _sViewProperties, _saColumnProperties)) < 0) {
            throw super.newTRSException();
        }
        super.updateProperties();
        return true;
    }

    public boolean createIndex(String strColumns, int iStopRecord) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_CreateIndex(super.getHandle(), super.getName(), super.getOwner(), strColumns, iStopRecord);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean deleteColumn(String strDelCols) {
        this.m_sDelColumns = strDelCols;
        return true;
    }

    public boolean deleteIndex(String strColumns, int iStartRecord) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_DeleteIndex(super.getHandle(), super.getName(), super.getOwner(), strColumns, iStartRecord);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public int deleteRecords(String strWhere, boolean bFastEnable) throws TRSException {
        return super.getConnection().executeDelete(super.getName(), super.getOwner(), strWhere, bFastEnable);
    }

    public boolean expandView(String BaseName, String BaseOwner) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_ExpandView(super.getHandle(), super.getName(), super.getOwner(), BaseName, BaseOwner, 0);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean extendAttribute(int iAddOpt, int iDelOpt) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_ExtendAttribute(super.getHandle(), super.getName(), super.getOwner(), iAddOpt, iDelOpt);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public TRSViewColumn[] getColumns() throws TRSException {
        return this.getColumns("*");
    }

    public TRSViewColumn[] getColumns(String strColNames) throws TRSException {
        String _strViewName = super.getFullName();
        String[] _saColProperties = TRSJNIV61.TRS_GetObjectList(super.getHandle(), 21, 0, _strViewName, strColNames, 0);
        if (_saColProperties == null) {
            throw super.newTRSException();
        }
        int _iColCount = _saColProperties.length;
        TRSViewColumn[] _oaViewColumns = new TRSViewColumn[_iColCount];
        int i = 0;
        while (i < _iColCount) {
            _oaViewColumns[i] = new TRSViewColumn(_saColProperties[i]);
            ++i;
        }
        return _oaViewColumns;
    }

    public String getDatabases() throws TRSException {
        return super.getProperty("DATABASES");
    }

    public int getUserRightInfo(String strUserName) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GetRightInfo(super.getHandle(), strUserName, super.getName(), super.getOwner(), null);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return _ret;
    }

    public int getUserRightInfo(String strUserName, String strColumn) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GetRightInfo(super.getHandle(), strUserName, super.getName(), super.getOwner(), strColumn);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return _ret;
    }

    public void grantUserRight(String strUserNames, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GrantRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), null);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public void grantUserRight(String strUserNames, String strColumns, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GrantRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), strColumns);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public int insertRecord(String strRecordValues) throws TRSException {
        return super.getConnection().executeInsert(super.getName(), super.getOwner(), strRecordValues);
    }

    public RecordReport loadRecords(String strSrcFileName, String strCtrlFileName, boolean bBatchMode) throws TRSException {
        return super.getConnection().loadRecords(super.getName(), super.getOwner(), strSrcFileName, strCtrlFileName, bBatchMode);
    }

    public boolean optimize(String strColumns, String strDevice) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_OptimizeDatabase(super.getHandle(), super.getName(), super.getOwner(), strColumns, strDevice);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean renameColumn(String strOldName, String strNewName) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RenameObject(super.getHandle(), 21, super.getName(), super.getOwner(), strOldName, strNewName);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public void revokeUserRight(String strUserNames, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RevokeRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), null);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public void revokeUserRight(String strUserNames, String strColumns, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RevokeRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), strColumns);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public boolean updateAlter() throws TRSException {
        int _ret;
        int i;
        String[] _saAddColumns = null;
        String[] _saAlterColumns = null;
        String _strViewProperties = super.getUpdateProperties();
        if (this.m_vAddColumns.size() != 0) {
            _saAddColumns = new String[this.m_vAddColumns.size()];
            i = 0;
            while (i < this.m_vAddColumns.size()) {
                _saAddColumns[i] = ((TRSObject)this.m_vAddColumns.elementAt(i)).getUpdateProperties();
                ++i;
            }
        }
        if (this.m_vModColumns.size() != 0) {
            _saAlterColumns = new String[this.m_vModColumns.size()];
            i = 0;
            while (i < this.m_vModColumns.size()) {
                _saAlterColumns[i] = ((TRSObject)this.m_vModColumns.elementAt(i)).getUpdateProperties();
                ++i;
            }
        }
        if ((_ret = TRSJNIV61.TRS_Admin_AlterView(super.getHandle(), _strViewProperties, _saAddColumns, _saAlterColumns, this.m_sDelColumns)) < 0) {
            throw super.newTRSException();
        }
        super.updateProperties();
        return true;
    }

    public int updateRecords(String strRecordValues, String strWhere) throws TRSException {
        return super.getConnection().executeUpdate(super.getName(), super.getOwner(), strRecordValues, strWhere);
    }

    public boolean validateIndex(String strColumns) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_ValidateIndex(super.getHandle(), super.getName(), super.getOwner(), strColumns);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }
}

