/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.ConstUtil;

public class JRTInfoUtil {
    public static boolean isIBMJDK() {
        return ConstUtil.JAVA_VENDOR.toUpperCase().indexOf("IBM") >= 0;
    }

    public static String getJavaEnvInfo() {
        try {
            Runtime runtime = Runtime.getRuntime();
            StringBuffer sb = new StringBuffer(2048);
            sb.append("[JavaEnv]:").append(ConstUtil.JAVA_VERSION).append(',').append(ConstUtil.JAVA_VENDOR).append(';');
            sb.append("[Memory]:").append(runtime.maxMemory() / 0x100000L).append("MB").append(';');
            sb.append("[UserDir]:").append(ConstUtil.EXECUTE_PATH).append(';');
            sb.append("[OS]:").append(ConstUtil.OS_NAME).append(',').append(ConstUtil.OS_VERSION).append(',').append(ConstUtil.OS_ARCH);
            return sb.toString();
        }
        catch (Throwable t) {
            return "getEnv fail! err=" + t;
        }
    }

    public static String getClasspaths() {
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("[JavaHome]:").append(ConstUtil.JAVA_HOME).append(';');
        buffer.append("[UserDir]:").append(ConstUtil.EXECUTE_PATH).append(';');
        buffer.append("[ClassPath]:").append(ConstUtil.JAVA_CLASS_PATH).append(';');
        return buffer.toString();
    }

    public static String getVMMemeoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("[Memory]: free=");
        buffer.append(runtime.freeMemory() / 0x100000L).append("MB, total=");
        buffer.append(runtime.totalMemory() / 0x100000L).append("MB, max=");
        buffer.append(runtime.maxMemory() / 0x100000L).append("MB");
        return buffer.toString();
    }

    private JRTInfoUtil() {
    }
}

